****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#INCLUDE WARN.HDR
#DEFINE _INTERNAL_
#INCLUDE restlist.hdr
#INCLUDE restmisc.hdr
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE FILEIO.HDR

VARDEF EXTERN
  INT __last_key
ENDDEF

FUNCTION INT fpick_Key_Handler
  PARAMETERS VALUE LONG list_handle,;    && current list handle
             VALUE UINT list_element,;   && current element #
                   UINT mouse_stat,;     && the &JL_MOUSE_???? defines
             VALUE UINT mrow,;           && current mouse row
             VALUE UINT mcol,;           && current mouse column
                    INT pick_key,;       && key hit if any
             VALUE UINT top_element,;    && top element displayed in PICK
             VALUE UINT last_element,;   && last element displayed in PICK
             VALUE UINT ur,;             && upper left row of PICK area
             VALUE UINT uc,;             && upper left column
             VALUE UINT lr,;             && lower right row
             VALUE UINT lc,;             && lower right column
             VALUE UINT scroll_col
  vardef
    int ret
  enddef

  do case
    case mouse_stat = &jl_mouse_ignore .AND. pick_key = 21   && CTRL-U
      ret = &jl_abort
    case mouse_stat = &jl_mouse_ignore .AND. pick_key = 32
      ret = &jl_abort
    case mouse_stat = &jl_mouse_xselect
      mouse_stat = &jl_mouse_ignore
      pick_key = 32
      __last_key = 32
      ret = &jl_abort
    otherwise
      ret = default_key_handler( list_handle, list_element, mouse_stat,;
                             mrow, mcol, pick_key, top_element, last_element,;
                             ur, uc, lr, lc, scroll_col )

  endcase

  RETURN ret
ENDPRO

*******************************************************************************
*                               Many_Fpick()
*<
*< -1 on return means memory error
*<  0 on return means esc pressed
*<  # on return means this is a list handle!  use vlist_max to determine
*<       the number selected.
*<
*******************************************************************************

FUNCTION LONG Many_Fpick
  PARAMETERS VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             VALUE UINT scroll_col,;
             VALUE UINT status_row,;
             VALUE UINT status_col,;
             VALUE UINT status_width,;
             VALUE BYTE dir_color,;
             VALUE BYTE mark_color,;
             CONST CHAR start_path,;
             CONST CHAR start_mask,;
             VALUE LOGICAL leave_dir,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL display_dirname,;
             VALUE LOGICAL maintain_list,;
             VALUE UINT    max_select,;
             VALUE BYTE std_color,;
             VALUE BYTE enhcd_color,;
             VALUE BYTE skip_color,;
             VALUE BYTE bar_color,;
             VALUE BYTE tab_color,;
             VALUE BYTE status_color

  VARDEF
    CHAR( 128 )    dir_path
    CHAR( 80 )     show_path
    CHAR( 40 )     dir_mask
    UINT           columns, marker, topp, old_mark
    LOGICAL        keep_going, is_dir, rescan, reset_var
    LONG           dir_list
    CHAR( 15 )     temp_name
    LONG           picked_list
    CHAR( 128 )    fullname
    UINT           temp_color, temp_loop
    INT            ret_val
    BYTE           old_cs, hit_color
  ENDDEF

  hit_color = skip_color
  reset_var = .T.

  picked_list = vlist_init( 52 )   && marked filename + path
  IF picked_list = 0
    RETURN -1
  ENDIF

  columns = ( lc - uc + 1 + 2 ) / 16
  IF columns = 0
    columns = 1
  ENDIF
 
  dir_mask = ALLTRIM( start_mask )
  rescan   = .T.

  keep_going = .T.

  dir_path = start_path

  SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )

  DO WHILE keep_going
    old_mark = marker
    If rescan
      dir_path  = FixPath( dir_path )
      show_path = ALLTRIM( ShortPath( status_width - 3, dir_path ) ) + "\"
      show_path = LEFT( show_path, status_width - 2 )

      old_cs = __color_std
      __color_std = status_color
      RESTORE_AREA()
      SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )
      @ status_row, status_col SAY " reading... "
      __color_std = old_cs

      dir_list = VLIST_INIT( 16 )
      IF dir_list = 0
        vlist_clear( picked_list )
        RESTORE_AREA()
        RETURN -1
      ENDIF

      IF .NOT. FIND_FIRST( dir_path + start_mask, 0x30 )
        keep_going = .F.
        Vlist_Clear( dir_list )
        LOOP
      ENDIF

      REPEAT
        temp_name = FIND_FSTR()
        IF temp_name = ".\"
          LOOP
        ENDIF

        IF AT( "\", temp_name ) > 0
          temp_name = LEFT( temp_name, RAT( "\", temp_name ) - 1 )
          is_dir = .T.
        ELSE
          is_dir = .F.
        ENDIF

        marker = AT( ".", temp_name )
        IF marker = 0 .OR. temp_name = ".."
          temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
        ELSE
          temp_name = LEFT( temp_name, marker - 1 ) +;
                      SPACE( 9 - marker + 1 ) +;
                      SUBSTR( temp_name, marker + 1, 3 )
          temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
        ENDIF

        IF is_dir
          temp_name = " " + temp_name + " "
          IF leave_dir
            IF .NOT. VList_Append( dir_list, &jl_normal, dir_color, temp_name )
              Vlist_Clear( dir_list )
              Vlist_Clear( picked_list )
              RESTORE_AREA()
              RETURN -1
            ENDIF
   
          ELSE
            IF .NOT. VList_Append( dir_list, &jl_skip, dir_color, temp_name )
              Vlist_Clear( dir_list )
              vlist_clear( picked_list )
              RESTORE_AREA()
              RETURN -1
            ENDIF

          ENDIF
   
        ELSE
          fullname = dir_path + temp_name
          *- is this file marked?
          IF vlist_locate_substr( picked_list, fullname, 1, LEN( fullname ),;
                                 .T., .F. )
            temp_name  = "" + temp_name + "  "
            temp_color = mark_color
          ELSE
            temp_name  = " " + temp_name + "  "
            temp_color = &jl_default
          ENDIF

          IF .NOT. VList_Append( dir_list, &jl_normal, temp_color, temp_name )
            Vlist_Clear( dir_list )
            vlist_clear( picked_list )
            RESTORE_AREA()
            RETURN -1
          ENDIF
   
        ENDIF

      UNTIL .NOT. FIND_NEXT()

      old_cs = __color_std
      __color_std = status_color
      RESTORE_AREA()
      SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )
      @ status_row, status_col SAY " sorting... "
      Vlist_Sort_substr( dir_list, 1, Vlist_Max( dir_list ), 2, 14 )
      RESTORE_AREA()
      SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )
      __color_std = old_cs

      IF display_dirname
        old_cs = __color_std
        __color_std = status_color
        @ status_row, status_col SAY " " + show_path + " "
        __color_std = old_cs
      ENDIF

      IF reset_var
        marker = 1
        topp   = 1
      ELSE
        marker = old_Mark
        reset_var = .T.
      ENDIF
    ENDIF && rescan

    @ ur, uc CLEAR TO lr, lc
    ret_val = Vlist_Pick( dir_list, ur, uc, lr, lc, scroll_col, topp, marker,;
                         0, 0, 1, 14, columns, 2,;
                         fpick_Key_Handler,;
                         .F., .T., .F., is_mouse, .F.,;
                         std_color, std_color,;
                         enhcd_color, enhcd_color,;
                         skip_color, hit_color, bar_color, tab_color )

    DO CASE
      CASE ret_val = &EXIT_ESC
        keep_going = .F.
        Vlist_Clear( dir_list )
        vlist_clear( picked_list )
        picked_list = 0
        LOOP

      CASE ret_val = &EXIT_ERROR
        keep_going = .F.
        VList_Clear( dir_list )
        VList_Clear( picked_list )
        picked_list = -1
        LOOP

      CASE ret_val = &EXIT_SELECT
*        temp_name = Vlist_Cstr( dir_list )
*        IF AT( "", temp_name ) = 0
          keep_going = .F.
          vlist_clear( dir_list )
          LOOP
*        ENDIF

      CASE ret_val = &EXIT_ABORT .AND. LASTKEY() = 21 && clear all marks CTRL-U
        vlist_clear( picked_list )
        picked_list = vlist_init( 52 )
        IF picked_list = 0
          keep_going = .F.
          picked_list = -1
          LOOP
        ENDIF
        rescan = .T.
        reset_var = .F.
        LOOP
    ENDCASE

    temp_name = Vlist_Cstr( dir_list )

    IF AT( "", temp_name ) = 0
      *- this is someone to mark or unmark!
      rescan = .F.
      fullname  = temp_name
      temp_name = substr( fullname, 2, 12 )
      IF LEFT( fullname, 1 ) = ""
        * unmark
        fullname = dir_path + temp_name
        IF .NOT. vlist_locate_substr( picked_list, fullname,;
                                      1, LEN( fullname ),;
                                     .T., .F. )
          * we aren't in here anyway, something is wrong!
        ELSE
          vlist_cdelete( picked_list )
        ENDIF
        temp_name = " " + temp_name + "  "
        vlist_creplace( dir_list, &jl_normal, &jl_default, temp_name )
      ELSE
        * mark
        fullname = dir_path + temp_Name
        IF .NOT. vlist_locate_substr( picked_list, fullname,;
                                      1, LEN( fullname ),;
                                     .T., .F. )
          * mark em dano
          vlist_add( picked_list, fullname )
        ELSE
          * already marked!
        ENDIF
        temp_name = "" + temp_name + "  "
        vlist_creplace( dir_list, &jl_normal, mark_color, temp_name )
      ENDIF
      IF max_select > 0
        IF vlist_max( picked_list ) >= max_select
          vlist_clear( dir_list )
          keep_going = .F.
        ENDIF
      ENDIF
      LOOP
    ELSE
      rescan = .T.
      Vlist_Clear( dir_list )
      IF .not. maintain_list
        vlist_clear( picked_list )
        picked_list = vlist_init( 52 )
        IF picked_list = 0
          keep_going = .F.
          picked_list = -1
          LOOP
        ENDIF
      ENDIF

      IF ALLTRIM( LEFT( temp_name, 13 ) ) = ".."
        dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        dir_path = LEFT( dir_path, RAT( "\", dir_path ) )
      ELSE
        dir_path = dir_path + ALLTRIM( LEFT( temp_name, 9 ) ) + "." +;
                              ALLTRIM( SUBSTR( temp_name, 11, 3 ) )
        IF RIGHT( dir_path,  1 ) = "."
          dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        ENDIF
 
      ENDIF
 
    ENDIF
 
  ENDDO

  IF picked_list > 0
    IF vlist_max( picked_list ) > 0
      vlist_top( picked_list )
      do while .not. vlist_bol( picked_list )
        fullname  = vlist_cstr( picked_list )
        temp_name = substr( fullname, RAT("\",fullname)+1, 128 )
        fullname  = left( fullname, RAT("\",fullname) )
        temp_name = ALLTRIM( LEFT( temp_name, 8 ) ) + "." +;
                    ALLTRIM( SUBSTR( temp_name, 10, 3 ) )
        fullname  = fullname + temp_name
        vlist_cedit( picked_list, fullname )
        vlist_skip( picked_list, &jl_forward )
      enddo
    ENDIF
  ENDIF

  RESTORE_AREA()
  RETURN picked_list
ENDPRO
