****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#INCLUDE STRING.HDR
#INCLUDE MATH.HDR


************ Elapsed - calculate elapsed time between C_START and C_END parameters
FUNCTION DBL Elapsed
  PARAMETERS CONST CHAR( 8 ) cx_start,;
             CONST CHAR( 8 ) cx_end
 
  * start, end :: time in format HH:MM, if format is HH:MM:SS then the :SS is truncated

  VARDEF
    DBL        m_elapsed               && return value in minutes
    ULONG      s_start                 && times converted to seconds
    ULONG      s_end
    DBL        s_elapsed               && elapsed time in seconds
    CHAR( 5 )    c_start, c_end
  ENDDEF

  c_start = LEFT( cx_start, 5 )
  c_end   = LEFT( cx_end, 5 )

  IF ( LEN( c_start ) < 5 ) .OR. ( LEN( c_end ) < 5 )
    c_start = "00:00"                  && clear invalid times so that errors will not occur
    c_end   = "00:00"
  ENDIF

  s_start = VAL( SUBSTR( c_start, 1, 2 ) )*60 + VAL( SUBSTR( c_start, 4, 2 ) )
  s_end   = VAL( SUBSTR( c_end, 1, 2 )   )*60 + VAL( SUBSTR( c_end, 4, 2 )   )

  s_elapsed = s_end-s_start
  s_elapsed = ABS( s_elapsed )

  m_elapsed = s_elapsed                && convert to DBL minutes

  IF c_start = "00:00" .AND. c_end = "00:00"
    m_elapsed = -1                     && notify calling procedure of bad parameters
  ENDIF

  RETURN m_elapsed
ENDPRO                                 && FUNCTION DBL Elapsed
