
{SECTION  Execute }
Function  Execute(exefilename,params : string) : integer;
                        {[EXEC] run DOS program from program }
var err            : integer;
     begin
     err := 999;
     if FileExistsMSG(exefilename,'','Unable to find EXE file.') then
          begin
          {writeln('Execing [',CommandComFile,'] [',cmd,']');}
          SwapVectors;
          Exec(exefilename,params);
          SwapVectors;
          err := DOSError;
          if err = 8 then writeln('EXEC failed 8 (MAKE YOUR HEAP SMALLER!)  err= ',err);
          end;
     Execute := err;
     end;


{SECTION  ExecuteCommand }
Function  ExecuteCommand(cmd : string) : integer;
var err            : integer;
    CommandComFile : string[50];
     begin
     err := 0;
     CommandComFile  := getenv('COMSPEC');
     if FileExists(CommandComFile) then
          begin
          {writeln('Execing [',CommandComFile,'] [',cmd,']');}
          SwapVectors;
          Exec(CommandComFile,'/C ' + cmd);
          SwapVectors;
          err := DOSError;
          if err = 8 then writeln('EXEC failed 8 (MAKE YOUR HEAP SMALLER!)  err= ',err);
          end
     else begin
          writeln('Unable to find program ',CommandComFile);
          err := 999;
          end;
     ExecuteCommand := err;
     end;


{SECTION TPC }
Function TPC(fname,options : string; var err : integer) : boolean;
            {[EXEC] - Invokes the compiler directly, finds a few errors}

{ Expected errors  = -1 -> compile failed, no output file
                   = 15 -> input file not found
}

var ok   : boolean;
    line,fn,fn1 : string;
     begin
     fn := fname;
     ok := true;
     err := 0;
     line := fn + ' '+ options;
     if not fileexists(fn) then
          begin
          err := 15;
          ok := false;
          end;
     fn1 := fn; forceext(fn1,'tpu');
     if fileexists(fn1) then erasefile(fn1)
     else begin
          fn1 := fn; forceext(fn1,'exe');
          if fileexists(fn) then erasefile(fn1);
          end;
     SwapVectors;
     exec('c:\bp\bin\tpc.exe',line);
     SwapVectors;
     if DosError <> 0 then
          begin
          err := DosError;
          ok := false;
          end
     else begin
          fn1 := fn; forceext(fn1,'tpu');
          if fileexists(fn1) then
               begin
               if filedate(fn,'') > filedate(fn1,'') then
                    begin
                    err := -1;
                    ok := false;
                    end;
               end
          else begin
               fn1 := fn; forceext(fn1,'exe');
               if fileexists(fn) then
                    begin
                    if filedate(fn,'') > filedate(fn1,'') then
                         begin
                         err := -1;
                         ok := false;
                         end;
                    end
               else begin
                    err := -2;
                    ok := false;
                    end;
               end;
          end;
     TPC := ok;
     end;

{PAGE}
{section NCHANT }
{ Enchanted text is a mid-level encryption.  Should be enough to
discourage casual hacking.  Retains CR/LF and line separation.
Hides repeated characters by using a random key on each line and
appending the key to the string.  Algorithm uses character position
in string as a bias so the same character on a line will probably appear
different.  This would not slow NSA down, but it is good enough.
Comparable to GIFCRYPT palette scrambling.  A text file can be mixed clear
and encrypted lines, if that is useful.
Limitation - the last character of the unencrypted line can not be
between  128 and 160 - very seldom used characters.}

Function RollChar(ch : char; n : integer) : char;
           {[STRING] NCHANT support circular shift n places 32-127 }
var x,nn : integer;
    chx  : char;
     begin
     chx := ch;
     if (ord(ch) > 31) and (ord(ch) < 128) then
          begin
          if (n > -95) and (n < 95) then
               begin
               x := ord(ch) + n;
               if      x <  32 then x := x + 96
               else if x > 127 then x := x - 96;
               chx := chr(x);
               end;
          end;
     RollChar := chx;
     end;


Function IsNCHANTed(st : string) : boolean;
              {[STRING] Text Encryption - tests string - support for NCHANT }
     begin
     if (ord(st[length(st)]) > 127) and (ord(st[length(st)]) < 160) then
          IsNCHANTed := true
     else IsNCHANTed := false;
     end;


Function NCHANT(ch : char; n : integer; Bias : integer) : char;
              {[STRING] Text Encryption - support for NCHANT }
var x,xx  : integer;
     begin
     xx := (n + Bias) mod 95;
     NCHANT := RollChar(ch,xx);
     end;


Function RVERT(ch : char; n : integer; Bias : integer) : char;
              {[STRING] Reverse Text Encryption - support for RVERT }
var x,xx  : integer;
     begin
     xx := (n + Bias) mod 95;
     RVERT := RollChar(ch,-1*xx);
     end;



Function  NCHANTstr(st : string) : string;
              {[STRING] Text Encryption - grade 2, casual hackers }
var i,n : integer;
    s : string;
    Bias : integer;
     begin
     n := length(st);
     if not IsNCHANTed(st) then
          begin { clear string }
          Bias := trunc(random(31))+1;
          s := st;
          {writeln('Enchanting [',bias,'] [',s,']');}
          for i := 1 to length(s) do s[i] := NCHANT(s[i],i,Bias);
          NCHANTSTR := s + chr(128+bias);
          end
     else begin { already enchanted }
          NCHANTSTR := st;
          end;
     end;


Function  RVERTSTR(st : string) : string;
              {[STRING] Reverse Enchantment - can be called with clear text }
var i,n : integer;
    s : string;
    Bias : integer;
     begin
     RVERTSTR := st;
     n := length(st);
     if IsNCHANTed(st) then
          begin { enchanted }
          s := st;
          Bias := ord(s[n])-128;
          delete(s,n,1);
          {writeln('Reverting  [',bias,'] [',s,']');}
          for i := 1 to length(s) do s[i] := RVERT(s[i],i,Bias);
          RVERTSTR := s;
          end;
     end;


