#include <stdlib.h>
#include <dos.h>
#include <string.h>

// Uncomment the next line to test this module
// #define TESTING

// Given the path to a file or directory, resolve the path to an absolute 
// file name.  The absolute name is the file's name without using a
// subst'd, joined or indirect path.
//
// TrueName does this by by calling the undocumented INT 21 function 0x60.
// TrueName returns the full path and drive in the 128 byte buffer supplied
// by the user.
//
// TrueName can take indirect paths, such as "..\..\bin\file.c"
// and resolve it into "D:\BC45\BIN\file.c".
//
// Call INT 21h with AH = 0x60, DS:SI containing a pointer to the filename that
// you're interested in, ES:DI containing a pointer to a 128-byte buffer that
// will receive the expanded path specification.
//
// If resolved_path is a pointer to a null, be nice and allocate
// a buffer for the user.  TrueName will only allocate as much
// space as is needed for the string in the buffer.   It is the user's
// responsibility to free the buffer space when it's not needed anymore.
//
// Note that TrueName works equally as well for directory names because
// directories _are_ files.  :-)
//
// Return resolved_path through TrueName.
// If memory couldn't be allocated (when a buffer is not
// supplied), return NULL
// If an error occurred in resolving the path (i.e. device not ready),
// return an empty string for a previously allocated buffer and NULL
// for a dynamically allocated buffer.
//
char * TrueName(char *resolved_path, char * original_path) {
	union REGS inregs, outregs;
	struct SREGS segs;
	int resize = 0;

	if (!resolved_path) {
		resolved_path = (char *) malloc(128);
		// Check if memory was allocated okay
		if (!resolved_path) return NULL;
		resize = 1;
	}

	segread(&segs);

	// AH = 0x60
	inregs.h.ah = 0x60;

	// DS:SI = pointer to file I'm interested in
	segs.ds = FP_SEG(original_path);
	inregs.x.si = FP_OFF(original_path);

	// ES:DI = pointer to 128 byte buffer to receive expanded path
	segs.es = FP_SEG(resolved_path);
	inregs.x.di = FP_OFF(resolved_path);

	intdosx(&inregs, &outregs, &segs);

	if (outregs.x.cflag) {
		*resolved_path = 0;
		if (resize) return (char *) realloc(resolved_path, 0);
		else return resolved_path;
	}
	else {
		if (resize) {
			return ((char *) realloc(resolved_path, strlen(resolved_path)+1));
		}
		else {
			return resolved_path;
		}
	}
}



#ifdef TESTING
#include <stdio.h>
int main(int argc, char **argv) {
	char *full_name = NULL;
	char *partial_name = NULL;

	if (argc < 2) {
		printf("Usage:  %s path_or_file\n", argv[0]);
		return 1;
	}

	partial_name = argv[1];

	full_name = TrueName(0, partial_name);

	if (full_name) printf("%s resolved to %s\n", partial_name, full_name);
	else printf("%s could not be resolved.\n", partial_name);

	return 0;
}

#endif
