/* EOM.CMD - Program to count messages received for past MONTH
    version 1.0, 19 February, 1995 by Elliott Goodman 

    This is configured for MY system. Most likely, you'll have to make
    a few changes to drives and paths, file names, etc. PLEASE read
    thru the program before running it! On your head be the consequences!!

    Get LOG.CMD from 1:102/1319 and use to compile daily stats from the
    logfile.
*/

/* trace ?a */

say 'Monthly Message Stats Compiler by Elliott Goodman'
say ' '
say 'Creating Monster logfile. Wait a mo....'

/* load if not already loaded */
/*if RxFuncQuery('SysLoadFuncs') then
do
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs
end
*/

old_dir = directory()
call directory('D:\TEMP')

'@unzip d:\lora\lang\oldlora.zip 1>NUL 2>&1'
'@del init.log 1>NUL 2>&1'
'@copy *.log LORA.TMP 1>NUL 2>&1'
'@del *.log 1>NUL 2>&1'

say 'Now beginning gonzo scanning! Please wait....'
call time('R')

/* initialize variables */
phrase1 = 'Tossing'
phrase2 = 'packet(s):'

in_name = 'lora.TMP'
out_name = 'EOM.TXT'
toss_flag = 0
toss_pattern = '(Toss='
area_names = 0
temp_name = ' '
temp_count = 0
total_count = 0

drop messages.

/* Initialize Output file with date/time */
m_txt = 'End of Month Message Count v1.0 by Elliott Goodman'
call lineout out_name, m_txt
m_txt = '  '
call lineout out_name, m_txt
m_txt = 'Messages received Previous Month'
call lineout out_name, m_txt
time_string = time('C')
date_string = date('N')
m_txt = 'Current time:' time_string || ',' date_string
call lineout out_name, m_txt
m_txt = '  '
call lineout out_name, m_txt

/* cycle thru LORA.TMP */
do until lines(in_name) = 0
    work_line = linein(in_name)

/* set further-work flag. This should avoid messing with
irrelevant lines and speed things up */

    if toss_flag = 0 then do
        j = wordpos(phrase1, work_line)
        if j \= 0 then
            toss_flag = 1
        end /* if toss_flag <> 1 */

    if toss_flag = 1 then do
        j = wordpos(phrase2, work_line)
        if j \= 0 then
            toss_flag = 0
        end /* if toss_flag = 1 */

/* found block of lines headed by 'Tossing */
    if toss_flag = 1 then do
/* break up line into elements */
        parse var work_line . . area_tag toss_count stuff
/* if line contains (Toss=xxxx) then work on it */
        if left(toss_count, 6) = '(Toss=' then do

/* remove trailing space, if present */
            toss_count = strip(toss_count)
/* remove leading '(Toss=' stuff */
            parse var toss_count (toss_pattern) toss_count
/* remove trailing ')' - should now be of form '000x' */
            toss_count = strip(toss_count, 'T', ')' )

/* search thru array for area tag and increment if found */
            found = 0
            do index = 1 to area_names
                if messages.index = area_tag then do
                    messages.index.count = messages.index.count + toss_count
                    found = 1
                    leave
                    end /* if */
                end /* do index = 1 to area_names */

/* area tag not found; add to array */
             if found = 0 then do
                 area_names = area_names + 1
                 messages.area_names = area_tag
                 messages.area_names.count = toss_count
                 end /* if found = 0 */
            end /* if left = (Toss */
        end /* if toss_flag = 1 */
    end /* do until lines() = 0 */

/* sort routine - not fast but it works */
swap = 1
do until swap = 0
    swap = 0
    do index = 1 to area_names -1
        t_index = index + 1
        if messages.t_index.count > messages.index.count then do
            temp_name = messages.index
            temp_count = messages.index.count
            messages.index = messages.t_index
            messages.index.count = messages.t_index.count
            messages.t_index = temp_name
            messages.t_index.count = temp_count
            swap = 1
            end /* if */
        end /* do */
    end /* do until */

/* Now output sorted results after formatting a little */
do index = 1 to area_names
   select                                                               
      when messages.index.count > 9999 then                             
         m_txt = space(messages.index,                                  
            trunc(messages.index.count),(22-length(messages.index)),'.')
      when messages.index.count > 999 then                              
         m_txt = space(messages.index,                                  
            trunc(messages.index.count),(23-length(messages.index)),'.')
      when messages.index.count > 99 then                               
         m_txt = space(messages.index,                                  
            trunc(messages.index.count),(24-length(messages.index)),'.')
      when messages.index.count > 9 then                                
         m_txt = space(messages.index,                                  
            trunc(messages.index.count),(25-length(messages.index)),'.')
      otherwise                                                         
         m_txt = space(messages.index,                                  
            trunc(messages.index.count),(26-length(messages.index)),'.')
      end                                                               
   call lineout out_name, m_txt
   total_count = total_count + messages.index.count
   end

m_txt = '  '
call lineout out_name, m_txt

m_txt = space('Total' total_count,17,'.')
call lineout out_name, m_txt

/* close files, return to starting directory, copy output to
bulletin file */
call lineout in_name
call lineout out_name
'@del lora.tmp'
'@copy' out_name 'd:\lora\misc\BULLET7.BBS 1>NUL 2>&1'
'@copy' out_name 'd:\lora\lang 1>NUL 2>&1'
'@del eom.txt'
call directory(old_dir)

/* the following really isn't necessary. Just curious how
long it takes....*/
time_spent = trunc( time('E'))             
m_txt = ' '                                           
if time_spent > 3599 then do               
  hours = time_spent % 3600                
  time_spent = time_spent - (3600 * hours) 
  if hours > 1 then                        
    m_txt = m_txt hours 'hours'            
  else                                     
    m_txt = m_txt hours 'hour'             
  end                                      
                                           
if time_spent > 59 then do                 
  minutes = time_spent % 60                
  time_spent = time_spent - (60 * minutes) 
  if minutes > 1 then                      
    m_txt = m_txt minutes 'minutes'        
  else                                     
    m_txt = m_txt minutes 'minute'         
  end                                      
                                           
if time_spent > 1 then                     
  m_txt = m_txt time_spent 'seconds.'      
else                                       
  m_txt = m_txt time_spent 'second.'

say 'Done! ' m_txt                                    
