/* REXX */

/* CMD file to search outbound directories for xxxxxxxx.XUT files (outbound packets)
and if found, rename them to xxxxxxxx.OUT so Lora will send them. */


/* check whether RxFuncs are loaded. If not, load them. */
if RxFuncQuery('SysLoadFuncs') then
do
	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs
end

/* set up directories needed */
out_loc = 'd:\lora\outbound'
out2_loc = 'd:\lora\outbound.051'

/* move to outbound directory */
call directory out_loc

/* now see if there are any *.XUT files there */
call SysFileTree '*.XUT', 'x_files', 'FO'

/* test if there are any. If not, exit */
if x_files.0 > 0 then
do
	'rename *.XUT *.OUT'
	'COPY D:\LORA\FILE\RESCAN.NOW D:\LORA'
end

/* search the other outbound directory */
call directory out2_loc
call SysFileTree '*.XUT', 'x_files', 'FO'
if x_files.0 > 0 then
do
	'rename *.XUT *.OUT'
	'COPY D:\LORA\FILE\RESCAN.NOW D:\LORA'	/* copy a dummy file
								to force Lora to rescan
								the outbound dirs */
end

/* now exit in any case */
return
exit
