#include "stdafx.h"
#include "DEFMAP.h"
#include "mapfile.h"
#include "impfile.h"
#include "ordinal.h"


#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define new DEBUG_NEW


static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL
};


static UINT BASED_CODE buttons[] =
{
	ID_FILE_OPEN,
	ID_FILE_SAVE_AS,
		ID_SEPARATOR,
	ID_FILE_READ,
		ID_SEPARATOR,
	ID_EDIT_AUTO,
	ID_EDIT_IMPFILE,
	ID_EDIT_ORDINAL,
	ID_EDIT_ORDDIR,
		ID_SEPARATOR,
	ID_APP_EXIT,
		ID_SEPARATOR,
	ID_APP_ABOUT,
};

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CDEFMAP2Dlg

BEGIN_MESSAGE_MAP(CDEFMAP2Dlg, CDialogWinApp)
	//{{AFX_MSG_MAP(CDEFMAP2Dlg)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_CBN_SELCHANGE(IDC_CBCLASSNM, OnSelchangeCbclassnm)
	ON_LBN_DBLCLK(IDC_LIDEFENTRY, OnDblclkLidefentry)
	ON_LBN_SELCHANGE(IDC_LIDEFENTRY, OnSelchangeLidefentry)
	ON_COMMAND(ID_EDIT_AUTO, OnEditAuto)
	ON_UPDATE_COMMAND_UI(ID_EDIT_AUTO, OnUpdateEditAuto)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnUpdateFileSaveAs)
	ON_COMMAND(ID_EDIT_IMPFILE, OnEditImpfile)
	ON_UPDATE_COMMAND_UI(ID_EDIT_IMPFILE, OnUpdateEditImpfile)
	ON_COMMAND(ID_EDIT_ORDINAL, OnEditOrdinal)
	ON_COMMAND(ID_FILE_READ, OnFileRead)
	ON_UPDATE_COMMAND_UI(ID_FILE_READ, OnUpdateFileRead)
	ON_UPDATE_COMMAND_UI(ID_EDIT_ORDINAL, OnUpdateEditOrdinal)
	ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CLEAR, OnUpdateEditClear)
	ON_COMMAND(ID_EDIT_FIND, OnEditFind)
	ON_UPDATE_COMMAND_UI(ID_EDIT_FIND, OnUpdateEditFind)
	ON_LBN_DBLCLK(IDC_NOTFOUND, OnDblclkNotfound)
	ON_COMMAND(ID_EDIT_ORDDIR, OnEditOrddir)
	ON_UPDATE_COMMAND_UI(ID_EDIT_ORDDIR, OnUpdateEditOrddir)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CDEFMAP2Dlg::CDEFMAP2Dlg(CWinApp *pCWndApp, CWnd *pParent) : CDialogWinApp()
{
	ASSERT(pCWndApp != NULL);
	
	m_pCWndApp = pCWndApp;
	pMapFile = NULL;
	lpClass = NULL;
	
	//{{AFX_DATA_INIT(CDEFMAP2Dlg)
	//}}AFX_DATA_INIT

	CDialogWinApp::Create(IDD, indicators, sizeof(indicators)/sizeof(UINT)
		, buttons, sizeof(buttons)/sizeof(UINT), IDR_MAIN, pParent);
}
CDEFMAP2Dlg::~CDEFMAP2Dlg()
{
	if(pMapFile != NULL) delete pMapFile;
}
void CDEFMAP2Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDEFMAP2Dlg)
	DDX_Control(pDX, IDC_EDORDINAL, m_edOrdinal);
	DDX_Control(pDX, IDC_EDIMPFILE, m_edImpFile);
	DDX_Control(pDX, IDC_EDMAPFILE, m_edMapFile);
	DDX_Control(pDX, IDC_CBCLASSNM, m_cbClassNm);
	//}}AFX_DATA_MAP
}
	
/////////////////////////////////////////////////////////////////////////////
// CDEFMAP2Dlg::OnInitDialog
//	OnInitDialog initializes the dialog display.

BOOL CDEFMAP2Dlg::OnInitDialog()
{   
	CString str;
	CDialogWinApp::OnInitDialog();	// call baseclass  
	
	m_MarkListBox.SubclassDlgItem(IDC_LIDEFENTRY, this);
	str.LoadString(IDS_NONE);
	m_edMapFile.SetWindowText(str);
	m_edImpFile.SetWindowText(str);
	str.LoadString(IDS_BASEORDINAL);
	m_edOrdinal.SetWindowText(str);
	m_NotFoundListBox.SubclassDlgItem(IDC_NOTFOUND, this);
	return TRUE;  
}

void CDEFMAP2Dlg::OnOK()
{   
	m_cbClassNm.ResetContent();
	m_MarkListBox.ResetContent();
	m_NotFoundListBox.ResetContent();
	
	if(pMapFile != NULL) 
	{	delete pMapFile;
		pMapFile = NULL;
	}
	CDialogWinApp::OnOK();
}

void CDEFMAP2Dlg::OnCancel()
{   
	if(AfxMessageBox(IDS_WANTEXIT, MB_YESNO | MB_ICONQUESTION) == IDYES)
	{	
		m_cbClassNm.ResetContent();
		m_MarkListBox.ResetContent();
	
		if(pMapFile != NULL) 
		{	delete pMapFile;
			pMapFile = NULL;
		}
		CDialogWinApp::OnCancel();
	}
}

void CDEFMAP2Dlg::OnFileOpen()
{
	CString	szFilter;

	szFilter.LoadString(IDS_FILTERSTRING);
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter, this);
	
	if (dlg.DoModal() == IDOK)
	{	if( OnDocumentOpen(dlg.GetPathName()) )
		{   AfxGetApp()->AddToRecentFileList(dlg.GetPathName());
		}
	}
	Ready();
}       
BOOL CDEFMAP2Dlg::OnDocumentOpen(LPCSTR pszPathName)
{
	if(pMapFile != NULL)
	{	delete pMapFile;
		pMapFile = NULL;
	}   
	m_cbClassNm.ResetContent();
	m_MarkListBox.ResetContent();
	m_NotFoundListBox.ResetContent();
	RedrawWindow();
		
	pMapFile = new CMapFile();
	if(pMapFile->OnOpenDocument(pszPathName))
	{   CClassEntry* lpClass;         
			
		m_edMapFile.SetWindowText(pszPathName);
		m_cbClassNm.SetRedraw(FALSE);
	
		for(int x=0; x < pMapFile->lbClassMap.GetCount(); x++)
		{	lpClass = (CClassEntry*)pMapFile->lbClassMap.GetItemDataPtr(x);
			m_cbClassNm.AddString(lpClass->classnm);
		}
		m_cbClassNm.SetRedraw(TRUE);
		m_cbClassNm.RedrawWindow(); 
			
		m_cbClassNm.SetCurSel(0);
		OnSelchangeCbclassnm();
			
		pMapFile->baseOrdinal = GetDlgItemInt(IDC_EDORDINAL, NULL, FALSE);
		
		return TRUE;
	}
	return FALSE;
}
void CDEFMAP2Dlg::OnFileSaveAs()
{
	CString	szFilter;
	
	if(pMapFile->IsModified())
	{   CString strmes;                       
		CString strcap;
		
			                                  	
		strmes.LoadString(IDS_NOTIMPGEN);
		AfxGetMainWnd()->GetWindowText(strcap);
		
		if(MessageBox(strmes, strcap, MB_ICONQUESTION | MB_YESNO) == IDYES)
		{	pMapFile->OnEditImpfile();
		}
	}
	szFilter.LoadString(IDS_FILTERSTRING2);
	
	CFileDialog dlg(FALSE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);
	
	if (dlg.DoModal() == IDOK)
	{
		if(pMapFile->pImpFile->OnSaveDocument(dlg.GetPathName()))
		{   m_edImpFile.SetWindowText(dlg.GetPathName());
			pMapFile->SetModifiedFlag(FALSE);
		}
	}    
	Ready();
}


void CDEFMAP2Dlg::OnSelchangeCbclassnm()
{   CString classnm;
	
	if(pMapFile == NULL) return;
	if(m_cbClassNm.GetCurSel() == CB_ERR) return;
	
	m_MarkListBox.SetRedraw(FALSE);
	m_MarkListBox.ResetContent();
	
	int cursel = m_cbClassNm.GetCurSel();
	
	m_cbClassNm.GetLBText(cursel, classnm);
	
	lpClass = pMapFile->Find(classnm);
	
	if(lpClass != NULL)
	{
		CEntry* lpEntry;
	
		POSITION pos = lpClass->lpExportList.GetHeadPosition();
		
		while(pos != NULL)
		{	int idx;
			lpEntry = (CEntry*)lpClass->lpExportList.GetNext(pos);
			idx = m_MarkListBox.AddString(lpEntry->comment);
			m_MarkListBox.SetItemDataPtr(idx, lpEntry);
		}
	}
	m_MarkListBox.SetRedraw(TRUE);
	m_MarkListBox.RedrawWindow();
}

void CDEFMAP2Dlg::OnDblclkLidefentry()
{
	CEntry* lpEntry;
	int cursel = m_MarkListBox.GetCurSel();
	
	if(cursel != LB_ERR)
	{   lpEntry = (CEntry*)	m_MarkListBox.GetItemDataPtr(cursel);
		lpEntry->Export(!lpEntry->exported, pMapFile);
		m_MarkListBox.RedrawWindow();
	}
}

void CDEFMAP2Dlg::OnSelchangeLidefentry()
{
	CEntry* lpEntry;                       
	CString strerror;
	
	int cursel = m_MarkListBox.GetCurSel();
	
	if(cursel != LB_ERR)
	{   lpEntry = (CEntry*)	m_MarkListBox.GetItemDataPtr(cursel);
		AfxFormatString1(strerror, IDS_DEFENTRY, lpEntry->defname);
		StatusPane(strerror);
	}		
}

void CDEFMAP2Dlg::OnEditAuto()
{   
	if(AfxMessageBox(IDS_EDITAUTO, MB_YESNO | MB_ICONQUESTION) == IDYES)
	{
		pMapFile->baseOrdinal = GetDlgItemInt(IDC_EDORDINAL, NULL, FALSE);
		pMapFile->freeOrdinal();
		pMapFile->AutoExport();
		
		OnSelchangeCbclassnm();
		Ready();
	}
}

void CDEFMAP2Dlg::OnUpdateEditAuto(CCmdUI* pCmdUI)
{   pCmdUI->Enable(pMapFile != NULL);
}

void CDEFMAP2Dlg::OnUpdateFileSaveAs(CCmdUI* pCmdUI)
{
	if(pMapFile == NULL)
	{	pCmdUI->Enable(FALSE);
		return;
	}
	if(pMapFile->pImpFile == NULL)
	{   pCmdUI->Enable(FALSE);
		return;
	}
	pCmdUI->Enable(TRUE);
}

void CDEFMAP2Dlg::OnEditImpfile()
{   
	if(AfxMessageBox(IDS_EDITIMPFILE, MB_YESNO | MB_ICONQUESTION) == IDYES)
	{
		pMapFile->OnEditImpfile();
	}
	Ready();
}

void CDEFMAP2Dlg::OnUpdateEditImpfile(CCmdUI* pCmdUI)
{   pCmdUI->Enable(pMapFile != NULL);
}

void CDEFMAP2Dlg::OnEditOrdinal()
{	
	if(AfxMessageBox(IDS_EDITORDINAL, MB_YESNO | MB_ICONQUESTION) == IDYES)
	{
		pMapFile->baseOrdinal = GetDlgItemInt(IDC_EDORDINAL, NULL, FALSE);
		pMapFile->ReMap();
		RedrawWindow();
		Ready();
	}
}

void CDEFMAP2Dlg::OnFileRead()
{	pMapFile->OnImpFileRead(this);
	RedrawWindow();
	Ready();
}

void CDEFMAP2Dlg::OnUpdateFileRead(CCmdUI* pCmdUI)
{   pCmdUI->Enable(pMapFile != NULL);
}

void CDEFMAP2Dlg::OnUpdateEditOrdinal(CCmdUI* pCmdUI)
{   pCmdUI->Enable(pMapFile != NULL);
}

void CDEFMAP2Dlg::OnEditClear()
{	
   	if(AfxMessageBox(IDS_EDITCLEAR, MB_YESNO | MB_ICONQUESTION) == IDYES)
	{
		pMapFile->Clear();
		RedrawWindow();
		Ready();
	}
}

void CDEFMAP2Dlg::OnUpdateEditClear(CCmdUI* pCmdUI)
{	pCmdUI->Enable(pMapFile != NULL);
}

void CDEFMAP2Dlg::OnEditFind()
{
}

void CDEFMAP2Dlg::OnUpdateEditFind(CCmdUI* pCmdUI)
{   pCmdUI->Enable(pMapFile != NULL);
}

void CDEFMAP2Dlg::OnDblclkNotfound()
{
	CEntry* lpEntry;                       
	CString strerror;
	
	int cursel = m_NotFoundListBox.GetCurSel();
	
	if(cursel != LB_ERR)
	{   lpEntry = (CEntry*)m_NotFoundListBox.GetItemDataPtr(cursel);
		AfxFormatString1(strerror, IDS_DEFENTRY, lpEntry->defname);
		StatusPane(strerror);
	}		
}

void CDEFMAP2Dlg::OnEditOrddir()
{
	COrdinal pDlg;
	CEntry* lpEntry;
	int cursel = m_MarkListBox.GetCurSel();
	
	if(cursel != LB_ERR)
	{   lpEntry = (CEntry*)m_MarkListBox.GetItemDataPtr(cursel);
		pDlg.lpEntry = lpEntry;
		pDlg.pMapFile = pMapFile;
		pDlg.DoModal();
		m_MarkListBox.RedrawWindow();
	}
}

void CDEFMAP2Dlg::OnUpdateEditOrddir(CCmdUI* pCmdUI)
{	pCmdUI->Enable(pMapFile != NULL);
}
