#ifndef _DEFMAP_H_
#define _DEFMAP_H_

#include "dlgwnd.h"
#include "mapfile.h"
#include "resource.h"
	
class CMarkListBox : public CListBox
{
public:
// Operations
	void HandleFocusState(LPDRAWITEMSTRUCT lpdis, int inflate);
	void DrawEntireItem(LPDRAWITEMSTRUCT lpdis, int inflate);

// Implementation
	void getWindowFontMetric(CWnd* pWnd, LPTEXTMETRIC tm);
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMIS);
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDIS);
};

class CDEFMAP2Dlg : public CDialogWinApp
{
public:
	CDEFMAP2Dlg(CWinApp *pCWndApp, CWnd* pParent = NULL);
	CMapFile* pMapFile;
	~CDEFMAP2Dlg();
	
	CClassEntry* lpClass;
	CEntry* lpCurEntry;
	
	CMarkListBox m_MarkListBox;
	CMarkListBox m_NotFoundListBox;
	BOOL OnDocumentOpen(LPCSTR pszPathName);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	CWinApp		*m_pCWndApp;
	//{{AFX_DATA(CDEFMAP2Dlg)
	enum { IDD = IDR_MAIN };
	CListBox	m_liNotFound;
	CEdit	m_edOrdinal;
	CEdit	m_edImpFile;
	CEdit	m_edMapFile;
	CComboBox	m_cbClassNm;
	CListBox	m_liClassList;
	//}}AFX_DATA

	//{{AFX_MSG(CDEFMAP2Dlg)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnFileOpen();
	afx_msg void OnFileSaveAs();
	afx_msg void OnSelchangeCbclassnm();
	afx_msg void OnDblclkLidefentry();
	afx_msg void OnSelchangeLidefentry();
	afx_msg void OnEditAuto();
	afx_msg void OnUpdateEditAuto(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnEditImpfile();
	afx_msg void OnUpdateEditImpfile(CCmdUI* pCmdUI);
	afx_msg void OnEditOrdinal();
	afx_msg void OnFileRead();
	afx_msg void OnUpdateFileRead(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditOrdinal(CCmdUI* pCmdUI);
	afx_msg void OnEditClear();
	afx_msg void OnUpdateEditClear(CCmdUI* pCmdUI);
	afx_msg void OnEditFind();
	afx_msg void OnUpdateEditFind(CCmdUI* pCmdUI);
	afx_msg void OnDblclkNotfound();
	afx_msg void OnEditOrddir();
	afx_msg void OnUpdateEditOrddir(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif	
