#include "stdafx.h"
#include "dlgwnd.h"
#include "resource.h"


#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define new DEBUG_NEW


/////////////////////////////////////////////////////////////////////////////
// Message Map -- CDialogWinApp

BEGIN_MESSAGE_MAP(CDialogWinApp, CDialog)
	//{{AFX_MSG_MAP(CDialogWinApp)
	ON_COMMAND(ID_VIEW_STATUS_BAR, OnViewStatusBar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_STATUS_BAR, OnUpdateViewStatusBar)
	ON_WM_ENTERIDLE()
	ON_MESSAGE(WM_SETMESSAGESTRING, OnSetMessageString)
	ON_WM_MENUSELECT()
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_CAPS, OnUpdateKeyIndicator)
	ON_COMMAND(ID_VIEW_TOOLBAR, OnViewToolbar)
	ON_UPDATE_COMMAND_UI(ID_VIEW_TOOLBAR, OnUpdateViewToolbar)
	ON_WM_INITMENUPOPUP()
	ON_MESSAGE(WM_COMMANDHELP, OnCommandHelp)
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_NUM, OnUpdateKeyIndicator)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_SCRL, OnUpdateKeyIndicator)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogWinApp::CDialogWinApp
//	This is the constructor for the CDialogWinApp class.  

CDialogWinApp::CDialogWinApp()
{
	m_nIDTracking	= 0;
	m_nIDLastMessage = 0;

	m_lpaIDStatusBar = NULL;
	m_cIDStatusBar   = 0;
	m_lpaIDToolBar   = NULL;
	m_cIDToolBar	 = 0;
	m_nIDBitmap	  = 0;
}
BOOL CDialogWinApp::Create(UINT nIDTemplate
	, UINT FAR *lpaIDStatus, int cIDStatus
	, UINT FAR *lpaIDToolbar, int cIDToolbar, UINT nIDBitmap
	, CWnd *pParent)
{
	m_lpaIDStatusBar = lpaIDStatus;
	m_cIDStatusBar   = cIDStatus;
	m_lpaIDToolBar   = lpaIDToolbar;
	m_cIDToolBar	 = cIDToolbar;
	m_nIDBitmap	  = nIDBitmap;
	return CDialog::Create(nIDTemplate, pParent);
}
void CDialogWinApp::OnOK()
{
	CDialog::OnOK();		
	DestroyWindow();
	PostQuitMessage(0);
}
void CDialogWinApp::OnCancel()
{
	CDialog::OnCancel();	
	DestroyWindow();
	PostQuitMessage(0);
}
void CDialogWinApp::PostNcDestroy()
{   delete this;
}
BOOL CDialogWinApp::IsTracking() const
{
	return m_nIDTracking != 0 &&
		m_nIDTracking != AFX_IDS_HELPMODEMESSAGE &&
		m_nIDTracking != AFX_IDS_IDLEMESSAGE;
}
LRESULT CDialogWinApp::OnCommandHelp(WPARAM, LPARAM lParam)
{
	if (lParam == 0)
	{
		if (IsTracking())
			lParam = HID_BASE_COMMAND + m_nIDTracking;
		else
			lParam = HID_BASE_RESOURCE + m_nIDHelp;
	}
	
	if (lParam != 0)
	{
		AfxGetApp()->WinHelp(lParam);
		return TRUE;
	}
	return FALSE;
}

void CDialogWinApp::OnDestroy()
{
	if (AfxGetApp()->m_pMainWnd == this)
		::WinHelp(m_hWnd, NULL, HELP_QUIT, 0L);

	CDialog::OnDestroy();
}
BOOL CDialogWinApp::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	CenterWindow();
	if (m_wndStatusBar.Create(this))
	{
		RepositionBars(0, 0xFFFF, 0);
		m_wndStatusBar.SetIndicators(m_lpaIDStatusBar, m_cIDStatusBar);
		OnSetMessageString(AFX_IDS_IDLEMESSAGE);
	}                 
	if (m_wndToolBar.Create(this) &&
		m_wndToolBar.LoadBitmap(m_nIDBitmap) &&
		m_wndToolBar.SetButtons(m_lpaIDToolBar, m_cIDToolBar))
	{
		RepositionBars(0, 0xFFFF, 0);
	}
	m_wndToolBar.SetTipFont(FALSE);
	m_wndToolBar.SetTipStyle (TTIPS_LONGTEXT | TTIPS_SQUARESTYLE);

	return TRUE;
}
void CDialogWinApp::OnInitMenuPopup(CMenu *pMenu, UINT, BOOL bSysMenu)
{
	if (!bSysMenu)
	{
		ASSERT(pMenu != NULL);

		// check the enabled state of various menu items
		CCmdUI state;
		state.m_pMenu = pMenu;
		ASSERT(state.m_pOther == NULL);
		
		state.m_nIndexMax = pMenu->GetMenuItemCount();
		
		for (state.m_nIndex = 0; state.m_nIndex < state.m_nIndexMax;
			state.m_nIndex++)
		{
			state.m_nID = pMenu->GetMenuItemID(state.m_nIndex);
			if (state.m_nID == 0)
				continue; // menu separator or invalid cmd - ignore it
			
			ASSERT(state.m_pOther == NULL);
			ASSERT(state.m_pMenu != NULL);
			
			if (state.m_nID == (UINT)-1)
			{
				// possibly a popup menu, route to first item of that popup
				state.m_pSubMenu = pMenu->GetSubMenu(state.m_nIndex);
				
				if (state.m_pSubMenu == NULL ||
					(state.m_nID = state.m_pSubMenu->GetMenuItemID(0)) == 0 ||
					state.m_nID == (UINT)-1)
				{
					   continue;	   // first item of popup can't be routed to
				}
				state.DoUpdate(this, FALSE);	// popups are never auto disabled
			 }
			else
			{
				// normal menu item
				// Auto enable/disable if command is _not_ a system command.
				state.m_pSubMenu = NULL;
				state.DoUpdate(this, state.m_nID < 0xF000);
			}
		}
	}
}
void CDialogWinApp::OnViewStatusBar()
{
	m_wndStatusBar.ShowWindow(m_wndStatusBar.IsWindowVisible() ? SW_HIDE : SW_SHOWNA);
}
void CDialogWinApp::OnUpdateViewStatusBar(CCmdUI* pCmdUI)
{
	ASSERT(pCmdUI->m_nID == ID_VIEW_STATUS_BAR);

	pCmdUI->SetCheck(m_wndStatusBar.IsWindowVisible());
}
void CDialogWinApp::OnEnterIdle(UINT nWhy, CWnd * /*pWho*/)
{
	if (nWhy != MSGF_MENU || m_nIDTracking == m_nIDLastMessage)
		return;

	OnSetMessageString(m_nIDTracking);
	ASSERT(m_nIDTracking == m_nIDLastMessage);
}
void CDialogWinApp::OnMenuSelect(UINT nItemID, UINT nFlags, HMENU /*hSysMenu*/)
{
	// set the tracking state
	if (nFlags == 0xFFFF)
	{
		// cancel menu operation (go back to idle now)
		m_nIDTracking = AFX_IDS_IDLEMESSAGE; 
		OnSetMessageString(m_nIDTracking);   // set string now
		ASSERT(m_nIDTracking == m_nIDLastMessage);
	}
	else if (nItemID == 0 || nFlags & (MF_SEPARATOR|MF_POPUP|MF_MENUBREAK|MF_MENUBARBREAK))
	{
		// nothing should be displayed
		m_nIDTracking = 0;
	}
	else if (nItemID >= 0xF000 && nItemID < 0xF1F0)
	{
		// special string table entries for system commands
		m_nIDTracking = ID_COMMAND_FROM_SC(nItemID);
		
		ASSERT(m_nIDTracking >= AFX_IDS_SCFIRST &&
			m_nIDTracking < AFX_IDS_SCFIRST + 31);
	}
	else
	{
		// track on idle
		m_nIDTracking = nItemID;
	}
}
LRESULT CDialogWinApp::OnSetMessageString(WPARAM wParam, LPARAM lParam)
{
	UINT	nIDMsg = (UINT)wParam;
	CString strMsg;    
	
	if(lParam != 0)
	{	m_wndStatusBar.SetWindowText((LPCSTR)lParam);
		m_wndStatusBar.UpdateWindow();
	}
	if (wParam)
	{
		if (strMsg.LoadString(nIDMsg) != 0) 
			m_wndStatusBar.SetWindowText(strMsg);
		else
			TRACE1("Warning: no message line prompt for ID 0x%04X\n", nIDMsg);
	}
	UINT nIDLast = m_nIDLastMessage;
	m_nIDLastMessage = nIDMsg;
	m_nIDTracking = nIDMsg;
	
	return nIDLast;
}
void CDialogWinApp::OnUpdateKeyIndicator(CCmdUI* pCmdUI)
{
	UINT nVK;

	switch (pCmdUI->m_nID)
	{
	case ID_INDICATOR_CAPS:
		nVK = VK_CAPITAL;
		break;

	case ID_INDICATOR_NUM:
		nVK = VK_NUMLOCK;
		break;

	case ID_INDICATOR_SCRL:
		nVK = VK_SCROLL;
		break;

	default:
		TRACE1("Warning: OnUpdateKeyIndicator - unknown indicator 0x%04X\n",
			pCmdUI->m_nID);
		pCmdUI->ContinueRouting();
		return; // not for us
	}

	pCmdUI->Enable(::GetKeyState(nVK) & 1);
		// enable static text based on toggled key state
	ASSERT(pCmdUI->m_bEnableChanged);
}

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CDlgStatusBar

BEGIN_MESSAGE_MAP(CDlgStatusBar, CStatusBar)
	//{{AFX_MSG_MAP(CDlgStatusBar)
	ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdateCmdUI)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LRESULT CDlgStatusBar::OnIdleUpdateCmdUI(WPARAM wParam, LPARAM)
{
	if (IsWindowVisible())
	{
		CFrameWnd *pParent = (CFrameWnd *)GetParent();
		if (pParent)
			OnUpdateCmdUI(pParent, (BOOL)wParam);
	}
	return 0L;
}
void CDialogWinApp::OnViewToolbar()
{
	m_wndToolBar.ShowWindow(m_wndToolBar.IsWindowVisible() ? SW_HIDE : SW_SHOWNA);
}
void CDialogWinApp::OnUpdateViewToolbar(CCmdUI* pCmdUI)
{
	ASSERT(pCmdUI->m_nID == ID_VIEW_TOOLBAR);

	pCmdUI->SetCheck(m_wndToolBar.IsWindowVisible());
}

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CDlgToolBar

BEGIN_MESSAGE_MAP(CDlgToolBar, CToolTipBar)
	//{{AFX_MSG_MAP(CDlgToolBar)
	ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdateCmdUI)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LRESULT CDlgToolBar::OnIdleUpdateCmdUI(WPARAM wParam, LPARAM lParam)
{
	if (IsWindowVisible())
	{
		CFrameWnd *pParent = (CFrameWnd *)GetParent();
		if (pParent)
			OnUpdateCmdUI(pParent, (BOOL)wParam);
	}
	return CToolTipBar::OnIdleUpdateCmdUI(wParam, lParam);
}

void CDialogWinApp::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);
	
	RepositionBars(0, 0xFFFF, 0);
	
	CWnd* pLWnd;
	CWnd* pNFoundWnd;
	CWnd* pNTextWnd;
	
	CRect rc, rcItem, rcStat, rcTool, rcNFound;
	CRect rcClient;
    
	pLWnd = GetDlgItem(IDC_LIDEFENTRY);
	pNFoundWnd = GetDlgItem(IDC_NOTFOUND);
	pNTextWnd = GetDlgItem(IDC_NOTTEXT);
	
	m_wndStatusBar.GetWindowRect(rcStat);
	m_wndToolBar.GetWindowRect(rcTool);
	
	if(pLWnd != NULL)
	{
		GetClientRect(&rc);
		pLWnd->GetWindowRect(&rcItem);
		
		pNFoundWnd->GetWindowRect(&rcClient);
		pNFoundWnd->GetWindowRect(&rcNFound);
		
		::MapWindowPoints(NULL, this->GetSafeHwnd(), (LPPOINT)&rcItem, 2);
		
		int width = rc.Width() - rcItem.left - rcItem.left;
		int height = rc.Height() - rcItem.top  - rcStat.Height() - rcNFound.Height() - 20;
			
		pLWnd->SetWindowPos(NULL, 0, 0,	width, height, SWP_NOMOVE|SWP_NOZORDER|SWP_NOACTIVATE);
		pLWnd->GetWindowRect(&rcItem);
        ScreenToClient(&rcItem);

		pNTextWnd->SetWindowPos(NULL, rcItem.left, rcItem.bottom, 0, 0, SWP_NOSIZE| SWP_NOZORDER|SWP_NOACTIVATE);
		pNFoundWnd->SetWindowPos(NULL, rcItem.left, rcItem.bottom+15, 
			width, rcClient.Height(), SWP_NOZORDER|SWP_NOACTIVATE);
	}   
	RedrawWindow(NULL, NULL, RDW_ERASE | RDW_ALLCHILDREN | RDW_UPDATENOW | RDW_INVALIDATE);
}

void CDialogWinApp::OnAppExit()
{
	OnCancel();  
}
