#include "stdafx.h"
#include "DEFMAP.h"
#include "dlgwnd.h"
#include "mapfile.h"
#include "impfile.h"
#include "resource.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImpFile

#define new new
IMPLEMENT_SERIAL(CImpFile, CDocument, 0 /* schema number*/ )
#undef new
#define new DEBUG_NEW

CImpFile::CImpFile()
{
}

BOOL CImpFile::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}

CImpFile::~CImpFile()
{	freeSearch();
}

BEGIN_MESSAGE_MAP(CImpFile, CDocument)
	//{{AFX_MSG_MAP(CImpFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CImpFile serialization

void CImpFile::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{}
	else
	{}
}

/////////////////////////////////////////////////////////////////////////////
// CImpFile commands

void CImpFile::Add(CString& export)
{   m_pExport.AddTail(export);
}
BOOL CImpFile::OnSaveDocument(const char * pszPathName)
{
	CFile file;
	CFileException fe;

	BeginWaitCursor();

	if (!file.Open(pszPathName, CFile::modeCreate |
	  CFile::modeReadWrite | CFile::shareExclusive, &fe))
	{
		ReportSaveLoadException(pszPathName, &fe,
			TRUE, AFX_IDP_INVALID_FILENAME);
		return FALSE;
	}
	TRY
	{
		CString line;           
		CString lpString;
		
		line = "EXPORTS\x0d\x0a";
		file.Write(line, line.GetLength());

		POSITION pos = m_pExport.GetHeadPosition();
		
		while(pos != NULL)
		{	lpString = m_pExport.GetNext(pos);
			line = lpString + "\x0d\x0a";
			file.Write(line, line.GetLength());
		}
		file.Close();
	}
	CATCH_ALL(e)
	{
		file.Abort(); // will not throw an exception
		EndWaitCursor();
		TRY
			ReportSaveLoadException(pszPathName, e,
				TRUE, AFX_IDP_FAILED_TO_SAVE_DOC);
		END_TRY
		return FALSE;
	}
	END_CATCH_ALL
	
	EndWaitCursor();
	SetModifiedFlag(FALSE);     // back to unmodified

	return TRUE;        // success
}           
HPSTR CImpFile::getLine(HPSTR lpOrg)
{
	HPSTR c1;
	HPSTR c2;
	WORD len;
	
	line = "";
	if(*lpOrg == '\0') return (NULL);
	
	c1 = NULL;
	for(c2 = lpOrg, len = 1; *c2 != '\0'; c2++, len++)
	{	if(*c2 == '\x0d') 
		{	c1 = c2;
			break;
		}
	}
	if(c1 == (HPSTR)NULL)
	{	c1 = lpOrg + lstrlen(lpOrg);
	}
	c1++; // 0a ueberlesen
	
	if(len > MAXLEN)
	{	AfxThrowUserException();
	}                                 
	
	char* lpBuff = new char [len+10];
	hmemcpy(lpBuff, lpOrg, len -1);
	lpBuff[len-1] = '\0';
	//OemToAnsiBuff(lpBuff, lpLine, len);
	line = lpBuff;
	delete lpBuff;
		
	if(*c1 != '\0')
	{	++c1;
	}
	LineNr++;
	return(c1);
}   
BOOL CImpFile::OnOpenDocument(const char * pszPathName)
{
	BOOL success;
	HPSTR lpBuff;
	DWORD len;
	CFile f;
	CFileException e;
	CString strerror;
	
	success = FALSE;
	
	if (IsModified())
		TRACE0("Warning: OnOpenDocument replaces an unsaved document\n");

	DeleteContents();
	SetModifiedFlag(FALSE);  // dirty during de-serialize

	if( !f.Open( pszPathName, CFile::modeRead | CFile::shareCompat, &e ) )
	{	return FALSE;
	}         
	
    f.SeekToBegin();
    len = f.GetLength();
	LineNr = 0;          
	
	AfxFormatString1(strerror, IDS_READING, pszPathName);
	StatusPane(strerror);
	
	TRY
	{
		hBuff = GlobalAlloc(GHND, len+10);
		if(hBuff == 0)
		{   m_err = IDM_OUTOFMEMORY;
			AfxThrowUserException();
		}
		lpBuff = (HPSTR)GlobalLock(hBuff);
		if(lpBuff == (HPSTR)NULL)
		{	m_err = IDM_OUTOFMEMORY;
			AfxThrowUserException();
		}
		
		if(f.ReadHuge(lpBuff, len+1) == 0)
		{	m_err = IDM_CANTREAD;
			AfxThrowUserException();
		}
		lpBuff[len+1] = '\0';
		
		eof = lpBuff;
		LineNr = 1;
		
		m_err = IDM_LINELEN;

		eof = getLine(eof);
		while(eof != (HPSTR)NULL)
		{   Add(line);
			eof = getLine(eof);
		}
		GlobalUnlock(hBuff);
		GlobalFree(hBuff);
		hBuff = 0;
		
		success = TRUE;
	}
	CATCH_ALL(e)
	{   
		char tmp[20];
		CString strerror;
		
		AfxFormatString2(strerror, m_err, pszPathName, _itoa(LineNr, tmp, 10));
		AfxGetMainWnd()->MessageBox(strerror);
		
		if(hBuff != 0)
		{
			GlobalUnlock(hBuff);
			GlobalFree(hBuff);
			hBuff = 0;
		}
	}
	END_CATCH_ALL

	f.Close();
    
	return success;
}           
void CImpFile::freeSearch()
{
	POSITION pos, pos2;
	CString key;
	CString key2;
	CMapStringToPtr* lpClasses;
	CImpEntry* lpEntry;
	
	for( pos = classes.GetStartPosition(); pos != NULL; )
	{   classes.GetNextAssoc( pos, key, (void*&)lpClasses );
		
		for( pos2 = lpClasses->GetStartPosition(); pos2 != NULL; )
		{   lpClasses->GetNextAssoc( pos2, key2, (void*&)lpEntry );
			delete lpEntry;
		}                
		lpClasses->RemoveAll();
		delete lpClasses;
	}
	classes.RemoveAll();
}

void CImpFile::prepareSearch(CMapFile* pMapFile)
{
	CString str;
	LPCSTR lp1;
	LPCSTR lp2;
	LPCSTR lp3;
	LPCSTR lp4;
	char* lpBuff;
	CMapStringToPtr* lpClasses;
	CImpEntry* lpEntry;
		
	POSITION pos = m_pExport.GetHeadPosition();
	
	lpClasses = NULL;
		
	while(pos != NULL)
	{	str = m_pExport.GetNext(pos);
		lpBuff = new char[str.GetLength()+2];
		lstrcpy(lpBuff, str);
			
		lp1 = _fstrtok(lpBuff, " ");
		lp2 = _fstrtok(NULL, " ");
		lp3 = _fstrtok(NULL, " ");
		lp4 = _fstrtok(NULL, " ");
		
		if((lp1 == NULL)
		||(lp2 == NULL))
		{	goto next1;
		}
		if(lstrcmp(lp1, ";CLASS:") == 0)
		{	lpClasses = new CMapStringToPtr();
			classes.SetAt(lp2, lpClasses);
			goto next1;
		}    
		if(lpClasses == NULL) goto next1;
		      
		if(lstrcmp(lp1, ";NONE_EXPORT") == 0)
		{	lpEntry = new CImpEntry();
	
			lpEntry->exported = FALSE;
			lpEntry->ordinal = 0;
			lpClasses->SetAt(lp2, lpEntry);
			goto next1;
		}
		lpEntry = new CImpEntry();
	
		lpEntry->exported = TRUE;
		lpEntry->ordinal = atoi(++lp2);
		
		pMapFile->allocOrdinal(lpEntry->ordinal);       
		
		lpClasses->SetAt(lp1, lpEntry);
next1:
		delete lpBuff;
	}
}
void CImpFile::search(LPCSTR classnm, LPCSTR defname, UINT& ordinal, BOOL& exported)
{
	CString key;
	CString key2;
	CMapStringToPtr* lpClasses;
	CImpEntry* lpEntry;
	
	exported = FALSE;
	ordinal = 0;
	
	if(classes.Lookup(classnm, (void*&)lpClasses))
	{	if(lpClasses->Lookup(defname, (void*&)lpEntry))
		{	ordinal = lpEntry->ordinal;
			exported = lpEntry->exported;
		}
	}
}
void CImpFile::reImport(CMapFile* pMapFile, CWnd* pWnd)
{
	CString str;
	LPCSTR lp1;
	LPCSTR lp2;
	LPCSTR lp3;
	LPCSTR lp4;
	char* lpBuff;
	CClassEntry* lpClasses;
	CEntry* lpEntry;
	CString classnm;
	BOOL bAddClassnm = TRUE;
	CString strNotFound;
	int idx;
	POSITION pos;	
	
	lpClasses = NULL;
	
	pos = pMapFile->m_notfound.GetHeadPosition();
		
	while(pos != NULL)
	{	lpEntry = (CEntry*)pMapFile->m_notfound.GetNext(pos);
		delete lpEntry;
	}
	pMapFile->m_notfound.RemoveAll();
	
	pWnd->SendDlgItemMessage(IDC_NOTFOUND, LB_RESETCONTENT, 0, 0L);
		
	pos = m_pExport.GetHeadPosition();
	while(pos != NULL)
	{	str = m_pExport.GetNext(pos);
		lpBuff = new char[str.GetLength()+2];
		lstrcpy(lpBuff, str);
			
		lp1 = _fstrtok(lpBuff, " ");
		lp2 = _fstrtok(NULL, " ");
		lp3 = _fstrtok(NULL, " ");
		lp4 = _fstrtok(NULL, "\x00");
		
		if((lp1 == NULL)
		||(lp2 == NULL))
		{	goto next1;
		}
		if(lstrcmp(lp1, ";CLASS:") == 0)
		{	lpClasses = pMapFile->findClass(lp2);
			classnm = lp2;
			bAddClassnm = TRUE;
			goto next1;
		}    
		if(lstrcmp(lp1, ";NONE_EXPORT") == 0)
		{	goto next1;
		}   
		lpEntry = NULL;
		
		if(lpClasses != NULL) 
		{	lpEntry = lpClasses->findEntry(lp1);	
		}
		if(lpEntry != NULL)
		{
			lpEntry->exported = TRUE;
			lpEntry->ordinal = atoi(++lp2);
			
			pMapFile->allocOrdinal(lpEntry->ordinal);       
		}else
		{
			if(bAddClassnm)
			{
				idx = (int)pWnd->SendDlgItemMessage(IDC_NOTFOUND, LB_ADDSTRING, 0, (LPARAM)(LPCSTR)classnm);
				pWnd->SendDlgItemMessage(IDC_NOTFOUND, LB_SETITEMDATA, idx, 0);
				bAddClassnm = FALSE;
			}           
			lpEntry = new CEntry();
			pMapFile->m_notfound.AddTail(lpEntry);

			lpEntry->defname = lp1;
			lpEntry->exported = TRUE;
			lpEntry->ordinal = atoi(++lp2);
			lpEntry->comment = lp4;

			idx = (int)pWnd->SendDlgItemMessage(IDC_NOTFOUND, LB_ADDSTRING, 0, (LPARAM)(LPCSTR)lpEntry->comment);
			if(idx == LB_ERRSPACE) 
			{	pWnd->MessageBox("Out of Memory");
				break;
			}
			pWnd->SendDlgItemMessage(IDC_NOTFOUND, LB_SETITEMDATA, idx, (LONG)lpEntry);
			
		}
next1:
		delete lpBuff;
	}
}
