#include "stdafx.h"
#include "mainwnd.h"
#include "defmap.h"	


#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define new DEBUG_NEW


/////////////////////////////////////////////////////////////////////////////
// This is the one and only CDEFMAP2App object.

CDEFMAP2App NEAR app;

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CDEFMAP2App

BEGIN_MESSAGE_MAP(CDEFMAP2App, CWinApp)
	//{{AFX_MSG_MAP(CDEFMAP2App)
	ON_COMMAND(ID_HELP, OnHelp)
	ON_COMMAND(ID_DEFAULT_HELP, OnHelp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)

	ON_COMMAND_EX(ID_FILE_MRU_FILE1, OnOpenRecentFile)
	ON_COMMAND_EX(ID_FILE_MRU_FILE2, OnOpenRecentFile)
	ON_COMMAND_EX(ID_FILE_MRU_FILE3, OnOpenRecentFile)
	ON_COMMAND_EX(ID_FILE_MRU_FILE4, OnOpenRecentFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDEFMAP2App::CDEFMAP2App

CDEFMAP2App::CDEFMAP2App()
{	  
}

int CDEFMAP2App::ExitInstance()
{
	return CWinApp::ExitInstance();
}
BOOL CDEFMAP2App::InitApplication()
{
	BOOL		bSuccess;
	WNDCLASS	wc;

	// Get normal dialog class information
	bSuccess = GetClassInfo(NULL, MAKEINTRESOURCE(0x8002), &wc);
   
	if (bSuccess)      
	{
		wc.lpszClassName = "DefMapperWindow";
		wc.style ^= CS_GLOBALCLASS;
		wc.hIcon = LoadIcon(IDR_MAIN);
		wc.hInstance = AfxGetInstanceHandle();
		bSuccess = (::RegisterClass(&wc) != 0) ? TRUE : FALSE;
	}
	return bSuccess;
}
BOOL CDEFMAP2App::InitInstance()
{
	BOOL bSuccess = FALSE;

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)
	SetDialogBkColor();        // Set dialog background color to gray
	
	TRY
	{
		m_pMainWnd = new CDEFMAP2Dlg(this);
		bSuccess = TRUE;
	}
	CATCH_ALL(e)
	{
		bSuccess = FALSE;
	}
	END_CATCH_ALL

	return bSuccess;
}
BOOL CDEFMAP2App::PreTranslateMessage(MSG *pMsg)
{
	static	HACCEL	m_hAccel=NULL;		// Accelerator handle

	if(!m_hAccel)
		m_hAccel=::LoadAccelerators(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_MAIN_ACCEL));

	if(!TranslateAccelerator(m_pMainWnd->m_hWnd, m_hAccel, pMsg))
		return CWinApp::PreTranslateMessage(pMsg);
	else
		return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog

class CAboutDlg : public CDialog
{
// Construction
public:
	CAboutDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUT };
	CStatic	m_cProgVersion;
	CStatic	m_cProgName;
	CStatic	m_cSystemResources;
	CStatic	m_cSystemMemory2;
	CStatic	m_cSystemMemory;
	CStatic	m_cCopyRight;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);

	// Generated message map functions
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog

CAboutDlg::CAboutDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAboutDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, ID_PROGRAM_VERSION, m_cProgVersion);
	DDX_Control(pDX, ID_PROGRAM_NAME, m_cProgName);
	DDX_Control(pDX, ID_SYSTEM_RESOURCES, m_cSystemResources);
	DDX_Control(pDX, ID_SYSTEM_MEMORY2, m_cSystemMemory2);
	DDX_Control(pDX, ID_SYSTEM_MEMORY, m_cSystemMemory);
	DDX_Control(pDX, ID_PROGRAM_COPYRIGHT, m_cCopyRight);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
						  
	BOOL fImUsingWin30 = TRUE;
	
	DWORD dwVersion = ::GetVersion();
	
	if ( LOBYTE(LOWORD(dwVersion)) >= 3 && HIBYTE(LOWORD(dwVersion)) > 0 )
		fImUsingWin30 = FALSE;
		
	TRACE("Windows version %d.%d, %d\n", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), fImUsingWin30);
	
	m_cProgName.SetWindowText("DEF-File Export Manager  - Freeware");
	m_cCopyRight.SetWindowText("Copyright \251 1994 Data-Plan Software GmbH");
	m_cProgVersion.SetWindowText("2.0.000");
		
	char	szTemp[40];

	DWORD dwTemp = ::GetFreeSpace(0);
	wsprintf(szTemp, "Memory: %lu KB Free", dwTemp/1024);
	m_cSystemMemory.SetWindowText((fImUsingWin30 ? "" : (LPSTR)szTemp));
	m_cSystemMemory2.SetWindowText((fImUsingWin30 ? (LPSTR)szTemp : ""));

	if (fImUsingWin30)
		SetDlgItemText(ID_SYSTEM_RESOURCES, "");
	else
	{
		UINT uiTemp = ::GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
		wsprintf(szTemp, "System Resources: %2i %%", uiTemp);
		m_cSystemResources.SetWindowText(szTemp);
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDEFMAP2App::OnAppAbout()
{
	CAboutDlg	dlg;
	dlg.DoModal();
}

BOOL CDEFMAP2App::OnOpenRecentFile(UINT nID)
{
	ASSERT_VALID(this);

	if( (nID >= ID_FILE_MRU_FILE1)
	&&  (nID <=  ID_FILE_MRU_FILE4))
	{	((CDEFMAP2Dlg*)AfxGetMainWnd())->OnDocumentOpen((LPCSTR)m_strRecentFiles[nID - ID_FILE_MRU_FILE1]);
	}    
	return TRUE;
}
void CDEFMAP2App::OnHelp()
{
	AfxGetApp()->WinHelp(0, HELP_CONTENTS);
}
