#include "stdafx.h"
#include "DEFMAP.h"
#include "dlgwnd.h"
#include "mapfile.h"
#include "impfile.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMapFile

#define new new
IMPLEMENT_SERIAL(CMapFile, CDocument, 0 /* schema number*/ )
#undef new
#define new DEBUG_NEW

CEntry::CEntry()
{   
	ordinal = 0;
	defname = "";
	comment = "";
	exported = FALSE;
}
void CEntry::AutoExport(CMapFile* pMapFile)
{   
    if( (comment.Find("public") >= 0) 
    || (comment.Find("virtual") >= 0) 
    || (comment.Find("AFX_MSGMAP ") >= 0) )
    {	exported = TRUE;
    	ordinal = pMapFile->getFreeOrdinal();
    }else
    {	exported = FALSE;
    }
}                 
void CEntry::ReMap(CMapFile* pMapFile)
{   
    if(exported)
    {	ordinal = pMapFile->getFreeOrdinal();
    }else
    {	ordinal = 0;
    }
   	pMapFile->SetModifiedFlag(TRUE);
}                 
void CEntry::Clear(CMapFile* pMapFile)
{   
    exported = FALSE;
    ordinal = 0;
	pMapFile->SetModifiedFlag(TRUE);
}                 
void CEntry::Export(BOOL bExport, CMapFile* pMapFile)
{   
	if(bExport)
    {	exported = TRUE;
    	ordinal = pMapFile->getFreeOrdinal();
    }else
    {	exported = FALSE;                    
    	pMapFile->setFreeOrdinal(ordinal);
    	ordinal = 0;
    }
	pMapFile->SetModifiedFlag(TRUE);
}                 
CString& CEntry::getExport()
{   static CString NEAR export;
	char tmp[20];

	if(exported)
    {	_itoa(ordinal, tmp, 10);
    	export = "    " + defname + " @"+ tmp + " NONAME; " + comment;
    }else
    {	export = ";NONE_EXPORT    " + defname + " " + comment;
    }	
    return(export);
}
void CEntry::UpdateMap(LPCSTR classnm, CImpFile* pImpFile, CMapFile* pMapFile)
{   UINT ord;
	BOOL exp;
	
	pImpFile->search(classnm, defname, ord, exp);
	if(exp)
	{   ordinal = ord;
		exported = exp;
	}
	
	pMapFile->SetModifiedFlag(TRUE);
}
CClassEntry::CClassEntry(LPCSTR lpClassnm)
{   classnm = lpClassnm;
}                 
CClassEntry::~CClassEntry()
{   
	CEntry* lpEntry;
	
	POSITION pos = lpExportList.GetHeadPosition();
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		delete lpEntry;
	}
}                 
void CClassEntry::AutoExport(CMapFile* pMapFile)
{   
	CEntry* lpEntry;
	
	POSITION pos = lpExportList.GetHeadPosition();
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		lpEntry->AutoExport(pMapFile);
	}
}                 
void CClassEntry::ReMap(CMapFile* pMapFile)
{   
	CEntry* lpEntry;
	
	POSITION pos = lpExportList.GetHeadPosition();
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		lpEntry->ReMap(pMapFile);
	}
}                 
void CClassEntry::Clear(CMapFile* pMapFile)
{   
	CEntry* lpEntry;
	
	POSITION pos = lpExportList.GetHeadPosition();
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		lpEntry->Clear(pMapFile);
	}
}                 
void CClassEntry::writeExport(CImpFile* pImpFile)
{   
	CEntry* lpEntry;
	CString export;
	
	POSITION pos = lpExportList.GetHeadPosition();
	
	export = " ";
	pImpFile->Add(export);
	export = ";CLASS: " + classnm;
	pImpFile->Add(export);
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		pImpFile->Add(lpEntry->getExport());
	}
}                 
CEntry* CClassEntry::findEntry(LPCSTR defname)
{   
	CEntry* lpEntry;
	
	POSITION pos = lpExportList.GetHeadPosition();
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		if(lstrcmp(lpEntry->defname, defname) == 0)
		{	return(lpEntry);
		}
	}    
	return NULL;
}                 
void CClassEntry::UpdateMap(CImpFile* pImpFile, CMapFile* pMapFile)
{   
	CEntry* lpEntry;
	CString strerror;
	
	POSITION pos = lpExportList.GetHeadPosition();

	AfxFormatString1(strerror, IDS_SERACH, classnm);
	StatusPane(strerror);
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		lpEntry->UpdateMap(classnm, pImpFile, pMapFile);
	}
}                 
void CClassEntry::Sort()
{   
	CEntry* lpEntry;
	CListBox lbSort;        
	CRect rect(10,10,20,20);
	
	if(!lbSort.Create(LBS_SORT, rect, AfxGetMainWnd(), 1))
	{	return;
	}
	POSITION pos = lpExportList.GetHeadPosition();
	
	while(pos != NULL)
	{	lpEntry = (CEntry*)lpExportList.GetNext(pos);
		int idx = lbSort.AddString(lpEntry->comment);
		if(idx != LB_ERR)
		{	lbSort.SetItemDataPtr(idx, lpEntry);
		}
	}    
	lpExportList.RemoveAll();
	
	for(int x=0; x < lbSort.GetCount(); x++)
	{	lpEntry = (CEntry*)lbSort.GetItemDataPtr(x);
		lpExportList.AddTail(lpEntry);
	}
}                 
UINT CClassEntry::Count()
{   return(lpExportList.GetCount());
}                 
BOOL CClassEntry::matchClass(CString& DefEntry)
{
    int part;
    
    part = DefEntry.Find("??");
    
    if (part >= 0 )
    {   part = part + 2;
        
        while(part <= DefEntry.GetLength())
        {
            if (DefEntry[part] == '@' )
            {	return FALSE;
            }
            if (DefEntry.Mid(part, classnm.GetLength()) == classnm)
            {   return TRUE;
            }
            part++;
        }
    }else
    {
        part = DefEntry.Find("?");
        if (part >= 0)
        {   part = DefEntry.Find("@");
            if (DefEntry.Mid(part + 1, classnm.GetLength()) == classnm)
            {   return TRUE;
            }
        }
    }              
    return FALSE;
}
LPCSTR CClassEntry::cleanComment(LPCSTR lpComment)    
{
    int start;
    
	work = "";    
    start = 0;
    while(*(lpComment+start) != '\0')
    {   
    	if( *(lpComment+start) != ' ')
    	{	break;
    	}
    	start++;
	}             
	work = lpComment + start;
	
    start = 1;
    while(start >= 0)
    {   start = work.Find("__far");
        if (start >= 0)
        {	work = work.Left(max(start, 0)) + work.Mid(min(start + 5, work.GetLength()) );
        }
	}       
    start = 1;
    while (start >= 0)
    {   start = work.Find("__pascal");
        if (start >= 0)
        {	work = work.Left(max(start, 0)) + work.Mid(min(start + 8, work.GetLength()) );
        }
    }
    start = 1;
    while (start >= 0)
    {   start = work.Find("  ");
        if (start >= 0)
        {	work = work.Left(max(start, 0)) + work.Mid(min(start + 1, work.GetLength()) );
        }
    }
    return(work);
}
void CClassEntry::Read(CMapFile* lpMapFile)
{
	CString DefEntry;
	CString Comment;
	CString Classname;
	CEntry* lpEntry;      
	
	lpMapFile->eof = lpMapFile->getLine(lpMapFile->eof); 
	while(lpMapFile->eof != (HPSTR)NULL)
	{
		if(lpMapFile->line.Find("Publics by Value") >= 0)
		{	break;
		}              
		if(lpMapFile->getParts(DefEntry, Comment) == TRUE)
		{	
            Classname = lpMapFile->GetClassnm(DefEntry);
			
            if(classnm == Classname)
            {
				lpEntry = new CEntry();
				lpEntry->defname = DefEntry;                
				lpEntry->comment = cleanComment(Comment);
				
				lpExportList.AddTail(lpEntry);
            }
		}
		lpMapFile->eof = lpMapFile->getLine(lpMapFile->eof); 
	}      
}
	

CMapFile::CMapFile()
{
	hBuff = 0;
	delm = '\x0a';
	eof = NULL;

	pOrdArray = NULL;

	CRect rect(10,10,20,20);
	
	if(!lbClassMap.Create(LBS_SORT, rect, AfxGetMainWnd(), 99))
	{	THROW_LAST();
	}
	pImpFile = NULL;
	m_grow = 30;
}
CMapFile::~CMapFile()
{   CClassEntry* lpClass;         
	CEntry* lpEntry;
	CString key;
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry*)lbClassMap.GetItemDataPtr(x);
		delete lpClass;
	}
	lbClassMap.ResetContent();
	freeOrdinal();  
	
	if(pImpFile != NULL)
	{   delete pImpFile;
		pImpFile = NULL;
	} 
	POSITION pos = m_notfound.GetHeadPosition();
		
	while(pos != NULL)
	{	lpEntry = (CEntry*)m_notfound.GetNext(pos);
		delete lpEntry;
	}
	m_notfound.RemoveAll();
}
BOOL CMapFile::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;
	return TRUE;
}       
HPSTR CMapFile::getLine(HPSTR lpOrg)
{
	HPSTR c1;
	HPSTR c2;
	WORD len;
	
	line = "";
	if(*lpOrg == '\0') return (NULL);
	
	c1 = NULL;
	for(c2 = lpOrg, len = 1; *c2 != '\0'; c2++, len++)
	{	if(*c2 == '\x0d') 
		{	c1 = c2;
			break;
		}
	}
	if(c1 == (HPSTR)NULL)
	{	c1 = lpOrg + lstrlen(lpOrg);
	}
	c1++; // 0a ueberlesen
	
	if(len > MAXLEN)
	{	AfxThrowUserException();
	}                                 
	
	char* lpBuff = new char [len+10];
	hmemcpy(lpBuff, lpOrg, len -1);
	lpBuff[len-1] = '\0';
	//OemToAnsiBuff(lpBuff, lpLine, len);
	line = lpBuff;
	delete lpBuff;
		
	if(*c1 != '\0')
	{	++c1;
	}
	LineNr++;
	return(c1);
}   
BOOL CMapFile::getParts(CString& DefEntry, CString& Comment)
{
	int part;
	CString Parse;
	
	if(line.GetLength() < 10)
	{	return FALSE;
	}
	if(line.Find(" Imp ") > 0)
	{	return FALSE;
	}
	part = line.Find(" ?");
	
	if(part <= 0)
	{	return FALSE;
	}
	Parse = line.Mid(part+1);
	
	part = Parse.Find(delm);
	
	if(part > 0)
	{
		DefEntry = Parse.Left(part);
		Parse = Parse.Mid(part+1);
		part = Parse.Find(delm);
		if(part <= 0)
		{	part = Parse.GetLength();
		}
		Comment = Parse.Left(part);
		
		return TRUE;
	}
	return FALSE;
}                        
CString CMapFile::GetClassnm(CString& DefEntry)
{
	CString Classname;
	CString partOf("0123456789ABCDEFGHIJKLMNOPRSTUVWXYZ");
	int part, part2, at;
	
	part = DefEntry.Find("??");
    if (part >= 0 )
    {   part = part + 2;
        if ((at = partOf.Find(DefEntry[part])) >= 0 )
        {
            part2 = DefEntry.Find("@");
            Classname = DefEntry.Mid(part+1, part2 - part - 1);
		    if(Classname.GetLength() < 1)
		    {	Classname = "<global>";
		    }
        }
	}else
	{
        part = DefEntry.Find("@");
        Classname = DefEntry.Mid(part+1);
        part2 = Classname.Find("@");          
        if(part2 > 1)
        {
            Classname = Classname.Left(part2);
		    if(Classname.GetLength() < 1)
		    {	Classname = "<global>";
		    }
	    }else
	    {   Classname = "<global>";
	    }	            
    }       
    return(Classname);
}
void CMapFile::scanClasses()
{
	CString DefEntry;
	CString Comment;
	CString Classname; 
	CListBox lbSort;        
	CRect rect(10,10,20,20);
	int x;
	
	HPSTR lpStart; 
	CString lpClassnm;
	CString strerror;
	
	if(!lbSort.Create(LBS_SORT, rect, AfxGetMainWnd(), 1))
	{	return;
	}              
	lpStart = eof;                    
	eof = getLine(eof);                
	
	strerror.LoadString(IDS_SCANNING);
	StatusPane(strerror);
	
	while(eof != (HPSTR)NULL)
	{
		if(line.Find("Publics by Value") >= 0)
		{	break;
		}              
		if(getParts(DefEntry, Comment) == TRUE)
		{	
		    Classname = GetClassnm(DefEntry);
		    if(Classname.GetLength() > 0)
		    {   if (lbSort.FindStringExact(-1, Classname) == LB_ERR)
	            {   lbSort.AddString(Classname);
	            }
	        }
		}
		eof = getLine(eof);
	}
	for(x=0; x < lbSort.GetCount(); x++)
	{	lbSort.GetText(x, lpClassnm);
	
		addClass(lpClassnm);
	}
	eof = lpStart;
	importClasses();

	for(x=0; x < lbClassMap.GetCount(); x++)
	{	
		CClassEntry* lpClassEntry;
        lpClassEntry = (CClassEntry*)lbClassMap.GetItemDataPtr(x);
        if(lpClassEntry != NULL)
        {	lpClassEntry->Sort();
        }
	}
}
BOOL CMapFile::importClasses()
{
	CString DefEntry;
	CString Comment;
	CString Classname;
	CEntry* lpEntry;          
	CClassEntry* lpClassEntry;
	CString strerror;
	
	eof = getLine(eof); 
	while(eof != (HPSTR)NULL)
	{
		if(line.Find("Publics by Value") >= 0)
		{	break;
		}              
		if(getParts(DefEntry, Comment) == TRUE)
		{	
            Classname = GetClassnm(DefEntry);
            
            lpClassEntry = findClass(Classname);
			
            if(lpClassEntry != NULL)
            {
				AfxFormatString1(strerror, IDS_IMPORTING, Classname);
				StatusPane(strerror);
			
				lpEntry = new CEntry();
				lpEntry->defname = DefEntry;                
				lpEntry->comment = lpClassEntry->cleanComment(Comment);
				
				lpClassEntry->lpExportList.AddTail(lpEntry);
            }
		}
		eof = getLine(eof); 
	}                 
	return TRUE;
}

BOOL CMapFile::addClass(LPCSTR lpClassnm)
{
	CClassEntry* lpClassEntry;
	
	//if(lstrlen(lpClassnm) < 1) return FALSE;

	lpClassEntry = new CClassEntry(lpClassnm);
	//lpClassEntry->Read(this);
	//lpClassEntry->Sort();
	
	int idx = lbClassMap.AddString(lpClassnm);
	if(idx != LB_ERR)lbClassMap.SetItemDataPtr(idx, lpClassEntry);
			
	return TRUE;
}
CClassEntry* CMapFile::findClass(LPCSTR lpClassnm)
{
	int idx = lbClassMap.FindStringExact(-1, lpClassnm);
	
	if(idx != LB_ERR)
	{	return((CClassEntry*)lbClassMap.GetItemDataPtr(idx));
	}		
	return NULL;
}
BOOL CMapFile::OnOpenDocument(const char * pszPathName)
{
	BOOL success;
	HPSTR lpBuff;
	DWORD len;
	CFile f;
	CFileException e;
	CString strerror;
	
	success = FALSE;
	
	if (IsModified())
		TRACE0("Warning: OnOpenDocument replaces an unsaved document\n");

	DeleteContents();
	SetModifiedFlag(TRUE);  // dirty during de-serialize

	if( !f.Open( pszPathName, CFile::modeRead | CFile::shareCompat, &e ) )
	{	return FALSE;
	}         
	
    f.SeekToBegin();
    len = f.GetLength();
	LineNr = 0;          
	
	AfxFormatString1(strerror, IDS_READING, pszPathName);
	StatusPane(strerror);
	
	TRY
	{
		hBuff = GlobalAlloc(GHND, len+10);
		if(hBuff == 0)
		{   m_err = IDM_OUTOFMEMORY;
			AfxThrowUserException();
		}
		lpBuff = (HPSTR)GlobalLock(hBuff);
		if(lpBuff == (HPSTR)NULL)
		{	m_err = IDM_OUTOFMEMORY;
			AfxThrowUserException();
		}
		
		if(f.ReadHuge(lpBuff, len+1) == 0)
		{	m_err = IDM_CANTREAD;
			AfxThrowUserException();
		}
		lpBuff[len+1] = '\0';
		
		eof = lpBuff;
		LineNr = 1;
		
		m_err = IDM_LINELEN;

		eof = getLine(eof);
		while(eof != (HPSTR)NULL)
		{
			if(line.Find("Publics by Name") > 0)
			{	scanClasses();
				break;
			}
			eof = getLine(eof);
		}
		GlobalUnlock(hBuff);
		GlobalFree(hBuff);
		hBuff = 0;
		
		success = TRUE;
		
	}
	CATCH_ALL(e)
	{   
		char tmp[20];
		CString strerror;
		
		AfxFormatString2(strerror, m_err, pszPathName, _itoa(LineNr, tmp, 10));
		AfxGetMainWnd()->MessageBox(strerror);
		
		if(hBuff != 0)
		{
			GlobalUnlock(hBuff);
			GlobalFree(hBuff);
			hBuff = 0;
		}
	}
	END_CATCH_ALL

	f.Close();
	return success;
}           

BEGIN_MESSAGE_MAP(CMapFile, CDocument)
	//{{AFX_MSG_MAP(CMapFile)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapFile serialization

void CMapFile::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}
void CMapFile::AutoExport()
{   CClassEntry* lpClass;         
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry* )lbClassMap.GetItemDataPtr(x);
		lpClass->AutoExport(this);
	}
	SetModifiedFlag(TRUE);
}
UINT CMapFile::Count()
{   CClassEntry* lpClass;         
	CString key;    
	UINT count;
	
	count = 0;
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry* )lbClassMap.GetItemDataPtr(x);
		count += lpClass->Count();
	}
	return(count);
}
UINT CMapFile::getFreeOrdinal()
{   if(pOrdArray == NULL)
	{	ordSize = Count() + baseOrdinal;
		pOrdArray = new BYTE[ordSize+1];
		for(UINT x=0; x < ordSize; x++)
		{	pOrdArray[x] = 0;
		}
	}
	for(UINT x=baseOrdinal; x < ordSize; x++)
	{
		if(pOrdArray[x] == 0)
		{	pOrdArray[x] = 1;
			return(x);
		}
	}       
	return 0;
}
BOOL CMapFile::allocOrdinal(UINT ordinal)
{   
	if(pOrdArray == NULL)
	{	ordSize = Count() + baseOrdinal;
		pOrdArray = new BYTE[ordSize+1];
		
		_fmemset(pOrdArray, 0, ordSize+1);
	}
	if(ordinal > ordSize)
	{   BYTE* pNewOrdArray;
		
		pNewOrdArray = new BYTE[ordinal + m_grow];
		_fmemset(pNewOrdArray, 0, ordinal + m_grow);
		
		_fmemcpy(pNewOrdArray, pOrdArray, ordSize);
		ordSize = ordinal + m_grow;
		delete pOrdArray;
		pOrdArray = pNewOrdArray;
	}
	if(pOrdArray[ordinal] == 1)
	{	return FALSE;
	}
	pOrdArray[ordinal] = 1;
	
	return(TRUE);
}
void CMapFile::setFreeOrdinal(UINT ordinal)
{   if(pOrdArray == NULL)
	{	return;
	}
	if(ordinal > ordSize)
	{	return;
	}
	pOrdArray[ordinal] = 0;
}
void CMapFile::freeOrdinal()
{	if(pOrdArray == NULL)
	{	return;
	}
	delete pOrdArray;
	pOrdArray = NULL;
	ordSize = 0;
}
CClassEntry* CMapFile::Find(LPCSTR lpClassnm)
{   CClassEntry* lpClass;         
	
	lpClass =  NULL;
	
	int idx = lbClassMap.FindStringExact(-1, lpClassnm);
	if(idx != LB_ERR)
	{	lpClass = (CClassEntry*)lbClassMap.GetItemDataPtr(idx);
	}
    return(lpClass);
}
void CMapFile::OnEditImpfile()
{
	CClassEntry* lpClass;         
	
	if(pImpFile != NULL)
	{	delete pImpFile;
		pImpFile = NULL;
	}
	pImpFile = new CImpFile();
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry* )lbClassMap.GetItemDataPtr(x);
		lpClass->writeExport(pImpFile);
	}                       
	SetModifiedFlag(FALSE);
}
void CMapFile::OnImpFileRead(CWnd* pWnd)
{
	CString	szFilter;
	
	szFilter.LoadString(IDS_FILTERSTRING2);
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter, pWnd);
	
	if (dlg.DoModal() == IDOK)
	{	
		pWnd->RedrawWindow();
		
		if(pImpFile != NULL)
		{	delete pImpFile;
			pImpFile = NULL;
		}   
		pImpFile = new CImpFile();
		if(pImpFile->OnOpenDocument(dlg.GetPathName()))
		{   UpdateMap(pWnd);
			pWnd->GetDlgItem(IDC_EDIMPFILE)->SetWindowText(dlg.GetPathName());
			
			delete pImpFile;
			pImpFile = NULL;  
			
			OnEditImpfile();
		}
	}       
}
void CMapFile::UpdateMap(CWnd* pWnd)
{
#ifdef NIXN
	CClassEntry* lpClass;         
	
	pImpFile->prepareSearch(this);
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry* )lbClassMap.GetItemDataPtr(x);
		lpClass->UpdateMap(pImpFile, this);
	}
	pImpFile->freeSearch();
#endif
	pImpFile->reImport(this, pWnd);
	
	SetModifiedFlag(TRUE);
}
void CMapFile::ReMap()
{   
    CClassEntry* lpClass;         
	freeOrdinal();
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry* )lbClassMap.GetItemDataPtr(x);
		lpClass->ReMap(this);
	}
	SetModifiedFlag(TRUE);
}
void CMapFile::Clear()
{   
    CClassEntry* lpClass;         
	freeOrdinal();
	
	for(int x=0; x < lbClassMap.GetCount(); x++)
	{	lpClass = (CClassEntry* )lbClassMap.GetItemDataPtr(x);
		lpClass->Clear(this);
	}
	SetModifiedFlag(TRUE);
}
