#ifndef _MAPFILE_H_
#define _MAPFILE_H_

#define HPSTR char huge *
#define MAXLEN 2000

#define StatusPane(a) ((CDEFMAP2Dlg*)AfxGetMainWnd())->OnSetMessageString(0, (LPARAM)(LPCSTR)a) 
#define Ready() ((CDEFMAP2Dlg*)AfxGetMainWnd())->OnSetMessageString(AFX_IDS_IDLEMESSAGE, 0) 

class CImpFile;
class CMapFile;
class CEntry 
{
public:	
	CEntry();
	~CEntry() {};
	
	UINT ordinal;
	CString defname;
	CString comment;
	BOOL exported;
	void AutoExport(CMapFile* pMapFile);
	void ReMap(CMapFile* pMapFile);
	void Clear(CMapFile* pMapFile);
	
	void Export(BOOL bExport, CMapFile* pMapFile);
	CString& getExport();
	void UpdateMap(LPCSTR classnm, CImpFile* pImpFile, CMapFile* pMapFile);
};  
class CClassEntry
{
public:	
	CClassEntry() {};
	CClassEntry(LPCSTR lpClassnm);
	
	~CClassEntry();
	
	CString classnm;
	CPtrList lpExportList;
	CString work;

	void AutoExport(CMapFile* pMapFile);
	void ReMap(CMapFile* pMapFile);
	void Clear(CMapFile* pMapFile);
	UINT Count();
    	
	void Read(CMapFile* lpMapFile);
	BOOL matchClass(CString& DefEntry);
	LPCSTR cleanComment(LPCSTR lpComment);
	void Sort();

	void writeExport(CImpFile* pImpFile);
	void UpdateMap(CImpFile* pImpFile, CMapFile* pMapFile);
	
	CEntry* findEntry(LPCSTR defname);
};
class CMapFile : public CDocument
{
	DECLARE_SERIAL(CMapFile)
public:
	CMapFile();			// protected constructor used by dynamic creation
	~CMapFile();	

// Attributes
public:
	HGLOBAL hBuff;
	int LineNr;               
	WORD m_err;
	CString line; 
	char delm;
	CListBox lbClassMap;
	HPSTR eof;
	UINT baseOrdinal;
	BYTE* pOrdArray;
	UINT ordSize;
	WORD m_grow;
	
	CImpFile* pImpFile;
	CPtrList m_notfound;

// Operations
public:
	HPSTR getLine(HPSTR lpOrg);
	BOOL getParts(CString& DefEntry, CString& Comment);
	void scanClasses();
	CString GetClassnm(CString& DefEntry);
	BOOL addClass(LPCSTR lpClassnm);
	void AutoExport(CMapFile* pMapFile);
	UINT Count();

	virtual BOOL OnOpenDocument(const char * pszPathName);

    void AutoExport();
	void ReMap();
    void Clear();
    void freeOrdinal();
    BOOL allocOrdinal(UINT ordinal);

    UINT getFreeOrdinal();    
    void setFreeOrdinal(UINT ordinal);
    
    CClassEntry* Find(LPCSTR lpClassnm);
    void OnEditImpfile();
	void OnImpFileRead(CWnd* pWnd);
	void UpdateMap(CWnd* pWnd);

	CClassEntry* findClass(LPCSTR lpClassnm);
	BOOL importClasses();
    
// Implementation
protected:
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
	virtual	BOOL OnNewDocument();

	// Generated message map functions
protected:
	//{{AFX_MSG(CMapFile)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
