#include "stdafx.h"
#include "DEFMAP.h"
#include "ordinal.h"
#include "mapfile.h"
#include "impfile.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COrdinal dialog


COrdinal::COrdinal(CWnd* pParent /*=NULL*/)
	: CDialog(COrdinal::IDD, pParent)
{
	//{{AFX_DATA_INIT(COrdinal)
	//}}AFX_DATA_INIT
}

void COrdinal::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COrdinal)
	DDX_Control(pDX, IDC_EDORDINAL, m_edOrdinal);
	DDX_Control(pDX, IDC_COMMENT, m_stComment);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(COrdinal, CDialog)
	//{{AFX_MSG_MAP(COrdinal)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// COrdinal message handlers

BOOL COrdinal::OnInitDialog()
{
	char tmp[30];
	CDialog::OnInitDialog();
	
	m_stComment.SetWindowText(lpEntry->comment);

	if(lpEntry->exported)
	{
		_itoa(lpEntry->ordinal, tmp, 10);
		m_edOrdinal.SetWindowText(tmp);
	}	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COrdinal::OnCancel()
{
	CDialog::OnCancel();
}

void COrdinal::OnOK()
{
	UINT ordinal = GetDlgItemInt(IDC_EDORDINAL);
	
	if(pMapFile->allocOrdinal(ordinal) == FALSE)
	{	AfxMessageBox(IDS_ORDUSED);
		return;
	}   
	if(lpEntry->exported)
	{	pMapFile->setFreeOrdinal(lpEntry->ordinal);
	}
	lpEntry->ordinal = ordinal;
	lpEntry->exported = TRUE;

	pMapFile->SetModifiedFlag(TRUE);
	
	CDialog::OnOK();
}
