#include "stdafx.h"
#include "DEFMAP.h"
#include "mapfile.h"
#include "resource.h"


#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define new DEBUG_NEW

void CMarkListBox::getWindowFontMetric(CWnd* pWnd, LPTEXTMETRIC tm)
{   
	HDC hdc;
	HFONT hFont, hFontOld;
	
	hFont = (HFONT)LOWORD(pWnd->SendMessage(WM_GETFONT, 0, 0L));
	    
	hdc = ::GetDC(NULL);
	hFontOld = NULL;
	    
	if(hFont != NULL)
	{
	   	hFontOld = (HFONT)SelectObject(hdc, hFont);
	}
	GetTextMetrics(hdc, tm);
	tm->tmHeight += 5;
	    
	if(hFontOld != NULL)
	{   SelectObject(hdc, hFontOld);
	}                 
	::ReleaseDC(NULL, hdc);
}

void CMarkListBox::MeasureItem(LPMEASUREITEMSTRUCT lpmis)
{
	TEXTMETRIC tm;
	
	if(lpmis->CtlType != ODT_LISTBOX)
	{	return;
	}
    getWindowFontMetric(this->GetParent(), &tm);
    lpmis->itemHeight = tm.tmHeight-4;
}
void CMarkListBox::HandleFocusState(LPDRAWITEMSTRUCT lpdis, int inflate)
{
	RECT	rc;

	CopyRect ((LPRECT)&rc, (LPRECT)&lpdis->rcItem);
	InflateRect ((LPRECT)&rc, inflate, inflate);

	if (lpdis->itemState & ODS_FOCUS)
	{   DrawFocusRect(lpdis->hDC, (LPRECT)&rc);
	}
}
void CMarkListBox::DrawEntireItem(LPDRAWITEMSTRUCT lpdis, int /*inflate*/)
{
	char text[255];
	HFONT hOldFont;
	HFONT hFont, hFontWind;
	CEntry* lpEntry;
	LOGFONT lf;
	char tmp[20];
	int tabs[1];
	CSize sz;
	                   
	hFont = (HFONT)GetParent()->SendMessage(WM_GETFONT, 0, 0L);
		
	SendMessage(LB_GETTEXT, lpdis->itemID, (LPARAM)(LPSTR)text);
	
	SetBkColor(lpdis->hDC, GetSysColor(COLOR_WINDOW));
	SetTextColor(lpdis->hDC, GetSysColor(COLOR_WINDOWTEXT));
	
	lpEntry = (CEntry*)GetItemDataPtr(lpdis->itemID);

	sz = GetTextExtent(lpdis->hDC, "WW", 2);
	
	if(lpEntry != NULL)
	{
		GetObject(hFont, sizeof(LOGFONT), &lf);
		
		lf.lfHeight = -11;
		lf.lfWidth = 0;
		lf.lfEscapement = 0;
		lf.lfOrientation = 0;
		lf.lfWeight = 400;
		lf.lfItalic = 0;
		lf.lfUnderline = 0;
		lf.lfStrikeOut = 0;
		lf.lfCharSet = 2;
		lf.lfOutPrecision = 3;
		lf.lfClipPrecision = 2;
		lf.lfQuality = 1;
		lf.lfPitchAndFamily = 2;
		lstrcpy(lf.lfFaceName, "Wingdings");
		hFontWind = ::CreateFontIndirect(&lf);
		hOldFont = (HFONT)::SelectObject(lpdis->hDC, hFontWind);
	
		if(lpEntry->exported)
		{   ::TextOut(lpdis->hDC, lpdis->rcItem.left, lpdis->rcItem.top, "", 1);
		}else
		{	::TextOut(lpdis->hDC, lpdis->rcItem.left, lpdis->rcItem.top, "", 1);
		}
		::DeleteObject(::SelectObject(lpdis->hDC, hFont));
		if (lpdis->itemState & ODS_SELECTED)
		{
			SetBkColor(lpdis->hDC, GetSysColor(COLOR_HIGHLIGHT));
			SetTextColor(lpdis->hDC, GetSysColor(COLOR_HIGHLIGHTTEXT));
		}   
		strcpy(tmp, "");
		if(lpEntry->ordinal != 0)
		{	_itoa(lpEntry->ordinal, tmp, 10);                         
		}
		strcpy(text, tmp);
		strcat(text, "\t");
		strcat(text, lpEntry->comment);
		strcat(text, "\t");
	}else
	{	hOldFont = (HFONT)::SelectObject(lpdis->hDC, hFont);
		GetText(lpdis->itemID, text);
	}	
	tabs[0] = lpdis->rcItem.right / 10;           
	
	TabbedTextOut(lpdis->hDC, lpdis->rcItem.left+sz.cx, lpdis->rcItem.top, 
	 	text, lstrlen(text), 1, tabs, lpdis->rcItem.left+sz.cx);
	 	
	if( (lpdis->itemState & ODA_FOCUS) != 0)
	{	HandleFocusState(lpdis, 1);
	}
	::SelectObject(lpdis->hDC, hOldFont);
}

void CMarkListBox::DrawItem(LPDRAWITEMSTRUCT lpdis)
{
	if(lpdis->CtlType != ODT_LISTBOX)
	{	return;
	}
    if (lpdis->itemID == -1)
    {	// leere Box
			if (lpdis->itemState & ODS_FOCUS)
			{
				HandleFocusState(lpdis, 1);
			}
    }else
    {                                   
		DrawEntireItem(lpdis, 1);
				    
		if( (lpdis->itemAction & ODA_DRAWENTIRE) != 0)
		{	// DrawEntireItem(lpdis, 1);
		}
		if( (lpdis->itemAction & ODA_SELECT) != 0)
		{	// HandleSelectionState(lpdis, 1);
		}
		if( (lpdis->itemAction & ODA_FOCUS) != 0)
		{	// DrawEntireItem(lpdis, 1);
			// HandleFocusState(lpdis, 1);
		}
	}
}
