VERSION 2.00
Begin Form DemoF 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "DTEDIT.VBX Demonstration"
   ClientHeight    =   5625
   ClientLeft      =   1095
   ClientTop       =   1470
   ClientWidth     =   6495
   Height          =   6030
   Left            =   1035
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   5625
   ScaleWidth      =   6495
   Top             =   1125
   Width           =   6615
   Begin ComboBox cmbLanguage 
      Height          =   300
      Left            =   1110
      Style           =   2  'Dropdown List
      TabIndex        =   23
      Top             =   3750
      Width           =   4305
   End
   Begin Frame grpOptions 
      Caption         =   "&Options"
      Height          =   1515
      Left            =   4155
      TabIndex        =   13
      Top             =   1605
      Width           =   2040
      Begin CheckBox chkKeyboardEntry 
         Caption         =   "Keyboard Entry"
         Height          =   330
         HelpContextID   =   11
         Left            =   130
         TabIndex        =   16
         Top             =   1080
         Width           =   1800
      End
      Begin CheckBox chkWrapAround 
         Caption         =   "Wrap Around"
         Height          =   375
         HelpContextID   =   9
         Left            =   135
         TabIndex        =   15
         Top             =   690
         Width           =   1665
      End
      Begin CheckBox chkShowButtons 
         Caption         =   "Spin Buttons"
         Height          =   480
         HelpContextID   =   10
         Left            =   130
         TabIndex        =   14
         Top             =   270
         Width           =   1530
      End
   End
   Begin Frame Frame3 
      Caption         =   "Enter Any Date/Time"
      Height          =   1290
      Left            =   150
      TabIndex        =   18
      Top             =   4185
      Width           =   6060
      Begin CommandButton cmdCopyFromDate 
         Caption         =   "Copy From Date"
         Height          =   400
         HelpContextID   =   5
         Left            =   3105
         TabIndex        =   21
         Top             =   720
         Width           =   2000
      End
      Begin CommandButton cmdCopyToDate 
         Caption         =   "Copy To Date"
         Height          =   400
         HelpContextID   =   5
         Left            =   945
         TabIndex        =   20
         Top             =   720
         Width           =   2000
      End
      Begin TextBox txtDateTime 
         Height          =   300
         HelpContextID   =   5
         Left            =   510
         TabIndex        =   19
         Top             =   345
         Width           =   5115
      End
   End
   Begin ComboBox cmbFormat 
      Height          =   300
      HelpContextID   =   8
      Left            =   1110
      TabIndex        =   17
      Top             =   3315
      Width           =   4305
   End
   Begin Frame Frame2 
      Caption         =   "Date/Time Edit Custom Control"
      Height          =   1365
      Left            =   150
      TabIndex        =   0
      Top             =   120
      Width           =   6030
      Begin DateEdit Date1 
         Format          =   "dddddd ttttt"
         Height          =   315
         HelpContextID   =   1
         Language        =   "Default"
         Left            =   765
         TabIndex        =   1
         Top             =   375
         Width           =   4635
      End
      Begin CommandButton cmdNow 
         Caption         =   "&Now"
         Height          =   400
         HelpContextID   =   5
         Left            =   990
         TabIndex        =   2
         Top             =   765
         Width           =   2000
      End
      Begin CommandButton cmdClear 
         Caption         =   "&Clear"
         Height          =   400
         Left            =   3090
         TabIndex        =   3
         Top             =   765
         Width           =   2000
      End
   End
   Begin Frame Frame1 
      Caption         =   "&Time Resolution"
      Height          =   1515
      HelpContextID   =   7
      Left            =   2025
      TabIndex        =   8
      Top             =   1600
      Width           =   2010
      Begin TextBox txtTimeStep 
         Height          =   345
         HelpContextID   =   4
         Left            =   200
         TabIndex        =   11
         Top             =   1065
         Width           =   660
      End
      Begin OptionButton optTimeResolution 
         Caption         =   "Minutes"
         Height          =   300
         HelpContextID   =   7
         Index           =   1
         Left            =   200
         TabIndex        =   10
         Top             =   720
         Width           =   1110
      End
      Begin OptionButton optTimeResolution 
         Caption         =   "Seconds"
         Height          =   300
         HelpContextID   =   7
         Index           =   0
         Left            =   200
         TabIndex        =   9
         Top             =   405
         Width           =   1110
      End
      Begin Label lblTimeStep 
         AutoSize        =   -1  'True
         Caption         =   "Time Step"
         Height          =   195
         Left            =   960
         TabIndex        =   12
         Top             =   1125
         Width           =   870
      End
   End
   Begin Frame grpAlignment 
      Caption         =   "&Alignment"
      Height          =   1515
      HelpContextID   =   2
      Left            =   135
      TabIndex        =   4
      Top             =   1600
      Width           =   1755
      Begin OptionButton optAlignment 
         Caption         =   "Centre"
         Height          =   285
         HelpContextID   =   2
         Index           =   2
         Left            =   200
         TabIndex        =   7
         Top             =   1005
         Width           =   990
      End
      Begin OptionButton optAlignment 
         Caption         =   "Right"
         Height          =   285
         HelpContextID   =   2
         Index           =   1
         Left            =   200
         TabIndex        =   6
         Top             =   705
         Width           =   900
      End
      Begin OptionButton optAlignment 
         Caption         =   "Left"
         Height          =   285
         HelpContextID   =   2
         Index           =   0
         Left            =   200
         TabIndex        =   5
         Top             =   405
         Width           =   795
      End
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Language"
      Height          =   195
      Left            =   120
      TabIndex        =   24
      Top             =   3750
      Width           =   855
   End
   Begin Label lblFormat 
      Caption         =   "&Format"
      Height          =   270
      Left            =   180
      TabIndex        =   22
      Top             =   3315
      Width           =   690
   End
   Begin Menu mnuDtedit 
      Caption         =   "Date VBX Popup Menu"
      Visible         =   0   'False
      Begin Menu mnuDteditNow 
         Caption         =   "Now"
      End
      Begin Menu mnuDteditTomorrow 
         Caption         =   "Tomorrow"
      End
      Begin Menu mnuDteditYesterday 
         Caption         =   "Yesterday"
      End
      Begin Menu mnuDteditSeparator1 
         Caption         =   "-"
      End
      Begin Menu mnuDteditClear 
         Caption         =   "Clear"
      End
      Begin Menu mnuDteditSeparator2 
         Caption         =   "-"
      End
      Begin Menu mnuDteditInformation 
         Caption         =   "Information ..."
      End
   End
End
Option Explicit

Sub chkKeyboardEntry_Click ()
    Date1.KeyboardEntry = chkKeyboardEntry
End Sub

Sub chkShowButtons_Click ()
    Date1.ShowButtons = chkShowButtons
End Sub

Sub chkWrapAround_Click ()
    Date1.WrapAround = chkWrapAround
End Sub

Sub cmbFormat_Change ()
    Date1.Format = cmbFormat.Text

    ' Disable the option to set the time resolution
    ' if the format string does not contain the string
    ' "ttttt"
    If InStr(LCase$(cmbFormat.Text), "ttttt") = 0 Then
	optTimeResolution(0).Enabled = False
	optTimeResolution(1).Enabled = False
    Else
	optTimeResolution(0).Enabled = True
	optTimeResolution(1).Enabled = True
    End If
End Sub

Sub cmbFormat_Click ()
    Date1.Format = cmbFormat.Text

    ' Disable the option to set the time resolution
    ' if the format string does not contain the string
    ' "ttttt"
    If InStr(LCase$(cmbFormat.Text), "ttttt") = 0 Then
	optTimeResolution(0).Enabled = False
	optTimeResolution(1).Enabled = False
    Else
	optTimeResolution(0).Enabled = True
	optTimeResolution(1).Enabled = True
    End If
End Sub

Sub cmbLanguage_Click ()
    Date1.Language = cmbLanguage.Text
End Sub

Sub cmdClear_Click ()
    ' An alternative way to clear the text is
    ' to set the text property to the empty string,
    ' ie Date1 = ""
    Date1.Clear
End Sub

Sub cmdCopyFromDate_Click ()
    txtDateTime = Date1
End Sub

Sub cmdCopyToDate_Click ()
    On Error GoTo InvalidDateTime
    Date1 = txtDateTime
    Exit Sub

InvalidDateTime:
    MsgBox Error$, 48
    Exit Sub
End Sub

Sub cmdNow_Click ()
    Date1 = "Now"
End Sub

Sub Date1_DragDrop (Source As Control, X As Single, Y As Single)
    On Error GoTo Date1_DragDrop_InvalidDateTime
    If TypeOf Source Is TextBox Then
	Date1 = Source.Text
    End If
    Exit Sub

Date1_DragDrop_InvalidDateTime:
    MsgBox Error$, 48
    Exit Sub
End Sub

Sub Date1_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (Button And 2) = 2 Then
	' right mouse button pressed
	PopupMenu mnuDtedit
    End If
End Sub

Sub Date1_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If (Button And 1) = 1 Then
	' start drag if left button is down
	Date1.Drag
    End If
End Sub

Sub Form_Load ()
    cmbFormat.AddItem "ddd ddddd ttttt"
    cmbFormat.AddItem "dddddd ttttt"
    cmbFormat.AddItem "yyyy-mm-dd hh:mm:ss"
    cmbFormat.AddItem "m/d/yy hh:mm:ss ampm"
    cmbFormat.AddItem "dd/mm/yyyy hh:mm:ss"
    cmbFormat.AddItem "d-mmm-yy"
    cmbFormat.AddItem "ddd mmm dd hh:mm:ss yyyy"
    cmbFormat.ListIndex = 0

    cmbLanguage.AddItem "Default"
    cmbLanguage.AddItem "Danish"
    cmbLanguage.AddItem "Dutch"
    cmbLanguage.AddItem "English"
    cmbLanguage.AddItem "Finnish"
    cmbLanguage.AddItem "French"
    cmbLanguage.AddItem "French Canadian"
    cmbLanguage.AddItem "German"
    cmbLanguage.AddItem "Icelandic"
    cmbLanguage.AddItem "Italian"
    cmbLanguage.AddItem "Norwegian"
    cmbLanguage.AddItem "Portuguese"
    cmbLanguage.AddItem "Spanish"
    cmbLanguage.AddItem "Swedish"
    cmbLanguage.ListIndex = 0

    ' Initialise Alignment display
    optAlignment(Date1.Alignment) = True

    ' Initialise TimeResolution display
    optTimeResolution(Date1.TimeResolution) = True
    txtTimeStep = Str$(Date1.TimeStep)

    ' Initialise ShowButtons display
    If Date1.ShowButtons Then
	chkShowButtons = 1
    Else
	chkShowButtons = 0
    End If

    If Date1.WrapAround Then
	chkWrapAround = 1
    Else
	chkWrapAround = 0
    End If

    If Date1.KeyboardEntry Then
	chkKeyboardEntry = 1
    Else
	chkKeyboardEntry = 0
    End If



End Sub

Sub mnuDteditClear_Click ()
    Date1 = ""
End Sub

Sub mnuDteditInformation_Click ()
    Dim T$
    T$ = "You can put any popup menu you like with this control."
    T$ = T$ & "  These menu items are for demonstration only."
    T$ = T$ & "  Use the VB 'PopupMenu' command for displaying popup menus."
    MsgBox T$, 64, "About Popup Menus"
End Sub

Sub mnuDteditNow_Click ()
    Date1 = "Now"
End Sub

Sub mnuDteditTomorrow_Click ()
    Date1 = Format(Now + 1, "ddddd ttttt")
End Sub

Sub mnuDteditYesterday_Click ()
    Date1 = Format$(Now - 1, "ddddd ttttt")
End Sub

Sub optAlignment_Click (Index As Integer)
    Date1.Alignment = Index
End Sub

Sub optTimeResolution_Click (Index As Integer)
    Date1.TimeResolution = Index
End Sub

Sub txtDateTime_DragDrop (Source As Control, X As Single, Y As Single)
    txtDateTime.Text = Source
End Sub

Sub txtDateTime_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    txtDateTime.Drag
End Sub

Sub txtTimeStep_Change ()
    On Error GoTo InvalidTimeStep
    Date1.TimeStep = Val(txtTimeStep)
    Exit Sub

InvalidTimeStep:
    MsgBox "Invalid value for TimeStep property"
    txtTimeStep = "1"
    Exit Sub
End Sub

