VERSION 2.00
Begin Form Chat 
   Caption         =   "MSlot VBX Sample - Network Chat"
   ClientHeight    =   6375
   ClientLeft      =   1245
   ClientTop       =   1845
   ClientWidth     =   7815
   Height          =   6780
   Left            =   1185
   LinkTopic       =   "Form1"
   ScaleHeight     =   6375
   ScaleWidth      =   7815
   Top             =   1500
   Width           =   7935
   Begin TextBox txtLocal 
      Height          =   975
      Left            =   120
      TabIndex        =   0
      Text            =   "User Types Text Here"
      Top             =   5280
      Width           =   7575
   End
   Begin TextBox txtChat 
      Height          =   4575
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      TabStop         =   0   'False
      Text            =   "Output Appears Here"
      Top             =   600
      Width           =   7575
   End
   Begin VBMailslots Mailslot1 
      Height          =   420
      Interval        =   250
      Left            =   7320
      MailslotName    =   ""
      MailslotSize    =   4000
      Message         =   ""
      MessageSize     =   400
      Priority        =   0
      Timeout         =   0
      Top             =   120
      Width           =   420
   End
End
Option Explicit

Sub Form_Load ()
    ' clear edit boxes
    txtLocal = ""
    txtChat = ""

    ' create the mailslot
    Mailslot1.MailslotName = "\MAILSLOT\NetChat"
    Mailslot1.Action = MSLOT_OPEN

    ' tell everyone that we're here
    SendMessage "Has joined the group ..."
End Sub

Sub Form_Resize ()
    ' resize/position output edit box
    txtChat.Left = 120
    txtChat.Top = 120
    txtChat.Height = Chat.ScaleHeight - 360 - 975
    txtChat.Width = Chat.ScaleWidth - 240

    ' resize/position input edit box
    txtLocal.Top = Chat.ScaleHeight - 120 - 975
    txtLocal.Left = 120
    txtLocal.Height = 975
    txtLocal.Width = Chat.ScaleWidth - 240
End Sub

Sub Form_Unload (Cancel As Integer)
    SendMessage "Is leaving ..."
End Sub

Sub Mailslot1_MessageWaiting (MessageCount As Integer)
    ' read twice to deal with W4Wg bug
    On Error Resume Next
    Mailslot1.Action = MSLOT_READ
    Mailslot1.Action = MSLOT_READ
    On Error GoTo 0

    ' add new message to edit box
    If txtChat <> "" Then
        txtChat = txtChat & Chr(13) & Chr(10)
    End If

    txtChat = txtChat & Mailslot1.Message
    txtChat.SelStart = Len(txtChat)
End Sub

Sub SendMessage (Text)
    Dim TempMessage As String

    ' send message
    Mailslot1.Message = Mailslot1.UserName & " (" & Mailslot1.ComputerName & "): " & Text
    Mailslot1.MailslotName = "\\*\MAILSLOT\NetChat"
    Mailslot1.Action = MSLOT_WRITE
End Sub

Sub txtLocal_KeyPress (KeyAscii As Integer)
    ' if the user pressed Enter, send result to net
    If KeyAscii = 13 Then
        KeyAscii = 0

        SendMessage txtLocal

        ' clear edit box
        txtLocal = ""
    End If
End Sub

Sub txtLocal_LostFocus ()
    ' make sure focus remains here
    txtLocal.SetFocus
End Sub

