#include <windows.h>

#include <stdio.h>
#include <ctype.h>
#include <string.h>

#include "winio.h"
#include "rcp.h"

LPSTR rtitle = "Winsock RCP DLL Sample";

void rcp(argc,argv)
	int argc;
	char *argv[];
{
	int a, result;
	int rflag = 0, aflag = 0;

	
	// Examine command line arguments
	for(a = 1; a <= argc; a++)
	{
	  if (strcmp(argv[a],"-r") == 0)	// -r: Recursive flag
	    rflag = 1;
	  else if (strcmp(argv[a],"-a") == 0)	// -a: Ascii flag
	         aflag = 1;
	  else if (argv[a][0] == '-')		// Others are invalid
	       {
		 printf("Invalid option: %s\n",argv[a]);
	         printf("\nPress Return: ");
	         getchar();
		 return;
	       }
	       else				// Found first filename
		 break;
	}

	printf("Copying %s to %s\n",argv[a],argv[a+1]);
	result = WinsockRCP(winio_hwnd(),rtitle,argv[a],argv[a+1],rflag,aflag);

	if (result < 0)
	  printf("Remote Copy Was Not Successful.  Error Number: %d\n", result);
	else
	  printf("Remote Copy Successful\n%d Files Copied\n",result);

	printf("\nPress Return: ");
	getchar();
}

#define argc __argc
#define argv __argv

extern int __argc;
extern char **__argv;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	
	winio_settitle("Winsock RCP DLL Sample");
	nCmdShow = SW_SHOWNORMAL;

	if (! winio_init(hInstance, hPrevInstance, nCmdShow, 16384))
	  return 1;
	
	rcp(argc, argv);

	winio_close();

	return TRUE;
}

