{$A-,B-,D+,E+,F-,I+,L+,N-,O-,R-,S+,V+}
{$M 16384,0,16384}

{ This program reads a Ventura Publisher (VP) chapter file (.CHP) and
  creates a .ZIP archive using the PKWare utility programs.  The program
  can optionally back up the width file referenced by the VP .STY style
  file, as well as make the resulting .ZIP file a self-extracting archive.

  If you've already created an archive for a particular chapter, running
  ArcVpChp against that chapter will update, not replace, the previously
  created archive.  I thought about deleting any previously created archive
  by the same name, but thought the benefits outweighed the drawbacks. Note
  that the self-extracting archive WILL be replaced by a newer version, but
  not the .ZIP archive.  Another note is that if you create the .EXE self-
  extracting archive, the .ZIP archive that it was created from is deleted.
  If you want to keep the .ZIP file for some reason, make the conversion
  yourself.

  For those not familiar with the PKWare utility programs PKZIP, PKUNZIP and
  the rest of the programs in this set, you are referred to just about any
  bulletin board (BBS).  The PKWare utilities seem to be the most frequently
  used archive programs.  They make it much easier to download programs since
  they both reduce the space required by the files and hence reduce the time
  required to download the files from the BBS, as well as keep as set of
  related files together in one archive.  The current version of these
  utilities as of 11/16/89 is version 1.02, but ArcVpChp should work with
  older versions, as well.

  The instructions for using these programs may be found with these programs.
  You need, at least, the archive creator program PKZIP.EXE.  If you want
  to be able to unextract the files from the archive, you also need to
  have PKUNZIP.EXE available.  If you want to make the .ZIP archive into
  a self-extracting archive, you also need ZIP2EXE.EXE and PKSFX.PRG.
  Follow the instructions for the PKWare utilities for creating PKSFX.PRG.
  All of these must be on the DOS PATH= statement for ArcVpChp to work
  properly.

  This program is not meant to represent the world's greatest coding - it
  works.  It'd be nice if it was menu-driven and drew nice pretty pictures,
  but what the heck - the price is right....  Maybe in version 2.

  Basically, the program reads the specified .CHP file and writes the
  appropriate filenames to a temporary file.  PKZIP is then called to
  create the archive and add the files whose names are in the temporary
  file.  If you want a self-extracting file, the ZIP2EXE is called to
  make this conversion, and it creates an executable .EXE file that
  may be run by itself or modified/extracted/updated with PKZIP or PKUNZIP.

  This program was written by Bob White and is hereby donated to the
  public domain and anyone may use it without charge.  If you have comments,
  questions, or futher development ideas, leave me a message on CompuServe,
  ID 71121,2333. }

Program Archive_VP_Chapters;

  Uses
    Dos;

  var
    Chapter_File                 : Text;
    Chapter_FileName             : PathStr;
    Style_Name                   : PathStr;
    Width_Name                   : PathStr;
    A_File_Name                  : PathStr;
    Current_File_Line            : String;
    Chapter_Dir                  : DirStr;
    Chapter_Name                 : NameStr;
    Chapter_Ext                  : ExtStr;
    Line_Type                    : Integer;
    Temp_File                    : Text;
    ParamTemp                    : String;
    Plen                         : Integer;
    PKZIP_Line                   : String;
    PKZIP_Path                   : PathStr;
    I,J                          : Integer;
    Save_Width                   : Boolean;
    Self_Extract                 : Boolean;

    Current_Directory            : String;
    New_Directory                : String;

  const
    Ext_Types : String[24] = '.CHP.CAP.CIF.VGR.GEN.$HP';
    File_Check : String[9] = '#T #G #I ';

    PKZ_Name : String[12] = 'PKZIP.EXE';
    Z2E_Name : String[12] = 'ZIP2EXE.EXE';
    Temp_File_Name : String[12] = 'CHP.TXT';

{ Find the names of any files with the same name as the .CHP file.  Valid
  files are checked against the string EXT_TYPES and only those files whose
  file extension is in that string are copied to the archive.  I did this
  to limit the number of files that might be put in the archive.  For
  example, if you named the style file to be the same thing as the chapter
  file, this routine would cause the style file to be archived twice - once
  here, and once because the chapter file references it directly. }

  Procedure Find_Chapter_Files;

    var
      Search_Buffer              : SearchRec;
      File_Dir                   : DirStr;
      File_Name                  : NameStr;
      File_Ext                   : ExtStr;
      This_File                  : PathStr;

    begin



      FindFirst( Chapter_Dir+Chapter_Name+'.*', AnyFile, Search_Buffer );
      While DosError = 0 do
        begin
          This_File := FExpand( Chapter_Dir + Search_Buffer.Name );
          FSplit( This_File, File_Dir, File_Name, File_Ext );

{ If the 4-character file type is found in the string EXT_TYPES, then
  add it to the archive list.  To add additional file types to the list,
  append it to the string in the CONST section above. }

          If Pos( File_Ext, Ext_Types ) <> 0 then
            Writeln(Temp_File, This_File );

          FindNext( Search_Buffer );
        end;
    end;

{ This procedure scans a line from the chapter file for whatever filename
  is on this line.  The routine keys on the ":\" portion of the filename.
  Characters are copied to the buffer until a blank or the end of the line
  is reached. }

  Procedure Scan_For_Filename( var A_Path : PathStr );

    var
      I,J,K                      : Integer;
      Loc                        : Integer;
      Max                        : Integer;
      AChar                      : Char;
    begin
      Loc := Pos( ':\', Current_File_Line );
      If Loc > 0 then
        begin
          Max := Length( Current_File_Line );
          I := Loc - 1;
          J := 0;
          AChar := Current_File_Line[I];

          While (AChar <> ' ') and (I <= Max ) do
            begin
              J := J + 1;
              A_Path[J] := AChar;
              I := I + 1;
              AChar := Current_File_Line[I];
            end;

          A_Path[0] := Char(J);
        end;
    end;

{ This routine extracts the width filename from the .STY file.  It assumes
  that the width filename always begins with the ninth character of the
  file and is a null-terminated string. }

  Procedure Get_Width_FileName( Style_Name : PathStr;
                            var Width_Name : PathStr );

    var
      Style_File                : File;
      Buffer                    : Array[1..128] of Char;
      I,J                       : Integer;

    begin
      Assign( Style_File, Style_Name  );
      {$I-} Reset( Style_File, 1 ); {$I+}

      If IOResult <> 0 then
        begin
          Writeln('** Cannot open style file **');
          Exit;
        end;

      BlockRead( Style_File, Buffer, Sizeof( Buffer ) );
      Close( Style_File );

      I := 9;      {Width filename begins after 8th character }
      J := 0;
      Width_Name := '';

      While Buffer[I] <> #0 do
        begin
          J := J + 1;
          Width_Name[J] := Buffer[I];
          I := I + 1;
        end;

      Width_Name[0] := Char(J);

    end;

{ This routine deletes a file }

  Procedure Delete_A_File( A_File_Name : PathStr );

    begin
      Assign( Temp_File, A_File_Name );
      {$I-} Reset( Temp_File ); {$I+}
      If IOResult = 0 then
        begin
          Close( Temp_File );
          Erase( Temp_File );
        end;
    end;

  begin

{ Default values }

    Save_Width := False;
    Self_Extract := False;
    Chapter_FileName := '';

    Writeln;
    Writeln('ArcVpChp - Archive Ventura Publisher Chapters v. 1.0',
            ' -- by Bob White');
    Writeln;

{ If nothing specified on the command line, print a help message }

    If ParamCount = 0 then
      begin
        Writeln(' This program creates a .ZIP archive of all files referenced');
        Writeln(' in a Ventura Publisher .CHP chapter file.  Usage:');
        Writeln;
        Writeln('ArcVpChp {chapter} [/WIDTH] [/SELF]');
        Writeln;
        Writeln(' {chapter} is the full pathname to the .CHP chapter file');
        Writeln(' /WIDTH will also archive width file referenced in the .STY');
        Writeln('   style file.  Default is not to archive the width file.');
        Writeln(' /SELF will create a self-extracting archive.  The default');
        Writeln('   is to not create a self-extracting archive.');
        Halt;
      end;

{ Do a simple check for the various parameters.  They may be in any order,
  and the option switches may be in any order and may also be abbreviated
  to the minimum to get a unique combination.  Assume anything that doesn't
  begin with a "/" is a filename.  This routine will let you specify several
  filenames on the command line, but it will only process the last one. }

    For I := 1 to ParamCount do
      begin
        ParamTemp := ParamStr(I);
        PLen := Length( ParamTemp );
        For J := 1 to PLen do ParamTemp[J] := Upcase( ParamTemp[J] );

        If ParamTemp[1] = '/' then
          begin
            If Plen = 1 then Plen := 2;  {Must specify 2 characters}
            If Copy('/WIDTH', 1, PLen ) = ParamTemp then Save_Width := True;
            If Copy('/SELF', 1, PLen ) = ParamTemp then Self_Extract := True;
          end
         else
          Chapter_FileName := FExpand( ParamTemp );
      end;

    If Chapter_FileName = '' then
      begin
        Writeln('** Please specify the chapter name on the command line **');
        Halt;
      end;

{ Split the name into it's various pieces }

    FSplit( Chapter_FileName, Chapter_Dir, Chapter_Name, Chapter_Ext );

    Assign( Chapter_File, Chapter_FileName );
    {$I-} Reset( Chapter_File ); {$I+}

    If IOResult <> 0 then
      begin
        Writeln('Could not open chapter: ', Chapter_FileName );
        Halt;
      end;

    Readln( Chapter_File, Current_File_Line );

{ The program expects the first line to begin with #D, which specifies the
  name of the style file used by this chapter. }

    If Copy( Current_File_Line, 1, 3 ) <> '#D ' then
      begin
        Writeln('** That is not a valid VP Chapter file **');
        Close( Chapter_File );
        Halt;
      end;

    Assign( Temp_File, Temp_File_Name );
    {$I-} Rewrite( Temp_File ); {$I+}

    If IOResult <> 0 then
      begin
        Writeln('** Cannot create temporary file **');
        Halt;
      end;

{ Find those files with the same name as the chapter file }

    Find_Chapter_Files;

{ Get the name of the style file from chapter file. }

    Scan_For_Filename( Style_Name );
    Writeln( Temp_File, FExpand( Style_Name ) );

{ If we're going to save the width file as well, get the name from the
  style file and write it to the temporary file. }

    If Save_Width then
      begin
        Get_Width_FileName( Style_Name, Width_Name );
        Writeln( Temp_File, FExpand( Width_Name ) );
      end;

{ Now scan the chapter for the various text, image, or graphics files. VP
  seems to have record identifiers #T for text files, #G for line art, and
  #I for image files.  I haven't encountered others, anyway....}

    While not EOF( Chapter_File ) do
      begin
        Readln( Chapter_File, Current_File_Line );
        Line_Type := Pos( Copy( Current_File_Line, 1, 3 ), File_Check );

        Case Line_Type of
          0 : begin end;               {Not one we're looking for...}

          1 : begin
                Scan_For_Filename( A_File_Name );
                Writeln(Temp_File, FExpand( A_File_Name ) );
              end;

          4 : begin
                Scan_For_Filename( A_File_Name );
                Writeln(Temp_File, FExpand( A_File_Name ) );
              end;

          7 : begin
                Scan_For_Filename( A_File_Name );
                Writeln(Temp_File, FExpand( A_File_Name ) );
              end;
          end;
      end;
    Close( Chapter_File );
    Close( Temp_File );

{ Run PKZIP to create the archive.  Build the command line containing the
  desired archive name (same as chapter name) and tell it the files to
  archive are in the temporary file. }

{ Marc: -P -r are good command line options to embed path names
in there too 11/8/90}

{    PKZIP_Line := '/A ' + Chapter_Dir + Chapter_Name + ' @' + Temp_File_Name; }
    PKZIP_Line := '-P -r /A ' + Chapter_Dir + Chapter_Name + ' @' + Temp_File_Name;
    PKZIP_Path := FSearch( PKZ_Name, GetEnv( 'PATH' ) );

    If PKZIP_Path <> '' then
      begin
        PKZIP_Path := FExpand( PKZIP_Path );

        Exec( PKZIP_Path, PKZIP_Line );
        Exec( 'C:\command.com ', '/c Copy CHP.TXT '+ Chapter_Dir+Chapter_Name + '.TXT');
        Exec( PKZIP_Path, Chapter_Dir+Chapter_Name +' '+Chapter_Name+'.TXT' ); {Marc: Zip in the list of files}
      end
     else
      begin
        Writeln('** Cannot archive chapter files **');
        Writeln('     - cannot find ',PKZ_Name,' on the DOS PATH');
      end;

    Delete_A_File( Temp_File_Name );

{ If we're going to create a self-extracting archive, then set the
  stuff up for ZIP2EXE.  ZIP2EXE only accepts the name of the archive
  to create the self-extracting file from, and doesn't accept a destination
  file, so we have to change to the proper directory so the self-extracting
  archive is in the same directory as the chapter file.  The .ZIP file is
  deleted after the .EXE file is created. }

    If Self_Extract then
      begin

        PKZIP_Line := Chapter_Dir + Chapter_Name + '.ZIP';
        PKZIP_Path := FSearch( Z2E_Name, GetEnv( 'PATH' ) );

        If PKZIP_Path <> '' then
          begin
            PKZIP_Path := FExpand( PKZIP_Path );

            GetDir( 0, Current_Directory );
            New_Directory := Chapter_Dir;
            I := Length( New_Directory );
            If (I > 3) and (New_Directory[I] = '\') then
              Delete(New_Directory, I, 1);
            ChDir( New_Directory );

            Exec( PKZIP_Path, PKZIP_Line );

            Delete_A_File( PKZIP_Line );
            ChDir( Current_Directory );

          end
         else
           begin
            Writeln('** Cannot make archive self-extracting **');
            Writeln('     - cannot find ',Z2E_Name,' on the DOS PATH');
           end;
      end;
  end.
