PROGRAM maze;
  {
         This program will display a maze in three dimensions.  A different
    random number seed will produce a different maze.

         Written by James L. Dean
                    406 40th Street
                    New Orleans, LA 70124
  }
  USES Crt,Graph;

  TYPE

    prime_rec_ptr = ^prime_rec;
    prime_rec = RECORD
                  x         : REAL;
                  y         : REAL;
                  z         : REAL;
                  right     : prime_rec_ptr;
                  down      : prime_rec_ptr;
                  lesser_x  : prime_rec_ptr;
                  greater_x : prime_rec_ptr
                END;
    string_1 = STRING[1];

  VAR
    aspect_y                   : REAL;
    aspect_z                   : REAL;
    aspect_ratio               : REAL;
    ErrorCode                  : INTEGER;
    GraphDriver                : INTEGER;
    GraphMode                  : INTEGER;
    continue                   : BOOLEAN;
    delta_index_1              : INTEGER;
    delta_index_1a             : INTEGER;
    delta_index_1b             : INTEGER;
    delta_index_1c             : INTEGER;
    delta_index_1d             : INTEGER;
    delta_index_2              : INTEGER;
    delta_x                    : ARRAY [1..4,1..24] OF INTEGER;
    delta_y                    : ARRAY [1..4,1..24] OF INTEGER;
    digit                      : INTEGER;
    digit_num                  : INTEGER;
    max_x                      : INTEGER;
    max_y                      : INTEGER;
    max_y_out                  : INTEGER;
    max_z_out                  : INTEGER;
    num_columns                : INTEGER;
    num_rows                   : INTEGER;
    num_x_divisions            : INTEGER;
    num_y_divisions            : INTEGER;
    page                       : ARRAY [0..24,0..32] OF CHAR;
    prime_head                 : prime_rec_ptr;
    prime_ptr                  : prime_rec_ptr;
    r_n                        : ARRAY [1..8] OF INTEGER;
    r_n_index_1                : INTEGER;
    r_n_index_2                : INTEGER;
    response                   : CHAR;
    result                     : REAL;
    rotation                   : REAL;
    seed                       : STRING[8];
    sum                        : INTEGER;
    tem_int                    : INTEGER;
    tem_real                   : REAL;
    tilt                       : REAL;
    x                          : INTEGER;
    x_max                      : REAL;
    x_min                      : REAL;
    x_next                     : INTEGER;
    x_out                      : INTEGER;
    x_wall_1                   : INTEGER;
    y                          : INTEGER;
    y_aspect                   : WORD;
    y_max                      : REAL;
    y_min                      : REAL;
    y_next                     : INTEGER;
    y_out                      : INTEGER;
    y_prime_max                : REAL;
    y_prime_min                : REAL;
    y_wall_1                   : INTEGER;
    z_aspect                   : WORD;
    z_prime_max                : REAL;
    z_prime_min                : REAL;

  PROCEDURE add_room;
    VAR
      delta_index_1 : BYTE;
      delta_index_2 : BYTE;
    BEGIN
      page[y,x]:=' ';
      delta_index_1:=1;
      REPEAT
        delta_index_2:=r_n[1];
        r_n_index_1:=1;
        FOR r_n_index_2:=2 TO 8 DO
          BEGIN
            tem_int:=r_n[r_n_index_2];
            r_n[r_n_index_1]:=tem_int;
            delta_index_2:=delta_index_2+tem_int;
            IF delta_index_2 > 29 THEN
              delta_index_2:=delta_index_2-29;
            r_n_index_1:=r_n_index_2
          END;
        r_n[8]:=delta_index_2
      UNTIL
        (delta_index_2 <= 24);
      WHILE (delta_index_1 <= 4) DO
        BEGIN
          x_next:=x+2*delta_x[delta_index_1][delta_index_2];
          IF ((x_next <= 0) OR (x_next >= max_x)) THEN
            delta_index_1:=delta_index_1+1
          ELSE
            BEGIN
              y_next:=y+2*delta_y[delta_index_1][delta_index_2];
              IF ((y_next <= 0) OR (y_next >= max_y)) THEN
                delta_index_1:=delta_index_1+1
              ELSE
                IF page[y_next,x_next] = 'W' THEN
                  BEGIN
                    IF x = x_next THEN
                      BEGIN
                        y_wall_1:=(y+y_next) DIV 2;
                        page[y_wall_1,x_next]:=' '
                      END
                    ELSE
                      BEGIN
                        x_wall_1:=(x+x_next) DIV 2;
                        page[y_next,x_wall_1]:=' '
                      END;
                    x:=x_next;
                    y:=y_next;
                    add_room;
                    x:=x-2*delta_x[delta_index_1][delta_index_2];
                    y:=y-2*delta_y[delta_index_1][delta_index_2]
                  END
                ELSE
                  delta_index_1:=delta_index_1+1
            END
        END
    END;
  FUNCTION f(x,y : REAL) : REAL;
    VAR
      x_out     : INTEGER;
      y_out     : INTEGER;
    BEGIN
      y_out:=TRUNC(x/2.0)-1;
      IF y_out < 0 THEN
        f:=0.0
      ELSE
        IF y_out > max_y THEN
          f:=0.0
        ELSE
          BEGIN
            x_out:=TRUNC(y/2.0)-1;
            IF x_out < 0 THEN
              f:=0.0
            ELSE
              IF x_out > max_x THEN
                f:=0.0
              ELSE
                IF page[y_out,x_out] = 'W' THEN
                  f:=x_max/7.0
                ELSE
                  f:=0.0
          END
    END;
  PROCEDURE evaluate_and_transform(
   VAR x_min           : REAL;
   VAR x_max           : REAL;
   VAR y_min           : REAL;
   VAR y_max           : REAL;
   VAR num_x_divisions : INTEGER;
   VAR num_y_divisions : INTEGER;
   VAR rotation        : REAL;
   VAR tilt            : REAL;
   VAR prime_head      : prime_rec_ptr;
   VAR y_prime_min     : REAL;
   VAR y_prime_max     : REAL;
   VAR z_prime_min     : REAL;
   VAR z_prime_max     : REAL);
    TYPE
      up_rec_ptr = ^up_rec;
      up_rec = RECORD
                 up       : prime_rec_ptr;
                 next     : up_rec_ptr;
                 previous : up_rec_ptr;
               END;
    VAR
      cos_rotation       : REAL;
      cos_tilt           : REAL;
      delta_x            : REAL;
      delta_y            : REAL;
      finished           : BOOLEAN;
      last_prime_ptr     : prime_rec_ptr;
      prime_tail         : prime_rec_ptr;
      prime_ptr          : prime_rec_ptr;
      radians            : REAL;
      radians_per_degree : REAL;
      left               : prime_rec_ptr;
      sin_rotation       : REAL;
      sin_tilt           : REAL;
      up_head            : up_rec_ptr;
      up_ptr             : up_rec_ptr;
      up_tail            : up_rec_ptr;
      x                  : REAL;
      x_division_num     : INTEGER;
      y                  : REAL;
      y_division_num     : INTEGER;
      x_rotated          : REAL;
      z                  : REAL;
    BEGIN
      radians_per_degree:=arctan(1.0)/45.0;
      radians:=tilt*radians_per_degree;
      cos_tilt:=COS(radians);
      sin_tilt:=SIN(radians);
      radians:=rotation*radians_per_degree;
      cos_rotation:=COS(radians);
      sin_rotation:=SIN(radians);
      z:=f(x_min,y_min);
      x_rotated:=x_min*cos_rotation+y_min*sin_rotation;
      y_prime_min:=-x_min*sin_rotation+y_min*cos_rotation;
      z_prime_min:=-x_rotated*sin_tilt+z*cos_tilt;
      y_prime_max:=y_prime_min;
      z_prime_max:=z_prime_min;
      last_prime_ptr:=NIL;
      delta_x:=num_x_divisions;
      delta_x:=(x_max-x_min)/delta_x;
      delta_y:=num_y_divisions;
      delta_y:=(y_max-y_min)/delta_y;
      up_head:=NIL;
      up_tail:=NIL;
      FOR y_division_num:=1 TO num_y_divisions DO
        BEGIN
          NEW(up_ptr);
          up_ptr^.up:=NIL;
          IF up_head = NIL THEN
            BEGIN
              up_head:=up_ptr;
              up_ptr^.previous:=NIL
            END
          ELSE
            BEGIN
              up_tail^.next:=up_ptr;
              up_ptr^.previous:=up_tail
            END;
          up_ptr^.next:=NIL;
          up_tail:=up_ptr
        END;
      x:=x_min;
      FOR x_division_num:=1 TO num_x_divisions DO
        BEGIN
          left:=NIL;
          up_ptr:=up_head;
          y:=y_min;
          FOR y_division_num:=1 TO num_y_divisions DO
            BEGIN
              z:=f(x,y);
              NEW(prime_ptr);
              IF left <> NIL THEN
                left^.right:=prime_ptr;
              IF up_ptr^.up <> NIL THEN
                up_ptr^.up^.down:=prime_ptr;
              x_rotated:=x*cos_rotation+y*sin_rotation;
              prime_ptr^.y:=-x*sin_rotation+y*cos_rotation;
              prime_ptr^.x:=x_rotated*cos_tilt+z*sin_tilt;
              prime_ptr^.z:=-x_rotated*sin_tilt+z*cos_tilt;
              IF prime_ptr^.y < y_prime_min THEN
                y_prime_min:=prime_ptr^.y;
              IF prime_ptr^.y > y_prime_max THEN
                y_prime_max:=prime_ptr^.y;
              IF prime_ptr^.z < z_prime_min THEN
                z_prime_min:=prime_ptr^.z;
              IF prime_ptr^.z > z_prime_max THEN
                z_prime_max:=prime_ptr^.z;
              IF last_prime_ptr = NIL THEN
                BEGIN
                  prime_head:=prime_ptr;
                  prime_tail:=prime_ptr;
                  prime_ptr^.lesser_x:=NIL;
                  prime_ptr^.greater_x:=NIL
                END
              ELSE
                IF prime_ptr^.x < last_prime_ptr^.x THEN
                  BEGIN
                    finished:=FALSE;
                    WHILE (NOT finished) DO
                      BEGIN
                        last_prime_ptr:=last_prime_ptr^.lesser_x;
                        IF last_prime_ptr = NIL THEN
                          finished:=TRUE
                        ELSE
                          BEGIN
                            IF prime_ptr^.x >= last_prime_ptr^.x THEN
                              finished:=TRUE
                          END
                      END;
                    prime_ptr^.lesser_x:=last_prime_ptr;
                    IF last_prime_ptr = NIL THEN
                      BEGIN
                        prime_head^.lesser_x:=prime_ptr;
                        prime_ptr^.greater_x:=prime_head;
                        prime_head:=prime_ptr
                      END
                    ELSE
                      BEGIN
                        prime_ptr^.greater_x
                         :=last_prime_ptr^.greater_x;
                        last_prime_ptr^.greater_x^.lesser_x:=prime_ptr;
                        last_prime_ptr^.greater_x:=prime_ptr
                      END
                  END
                ELSE
                  BEGIN
                    finished:=FALSE;
                    WHILE (NOT finished) DO
                      BEGIN
                        last_prime_ptr:=last_prime_ptr^.greater_x;
                        IF last_prime_ptr = NIL THEN
                          finished:=TRUE
                        ELSE
                          BEGIN
                            IF prime_ptr^.x <= last_prime_ptr^.x THEN
                              finished:=TRUE
                          END
                      END;
                    prime_ptr^.greater_x:=last_prime_ptr;
                    IF last_prime_ptr = NIL THEN
                      BEGIN
                        prime_tail^.greater_x:=prime_ptr;
                        prime_ptr^.lesser_x:=prime_tail;
                        prime_tail:=prime_ptr
                      END
                    ELSE
                      BEGIN
                        prime_ptr^.lesser_x
                         :=last_prime_ptr^.lesser_x;
                        last_prime_ptr^.lesser_x^.greater_x:=prime_ptr;
                        last_prime_ptr^.lesser_x:=prime_ptr
                      END
                  END;
              left:=prime_ptr;
              up_ptr^.up:=prime_ptr;
              up_ptr:=up_ptr^.next;
              last_prime_ptr:=prime_ptr;
              y:=y+delta_y
            END;
          left^.right:=NIL;
          x:=x+delta_x
        END;
      WHILE (up_head <> NIL) DO
        BEGIN
          up_head^.up^.down:=NIL;
          up_ptr:=up_head^.next;
          DISPOSE(up_head);
          up_head:=up_ptr
        END
    END;
  PROCEDURE plot(
   VAR prime_head      : prime_rec_ptr;
   VAR y_prime_min     : REAL;
   VAR y_prime_max     : REAL;
   VAR z_prime_min     : REAL;
   VAR z_prime_max     : REAL;
   VAR max_y_out       : INTEGER;
   VAR max_z_out       : INTEGER;
   VAR aspect_ratio    : REAL);
    VAR
      box               : ARRAY [1..4] OF PointType;
      pixels_per_unit   : REAL;
      prime_ptr         : prime_rec_ptr;
      y_offset          : REAL;
      y_out_max         : REAL;
      z_offset          : REAL;
      z_out_max         : REAL;
    BEGIN
      y_out_max:=max_y_out;
      z_out_max:=max_z_out;
      IF aspect_ratio*z_out_max*(y_prime_max-y_prime_min)
       > y_out_max*(z_prime_max-z_prime_min) THEN
        BEGIN
          pixels_per_unit
           :=y_out_max/(aspect_ratio*(y_prime_max-y_prime_min));
          y_offset:=0.0;
          z_offset
           :=-(z_out_max-pixels_per_unit*(z_prime_max-z_prime_min))/2.0
        END
      ELSE
        IF aspect_ratio*z_out_max*(y_prime_max-y_prime_min)
         < y_out_max*(z_prime_max-z_prime_min) THEN
          BEGIN
            pixels_per_unit:=z_out_max/(z_prime_max-z_prime_min);
            y_offset:=(y_out_max
             -aspect_ratio*pixels_per_unit*(y_prime_max-y_prime_min))
             /2.0;
            z_offset:=0.0
          END
        ELSE  { plot degenerates to a single point }
          BEGIN
            pixels_per_unit:=1.0;
            y_offset:=y_out_max/2.0;
            z_offset:=-z_out_max/2.0
          END;
      SetColor(GetMaxColor);
      SetFillStyle(SolidFill,0);
      SetLineStyle(SolidLn,0,NormWidth);
      prime_ptr:=prime_head;
      WHILE (prime_ptr <> NIL) DO
        BEGIN
          IF (prime_ptr^.right <> NIL) THEN
            BEGIN
              IF (prime_ptr^.down <> NIL) THEN
                BEGIN
                  box[1].x:=TRUNC(y_offset+pixels_per_unit
                   *aspect_ratio*(prime_ptr^.y-y_prime_min));
                  box[1].y:=TRUNC(z_offset+z_out_max
                   -pixels_per_unit
                   *(prime_ptr^.z-z_prime_min));
                  box[2].x:=TRUNC(y_offset+pixels_per_unit
                   *aspect_ratio*(prime_ptr^.right^.y-y_prime_min));
                  box[2].y:=TRUNC(z_offset+z_out_max
                   -pixels_per_unit
                   *(prime_ptr^.right^.z-z_prime_min));
                  box[4].x:=TRUNC(y_offset+pixels_per_unit
                   *aspect_ratio*(prime_ptr^.down^.y-y_prime_min));
                  box[4].y:=TRUNC(z_offset+z_out_max
                   -pixels_per_unit
                   *(prime_ptr^.down^.z-z_prime_min));
                  box[3].x:=TRUNC(y_offset+pixels_per_unit
                   *aspect_ratio
                   *(prime_ptr^.down^.right^.y-y_prime_min));
                  box[3].y:=TRUNC(z_offset+z_out_max
                   -pixels_per_unit
                   *(prime_ptr^.down^.right^.z-z_prime_min));
                  FillPoly(4,box)
                END
            END;
          prime_ptr:=prime_ptr^.greater_x;
        END
    END;
  BEGIN
    ClrScr;
    WRITELN(OUTPUT,'                                 Maze Generator');
    WRITELN(OUTPUT,' '); WRITELN(OUTPUT,' '); WRITELN(OUTPUT,' ');
    WRITE(OUTPUT,'     Random number seed?  ');
    READLN(INPUT,seed);
    r_n_index_1:=1;
    FOR r_n_index_2:=1 TO LENGTH(seed) DO
      BEGIN
        tem_int:=ORD(seed[r_n_index_2]);
        WHILE (tem_int > 29) DO tem_int:=tem_int-29;
        r_n[r_n_index_1]:=tem_int;
        r_n_index_1:=r_n_index_1+1
      END;
    r_n_index_2:=8;
    WHILE (r_n_index_1 > 1) DO
      BEGIN
        r_n_index_1:=r_n_index_1-1;
        r_n[r_n_index_2]:=r_n[r_n_index_1];
        r_n_index_2:=r_n_index_2-1
      END;
    WHILE (r_n_index_2 >= 1) DO
      BEGIN
        r_n[r_n_index_2]:=19;
        r_n_index_2:=r_n_index_2-1
      END;
    delta_x[1,1]:=-1;
    delta_y[1,1]:=0;
    delta_x[2,1]:=0;
    delta_y[2,1]:=1;
    delta_x[3,1]:=1;
    delta_y[3,1]:=0;
    delta_x[4,1]:=0;
    delta_y[4,1]:=-1;
    delta_index_2:=0;
    FOR delta_index_1a:=1 TO 4 DO
      FOR delta_index_1b:=1 TO 4 DO
        IF delta_index_1a <> delta_index_1b THEN
          FOR delta_index_1c:=1 TO 4 DO
            IF ((delta_index_1a <> delta_index_1c)
            AND (delta_index_1b <> delta_index_1c)) THEN
              FOR delta_index_1d:=1 TO 4 DO
                IF ((delta_index_1a <> delta_index_1d)
                AND (delta_index_1b <> delta_index_1d)
                AND (delta_index_1c <> delta_index_1d)) THEN
                  BEGIN
                    delta_index_2:=delta_index_2+1;
                    delta_x[delta_index_1a,delta_index_2]:=delta_x[1,1];
                    delta_y[delta_index_1a,delta_index_2]:=delta_y[1,1];
                    delta_x[delta_index_1b,delta_index_2]:=delta_x[2,1];
                    delta_y[delta_index_1b,delta_index_2]:=delta_y[2,1];
                    delta_x[delta_index_1c,delta_index_2]:=delta_x[3,1];
                    delta_y[delta_index_1c,delta_index_2]:=delta_y[3,1];
                    delta_x[delta_index_1d,delta_index_2]:=delta_x[4,1];
                    delta_y[delta_index_1d,delta_index_2]:=delta_y[4,1]
                  END;
    GraphDriver:=Detect;
    InitGraph(GraphDriver,GraphMode,'');
    ErrorCode:=GraphResult;
    IF ErrorCode <> grOk THEN
      WRITELN(OUTPUT,'Fatal error:  ',GraphErrorMsg(ErrorCode))
    ELSE
      BEGIN
        max_y_out:=GetMaxX;
        max_z_out:=GetMaxY;
        GetAspectRatio(y_aspect,z_aspect);
        aspect_y:=y_aspect;
        aspect_z:=z_aspect;
        aspect_ratio:=aspect_z/aspect_y;
        num_columns:=max_y_out DIV 40;
        IF num_columns > 16 THEN
          num_columns:=16;
        tem_real:=max_z_out;
        num_rows:=TRUNC(tem_real*aspect_ratio/40.0);
        IF num_rows > 12 THEN
          num_rows:=12;
        max_x:=2*num_columns;
        max_y:=2*num_rows;
        FOR y_out:=0 TO max_y DO
          FOR x_out:=0 TO max_x DO
            page[y_out,x_out]:='W';
        sum:=0;
        FOR digit_num:=1 TO 3 DO
          BEGIN
            digit:=r_n[1];
            r_n_index_1:=1;
            FOR r_n_index_2:=2 TO 8 DO
              BEGIN
                tem_int:=r_n[r_n_index_2];
                r_n[r_n_index_1]:=tem_int;
                digit:=digit+tem_int;
                IF digit > 29 THEN
                  digit:=digit-29;
                r_n_index_1:=r_n_index_2
              END;
            r_n[8]:=digit;
            sum:=29*sum+digit
          END;
        x:=2*(sum MOD num_columns)+1;
        sum:=0;
        FOR digit_num:=1 TO 3 DO
          BEGIN
            digit:=r_n[1];
            r_n_index_1:=1;
            FOR r_n_index_2:=2 TO 8 DO
              BEGIN
                tem_int:=r_n[r_n_index_2];
                r_n[r_n_index_1]:=tem_int;
                digit:=digit+tem_int;
                IF digit > 29 THEN
                  digit:=digit-29;
                r_n_index_1:=r_n_index_2
              END;
            r_n[8]:=digit;
            sum:=29*sum+digit
          END;
        y:=2*(sum MOD num_rows)+1;
        add_room;
        page[0,1]:=' ';
        page[max_y,max_x-1]:=' ';
        x_min:=1.0;
        x_max:=max_y;
        x_max:=2.0*x_max+5.0;
        y_min:=1.0;
        y_max:=max_x;
        y_max:=2.0*y_max+5.0;
        num_x_divisions:=2*(max_y+3);
        num_y_divisions:=2*(max_x+3);
        continue:=TRUE;
        prime_head:=NIL;
        rotation:=20.0;
        tilt:=30.0;
        evaluate_and_transform(x_min,x_max,y_min,y_max,num_x_divisions,
         num_y_divisions,rotation,tilt,prime_head,y_prime_min,
         y_prime_max,z_prime_min,z_prime_max);
        plot(prime_head,y_prime_min,y_prime_max,z_prime_min,
         z_prime_max,max_y_out,max_z_out,aspect_ratio);
        response:=ReadKey;
        CloseGraph;
        WHILE (prime_head <> NIL) DO
          BEGIN
            prime_ptr:=prime_head^.greater_x;
            DISPOSE(prime_head);
            prime_head:=prime_ptr
          END
      END
  END.
