# control.plt

paper size 11 by 8.5

#
# From _Automatic_Control_Systems_, fourth ed., figure 6-14
# transient response of a second-order system to a unit step input function
#
damp(t) = exp(-s*wn*t)/sqrt(1.0-s*s)
per(t) = sin(wn*sqrt(1.0-s*s)*t - atan(-sqrt(1.0-s*s)/s))
c(t) = 1-damp(t)*per(t)
#
#     wn is natural undamped frequency
#     s is damping factor
#
wn = 1.0
map x 0 14
divi x 7,2
sampling 50
dummy t
#
# plot c(t) for several different damping factors s
#
color lred
plot s=.1,c(t),s=.3,c(t),s=.5,c(t),s=.7,c(t),s=.9,c(t),s=1.0,c(t),s=1.5,c(t),s=2.0,c(t)
color green
format x 0
draw x y
xlabel 'time'
ylabel 'response'
frame

font 3
char size 0.2 slant 10
color lblue
title 'TRANSIENT RESPONSE OF A SECOND-ORDER SYSTEM'
title 'Plotting Several Functions with one Plot Command'
