# Script for drawing the graph of a function

units cm
paper size 29.6 by 20.9
noborder
nobeep

# Set up domain and co-domain
map x -0.1 0.1        # Specify domain if desired
#map y                # Specify co-domain if desired 
sample 500            # Use 500 points across

# Draw the curve
color lred
plot x**2*sin(1/x)

# Draw the axes, etc
color green
tics out              # Tics facing outwards
tics size .5 .2       # Major tics .5 cm long, minor tics .2 cm long

divisions x 4,5       # 4 major divisions with 5 minor divisions between 
format x 2            # Show 2 decimal places on X-axis
char size .4          # Character height on X-axis = .4 cm 
#grid color green     # Turn grid drawing on if desired
draw x                # Draw X-axis
#nogrid               # Turn grid drawing off if desired
xlabel 'X'            # Label the X-axis

divisions y 4,1       # 4 major divisions
format y 3            # Show 3 decimal places on Y-axis
char size .4          # Character height on X-axis = .4 cm 
#grid color green     # Turn grid drawing on if desired
draw y                # Draw Y-axis
#nogrid               # Turn grid drawing off if desired
ylabel 'Y'            # Label the Y-axis

char size 1
title 'GRAPHFN.PLT'

# Hardcopy to dotmatrix 24 pin if desired
# dump hpgl
# $d:\grafsys\printgl graphica.hpg /FT*
