# rocha.plt - a couple of graphs on one page

paper size 8.5 11.0
font 1

subplot area 2.0 2.0 6.5 5.5
char size 0.10 ratio 0.67
map x 0. 600. y 0. 60. y2 0. 600.0
divi x 6,2 y 6,2 y2 1,1
format x -1 y -1
draw x y y2 mask
xlabel 'Contact Time (hr)'
ylabel 'Concentration (ppm)'

label botto ' '
label botto 'BATCH EXPERIMENT # 2'
label botto '15 g Berea Sandstone & 50 g Aluminum Citrate Solution'

# Plot Al data
symbol tria size 0.08
data
0,49.5 2,32.23 5,29.86 10,26.62 19.75,23.4
49.67,19.42 97.17,16.27 300,4.04 353,3.55 502,1.34
end
plot x y add symbol

# Plot Fe data
symbol diam size 0.08
data
10,8.2 19.75,9.14 49.67,9.86 100.,11.48 192.,2.66
end
plot x y add symbol

# Plot Ca data
symbol squa size 0.08
data
2,7.85 5,9.35 10,10.22 19.75,13.37 49.67,14.27
100.,20.48 192.,34.27 300,53.56 353,45.83 502,58.7
end
plot x y add symbol

# Plot Mg data
symbol star size 0.08
data
2,21.04 5,22.06 10,19.05 19.75,21.68 49.67,20.91
100.,27.28 192.,29.44 300,31.6 353,31.6 502,35.6
end
plot x y add symbol

# Plot K data
symbol circ size 0.08
data
2,12.28 5,12.64 10,15.38 19.75,14.43 49.67,15.06
100.,11.77 192.,13.48 300,14.5 353,14.9 502,17.2
end
plot x y add symbol

char size 0.08 ratio 0.67
legend at 3 5
symbol tria 'Al\U3+\D'
symbol diam 'Fe\U3+\D'
symbol squa 'Ca\U2+\D'
symbol star 'Mg\U2+\D'
symbol circ 'K\U+\D'
end

subplot area 2 6 6.5 9.50
char size 0.10 ratio 0.67
map x 0. 600. y 650. 750. y2 5.5 8. x2 0. 600.0
divi x 6,2  y 5,2  y2 5,1  x2 1,1
format x -1 y -1 y2 1
draw y x2 mask y2
ylabel 'Na\U+\D Concentration (ppm)'
y2label 'pH'

# Plot Na data
symbol plus size 0.08
data
0,709.3 2,709.6 5,706.4 10,708.3 19.75,698.2 49.67,712.4
100.,715.29 192.,718.66 300,708.55 353,715.03 502,713.1
end
plot x y add symbol

# Plot pH
symbol squa size 0.08
data
0,5.96 2,7.25 5,7.38 10,7.54 19.75,7.63 49.67,7.5
100.,7.44 192.,7.66 300,7.73 353,7.69 502,7.68
end
plot x y2 add symbol
char size 0.08 ratio 0.67

legend at 3 7
symbol plus 'Sodium Concentration'
symbol squa 'pH'
end