CSEG            SEGMENT
                ASSUME  CS:CSEG, DS:CSEG, ES:CSEG
		ORG     0100H
START:          JMP     INITIALIZE

OldInt10        DD      ?
red             db      ?
grn             db      ?
blu             db      ?

NewInt10        PROC    FAR
                ASSUME  DS:NOTHING, ES:NOTHING

		CMP     AH,10H          ;PALETTE/ATTRIBUTE FUNC ?
		JE      CHECK_SubFunc   ;YES ! - check subfuntion

INT10_EXIT:     JMP     CS:OldInt10     ;Continue with original

CHECK_SubFunc:  CMP     AL,10H          ;SINGLE DAC UPDATE
		JE      DAC_UPDATE      ;YES ! - goto new DAC UPDATE
		CMP     AL,15H          ;SINGLE DAC READ
		JE      DAC_READ        ;YES ! - goto new DAC READ

		JMP     INT10_EXIT      ;none of the above

DAC_UPDATE:     mov     red,dh
		mov     grn,ch
		mov     blu,cl
		push    cs
		pop     es              ;get seg of DAC table
		mov     dx,offset red   ;get offset of DAC table
		mov     ah,10H
		mov     al,12H          ;block DAC update SubFunc
		mov     cx,1            ;read 1 DAC (BX same as orig)
		int     10H
		IRET

DAC_READ:       push    cs
		pop     es              ;get seg of DAC table
		mov     dx,offset red   ;get offset of DAC table
		mov     ah,10H
		mov     al,17H          ;block DAC read SubFunc
		mov     cx,1            ;read 1 DAC (BX same as orig)
		int     10H
		mov     dh,red
		mov     ch,grn
		mov     cl,blu
		IRET                    ;fini

NewInt10        ENDP

LASTBYTE        =       $


                ASSUME  CS:CSEG, DS:CSEG, ES:NOTHING
INITIALIZE      PROC    NEAR

CRCret:         MOV     DX,OFFSET COPYRIGHT
		MOV     AH,9
		INT     21H

		NOT     WORD PTR START
		XOR     BX,BX
		MOV     AX,CS

NextSeg:        INC     bx
		CMP     ax,bx
		MOV     es,bx
		JE      NOT_Resident
		MOV     si,OFFSET START
		MOV     di,si
		MOV     cx,16
		REP     CMPSB
		OR      cx,cx
		JNZ     NextSeg
Resident:       MOV     DX,OFFSET Resident_MSG

		MOV     ah,9
                INT     21H
		MOV     ax,4C01H
                INT     21H
NOT_Resident:
		MOV     ax,3510H
                INT     21H
		MOV     WORD PTR [OldInt10],  BX
		MOV     WORD PTR [OldInt10+2],ES
		MOV     DX, OFFSET NewInt10
		MOV     AX, 2510H
		INT     21H

	 mov     dx, offset LASTBYTE
	 mov     cl, 4
	 shr     dx, cl
	 inc     dx
	 mov     ah, 31H
	 mov     al, 0
	 INT     21H

INITIALIZE      ENDP

COPYRIGHT       DB      13,10
		DB      "VGAFIX v1.0 Copr. (c) 1988 Lawrence & Marvin Gozum"
		DB      13,10
		DB      "$",1Ah

Resident_MSG    DB      13,10,7,"VGAFIX already resident !  Aborting.$"

CSEG            ENDS
                END     START
