;; Mandelbrot Point Computation FPU routine.
;; Written by John W. Ratcliff, January 19, 1993.
;; This source is free,but if you choose to use it, please credit the
;; author, because his ego needs feeding, practically on a daily basis.
	IDEAL
	JUMPS
	include "prologue.mac"
	P386			; 386 specific opcodes and shit allowed.

SMALL_MODEL	equ	0   ;: True if you need a small model version.

	SETUPSEGMENT

Macro	CPROC	name
	public	_&name
IF	SMALL_MODEL
Proc	_&name	near
ELSE
Proc	_&name	far
ENDIF
	endm

P387

;; This is the Mandelbrot point computation procedure.
CPROC	MandelbrotPoint
	ARG	LIMIT:QWORD,ITERATIONS:WORD,REAL:QWORD,IMAGINARY:QWORD
	PENTER	0

	mov	cx,[ITERATIONS]
	mov	bx,cx
	finit
	fld	[LIMIT] 	; 7 Load floating point limit
	fld	[REAL]		; 6 load floating point real.
	fld	[IMAGINARY]	; 5 load floating point imaginary.
	fld	[REAL]		; 4 fx store 0.0 real accum.
	fld	[IMAGINARY]	; 3 fy store 0.0 imaginary accum
	fldz			; 2 xs store 0.0 holds real squared
	fldz			; 1 ys store 0.0 holds imaginary squared
	fldz			; 0 store 0.0, clear accum.

@@GO:
;;    xs = fx*fx;
	fxch	st(4)		; get FX
	fst	st(4)		; save it back.
	fmul	st,st		; Square it.
	fst	st(2)		; Save in XS xsquared.

;;    ys = fy*fy;
	fxch	st(3)		; Get FY
	fst	st(3)		; save it back.
	fmul	st,st		; sqare it.
	fst	st(1)		; Save it.

;;  fy = (2*fx*fy)+imaginary;
	fxch	st(4)		; get FX
	fadd	st,st		; *2
	fmul	st,st(3)	; * fy
	fadd	st,st(5)	; plus imaginary portion.
	fst	st(3)		; Store result back into FY!

;;    fx = xs-ys+real;

	fxch	st(2)		; Get xsquared.
	fst	st(2)		; Save it back again for loop test!
	fsub	st,st(1)	; less ysquared.
	fadd	st,st(6)	; Plus real portion.
	fst	st(4)		; Store result back into FX

;; while ( xs+ys < limit && count < iterations);
	fxch	st(2)		; Get x squared.
	fadd	st,st(1)	; Add y sqaured

	fcom	st(7)		; is it < limit?
	fstsw   ax              ;sw till ax
	shr	ah,1
	jnc	@@exit		; exit if >= limit
	dec	cx
	jnz	@@GO		; Next iteration.

@@exit: mov     ax,bx
	sub	ax,cx
	finit                   ;Initialisera coprocessorn!!

	PLEAVE
	ret
	endp

	ENDS
	END
