/*
      MANDELBROT PICTURES GENERATOR        Jose L. Rodriguez 08/09

      Ref. Scientific American  Aug.85, Nov.87 and Feb.89

      VGA, MCGA 320x200x256 Version        (Microsoft C 5.1/QC 2.0) */


      #include  <graph.h>
      #include  <stdlib.h>
      #include  <stdio.h>

      main()
      {

	 int maxx, maxy, xpix, ypix, maxit, dwell, ga, gm;
	 double xma, xmi, yma, ymi, x, y, xt, xn, yn, xi, yi, d2;
	 struct videoconfig screen;

	 printf(" Enter: Min X  Max X  Min Y  Max Y;   Example"
		" -2 1.5 -1.25 1.25 \n");
	 scanf("%lf %lf %lf %lf", &xmi, &xma, &ymi, &yma);
	 if((xmi>=xma)||(ymi>=yma)) {
	    printf("\n Illegal data \n");
	    exit (1);
	    }

	 _getvideoconfig (&screen);
	 if((screen.adapter==_MCGA) || (screen.adapter==_VGA))
	    _setvideomode(_MRES256COLOR);
	    else
	    {
	    printf("\n Error: Cannot set graphics mode \n");
	    exit (2);
	    }

	 maxx=320;
	 maxy=200;
	 maxit=255;

	 xi=(xma-xmi)/maxx;
	 yi=(yma-ymi)/maxy;
	 x=xmi-xi;
	 for (xpix=0; xpix<=(maxx-1); xpix++)
	 {
	    x=x+xi;
	    y=ymi-yi;
	    for (ypix=maxy-1; ypix>=0; ypix--)
	    {
	       y=y+yi;
	       xn=0;
	       yn=0;
	       d2=0.;
	       dwell=0;
	       while ((d2<4.) && (dwell<maxit))
	       {
		  dwell++;
		  xt=xn;
		  xn=xn*xn-yn*yn+x;
		  yn=2*xt*yn+y;
		  d2=xn*xn+yn*yn;
		}
	       if (dwell<maxit) {
		  _setcolor(dwell);
		  _setpixel(xpix, ypix);
		}
	     }
	  }

      while (!kbhit());

      _setvideomode(_DEFAULTMODE);

      printf(" Input values:  %10.6f %10.6f %10.6f %10.6f \n",
	     xmi, xma, ymi, yma);
      return 0;
      }
