C
C     MANDELBROT PICTURES GENERATOR       Jose L. Rodriguez 08/89
C
C     Ref. Scientific American  Aug.85, Nov.87 and Feb.89
C
C     VGA, MCGA 320x200x256 Version       (Microsoft FORTRAN 5.0)
C

      INCLUDE  'FGRAPH.FI'
      INCLUDE  'FGRAPH.FD'

      INTEGER*2 DUMMY, MAXX, MAXY, XPIX, YPIX, MAXIT
      INTEGER*4 DWELL
      REAL*8 XMA, XMI, YMA, YMI, X, Y, XT, XN, YN, XI, YI, D2
      RECORD /VIDEOCONFIG/ SCREEN

      WRITE(*,1)
  1   FORMAT(' Enter: Min X  Max X  Min Y  Max Y;  Example -2'
     *' 1.5 -1.25 1.25')
      READ(*,*) XMI, XMA, YMI , YMA
      IF((XMI.GE.XMA).OR.(YMI.GE.YMA)) STOP 'Illegal data'

      CALL GETVIDEOCONFIG(SCREEN)
      IF(((SCREEN.ADAPTER).EQ.$MCGA).OR.((SCREEN.ADAPTER).EQ.$VGA)) THEN
            DUMMY=SETVIDEOMODE($MRES256COLOR)
            ELSE
            STOP 'Error: Cannot set graphics mode'
            ENDIF

      MAXX=320
      MAXY=200
      MAXIT=255

      XI=(XMA-XMI)/MAXX
      YI=(YMA-YMI)/MAXY
      X=XMI-XI
      DO XPIX=0,MAXX-1
         X=X+XI
         Y=YMI-YI
         DO YPIX=MAXY-1,0,-1
            Y=Y+YI
            XN=0
            YN=0
            D2=0.
            DWELL=0
            DO WHILE ((D2.LT.(4.)).AND.DWELL.LT.MAXIT)
               DWELL=DWELL+1
               XT=XN
               XN=XN*XN-YN*YN+X
               YN=2*XT*YN+Y
               D2=XN*XN+YN*YN
            END DO
            IF(DWELL.LT.MAXIT) THEN
               DUMMY=SETCOLOR(DWELL)
               DUMMY=SETPIXEL(XPIX,YPIX)
            ENDIF
         END DO
      END DO

      READ(*,*)
      DUMMY=SETVIDEOMODE($DEFAULTMODE)
      WRITE(*,2) XMI, XMA, YMI, YMA
  2   FORMAT(' Input values: ', 4(F11.6))
      END

