PROGRAM Hlrb;  { Print out the Handy Little Reference Books }

USES CRT, DOS, PRINTER;

{
  Ŀ
    Pinnacle  Software's  Handy Little Reference Book Printer    H L R B  
  Ĵ
    C O P Y R I G H T  (C)  1989  BY   P I N N A C L E    S O F T W A R E  
    P.O. Box  386, Town of Mount Royal, Montreal, Quebec, Canada  H3P 3C6  
  Ĵ
    Permission is  hereby given to distribute this Pinnacle product, pro-  
    vided that  it is distributed in its  complete  and  unaltered  form,  
    including all  programs, text and data.                                
  
}

TYPE
  String80 = STRING[80];

CONST
  Ver : STRING[7] = ' 1.10AA';  { V1.10 TP4 upgrade, printer-not-ready fix }
  Co  : STRING[40] = 'Copyright (C) 1989 by Pinnacle Software';

VAR  { Working Variables }
  Completed  : BOOLEAN;
  InChar     : CHAR;
  Indent     : INTEGER;
  IORes      : INTEGER;
  PrintFile  : STRING[64];
  TextLine   : STRING[255];
  VALRetCode : INTEGER;
  Width      : INTEGER;

VAR  { Files }
  TxtFile : TEXT;

{===== Utility Processors =====}

PROCEDURE PressKey;
BEGIN
  WRITELN;
  WRITE('Press a key to continue... ');
  InChar := READKEY;
  WRITELN;
END;

FUNCTION Upper(UStr : String80) : String80;
VAR
  UCntr : INTEGER;
BEGIN
  FOR UCntr := 1 TO LENGTH(UStr) DO UStr[UCntr] := UPCASE(UStr[UCntr]);
  Upper := UStr;
END; { Function Upper }

{$I DIR.INC}

{===== Mainline Processors =====}

PROCEDURE StartUp;
BEGIN
  CLRSCR;
  Completed := FALSE;
  Indent := 0;
  IF LENGTH(PARAMSTR(1)) = 0 THEN
  BEGIN
    WRITELN('  ͻ');
    WRITELN('     ۳ ');
    WRITELN('                       ۳ ');
    WRITELN('                                   ۳ ');
    WRITELN('                        ۳ ');
    WRITELN('     ۳ ');
    WRITELN('  ͺ ');
    WRITELN('     HANDY      LITTLE     REFERENCE     BOOKS    ');
    WRITELN('  ͺ ');
    WRITELN('        Entire product, Copyright (C) 1989        ');
    WRITELN('                ');
    WRITELN('        P I N N A C L E    S O F T W A R E        ');
    WRITELN('        P.O. Box 386,  Town of Mount Royal        ');
    WRITELN('        Montreal, Quebec,  Canada  H3P 3C6        ');
    WRITELN('  ͺ ');
    WRITELN('          VERSION    REVISION      PACKAGE    INTERNAL ID         ');
    WRITE  ('           ',Ver[1],' ',Ver[2]);
    WRITE  ('          ',Ver[4],Ver[5]);
    WRITE  ('            ',Ver[6]);
    WRITE  ('            ',Ver[7]);
    WRITELN('              ');
    WRITELN('  ͼ ');
    WRITELN('    ');
    WRITELN;
    WRITELN('    If you  find  this  product  useful,  please  drop us a line,  or');
    WRITELN('    refer to the documentation  for information  about extra support.');
    WRITELN;
    WRITE('    Press a key to begin... ');
    InChar := READKEY;
  END;  { No parameter at start-up }
END;  { StartUp }

FUNCTION GetFileName : BOOLEAN;
VAR
  GFNOkay : BOOLEAN;
  GotName : BOOLEAN;
BEGIN
  PrintFile := PARAMSTR(1);
  GotName := FALSE;
  GFNOkay := FALSE;
  REPEAT
    IF LENGTH(PrintFile) = 0
    THEN
    BEGIN
      CLRSCR;
      WRITELN('List of Handy Little Reference Books');
      WRITELN('');
      WRITELN;
      ShowFiles('HLB');
      WRITELN;
      WRITELN('Type the name of the book you want to print');
      WRITELN('or press ENTER to quit without printing.');
      WRITELN;
      WRITE('Which book?  ');
      READLN(PrintFile);
      PrintFile := UPPER(PrintFile);
      IF LENGTH(PrintFile) = 0
      THEN GotName := TRUE;
    END;
    IF LENGTH(PrintFile) > 0 THEN
    BEGIN
      IF POS('.',PrintFile) = 0 THEN PrintFile := PrintFile + '.HLB';
      {$I-}
      ASSIGN(TxtFile,PrintFile);
      RESET(TxtFile);
      IORes := IORESULT;
      {$I+}
      IF IORes = 0
      THEN
      BEGIN
        GFNOkay := TRUE;
        GotName := TRUE;
      END
      ELSE
      BEGIN
        WRITELN;
        WRITELN(PrintFile,' was not found.');
        PressKey;
        PrintFile := '';
      END;
    END;  { Input length > 0 }
  UNTIL GotName;
  GetFileName := GFNOkay;
END; { Procedure GetFileName }

PROCEDURE ShowAlign;
VAR
  IndOkay   : BOOLEAN;
  IndString : STRING[3];
BEGIN
  {----- Show picture if no alignment -----}
  IF Indent = 0 THEN
  BEGIN
    WRITELN('Insert the sheet into the printer.  Align the paper so');
    WRITELN('columns 1 and ',Width,' are an equal distance from the edges.');
    WRITELN;
    WRITELN('           1        ',Width);
    WRITELN('           |        |');
    WRITELN('         Ŀ');
    WRITELN('          Ŀ ');
    WRITELN('  ³ :        : ķ');
    WRITELN('(    ;    )');
    WRITELN('  ͵');
    WRITELN('                      [] [] []  ');
    WRITELN('  ľ');
  END;
  IndOkay := FALSE;
  {----- Get alignment if desired -----}
  REPEAT
    WRITELN;
    IF Indent = 0
    THEN
    BEGIN
      WRITELN('Press  ENTER  if you''ve aligned the paper this way, or type');
      WRITE  ('the number of spaces you want to indent (move over) the page.  ');
    END
    ELSE
    BEGIN
      WRITELN('Press ENTER to indent the page ',Indent,' spaces,');
      WRITE(  'or type a new indent value.  ');
    END;
    READLN(IndString);
    WRITELN;
    IF LENGTH(IndString) = 0
    THEN IndOkay := TRUE
    ELSE
    BEGIN
      VAL(IndString,Indent,VALRetCode);
      IF VALRetCode = 0
      THEN IndOkay := TRUE
      ELSE WRITELN('Please type a number or press ENTER.');
    END
  UNTIL IndOkay;
  CLRSCR;
  WRITELN('Now roll back the sheet to leave half an inch at the top.');
  WRITELN;
  WRITELN;
  WRITELN('          Half an inch');
  WRITELN('  Ŀķ');
  WRITELN('(    ;    )');
  WRITELN('  ͵');
  WRITELN('                      [] [] []  ');
  WRITELN('  ľ');
  PressKey;
  CLRSCR;
END;

PROCEDURE Prt(PLine : String80);
BEGIN
  {$I-}
  REPEAT
    WRITELN(LST,PLine);
  UNTIL IORESULT = 0;
  {$I+}
END;

PROCEDURE PrtLn(PLine : String80);
BEGIN
  Prt(PLine);
  Prt(#13#10);
END;

PROCEDURE DoPrint;
VAR
  Aborted : BOOLEAN;
  Done    : BOOLEAN;
  IndCntr : INTEGER;
BEGIN
  IF EOF(TxtFile)
  THEN
  BEGIN
    WRITELN('That booklet file is empty.');
  END
  ELSE
  BEGIN
    READLN(TxtFile,TextLine);
    Width := LENGTH(TextLine);
    Completed := FALSE;
    Done := FALSE;
    REPEAT
      RESET(TxtFile);
      CLRSCR;
      ShowAlign;
      CLRSCR;
      WRITELN('Press  P  to pause printing.');
      WRITELN('Press  R  to restart printing.');
      WRITELN('Press  C  to cancel printing.');
      WRITELN;
      Aborted := FALSE;
      REPEAT
        READLN(TxtFile,TextLine);
        IF POS('<<NEW PAGE>>',TextLine) = 1 THEN
        BEGIN
          CLRSCR;
          WRITELN;
          WRITELN('ͻ  Take the sheet out and');
          WRITELN('  NEW  PAGE    flip it over so we can');
          WRITELN('ͼ  print on the back.');
          WRITELN;
          ShowAlign;
        END
        ELSE
        BEGIN
          WRITELN(TextLine);
          IF KEYPRESSED THEN
          BEGIN
            InChar := READKEY;
            InChar := UPCASE(InChar);
            CASE InChar OF
              'P' : BEGIN
                      PressKey;
                      WRITELN;
                    END;
              'R' : BEGIN
                      Aborted := TRUE;
                      Completed := FALSE;
                      Done := FALSE;
                    END;
              'C' : BEGIN
                      Aborted := TRUE;
                      Completed := FALSE;
                      Done := TRUE;
                    END;
            END;
          END;
          IF Indent > 0 THEN FOR IndCntr := 1 TO Indent DO Prt(' ');
          PrtLn(TextLine);
        END;
        IF EOF(TxtFile) THEN
        BEGIN
          Aborted := TRUE;
          Completed := TRUE;
          Done := TRUE;
        END;
      UNTIL Aborted;  { Loop through file lines }
    UNTIL Done;  { Loops through re-prints }
  END;  { File not empty }
END; { Procedure PrintFile }

PROCEDURE ShowAssembly;
BEGIN
  CLRSCR;
  WRITE('Do you want instructions for assembling the book?  (Y/N)  ');
  REPEAT
    InChar := READKEY;
    InChar := UPCASE(InChar);
  UNTIL InChar IN ['Y','N'];
  IF InChar = 'Y' THEN
  BEGIN
    CLRSCR;
    WRITELN('Fold the sheet down the middle, between the double line.');
    WRITELN('The  Title Page  should be on the  outside  of the fold.');
    WRITELN;
    WRITELN('Ŀ              Ŀ');
    WRITELN(' Ŀ               Ŀ ');
    WRITELN('         TITLE                 TITLE  ');
    WRITELN(' Ĵ               Ĵ ');
    WRITELN('                                      ');
    WRITELN(' Ĵ     >    Ĵ ');
    WRITELN('                                      ');
    WRITELN(' Ĵ               Ĵ ');
    WRITELN('                                      ');
    WRITELN('                 ');
    WRITELN('              ');
    PressKey;
    CLRSCR;
    WRITELN('Press the sheet VERY flat and then trim off the borders.');
    WRITELN;
    WRITELN('                         Ŀ    ');
    WRITELN('Ŀ               Ŀ');
    WRITELN('Ŀ               Ŀ  ');
    WRITELN(' TITLE                 TITLE   ');
    WRITELN('Ĵ         Don''t Ĵ  ');
    WRITELN('                  cut          ');
    WRITELN('Ĵ          here Ĵ  ');
    WRITELN('                               ');
    WRITELN('Ĵ     >    Ĵ  ');
    WRITELN('                               ');
    WRITELN('                 ');
    WRITELN('              Ŀ ');
    WRITELN('                             ');
    PressKey;
    CLRSCR;
    WRITELN('Cut off each double page and tuck it in the middle.');
    WRITELN;
    WRITELN('Ŀ');
    WRITELN(' TITLE  1 >     Ŀ');
    WRITELN('Ĵ               TITLE Ŀ');
    WRITELN('        2 >    Ŀ');
    WRITELN('Ĵ                Ŀ');
    WRITELN('        3 >     ');
    WRITELN('Ĵ                   ');
    WRITELN('        4 >     ');
    WRITELN('');
    PressKey;
    CLRSCR;
    WRITELN('Now put two staples in the spine -- and you''re done!');
    WRITELN;
    WRITELN('       Ŀ');
    WRITELN('Ŀ             ');
    WRITELN('Ѿ   TITLE     ');
    WRITELN('ľ              ');
    WRITELN('    ');
    WRITELN(' ľ');
    WRITELN(' Stapler');
    PressKey;
    WRITELN;
    WRITELN('Enjoy your Handy Little Reference Book!');
    WRITELN;
  END;
END;

{===== Mainline Code =====}

BEGIN
  StartUp;
  IF GetFileName THEN DoPrint;
  IF Completed THEN ShowAssembly;
END.
