(* --- rnf0 ---*)


{  Turbo Pascal routines to get the date from DOS  }                  { V 2.1 }
                                                                      { V 2.1 }
type datetimetype = string[8];                                        { V 2.1 }
     regtype      = record                                            { V 2.1 }
                    ax,bx,cx,dx,bp,si,di,ds,es,flags: integer         { V 2.1 }
                    end;                                              { V 2.1 }
                                                                      { V 2.1 }
                                                                      { V 2.1 }
function date: datetimetype;                                          { V 2.1 }
  {  Returns current data in the form 'MM/DD/YY'  }                   { V 2.1 }
var  reg :     regtype;                                               { V 2.1 }
     y,m,d,w:  datetimetype;                                          { V 2.1 }
     i:        integer;                                               { V 2.1 }
                                                                      { V 2.1 }
begin                                                                 { V 2.1 }
(* THIS BLOCK OF CODE IS TURBO PASCAL V 3.0 AND PC/MS DOS DEPENDENT *){ V 2.1 }
  reg.ax := $2A00;                                                    { V 2.1 }
  intr($21,reg);                                                      { V 2.1 }
  str(reg.cx:4,y);                                                    { V 2.1 }
  delete(y,1,2);                                                      { V 2.1 }
  str(hi(reg.dx):2,m);                                                { V 2.1 }
  str(lo(reg.dx):2,d);                                                { V 2.1 }
  w := m + '/' + d + '/' + y;                                         { V 2.1 }
  for i := 1 to length(w) do if w[i]=' ' then w[i]:='0';              { V 2.1 }
  date:=w;                                                            { V 2.1 }
(*  END OF TURBO PASCAL V 3.0 DEPENDENT CODE *)                       { V 2.1 }
(*  THIS BLOCK OF CODE MAY BE USED IN PLACE OF THE ABOVE              { V 2.1 }
   date := '';                                                        { V 2.1 }
    END OF GENERIC CODE *)                                            { V 2.1 }
end;                                                                  { V 2.1 }



PROCEDURE INI;
{ Initialization procedures }

  var
    j: integer;

PROCEDURE INISTDMACS;

  const
    EmptyMacroText =
        '                                                                  ';
  type
    alfa66 = packed array [ 1 .. 66] of char;
    string66 = string[66];                                            { V 2.1 }
    NumParms_Type = 0..MaxParms;                                      { V 2.2 }

  var date_option : string66;                                         { V 2.1 }
      date_macro  : alfa66;                                           { V 2.1 }

  procedure move_date(var option:string66; var macro:alfa66);         { V 2.1 }

    begin                                                             { V 2.1 }
        fillchar(macro[1],sizeof(macro),' ');                         { V 2.1 }
        move(option[1],macro[1],length(option));                      { V 2.1 }
    end;                                                              { V 2.1 }

  procedure InitMac(MacroName: alfa;
                    NumParms : NumParms_Type;                         { V 2.2 }
                    MacType  : MacTyp;                                { V 2.2 }
                    MacText: alfa66);

    var
      TheMacroPtr: PMAC;
        length, i: integer;

    begin
      new(TheMacroPtr);
      with TheMacroPtr^  do
        begin
          ON := FALSE;   NM := MacroName;
          MT := MacType; NP := NumParms;                              { V 2.2 }
          MA := MACLSTP;

          MacroBegin := FreeStgIndx;
          if MacText = EmptyMacroText then
            begin
              Length := linlen;
              (* allocate, but don't use the space *)
              MacroEnd := MacroBegin - 1;
              StgTable[MacroBegin] := ' ';
            end
          else
            begin
              Length := 66;
              while ((Length > 1) and (MacText[Length] =  ' ')) do
                Length := Length - 1;
              if MacText[Length] <> ' ' then
                Length := Length + 1;

              MacroEnd := MacroBegin + Length - 1;

              for i := 1 to Length do
                StgTable[MacroBegin + i - 1] := MacText[i];
            end;
          FreeStgIndx := MacroBegin + Length;
        end;
      MACLSTP := TheMacroPtr;
    end;

  BEGIN
    MACLSTP := NIL;

    InitMac('FRCPAGE   ', 0, header,                                       { V 2.2 }
     '.BR .FOOT .TOP .SAV .RESPAG .HEAD .RES .MID                       ');{ V 2.0 }
    FrcPgMacP := MACLSTP;
    InitMac('HEAD      ', 0, header,                                       { V 2.2 }
     '.B 3 .TTL .NMP .BR .STL .B 2                                      ');{ V 2.0 }
    InitMac('FOOT      ', 0, header, emptymacrotext);                      { V 2.0 }

    InitMac(' d-frcpage', 0, header,                                       { V 2.2 }
     '.FRCPAGE                                                          ');
    DefrFrcPgMacP := MACLSTP;

    InitMac('NMP       ', 0, header,                                       { V 2.2 }
     '$$PAGE=$$PAGE+1; .IF $$NMP .TAB $$RM .RT $$PAGE                   ');

    InitMac('TTL       ', 0, header, EmptyMacroText);                      { V 2.2 }
    TTLMACP := MACLSTP;

    InitMac('STL       ', 0, header, EmptyMacroText);                      { V 2.2 }
    STLMACP := MACLSTP;

    InitMac('CH1       ', 0, PARM, EmptyMacroText);                        { V 2.2 }

    InitMac('CH        ', 8, HEADER,                                       { V 2.2 }
     '.frcpage .fig 12 .c Chapter $$CH=$$CH+1 $$HL=0; .b 2 .CHT .B 3    ');{ V 2.2 }
    ChapterMacP := MACLSTP;

    InitMac('CHT       ', 0, header,                                       { V 2.2 }
     '.c .ch1 .hc .ch1                                                  ');{ V 2.2 }
    CHTMACP := MACLSTP;

    InitMac(' defer pp ', 0, header,                                       { V 2.2 }
     '.PP                                                               ');
    ParagMacP := MACLSTP;

    InitMac(' defer cr ', 0, header,                                       { V 2.2 }
     '.CR                                                               ');
    CarRtnMacP := MACLSTP;

    InitMac(' defer mid', 0, header,                                       { V 2.2 }
     '.MID                                                              ');
    MidMacP := MACLSTP;

    date_option := date;                                              { V 2.1 }
    move_date(date_option,date_macro);                                { V 2.1 }
    writeln('Enter SYSDATE (Press <RETURN> for Default of ',date_option,')'); { V 2.1 }
    readln(date_option);                                              { V 2.1 }
    if length(date_option) > 0 then                                   { V 2.1 }
        move_date(date_option,date_macro);                            { V 2.1 }
    initmac('SYSDATE   ', 0, header, date_macro);                     { V 2.1 }

    date_option := date;                                              { V 2.1 }
    move_date(date_option,date_macro);                                { V 2.1 }
    writeln('Enter RNFDATE (Press <RETURN> for Default of ',date_option,')'); { V 2.1 }
    readln(date_option);                                              { V 2.1 }
    if length(date_option) > 0 then                                   { V 2.1 }
        move_date(date_option,date_macro);                            { V 2.1 }
    initmac('RNFDATE   ',0, header, date_macro);                      { V 2.1 }

END (*INISTDMACS*);


PROCEDURE INIRELS;

  BEGIN
    ARELOPR[EQ] := 'EQ        ';   ARELOPR[GT] := 'GT        ';
    ARELOPR[LT] := 'LT        ';   ARELOPR[NE] := 'NE        ';
    ARELOPR[GE] := 'GE        ';   ARELOPR[LE] := 'LE        ';
  END (*INIRELS*);


PROCEDURE INIVARS;
 
  var
    i: integer;
    
  BEGIN
    VID[VPAGE]  := '$PAGE     ';   VTY[VPAGE] := VITEM;
    VID[VCH]    := '$CH       ';   VTY[VCH]   := VITEM;
    VID[VHL]    := '$HL       ';   VTY[VHL]   := VARRAY;   VUP[VHL]    := 5;
    VID[VLIST]  := '$LIST     ';   VTY[VLIST] := VARRAY;   VUP[VLIST]  := 5;
    VID[VLM]    := '$LM       ';   VTY[VLM]   := VITEM;
    VID[VRM]    := '$RM       ';   VTY[VRM]   := VITEM;
    VID[VSP]    := '$SP       ';   VTY[VSP]   := VITEM;
    VID[VNMP]   := '$NMP      ';   VTY[VNMP]  := VITEM;
    VID[VOLNO]  := '$OLNO     ';   VTY[VOLNO] := VITEM;
    VID[VCR]    := '$CR       ';   VTY[VCR]   := VITEM;
    VID[VANSI]  := '$ANSI     ';   VTY[VANSI] := VITEM;
    VID[VFONT]  := '$FONT     ';   VTY[VFONT] := VITEM;               { V 2.0 }
    TV := NextVariable;
    FOR i := 1 TO VARMAX DO VAL[i] := 0;
  END (*INIVARS*);


PROCEDURE INICMDS;
 
PROCEDURE INIT1;
  
  BEGIN 
    cmds[cinclude]   := 'INCLUDE   ';   cmds[cbold]     := 'BOLD      ';
    cmds[ccaseflag]  := 'CASEFLAG  ';
    CMDS[CBLANK]     := 'B         ';   CMDS[CFLAG]     := 'FLAG      ';
    CMDS[CFLAGCAPS]  := 'FLAGCAPS  ';   CMDS[CFLAGOVER] := 'FLAGOVER  ';
    CMDS[CFLAGSIG]   := 'FLAGSIG   ';   CMDS[CLOWER]    := 'LOWER     ';
    CMDS[CUPPER]     := 'UPPER     ';   CMDS[CPERIOD]   := 'PERIOD    ';
    CMDS[CBREAK]     := 'BR        ';   CMDS[CCR]       := 'CR        ';
    CMDS[CESCCHR]    := 'ESC       ';   CMDS[CCENTER]   := 'C         ';
    CMDS[CJUST]      := 'J         ';   CMDS[CUL]       := 'UL        ';
    CMDS[CLMAR]      := 'LM        ';   CMDS[CRMAR]     := 'RM        ';
    CMDS[CSUP]       := 'SUP       ';   CMDS[CSTD]      := 'STD       ';
    CMDS[CPS]        := 'PAGESIZE  ';   CMDS[CSAV]      := 'SAV       ';
    CMDS[CP]         := 'P         ';   CMDS[CRES]      := 'RES       ';
    CMDS[CPP]        := 'PP        ';   CMDS[CSP]       := 'SP        ';
    CMDS[CS]         := 'S         ';   CMDS[CTP]       := 'TP        ';
    CMDS[CNMP]       := 'NMP       ';   CMDS[CPNO]      := 'PNO       ';
{   CMDS[CTITLE]     := 'TITLE     ';   CMDS[CST]       := 'ST        '; V 2.1 }
    CMDS[CTITLE]     := '.. AVAIL..';   CMDS[CST]       := '.. AVAIL..'; { V 2.1 }
{   CMDS[CATITLE]    := 'ATITLE    ';   CMDS[CLIST]     := 'LIST      '; V 2.1 }
    CMDS[CATITLE]    := '..avail.. ';   CMDS[CLIST]     := 'LIST      '; { V 2.1 }
    CMDS[CLE]        := 'LE        ';   CMDS[CELIST]    := 'ENDLIST   ';
  END;


PROCEDURE INIT2;

  BEGIN
    CMDS[CFIG]       := 'FIG       ';   CMDS[CBAR]      := 'BAR       ';
    CMDS[CBB]        := 'BB        ';   CMDS[CEB]       := 'EB        ';
    CMDS[CU]         := 'U         ';   CMDS[CT]        := 'T         ';
    CMDS[CTAB]       := 'TAB       ';   CMDS[CTABS]     := 'TABS      ';
    CMDS[CRT]        := 'RT        ';   CMDS[CHC]       := 'HC        '; { V 2.0 }
    CMDS[CAP]        := 'AP        ';   CMDS[CI]        := 'I         ';
    CMDS[CFILL]      := 'F         ';   CMDS[CSIG]      := 'SIG       ';
    CMDS[CPAGE]      := 'PAGE      ';   CMDS[CTC]       := 'TC        '; { V 2.0 }
    CMDS[CTOP]       := 'TOP       ';   CMDS[CMID]      := 'MID       ';
    CMDS[CBOT]       := 'BOTTOM    ';   CMDS[CARRAY]    := 'ARRAY     ';
    CMDS[CFMT]       := 'FMT       ';   CMDS[CIF]       := 'IF        ';
    CMDS[CASIS]      := 'ASIS      ';   CMDS[CDOT]      := 'DOT       ';
    CMDS[CREM]       := 'REM       ';   CMDS[CUPP]      := 'UP        ';
    CMDS[CUSB]       := 'USB       ';   CMDS[CHL]       := 'HL        ';
    CMDS[CRIGHT]     := 'RIGHT     ';   CMDS[CLINES]    := 'LINES     ';
    CMDS[CMACRO]     := 'MACRO     ';   CMDS[CX]        := 'X         ';
    CMDS[CVAR]       := 'VAR       ';   CMDS[CINC]      := 'INC       ';
    CMDS[CDEC]       := 'DEC       ';   CMDS[CSAVPAG]   := 'SAVPAG    ';
    CMDS[CRESPAG]    := 'RESPAG    ';   CMDS[NOTCMD]    := '----------';
    
    BREAKSET := [CCENTER, CTITLE, CST, CI, CHC, CLE, CLIST, CELIST, CHL,
       CCR, CPP, CPAGE, CFIG, CS, CTP, CBLANK, CASIS, CBREAK, CRES,
       CRESPAG];
    CRSET := BREAKSET - [CBREAK, CBLANK, CRES, CRESPAG];
  END (* INIT2 *);

  procedure IniPerfect;
   { Perfect hash function -- very fast keyword lookup }
    begin
      perfect[ 0] := NOTCMD;    
      perfect[ 1] := CP;                perfect[ 2] := CPP;
      perfect[ 3] := CNMP;              perfect[ 4] := CPAGE;
      perfect[ 5] := CJUST;             perfect[ 6] := NOTCMD;
      perfect[ 7] := CPERIOD;           perfect[ 8] := CPS (* PAGESIZE *);
      perfect[ 9] := CTP;               perfect[10] := CTOP;      
      perfect[11] := CDOT;              perfect[12] := CTITLE;    
      perfect[13] := CEB;               perfect[14] := CELIST  (* ENDLIST *);  
      perfect[15] := CT;                perfect[16] := CBOLD;     
      perfect[17] := CX;                perfect[18] := CSP;       
      perfect[19] := CSUP;              perfect[20] := CSTD;      
      perfect[21] := CTAB;              perfect[22] := CINCLUDE;
      perfect[23] := CBLANK;            perfect[24] := CBB;
      perfect[25] := CST;               perfect[26] := CUPP;
      perfect[27] := CTABS;             perfect[28] := CPNO;
      perfect[29] := NOTCMD;            perfect[30] := NOTCMD;
      perfect[31] := CI;                perfect[32] := CRT;
      perfect[33] := CS;                perfect[34] := CLE;
      perfect[35] := CRIGHT;            perfect[36] := CBREAK;
      perfect[37] := CBAR;              perfect[38] := CUSB;
      perfect[39] := CESCCHR;           perfect[40] := CDEC;
      perfect[41] := NOTCMD;            perfect[42] := CRES;
      perfect[43] := CLIST;             perfect[44] := NOTCMD;
      perfect[45] := CTC;               perfect[46] := NOTCMD;        { V 2.0 }
      perfect[47] := CAP;               perfect[48] := CFMT;
      perfect[49] := CU;                perfect[50] := CMID;
      perfect[51] := CATITLE;           perfect[52] := CUPPER;
      perfect[53] := CLINES;            perfect[54] := CINC;      
      perfect[55] := CIF;               perfect[56] := CSIG;      
      perfect[57] := CSAV;              perfect[58] := CUL;       
      perfect[59] := CSAVPAG;           perfect[60] := CLOWER;    
      perfect[61] := CCR;               perfect[62] := CFLAGCAPS; 
      perfect[63] := CBOT (* BOTTOM *); perfect[64] := CVAR;
      perfect[65] := CASIS;             perfect[66] := CRESPAG;   
      perfect[67] := CARRAY;            perfect[68] := NOTCMD;
      perfect[69] := CFLAGOVER;         perfect[70] := CHL;
      perfect[71] := CRMAR;             perfect[72] := CREM;
      perfect[73] := CCENTER;           perfect[74] := CHC;           { V 2.0 }
      perfect[75] := NOTCMD;            perfect[76] := CMACRO;
      perfect[77] := CFILL;             perfect[78] := CFIG;      
      perfect[79] := CFLAG;             perfect[80] := CLMAR;     
      perfect[81] := CCASEFLAG;         perfect[82] := CFLAGSIG;  
    end;

    procedure IniLetPerfect;
     
      begin
        LetPerfect['A'] := 45;    LetPerfect['B'] := 11;
        LetPerfect['C'] := 36;    LetPerfect['D'] :=  1;
        LetPerfect['E'] :=  0;    LetPerfect['F'] := 38;
        LetPerfect['G'] := 37;    LetPerfect['H'] := 36;
        LetPerfect['I'] := 15;    LetPerfect['J'] :=  2;
        LetPerfect['K'] :=  0;    LetPerfect['L'] := 32;
        LetPerfect['M'] := 46;    LetPerfect['N'] :=  0;
        LetPerfect['O'] := 25;    LetPerfect['P'] :=  0;
        LetPerfect['Q'] :=  0;    LetPerfect['R'] := 23;
        LetPerfect['S'] := 16;    LetPerfect['T'] :=  7;
        LetPerfect['U'] := 24;    LetPerfect['V'] := 38;
        LetPerfect['W'] :=  0;    LetPerfect['X'] :=  8;
        LetPerfect['Y'] := 17;    LetPerfect['Z'] :=  0;
      end;

  procedure initchars;

    var
      achar: char;

    begin
      for achar := chr(0) to chr(127) do  { 7-bit ASCII characters }
        begin
          CharCategory[achar] := OtherChar;
          (* default -- no case conversion *)
          MakeUpper[achar] := achar;
          MakeLower[achar] := achar;
          if (achar >= 'a') and (achar <= 'z') then
          begin                                                    { 5/21/87 }
            CharCategory[achar] := lcLetter;
            MakeUpper[achar] := chr(ord(achar) - 32);              { 5/21/87 }
          end                                                      { 5/21/87 }
          else
            if (achar >= 'A') and (achar <= 'Z') then
            begin                                                  { 5/21/87 }
              CharCategory[achar] := ucLetter;
              MakeLower[achar] :=chr(ord(achar) + 32);             { 5/21/87 }
           end;                                                    { 5/21/87 }
        end;
      for achar := chr(128) to chr(255) do  { 8-bit ASCII characters }
        begin
          CharCategory[achar] := MiscChar; { these pass through and print }
          (* no case conversion *)
          MakeUpper[achar] := achar;
          MakeLower[achar] := achar;

          {  comment-out either DEC or IBM-PC }

          (* DEC VT220, Rainbow character set *)
          { 128 .. 159 are control chars, and are not printed }
          { 192 .. 253 are foreign characters, upper or lower case }
{**        if (achar < chr(160)) then
            CharCategory[achar] := OtherChar
          else
            if (achar >= chr(192)) and (achar <= chr(253)) then
              CharCategory[achar] := lcLetter;
**}
          (* IBM-PC 8-bit characters, all are printable *)
          { 128 .. 167 are foreign characters (more or less) }

          if (achar < chr(168)) then
            CharCategory[achar] := lcLetter;

        end;

      CharCategory['^'] := UpArrow;
      CharCategory['<'] := LeftAngle;
      CharCategory['.'] := EndSentence;
      CharCategory['?'] := EndSentence;
      CharCategory['!'] := EndSentence;
      CharCategory['_'] := UnderScore;
      CharCategory['#'] := NumberSign;

      (* ASCII dependent *)

{}    CharCategory[chr(92)] := BackSlash;
      CharCategory['{'] := MiscChar;
      CharCategory['}'] := MiscChar;
{}    CharCategory[chr(126)] := MiscChar   (* tilda *);
{}    CharCategory[chr(96)] := MiscChar    (* grave *);
{}    CharCategory[chr(124)] := MiscChar   (* vertical bar *);
{}    for achar := ' ' to ']' do
        if CharCategory[achar] = OtherChar then
          CharCategory[achar] := ArithChar;

      RomanChars := 'M CMD CDC XCL XLX IXV IVI ';

      RomanValue[ 1] := 1000;
      RomanValue[ 2] :=  900;
      RomanValue[ 3] :=  500;
      RomanValue[ 4] :=  400;
      RomanValue[ 5] :=  100;
      RomanValue[ 6] :=   90;
      RomanValue[ 7] :=   50;
      RomanValue[ 8] :=   40;
      RomanValue[ 9] :=   10;
      RomanValue[10] :=    9;
      RomanValue[11] :=    5;
      RomanValue[12] :=    4;
      RomanValue[13] :=    1;
    end;

  BEGIN (* INICMDS *)
    INIT1;
    INIT2;
    IniPerfect;
    IniLetPerfect;
    initchars;
  END (*INICMDS*);  

PROCEDURE INIFILES;

  VAR
    parm_code: char;                                                  { V 2.0 }
    tran_sub,                                                         { V 2.0 }
    end_of_key: integer;                                              { V 2.0 }
    tocname,                                                          { V 2.0 }
    feedoption,                                                       { V 2.0 }
    parmoption,                                                       { V 2.0 }
    OUTNAME: string80;
    work_sub: byte;                                                   { V 2.0 }
    ans: char;
    badname, FromOS : boolean;

    function CommandLineFile : boolean;
    { If nothing given on command line, return false and set up defaults. }{ V 2.0 }
    { Else process each parm }                                        { V 2.0 }
    { Highly OS- and compiler-dependent; ParamCount, ParamStr Turbo Pascal }
    { For Turbo v 1 or 2, modify this routine to just return false. }
    BEGIN
      if ParamCount < 1 then  { ParamCount requires Turbo v 3 }
        begin
          CommandLineFile := false;
          InputName := '';                                            { V 2.0 }
          Outname   := '';                                            { V 2.0 }
          Tocname   := '';                                            { V 2.0 }
          feedoption := '';                                           { V 2.0 }
        end
      else
        begin
          CommandLineFile := true;
          InputName := '';                                            { V 2.0 }
          Outname   := 'CON:';                                        { V 2.0 }
          Tocname   := '*';                                           { V 2.0 }
          feedoption := '';                                           { V 2.0 }
          for work_sub := 1 to ParamCount do                          { V 2.0 }
          begin                                                       { V 2.0 }
              parmoption := ParamStr(work_sub);                       { V 2.0 }
              for tran_sub := 1 to length(parmoption) do              { V 2.0 }
                  parmoption[tran_sub] := upcase(parmoption[tran_sub]);{ V 2.0 }
              parm_code := parmoption[1];                             { V 2.0 }
              if not (parm_code in ['F','I','O','T']) then            { V 2.0 }
              begin                                                   { V 2.0 }
                  writeln('Invalid Keyword - ',parmoption);           { V 2.0 }
                  halt;                                               { V 2.0 }
              end;                                                    { V 2.0 }
              end_of_key := pos('=',parmoption);                      { V 2.0 }
              if end_of_key = 0 then                                  { V 2.0 }
                  end_of_key := length(parmoption);                   { V 2.0 }
              delete(parmoption,1,end_of_key);                        { V 2.0 }
              case parm_code of                                       { V 2.0 }
                  'F': feedoption := parmoption;                      { V 2.0 }
                  'I': InputName  := parmoption;                      { V 2.0 }
                  'O': Outname    := parmoption;                      { V 2.0 }
                  'T': Tocname    := parmoption;                      { V 2.0 }
              end;                                                    { V 2.0 }
          end; { of for loop }                                        { V 2.0 }
        end;                                                          { V 2.0 }
    end;

  BEGIN
    FromOS := CommandLineFile;
    repeat
      badname := false;                                               { V 2.0 }
      if length(inputname) > 0 then                                   { V 2.0 }
      begin                                                           { V 2.0 }
          badname := not fileexists(InputName);                       { V 2.0 }
  {VMS} (*if badname then                                             { V 2.0 }
          begin                                                       { V 2.0 }
            InputName := concat(InputName, '.text');                  { V 2.0 }
            badname := not fileexists(InputName);                     { V 2.0 }
          end;*)                                                      { V 2.0 }
          if badname then                                             { V 2.0 }
              writeln('Input File "',InputName,'" Does Not Exist');   { V 2.0 }
      end                                                             { V 2.0 }
      else                                                            { V 2.0 }
          badname := true;                                            { V 2.0 }
      if badname then                                                 { V 2.0 }
      begin                                                           { V 2.0 }
          write('Input File ..>');                                    { V 2.0 }
          readln(InputName);                                          { V 2.0 }
      end;                                                            { V 2.0 }
{}{VMS,Turbo}   if length(InputName) = 0 then halt;
{ VMS allows "length" on a PAOC, Turbo only on their string type }
    until not badname;

      if length(outname) = 0 then                                     { V 2.0 }
        begin
          WRITE('Listing File >');
          readln(outname);
         end;
      if length(outname) = 0 then                                     { V 2.0 }
         halt;                                                        { V 2.0 }

      if length(tocname) = 0 then                                     { V 2.0 }
        begin                                                         { V 2.0 }
          write('Table of Contents File >');                          { V 2.0 }
          readln(tocname);                                            { V 2.0 }
        end;                                                          { V 2.0 }

     if length(feedoption) = 0 then                                   { V 2.0 }
        if (outname = 'LST:') or (outname = 'CON:')                   { V 2.0 }
            then feedoption := 'H'                                    { V 2.0 }
        else                                                          { V 2.0 }
            feedoption := 'A';                                        { V 2.0 }
     feedoption := upcase(feedoption[1]);                             { V 2.0 }
     if (feedoption = 'H') or (feedoption = 'A') then                 { V 2.0 }
     else                                                             { V 2.0 }
         repeat                                                       { V 2.0 }
             write('Hand or Auto feed (H/F) >');                      { V 2.0 }
             readln(feedoption);                                      { V 2.0 }
             feedoption := upcase(feedoption[1]);                     { V 2.0 }
         until (feedoption = 'H') or (feedoption = 'A');              { V 2.0 }

{}{VMS,Turbo,Prospero} if length(outname) = 0 then halt;
{}{VMS} { open(File_Variable:=InFile,File_Name:=Inputname, History:= old); }
{}{Turbo,Prospero} assign(INFILE,InputName);
    RESET(INFILE);
{}{VMS} { open(File_Variable:=OutFile,File_Name:=OutName,History := new,   }
{}{VMS} {         Record_Length:= 322); }
{}{Turbo,Prospero} assign(OUTFILE,outname);
{}{VMS} {    REWRITE(OUTFILE, error := continue); }
{}{Turbo,Prospero}    REWRITE(OUTFILE);
      write_toc := (length(tocname) > 0) and (tocname <> '*');        { V 2.0 }
      if write_toc then                                               { V 2.0 }
      begin                                                           { V 2.0 }
{}{VMS} { open(File_Variable:=TabCont,File_Name:=TocName,History := new,   }{ V 2.0 }
{}{VMS} {         Record_Length:= 322); }                             { V 2.0 }
{}{Turbo,Prospero} assign(TabCont,Tocname);                           { V 2.0 }
{}{VMS} {    REWRITE(OUTFILE, error := continue); }                   { V 2.0 }
{}{Turbo,Prospero}    REWRITE(Tabcont);                               { V 2.0 }
            Writeln(tabcont,'.tabs 15 72 .lm 15 .rm 72 .p -14 0 2');  { V 2.2 }
      end;                                                            { V 2.0 }

  HandFeed := feedoption = 'H';                                       { V 2.0 }

  END (* INIFILES *);

  BEGIN (*INI*)
    VarName := AlfaBlanks;
    DangerPoint := maxint div 10;
    INIFILES;          INIRELS;
    InitialPageEject := false; { true for PAGE( ) before first page printed }
    USB := TRUE;       doinclfl := false;
    UNDL := FALSE;     bold := false;     asis := false;     XTEND := FALSE;
    ERRORCOUNT := 0;   ILNO := 0;         EOFINPUT := FALSE;
    do_int_term_cmds := false;                                        { V 2.0 }
    FREEMACP := NIL;   FLAGOVER := TRUE;
    FLAGSIG := TRUE;   T := FALSE;        RT := FALSE;       DOT := FALSE;
    PUSHED := FALSE;   PMAR := 0;         AP := FALSE;       PARA := FALSE;
    RIGHT := TRUE;     RT := FALSE;
    OVETXT := 58;      OETXT := 58;       OEPAG := 66;       ENP := 0;
    SUP := FALSE;      YES := TRUE;       ENP := 0;          PARSPACE := 1;
    PARTEST := 3;      DEFRB := 0;        PREL := TRUE;      FIRSTCH := TRUE;
    FORCE := FALSE;    ATITLE := FALSE;   FIGP := 0;         BAR := FALSE;
    BB := FALSE;       CLRTAB;
    
    ITEMSET := ['$', '0' .. '9', '+', '-', '#', '.'];
    TERMSET := ITEMSET + ['('];
    
    StgMarker := StgTblSize;
    TopOfStack := 0;
    with StgStack[0] do
      begin
        ActiveMacro := nil;
        StgBegin := 1;
        StgEnd := linlen;
        FreeStgIndx := StgEnd + 1;
        StgPosition := 1;
      end;
      
    for j := 1 to FreeStgIndx do
      StgTable[j] := ' ';
      
{} {fillchar(StgTable, StgTblSize, ' ');}
    for j:=1 to StgTblSize do StgTable[j] := ' ';

    INISTDMACS;  INICMDS;   SETSTD;

    INIVARS;
    VAL[VNMP] := 1;   VAL[VRM] := 72;   VAL[VSP] := 1;
{}  val[vcr] := {128+} 13;  { This character returns carriage to left edge }
    VAL[VLM] := 1;

    for j := 0 to LinLen do
      EmptyFlags[j] := false;
    
    CLRLINE;
    with otl do
      begin
        HasBoldPrinting := false;  HasOverPrinting := false;
        HasUnderScore := false;
        USflag := EmptyFlags;
        BoldFlag := EmptyFlags;
        FOR j := 1 TO LINLEN DO
          LIN[j] := ' ';
      end;
    SYL := OTL;   TMPL := OTL;   PAGSAV := OTL;      
    ADDSYL := OTL;   
    
    PQEND := FALSE;   OVBTXT := 0;
    WITH JUST DO
      FOR j := 1 TO LINLEN DO POS[j] := 0;
    JUST.NDX := 0;
    RIGHTSPACE := 0;
    FOR j := 1 TO FIGMAX DO FIGN[j] := 0;   HOLDBB := FALSE;
    LASTCUP := 0;   LASTLEN := 0;   LASTSLEN := 0;
    PAGOTL := FALSE;   EXPRERR := FALSE;
    SHOWEXPR := TRUE;   XTRABL := PQEND;
    VAL[VOLNO] := 10000;   SAVENV(PAGENV);   PushText(MidMacP);
    CaseConvert := False;                                       { 5/21/87 }
  END (*INI*);

