(* --- rnf3 --- *)

PROCEDURE BACKUPSYL;
 
  BEGIN StgStack[TopOfStack].StgPosition := LASTCUP END (*BACKUPSYL*);

PROCEDURE GETTOKEN;
 
  var
    i: integer;
    
  BEGIN
    WITH SYL DO
      BEGIN
        FOR i := 1 TO AlfaLen + 1 DO LIN[i] := ' ';
        LEN := 0;
        with StgStack[TopOfStack] do
          begin
            LASTCUP := StgPosition;
            if StgPosition < 1 then 
              writeln(' Empty token. TopOfStack = ',TopOfStack)
            else
              if StgPosition < StgEnd then
                begin
                  if TopOfStack = 0 then
                    StartToken := LASTCUP;
                  IF (StgTable[StgPosition] = ' ') AND SIGBL
                  THEN
                    WHILE (StgPosition < StgEnd) AND
                          (StgTable[StgPosition] = ' ') DO
                      BEGIN
                        LEN := LEN + 1;   LIN[LEN] := ' ';
                        StgPosition := StgPosition + 1;
                      END
                  ELSE
                    BEGIN
                      WHILE (StgPosition < StgEnd) AND
                          (StgTable[StgPosition] = ' ') DO
                        StgPosition := StgPosition + 1;
                      StgTable[StgEnd] := ' ';
                      LASTCUP := StgPosition;
                      if TopOfStack = 0 then
                        StartToken := StgPosition;
                      WHILE (StgTable[StgPosition] <> ' ') DO
                        BEGIN
                          LEN := LEN + 1;   
                          LIN[LEN] := StgTable[StgPosition];
                          StgPosition := StgPosition + 1;
                        END
                    END
                end;
          end;
      END;
  END (*GETTOKEN*);

procedure GetAlfaFromSyl(StartAt: integer; var a: alfa);
 
  var
    i, j: integer;
  
  begin
    a := AlfaBlanks;
    with syl do
      begin
        j := StartAt;
        i := 0;
        repeat
          i := i + 1;
          a[i] := ForceUpperCase(LIN[j]);
          j := j + 1;
        until (i = AlfaLen) or (j > len);
      end;
  END (* GetAlfaFromSyl *);


PROCEDURE LOOKUPMAC;
 
  VAR
                  L: alfa;
                  T: PMAC;
               done: BOOLEAN;
   
  PROCEDURE EXPMACRO(T: PMAC);
   
    VAR
                    SavPmac: Pmac;
                     SavEnd: integer;
                          N: 0 .. MaxParms;

    BEGIN
      (* !!! do this with a stack oriented allocation using StgMarker *)
      SavPmac := t;
      IF T ^.NP < MaxParms
      THEN (* SCAN PARMS       *)
        FOR N := T ^.NP DOWNTO 1 DO
          BEGIN
            T := T ^.MA (* PARM MACRO *);
            WITH T ^, StgStack[TopOfStack]  DO
              BEGIN
                SavEnd := StgEnd;
                GETTOKEN;   
                StgEnd := StgPosition;
                
                StackToMacro(LASTCUP, MacroBegin, MacroEnd);
                StgEnd := SavEnd;
              END
          END
      ELSE
        BEGIN (* REST OF LINE IS PARM *)
          T := T ^.MA;
          with T^, StgStack[TopOfStack] do
            begin
              StackToMacro(StgPosition, MacroBegin, MacroEnd);
              StgPosition := StgEnd;
            end;
        END;
      
      PushText(SavPmac);
    END (*EXPMACRO*);

  BEGIN (* lookUpMacro *)
    GetAlfaFromSyl(2, L);
    
    NotMacro := true;
    T := MACLSTP;   
    
    done := T = nil;
    while not done do
      begin
        if L =  T^.NM then
          begin
            done := true;
            NotMacro := false;
            if T^.ON then
              Error(9)  (* RECURSIVE MACRO CALL TO *)
            else
              ExpMacro(t)
          end
        else
          begin
            t := T^.MA;
            done := t = nil;
          end;
      end;
  END (*LOOKUPMAC*);


PROCEDURE GETMACSYM;
 
  BEGIN
    GetToken;
    while (SYL.len = 0) and (TopOfStack > 0) do
      begin
        (* !!! recover stack string space here *)
        if StgStack[TopOfStack].StgBegin = StgMarker + 1 then
          StgMarker := StgStack[TopOfStack].StgEnd;
        TopOfStack := TopOfStack - 1;
        GetToken;
      end;
  END (*GETMACSYM*);

PROCEDURE GETSYM;
 
  VAR
     LineIndex: integer;
     ActualLen: integer;
          hash: integer;
        fstlet,
        lstlet: char;
           PIN: alfa;

  BEGIN
    WITH SYL DO
      BEGIN
        REPEAT
          GETMACSYM;   NOTMACRO := TRUE;
          IF LIN[1] = MACCHR   THEN 
            if len > 1 then
              LOOKUPMAC
        UNTIL NOTMACRO;
        IF LEN = 0   THEN SYMTYPE := NONE
        ELSE
          IF (lin[1] = cmdchr) then
            begin
              if len = 1 then Error(56) (* lone period *) 
              else
                if (lin[2] in ['0' .. '9']) then SymType := word else
                BEGIN
                  SYMTYPE := COMMAND;   
                  CmdType := NotCmd;
                  
                  YES := 
                       ((LEN > 3) AND (ForceUpperCase(LIN[2]) = 'N') AND 
                       (ForceUpperCase(LIN[3]) = 'O')) = false {ESC UCSD BUG};
                  GetAlfaFromSyl(4 - 2 * BoolOrd(yes), PIN);
                  CMDS[NOTCMD] := PIN;
                  
                  ActualLen := 10 - 5 * BoolOrd(pin[6] = ' ');
                  while (ActualLen > 1) and (Pin[ActualLen] = ' ') do
                    ActualLen := ActualLen - 1;
                  
                  fstlet := pin[1];
                  lstlet := pin[ActualLen];
                  if CharCategory[lstlet] = ucLetter then
                    if CharCategory[fstlet] = ucletter then
                      begin
                        hash := ActualLen + LetPerfect[fstlet] +
                                                  LetPerfect[lstlet];
                        if hash <= maxhash then
                          if pin = Cmds[perfect[hash]] then
                            CmdType := perfect[hash];
                      end;
                  
                  IF CMDTYPE = NOTCMD
                  THEN Error(10)  (* UNKNOWN COMMAND *);
                END
              end
          ELSE
            IF (SYL.LIN[1] = VARCHR) AND (NOT (SYL.LIN[2] IN [' ', '0'
               .. '9']))
            THEN SYMTYPE := VARS
            ELSE SYMTYPE := WORD
      END;
  END (*GETSYM*);


PROCEDURE PUSHSYL (* var Asyl: LINE *);
 
  VAR
                  i: integer;
 
  BEGIN
    with asyl do
      if len > 0 then
        begin
          if lin[len] <> ' ' then
            begin
              len := len + 1;
              lin[len] := ' ';
            end;
          
          if TopOfStack = StackMax then
            Error(57)
          else
            TopOfStack := TopOfStack + 1;
          
          with StgStack[TopOfStack] do
            begin
              StgBegin := StgMarker - len + 1;
              StgPosition := StgBegin;
              ActiveMacro := nil;
              StgEnd := StgBegin + len - 1;
              StgMarker := StgBegin - 1;
              if FreeStgIndx > StgMarker then
                begin
                  writeln(' String table overflow. ... halting.');
                  {exit(program);}halt;
                end;
              for i := 1 to Len do
                StgTable[StgBegin + i - 1] := lin[i];
            end;
        end;
  END (*PUSHSYL*);


FUNCTION GETEXP: INTEGER; 
 
  var
    exp: integer;
    s: sign;
    
  BEGIN 
    GETSYM;   
    (* !!! check for space *)
    getnum(s, exp);
    if s = minus then
      exp := - exp;
    getexp := exp
  END (*GETEXP*);


PROCEDURE LOOKUPVAR;
 
  VAR
                  T: ALFA;
 
  BEGIN
    GetAlfaFromSyl(2, T);
    VID[TV] := T;   VARNDX := 1;
    WHILE VID[VARNDX] <> T DO VARNDX := VARNDX + 1;
  END (*LOOKUPVAR*);


(* ----------------- *)


PROCEDURE DOCOMMAND(TheCommand: CMDTYP);

  VAR
          SignValue: SIGN;
        NumberValue: INTEGER;
         TabCounter: LLEN;
 
  PROCEDURE GetOption;
 
    BEGIN
      GETSYM;
      IF SYL.LIN[1] IN ['0' .. '9', varchr, '(']
      THEN
        BEGIN
          GetNum(SignValue, NumberValue);
          IF (SignValue = INVALID) OR (NumberValue <= 0) THEN
            BEGIN
              Error(11)  (* EXPECTING POSITIVE NUMBER *);
              SignValue := INVALID;
            END;
        END
      ELSE BEGIN BACKUPSYL;   SignValue := INVALID; END;
    END (*GetOption*);
 
 
  PROCEDURE GetNumberAndSign;
 
    BEGIN GETSYM;   GetNum(SignValue, NumberValue) END (*GetNumberAndSign*);
            
  PROCEDURE CMDCLMAR; 
            
    var
      i: integer;
      
    BEGIN
      GetNumberAndSign;   IF OTL.LEN = VAL[VLM]   THEN OTL.LEN := 0;
      CASE SignValue OF
        MINUS:
          if TestOk(((VAL[VLM] - NumberValue) >= 0), 12) then
            (* Error - LM < 0  *)
            VAL[VLM] := VAL[VLM] - NumberValue;
        PLUS:
          if TestOk((VAL[VLM] + NumberValue <= 136), 13) then
            (* Error - LM > 136 *)
            VAL[VLM] := VAL[VLM] + NumberValue;
        UNSIGNED:
          if TestOk(((NumberValue >= 1) and (NumberValue <= 136)), 14) then
            (* Error - LM OUT OF RANGE *)
            VAL[VLM] := NumberValue;
        INVALID:
          Error(15)
          (* Error - LM FOLLOWED BY *)
      END;
      with otl do
        IF LEN = 0 THEN
          BEGIN
            LEN := VAL[VLM];   
            FOR i := 1 TO VAL[VLM] DO LIN[i] := ' ';
          END
   END (* CMDCLMAR *);
              
 PROCEDURE CMDCRMAR;
 
   BEGIN
     GetNumberAndSign;
     CASE SignValue OF
       PLUS:
         if TestOk(((VAL[VRM] + NumberValue) <= 136), 16) then
           (* Error - RM > 136 *)
           VAL[VRM] := VAL[VRM] + NumberValue;
       MINUS:
         if TestOk(((VAL[VRM] - NumberValue) >= 1), 17) then
           (* Error - RM < 1 *)
           VAL[VRM] := VAL[VRM] - NumberValue;
       UNSIGNED:
         if TestOk(((NumberValue >= 1) and (NumberValue <= 136)), 18) then
           (* Error - RM OUT OF RANGE *)
           VAL[VRM] := NumberValue;
       INVALID:
         Error(19)  (* Error - RM FOLLOWED BY *)
     END;
   END (* CMDCRMAR *); 
              
  PROCEDURE CMDCPS;
  
    BEGIN
      GetNumberAndSign;
      IF (SignValue = UNSIGNED) AND (NumberValue > 10)
      THEN
        BEGIN
          OETXT := NumberValue;   OVETXT := NumberValue - 1;   GetNumberAndSign;
          IF (SignValue = UNSIGNED) AND (NumberValue > 10)
          THEN BEGIN VAL[VRM] := NumberValue;   PAGENV.RM := NumberValue; END
          ELSE
            Error(20)  (* Error - INVALID PS COLUMN *);
        END
      ELSE
        Error(21)   (* Error - INVALID PS LINES  *);
    END (* CMDCSP *);
              
 PROCEDURE CMDCP;
 
   BEGIN
     GetNumberAndSign;
     IF (SignValue <> INVALID)
     THEN
       BEGIN
         CASE SignValue OF
           UNSIGNED: BEGIN PREL := FALSE;   PMAR := NumberValue END;
           MINUS: BEGIN PREL := TRUE;   PMAR := - NumberValue END;
           PLUS: BEGIN PREL := TRUE;   PMAR := NumberValue END
         END;
         GetNumberAndSign;
         IF (SignValue = UNSIGNED) AND (NumberValue >= 0) AND (NumberValue <= 5)
         THEN
           BEGIN
             PARSPACE := NumberValue;   GetNumberAndSign;
             IF (SignValue = UNSIGNED)   THEN PARTEST := NumberValue
             ELSE
               Error(22)  (* Error - PARAGRAPH TP *);
           END
         ELSE
           Error(23)  (* Error - PARAGRAPH SPACE *);
       END
     ELSE
       Error(24)  (* Error - Paragraph indent. *);
   END (* CMDCP *);
              
PROCEDURE CMDCI;

  var 
    i: integer;
  
  BEGIN
    GetNumberAndSign;
    IF SignValue <> INVALID
    THEN
      BEGIN
        CASE SignValue OF
          PLUS: NumberValue := NumberValue + VAL[VLM];
          MINUS: NumberValue := VAL[VLM] - NumberValue;
          UNSIGNED:
        END;
        IF NumberValue > 0
        THEN
          BEGIN
            WITH OTL DO
              BEGIN
                LEN := NumberValue;  
                FOR i := 1 TO NumberValue DO LIN[i] := ' ';
              END
          END
        ELSE
          Error(25) (* Error - Indent Less than 0 *);
      END
    ELSE Error(26)  (* Error - i followed by *);
  END (* CMDCI *);
              
 PROCEDURE CMDCHL;
 
   var
     HlCounter: integer;
     HlNumOk  :  Boolean;                                         { 5/21/87 }

   PROCEDURE CLRLISTS;

     BEGIN ENP := 0;   VAL[VLIST] := 0; END (*CLRLISTS*);

   BEGIN
     if (OVETXT - VAL[VOLNO] + 1) > 8 then
       BEGIN
         CLRLISTS;   GetNumberAndSign;
         HlNumOk := False;                                         { 5/21/87 }
         case SignValue of                                         { 5/21/87 }
         UNSIGNED : HlNumOK :=                                     { 5/21/87 }
                (NumberValue > 0) AND                              { 5/21/87 }
                (NumberValue <= VHLMAX) AND (NumberValue <= VAL[VHL] + 1);
         PLUS : Begin                                              { 5/21/87 }
                HlNumOK := (NumberValue = 0) OR (NumberValue = 1); { 5/21/87 }
                If HlNumOK then                                    { 5/21/87 }
                    NumberValue := Val[Vhl] + NumberValue;         { 5/21/87 }
                end;                                               { 5/21/87 }
         MINUS : Begin                                             { 5/21/87 }
                HlNumOk := ((Val[Vhl] - NumberValue) > 0);         { 5/21/87 }
                If HlNumOK then                                    { 5/21/87 }
                    NumberValue := Val[VHL] - NumberValue;         { 5/21/87 }
                end;                                               { 5/21/87 }
         end; { Case }                                             { 5/21/87 }
         if HlNumOk                                                { 5/21/87 }
         THEN
           BEGIN
             IF FIRSTCH
             THEN BEGIN SAVENV(PAGENV);   FIRSTCH := FALSE END;
             RESENV(PAGENV);   ENP := 0;   CLRLINE;
             PUTBLANK(3);
             IF NumberValue > VAL[VHL]   THEN VAL[VHL + NumberValue] := 0;
             VAL[VHL] := NumberValue;   NumberValue := VHL + NumberValue;
             VAL[NumberValue] := VAL[NumberValue] + 1;
             IF VAL[VCH] > 0
             THEN
               BEGIN HlCounter := VHL + 1;   ADDNUM(VAL[VCH], OTL)
               END
             ELSE
               BEGIN
                 HlCounter := VHL + 2;   ADDNUM(VAL[VHL + 1], OTL)
               END;
             FOR HlCounter := HlCounter TO NumberValue DO
               BEGIN ADDCHR('.');   ADDNUM(VAL[HlCounter], OTL) END;
             ADDCHR(' ');   ADDCHR(' ');   DEFRB := 1;
             FORCE := TRUE;
             tab_con_lvl[0] := chr(otl.len-1);                        { V 2.0 }
             move(otl.lin[1],tab_con_lvl[1],otl.len-1);               { V 2.0 }
           END
         ELSE
           Error(27)  (* Error -- BAD HEADER LEVEL *);
       END
     else   begin backupsyl;   PushText(DefrFrcPgMacP);   end;
   END (* CMDCHL *);

PROCEDURE CMDCHC;                                                     { V 2.0 }

  var  move_sub  :  integer;                                          { V 2.0 }

  begin
    if write_toc then                                                 { V 2.0 }
    begin                                                             { V 2.0 }
       write(tabcont,'.PP ');                                         { V 2.2 }
       if val[VHL] = 0 then    { print the chapter number }           { V 2.0 }
                               { if no heading level set }            { V 2.0 }
           write(tabcont,val[VCH]:4)                                  { V 2.0 }
       else                                                           { V 2.0 }
           write(tabcont,tab_con_lvl);                                { V 2.0 }
       writeln(tabcont,' .T $$RM=$$RM-10;');                          { V 2.2 }
    end;                                                              { V 2.0 }
    repeat                                                            { V 2.0 }
        getsym;                                                       { V 2.0 }
        if write_toc then                                             { V 2.0 }
        case symtype of                                               { V 2.0 }
           word, command : begin                                      { V 2.2 }
                           for move_sub := 1 to syl.len do            { V 2.0 }
                             write(tabcont,syl.lin[move_sub]);        { V 2.2 }
                           write(tabcont,' ');                        { V 2.2 }
                           end;                                       { V 2.2 }
           vars          : error(61);                                 { V 2.0 }
        end; { of case }                                              { V 2.0 }
    until symtype = none;                                             { V 2.0 }
    if write_toc then                                                 { V 2.0 }
    begin                                                             { V 2.2 }
        writeln(tabcont);                                             { V 2.2 }
        writeln(tabcont,'$$RM=$$RM+10; .RT ',val[VPAGE]:4);           { V 2.2 }
    end;                                                              { V 2.2 }
  end; { CMDCHC }                                                     { V 2.0 }

PROCEDURE CMDCSP;

  BEGIN
    GetNumberAndSign;
    IF (SignValue <> INVALID) AND (NumberValue >= 1) AND (NumberValue <= 5)
    THEN VAL[VSP] := NumberValue
    ELSE Error(28)  (* Error - SP followed by *);
  END (* CMDCSP *);

PROCEDURE CMDCS;

  BEGIN
    (* RETURN PLUS NumberValue EXTRA CARRIAGE RETURNS *) 
    GetOption;
    IF SignValue <> INVALID
    THEN PUTBLANK(NumberValue * VAL[VSP])
    ELSE PUTBLANK(VAL[VSP]);
  END (* CMDCS *);
              

 PROCEDURE CMDCTC;                                                    { V 2.0 }

   var  move_sub  :  integer;                                         { V 2.0 }

   BEGIN                                                              { V 2.0 }
     move_sub := stgstack[topofstack].stgposition;                    { V 2.0 }
     while (move_sub <= stgstack[topofstack].stgend) and              { V 2.0 }
              (stgtable[move_sub] = ' ') do                           { V 2.0 }
           move_sub := move_sub + 1;                                  { V 2.0 }
     if write_toc then                                                { V 2.0 }
     begin                                                            { V 2.0 }
         for move_sub := move_sub to stgstack[topofstack].stgend do   { V 2.0 }
             write(tabcont,stgtable[move_sub]);                       { V 2.0 }
         writeln(tabcont);                                            { V 2.0 }
     end;                                                             { V 2.0 }
     stgstack[topofstack].stgposition :=                              { V 2.0 }
                 stgstack[topofstack].stgend;                         { V 2.0 }

   END (* CMDCTC *);

PROCEDURE CMDCPNO;

  BEGIN
    GetNumberAndSign;
    IF (SignValue = UNSIGNED) AND (NumberValue < 1000)
    THEN VAL[VPAGE] := NumberValue - 1
    ELSE
      Error(29)  (* Error - Page Number was *);
  END (* CMDCPNO *);
              
PROCEDURE CMDCLIST;

  BEGIN
    GetNumberAndSign;
    IF (SignValue = UNSIGNED) AND (NumberValue > 0) AND (NumberValue < 6)
    THEN
      BEGIN
        PSHENV;
        IF VAL[VLIST] = 0   THEN VAL[VLM] := VAL[VLM] + 9
        ELSE VAL[VLM] := VAL[VLM] + 4;
        VAL[VLIST] := VAL[VLIST] + 1;
        VAL[VLIST + VAL[VLIST]] := 0;   VAL[VSP] := NumberValue;
        PARSPACE := NumberValue + 1;   PMAR := 0;   PREL := TRUE;
        PSHENV;
      END
    ELSE Error(30)  (* Error - List Spacing *);
  END (* CMDCLIST *);
              
PROCEDURE CMDCLE;

  BEGIN
    IF VAL[VLIST] > 0
    THEN
      BEGIN
        PUTBLANK(VAL[VSP]);
        RESENV(ENSTK[ENP - 1]);   CLRLINE;
        VAL[VLIST + VAL[VLIST]] := VAL[VLIST + VAL[VLIST]] + 1;
        OTL.LEN := VAL[VLM] - 4;
        ADDNUM(VAL[VLIST + VAL[VLIST]], OTL);   ADDCHR('.');
        OTL.LEN := VAL[VLM];  
      END
    ELSE Error(31) (* Error - NO ACTIVE LIST *);
  END (* CMDCLE *);
              
PROCEDURE CMDCELIST;

  BEGIN
    IF VAL[VLIST] > 0
    THEN
      BEGIN VAL[VLIST] := VAL[VLIST] - 1;   POPENV;   POPENV;
      END
    ELSE Error(32)  (* Error - NO ACTIVE LIST *);
  END (* CMDCELIST *);
             
PROCEDURE CMDCFIG;

  BEGIN
    GetNumberAndSign;
    IF (SignValue = UNSIGNED)
    THEN
      BEGIN
        IF NumberValue <= OVETXT - VAL[VOLNO] + 1
        THEN
          BEGIN
            OVBTXT := 0 (* SO PUTBLANK WORKS*); 
            PUTBLANK(NumberValue)
          END
        ELSE
          BEGIN
            IF FIGP < FIGMAX
            THEN
              BEGIN FIGP := FIGP + 1;   FIGN[FIGP] := NumberValue;
              END
            ELSE
              Error(33)  (* Error - TOO MANY PENDING FIGS *)
          END
      END
    ELSE
      Error(34) (* Error - FIG FOLLOWED BY *)
  END (* CMDCFIG *);
   
              
PROCEDURE CMDCMACRO;

 var
                 N8: 0 .. MaxParms;
              TMACP,
               MACP: PMAC;
                 TL: LINE;
 

  PROCEDURE SYLTOMAC;
 
    BEGIN
      WITH TMACP ^ DO
        BEGIN
          GetAlfaFromSyl(1, NM);
          NP := 0;   ON := FALSE;
          MacroBegin := 0;   MacroEnd := 0;  
        END;
    END (*SYLTOMAC*);
 
 
  PROCEDURE MAKPARM;
 
    BEGIN
      SYL := TL;   ADDNUM(NumberValue - N8 + 1, SYL);   NEW(TMACP);   SYLTOMAC;
      WITH TMACP ^ DO
        BEGIN
          MA := MACP ^.MA;   MACP ^.MA := TMACP;  
          MT := PARM;   MACP := TMACP;
        END;
    END (*MAKPARM*);

 
  BEGIN
    IF TopOfStack = 0 then
      BEGIN
        GETTOKEN;
        IF SYL.LEN <> 0
        THEN
          BEGIN
            NEW(TMACP);   SYLTOMAC;
            TMACP ^.MA := MACLSTP;
            TMACP ^.MT := HEADER;
            TL := SYL (* SAVE MACRO NAME  *);
            TL.LEN := TL.LEN + 1
            (* FOR ADDNUM*); 
            IF TL.LEN > AlfaLen THEN TL.LEN := AlfaLen;   
            
            GETTOKEN;
            IF NOT (SYL.LIN[1] IN ['*', '='])
            THEN GetNum(SignValue, NumberValue)
            ELSE SignValue := INVALID;
            IF SignValue = UNSIGNED   THEN GETTOKEN
            ELSE
              IF (SYL.LIN[1] = '*') AND (SYL.LEN = 1)
              THEN BEGIN NumberValue := MaxParms;   GETTOKEN END
              ELSE NumberValue := 0;
            
            IF (SYL.LIN[1] = '=') AND (SYL.LEN = 1)
            THEN
              BEGIN
                MACLSTP := TMACP;
                with StgStack[TopOfStack], TMACP^ do
                  begin
                    StackToMacro(StgPosition, MacroBegin, MacroEnd);
                    IF NumberValue < MaxParms
                    THEN
                      BEGIN
                        NP := NumberValue;   MACP := MACLSTP;
                        FOR N8 := NumberValue DOWNTO 1 DO MAKPARM
                      END
                    ELSE
                      BEGIN
                        NP := MaxParms;   N8 := NumberValue;
                        MACP := MACLSTP;   MAKPARM
                      END;
                    StgPosition := StgEnd;
                  end
              END
            ELSE
              Error(35)  (* Error - Missing = in macro def *)
          END
        ELSE Error(36) (* Error - No Macro Name *);
      END
    ELSE Error(37) (* Error - Nested Macro definitions *);
  END (* CMDCMACRO *);
   
              
PROCEDURE CMDCVAR;

  BEGIN
    GETSYM;
    IF SYMTYPE = VARS
    THEN
      BEGIN
        LOOKUPVAR;
        IF VARNDX < VARMAX
        THEN
          BEGIN
            IF VARNDX = TV THEN
              BEGIN TV := TV + 1;   VTY[VARNDX] := VITEM
              END;
            GETMACSYM;
            IF (SYL.LEN = 1) AND (SYL.LIN[1] = '=')
            THEN
              BEGIN
                GetNumberAndSign;
                IF SignValue <> INVALID THEN
                  BEGIN
                    IF SignValue = MINUS   THEN NumberValue := - NumberValue;
                    VAL[VARNDX] := NumberValue
                  END
              END
            ELSE PUSHSYL(SYL)
          END
        ELSE
          Error(38)  (* Error - Too Many Variables *)
      END
    ELSE
      Error(39)  (* Error - Needed variable name; got *)
  END (* CMDCVAR *);

              
PROCEDURE CMDCINC;

  BEGIN
    GETSYM;
    IF SYMTYPE = VARS
    THEN
      IF VARNDX < TV   THEN VAL[VARNDX] := VAL[VARNDX] + 1
      ELSE
        Error(40) (* Error - Undeclared variable *)
    ELSE
      Error(41) (* Error - inc Followed by *)
  END (* CMDCINC *);
   
            
PROCEDURE CMDCDEC;

  BEGIN
    GETSYM;
    IF SYMTYPE = VARS
    THEN
      IF VARNDX < TV   THEN VAL[VARNDX] := VAL[VARNDX] - 1
      ELSE
        Error(42) (* Error - Undeclared variable *)
    ELSE
      Error(43) (* Error - Dec followed by *)
  END (* CMDCINC *);
   
              
PROCEDURE CMDCARRAY;

  BEGIN
    GETSYM; 
    IF SYMTYPE = VARS
    THEN
      BEGIN
        LOOKUPVAR;
        IF VARNDX = TV
        THEN
          BEGIN
            NumberValue := GETEXP;
            IF (NumberValue > 0) AND (NOT EXPRERR)
            THEN
              IF NumberValue + TV < VARMAX
              THEN
                BEGIN
                  TV := TV + NumberValue + 1;   VUP[VARNDX] := NumberValue;
                  VTY[VARNDX] := VARRAY;
                END
              ELSE
                BEGIN
                  VarName := VID[VARNDX];
                  Error(44) (* Error - No room for array *)
                END
            ELSE
              Error(45)  (* Error - Bad array size *)
          END
        ELSE
          Error(46)  (* Error - Already declared *)
      END
    ELSE
      Error(47) (* Error - Not a variable symbol *)
  END (* CMDCARRAY *);

    
  procedure cmdinclude;
    
    var
      i : integer;
      testname : string80;

    begin
      gettoken;
      testname := 
'                                                                                ';
      for i := 1 to syl.len do
        testname[i] := syl.lin [i];
      testname[0] := chr(syl.len); { Turbo needs this for MS-DOS }
      if TestOk(not DoInclFl, 48) then
               (* Error - ILLEGAL NESTED INCLUDE COMMAND *)
        if FileExists(testname) then
          begin
            inclname := testname;
{}{VMS}  {open (File_Variable:=inclfile,File_Name:=inclname,History:=old);}
{}{Turbo,Prospero}   assign (inclfile,inclname);
            reset (inclfile);
            doinclfl := true;
            inclno := 0
          end
        else
{          if fileexists (concat (testname, '.text')) then
            begin
              inclname := testname;
              reset (inclfile, concat (inclname, '.text'));
              doinclfl := true;
              inclno := 0
            end
          else}
            Error(49) (* Error - Include file not present *)
    end (* cmdinclude *);

  PROCEDURE UPCASESYL;
   
    var
      i: integer;
    
    BEGIN
      WITH SYL DO 
        FOR i := 1 TO LEN DO
          LIN[i] := ForceUpperCase(LIN[i]);
    END (*UPCASESYL*);

 {  procedure cmdcaseflag(convert: boolean);  Deleted    5/21/87 }

  BEGIN (*DOCOMMAND*) 
    CASE TheCommand OF
      CBREAK: (* handled in ProcessLine *);
      CCR: (* handled in ProcessLine *);
      CTC: CMDCTC;                                                    { V 2.0 }
      cinclude : cmdinclude;
      CBLANK: (* BREAK FOLLOWED BY NumberValue EXTRA BLANK LINES *)
        BEGIN
          GetOption;
          IF SignValue <> INVALID   THEN PUTBLANK(NumberValue)
          ELSE PUTBLANK(1);
        END;
      CFLAG: FLAG := YES;
      CFLAGCAPS: FLAGCAPS := YES;
      CLOWER: LOWER := YES;
      CUPPER: LOWER := NOT YES;
      CESCCHR: ESCCHR := YES;
      CPERIOD: PERIOD := YES;
      CCENTER: OTL.CENTER := TRUE;
      CJUST: JUSTIT := YES;
      CUL: UL := YES;
      CLMAR: CMDCLMAR;
      CRMAR: CMDCRMAR;
      CFILL: FILL := YES;
      CSIG: SIGBL := YES;
      CPAGE: PushText(DefrFrcPgMacP);
      CTOP: DOTOP;
      CMID: DOMID;
      CBOT: DOBOT;
      CSUP: SUP := YES;
      CSTD: SETSTD;
      CPS: CMDCPS;
      CSAV: PSHENV;
      CP: CMDCP;
      CRES: BEGIN POPENV;   CLRLINE END;
      CPP: PARAGRAPH;
      CAP: AP := YES;
      CI: CMDCI;
      CSP: CMDCSP;
      CS: CMDCS;
      CTP:
        BEGIN
          GetNumberAndSign;
          IF SignValue = UNSIGNED   THEN TESTPAGE(NumberValue, false)
          ELSE Error(50)  (* Error - TP followed by *)
        END;
      CHC: CMDCHC;                                                    { V 2.0 }
      CHL: CMDCHL;
      CNMP: VAL[VNMP] := BoolOrd(yes);
      CPNO: CMDCPNO;
      CLIST: CMDCLIST;
      CLE: CMDCLE;
      CELIST: CMDCELIST;
      CFIG: CMDCFIG;
      CBAR: BAR := YES; 
      CBB: BEGIN BB := TRUE;   OTL.BBAR := TRUE END;
      CEB:
        BEGIN IF EMPTY   THEN OTL.BBAR := FALSE;   BB := FALSE;
        END;
      CU: UNDL := YES;
      cbold: bold := yes;
      CT: T := TRUE;
      CTAB, CTABS:
        BEGIN
          CLRTAB;
          TabCounter := 1;   
          GetOption;
          while (SignValue <> Invalid) and (TabCounter <= TabMax) do
            begin
              TABS[TabCounter] := NumberValue;   
              TabCounter := TabCounter + 1; 
              GetOption;
            end;
          BACKUPSYL;
        END;
      CRT: RT := TRUE;
      CDOT: DOT := YES; 
      CRIGHT:
        BEGIN
          GetNumberAndSign;
          IF (SignValue = UNSIGNED) AND (NumberValue <= 136)   
          THEN RIGHTSPACE := NumberValue
          ELSE Error(51)  (* Right space *)
        END;
      CLINES:
        BEGIN
          GetNumberAndSign;
          IF (SignValue = UNSIGNED)   THEN OEPAG := NumberValue
          ELSE Error(52)  (* Error - Lines followed by *)
        END;
      CMACRO: CMDCMACRO;
      CX: XTEND := YES; 
      CVAR: CMDCVAR;
      CINC: CMDCINC;
      CDEC: CMDCDEC;
      CSAVPAG: BEGIN SAVENV(PAGENV);   FIRSTCH := FALSE END; 
      CRESPAG: RESENV(PAGENV);
      CARRAY: CMDCARRAY;
      CFMT: BEGIN NumberValue := GETEXP;   DOFMT(NumberValue, GETEXP) END;
      CIF: IF GETEXP = 0   THEN 
             StgStack[TopOfStack].StgPosition := 
             StgStack[TopOfStack].StgEnd;
      CASIS: begin 
               TopOfStack := 0 (* !!! should free *); asis := true  
             end;
      CFLAGOVER: FLAGOVER := YES;
      CFLAGSIG: FLAGSIG := YES;
      CREM: StgStack[TopOfStack].StgPosition := 
                        StgStack[TopOfStack].StgEnd
             (* MAKES REST OF A LINE A COMMENT. *);
      CUPP: (* FORCE NEXT SYMBOL UPPER *)
        BEGIN GETSYM;   UPCASESYL;   ADDWORD; END;
      CUSB: USB := YES;
      ccaseflag: CaseConvert := TRUE;                           { 5/21/87 }
      NOTCMD: BEGIN END
    END;
  END (*DOCOMMAND*);

