program labels;
(*
  Copyright (C) 1986 by Caleb Computing Center
                        Karson W. Morrison
                        Martin Morrison
                        RD3,
                        417 Larsen Rd
                        Ringoes NJ. 08551
                        201-788-1846

  See the Envelope.doc file for all the little intricacies of this program.

*)
Const MaxWin = 3;
type
  AddressArray = array [1..7] of string[32];
var
  Addressline : AddressArray;
  RAddressline : AddressArray;
  FilVar : text;
  FileName : string[14];
  ReturnCorrect,              { Return Address correct }
  ReturnFirst,                { Return address first records on input file }
  ReturnLabels,               { Just return Labels }
  FormsCorrect,               { Forms alignment correct }
  CheckNames,                 { Check names before printing }
  PrintThisOne,               { Print this record }
  EndOfFile,                  { End of Input file }
  LengthValid,                { Is the length a valid number }
  NonBlank,                   { There is a valid character in the record }
  BlankLine,                  { This is a blank line }
  HaltEnvelope   : boolean;   { Print Envelopes }
  BlanksInLine : String[60];  { Number of blanks before address on envelopes }
  i, xx, Z : integer;

{$IWindo.inc}

function YesNO : Boolean;  { Checks for Y or N reply }
var Ch : Char;
begin
  Read(Kbd,Ch);
  if Upcase(Ch) = 'Y' then
    YesNo := True
  else
    YesNo := False;
end;

Procedure GetRAddress;    { Asks for return address }
begin
  Write('Return Address Line1.. ________________________________');
  GoToXY(24,WhereY);
  readln(RAddressLine[1]);
  Write('Return Address Line2.. ________________________________');
  GoToXY(24,WhereY);
  readln(RAddressLine[2]);
  Write('Return Address Line3.. ________________________________');
  GoToXY(24,WhereY);
  readln(RAddressLine[3]);
  Write('Return Address Line4.. ________________________________');
  GoToXY(24,WhereY);
  readln(RAddressLine[4]);
  Write('Return Address Line5.. ________________________________');
  GoToXY(24,WhereY);
  readln(RAddressLine[5]);
  Write('Return Address Line6.. ________________________________');
  GoToXY(24,WhereY);
  readln(RAddressLine[6]);
end;

Procedure CheckAllSpaces;      { checks if the record is all spaces }
var HoldLine : string[32];
begin
  NonBlank := False;
  HoldLine := AddressLine[xx];
  for i := 1 to length(HoldLine) do
  begin
    if HoldLine[i] <> ' ' then
      NonBlank := True;                   { line is a non blank line }
  end;
  if NonBlank = False then
     BlankLine := True;
end;

Procedure GetAddress;            { gets the name and address from the file }
begin
  BlankLine := False;
  EndOfFile := False;
  xx := 0;
  for i := 1 to 7 do             { Null out each line }
    AddressLine[i] := '';
  repeat
    xx := xx + 1;
    readln(FilVar,AddressLine[xx]);
    if AddressLine[xx] = '' then { the record was just a <CR> }
    begin
       BlankLine := True;
    end;
    if not Blankline then          { the record was not just a <CR> but }
      CheckAllSpaces;              { was it spaces anyway }
    if EOF(FilVar) then
       EndOfFile := True;
  until (EndOfFile) or (BlankLine);
end;

Procedure Show(Var PrintArray : AddressArray);
begin                                 { Shows the records on the screen }
  for i := 1 to 6 do
  begin
    Writeln(PrintArray[i]);
  end;
end;

Procedure Print(Var PrintArray : AddressArray;   { prints the record }
                    Ch         : Char);          { on the paper }
begin
  for i := 1 to 6 do
  begin
    if PrintArray[i] > '' then
       If Ch = 'A' then
          Write(Lst,BlanksInLine);
    Writeln(Lst,PrintArray[i]);
  end;
end;

Procedure FormsAlign;                 { like it says }
begin
  for i := 1 to 6 do
     Writeln(Lst,'X X X X X X  Line ',i,'  X X X X X X');
  Write('Forms OK (Y or N) ');
  FormsCorrect := YesNo;
  Writeln;
end;

begin                            { Main Line }
  TextBackground(1);
  TextColor(14);
  ClrScr;
  BlanksInLine := '                                                            ';
  Writeln('Label print program 1.1  Copyright (c) Caleb Computer Consultants');
  Writeln('Envelope print program                 Karson W. Morrison');
  Writeln('                                       Martin Morrison');
  Writeln('           October 30, 1988            RD 3 417 Larsen Rd.');
  Writeln('                                       Ringoes NJ. 08551');
  Writeln('                                       201-788-1846');
  Writeln;
  Writeln;
  ReturnFirst := False;
  Write('Do you want just a stack of return labels? (Y or N) ');
  ReturnLabels := YesNo;
  Writeln;
  if ReturnLabels then
  begin
    repeat
      GetRAddress;
      MkWin(4,7,60,19,1,14,1);   { Make a windo look like an envelope }
      Show(RAddressLine);        { put the return address in the corner }
      Write('Is the return address correct? (Y or N) ');
      ReturnCorrect := YesNo;    { is it OK }
      RmWin;                     { Get rid of the windo }
    until ReturnCorrect;
    repeat                         { I'll keep doing this }
      FormsAlign;
    until FormsCorrect;            { until its OK }
    repeat
      Write('How many Labels do you want?  (1 to 255) ');
      Readln(Z);                   { length ? }
      Writeln;
      LengthValid := False;
      If Z in [1..255] then LengthValid := True;
    until LengthValid;
    for i := 1 to Z do
      Print(RaddressLine,'R');  { Print return address }
    Halt;
  end;
  Write('Do you want envelopes? (Y or N) ');
  HaltEnvelope := YesNo;
  Writeln;
  Writeln;
  if HaltEnvelope then
  begin
    CheckNames := True;  { if you are printing envelopes I'll halt for each }
    Write('Is the first name on the file the return address? (Y or N) ');
    ReturnFirst := YesNo;
    Writeln;
    Writeln;
    Writeln;
  end
  else
  begin
    Write('Do you Check each name prior to printing? (Y or N) ');
    CheckNames := YesNo;
    Writeln;
    Writeln;
  end;
  if HaltEnvelope then             { are we doing envelopes }
  begin                            { I guess so }
    repeat
      if not ReturnFirst then      { if the first record is not the return }
      begin
        repeat
          GetRAddress;
          MkWin(4,7,60,19,3,0,11);   { Make a windo look like an envelope }
          Show(RAddressLine);        { put the return address in the corner }
          Write('Is the return address correct? (Y or N) ');
          ReturnCorrect := YesNo;    { is it OK }
          RmWin;                     { Get rid of the windo }
        until ReturnCorrect;
      end;
      ReturnCorrect := True;
      repeat
        Write('How many spaces before "TO Address"?  (1 to 60) ');
        Readln(Z);                   { length ? }
        Writeln;
        LengthValid := False;
        If Z in [1..60] then LengthValid := True;
      until LengthValid;
      BlanksInLine[0] := Chr(Z);   { set up the length to what you want }
    until ReturnCorrect;           { The return is OK }
  end
  else
    repeat                         { I'll keep doing this }
      FormsAlign;
    until FormsCorrect;            { until its OK }
  repeat
    Write('What is your input file name? (Press * when done) ');
    Readln(FileName);              { give me your file name }
    Writeln;
    if FileName <> '*' then        { All done }
    begin                          { Nope }
      Assign(FilVar, FileName);
      {$I-}                        { Turn of abend if IO-error }
      Reset(Filvar);
      {$I+}                        { turn it back on }
      if IOResult = 0 then         { Does the file exist in this directory }
      begin
        if ReturnFirst then             { If the return address is the first }
        begin                           { records on the file }
          GetAddress;                   { then go read the file }
          for i := 1 to 6 do            { and move it to the }
            RAddressLine[i] := AddressLine[i];  { return address area }
          if not HaltEnvelope then
            Writeln('Skipping the first record (Return Address) on the file');
        end;
        repeat
          GetAddress;                   { Read the name and address file }
          if CheckNames then            { If you want to stop }
          begin
            Show(AddressLine);          { Then lets show it to you }
            Writeln;
            Write('Print this one? (Y or N) ');   { Do you want to print it }
            PrintThisOne := YesNo;
            Writeln;
            Writeln;
            Writeln;
          end;
          if PrintThisOne then         { Good one to print }
          begin
            if HaltEnvelope then
            begin                      { ENVELOPES }
              Print(RaddressLine,'R');  { Print return address }
              Writeln(Lst);        { this moves the to address 3 lines under }
              Writeln(Lst);        { from address }
              Writeln(Lst);
              Print(AddressLine,'A');   { Print "TO" address }
            end
            else                      { LABELS }
              Print(AddressLine,'R'); { prints in return area }
          end;                        { meaning position 1 }
        until EndOfFile;
      end
      else
      begin
        Writeln('File ',FileName,' does not exist');
      end;
    end;
  until FileName = '*';             { When this happens we are all done }
end.
