/**********************************
 * MAKEHOLLOW.C
 *
 * Make HP Fonts Hollow
 *
 * James Bumgardner 1987
 **********************************/

#include <stdio.h>
#include <ctype.h>
#include "ffilters.h"

process_font_header()
{
	/* nada */
}

process_char(h,w)			/* Process pmap[0] --> pmap[1] */
{
	register int y,x;
	register char sflg;
	for (y = 0; y < h; ++y)	/* Blank Output */
		for (x = 0; x < w; ++x)
			pmap[1][y][x] = 0;

	for (y = 0; y < h; ++y)
	{					/* Mark Horizontal Edges */
		sflg = 0;
		for (x = 0; x < w; ++x)
		{
			if (pmap[0][y][x])
			{
				if (sflg == 0)
				{
					pmap[1][y][x] = 1;
					sflg = 1;
				}
			}
			else {
				if (sflg)
				{
					pmap[1][y][x-1] = 1;
					sflg = 0;
				}
			}
		}
		if (sflg)	pmap[1][y][x-1] = 1;
	}

	for (x = 0; x < w; ++x)
	{
		sflg = 0;
		for (y = 0; y < h; ++y)
		{				/* Mark Vertical Edges */
			if (pmap[0][y][x])
			{
				if (sflg == 0)
				{
					pmap[1][y][x] = 1;
					sflg = 1;
				}
			}
			else
			{
				if (sflg)
				{
					pmap[1][y-1][x] = 1;
					sflg = 0;
				}
			}
		}
		if (sflg)	pmap[1][y-1][x] = 1;
	}
}
