/**********************************
 * MAKESHAD.C
 *
 * Make Shadow Fonts
 *
 * James Bumgardner 1987
 **********************************/

#include <stdio.h>
#include <ctype.h>
#include "ffilters.h"

#define DEFAULT_SMEAR	10

process_font_header(smear)
{
	if (smear == 0)	smear = DEFAULT_SMEAR;
	font_header.width += smear;
	font_header.height += smear;
}

process_char(h,w,smear)			/* Process pmap[0] --> pmap[1] */
{
	register int y,x;
	register char i,sflg;

	if (smear == 0)	smear = DEFAULT_SMEAR;

	char_header.width += smear;
	char_header.height += smear;
	char_header.delta_x += smear;

	for (y = 0; y < h + smear; ++y)	/* Blank Output */
		for (x = 0; x < w + smear+8; ++x)
			pmap[1][y][x] = 0;

	for (i = smear-1; i >= 0; --i)
	    for (y = 0; y < h; ++y)
		for (x = 0; x < w; ++x)
		    if (pmap[0][y][x])
			pmap[1][y+i][x+i] = (i == 0)? 0 : 1;

	/*
	 * fill in North West Outlines - remove the
	 * following portion of code
	 * to make another interesting font
         */

	for (y = 0; y < h; ++y)
	{
		sflg = 0;
		for (x = 0; x < w; ++x)
		{
			if (pmap[0][y][x])
			{
				if (sflg == 0)
				{
					pmap[1][y][x] = 1;
					sflg = 1;
				}
			}
			else	sflg = 0;
		}
	}

	for (x = 0; x < w; ++x)
	{
		sflg = 0;
		for (y = 0; y < h; ++y)
		{
			if (pmap[0][y][x])
			{
				if (sflg == 0)
				{
					pmap[1][y][x] = 1;
					sflg = 1;
				}
			}
			else	sflg = 0;
		}
	}
}
