/*
**	File functions FSEARCH and FNEXT.
**
**	char *fsearch( filename )	returns "found" filename or 
**	char *fnext()			NULL for "not found" or "error".
**	char *fpath()			returns path part of filespec
**
**	Joe Barnhart,	21-July-86
*/

#include <stdio.h>
#include <dos.h>
#define INCL_DOS
#include <os2.h>

HDIR hdir;
USHORT usSearchCount;
FILEFINDBUF findbuf;


union	REGS regs;
char	workarea[43];		/* area for DOS to play around in */


char *fsearch( fname )
char *fname;
{
  USHORT returncode;

  hdir = HDIR_SYSTEM;
  usSearchCount = 1;
  returncode = DosFindFirst((PSZ)fname,
                            &hdir,
                            FILE_NORMAL | FILE_READONLY,
                            &findbuf,
                            sizeof(findbuf),
                            &usSearchCount,
                            0L);
  if(returncode)
    return NULL;
  else
    return findbuf.achName;
}


char *fnext()
{
  USHORT returncode;
  hdir = HDIR_SYSTEM;
  usSearchCount = 1;

  returncode = DosFindNext(hdir,
                           &findbuf,
                           sizeof(findbuf),
                           &usSearchCount);
  if(returncode)
    return NULL;
  else
    return findbuf.achName;
}


char *fpath( fname )
char *fname;
{

    static char path[32];
    register int plen;
    register char *p;
    char *endp;

    for( p=fname, endp=fname; *p!='\0'; p++ )
	if( *p==':' || *p=='\\' )
	    endp = p+1;

    plen = endp - fname;
    if( plen == 0 )
	path[0] = '\0';
    else {
	strncpy( path, fname, plen );
	path[ plen+1 ] = '\0';
	strlwr( path );
	}
    return( path );
}

