ECHO OFF
REM ---------------------------------------------------------------------------
REM  INTRO.BAT - Introduction to instantADDRESS
REM              Copyright (C) 1991 KJL Software. All rights reserved.
REM
REM              *** PLEASE NOTE ***
REM
REM              This batch file requires the following files to be in the
REM              current subdirectory:
REM
REM              SCRSHOW .EXE
REM              INTRO   .SCN
REM              PRINTEXT.EXE
REM ---------------------------------------------------------------------------
:start
scrshow intro.scn /n1 /k
IF ERRORLEVEL 59 GOTO help
IF ERRORLEVEL 8 GOTO info
IF ERRORLEVEL 7 GOTO resident
IF ERRORLEVEL 6 GOTO manual
IF ERRORLEVEL 5 GOTO site
IF ERRORLEVEL 4 GOTO register
IF ERRORLEVEL 3 GOTO readme
IF ERRORLEVEL 2 GOTO install
IF ERRORLEVEL 1 GOTO exit
GOTO start

REM ---------------------------------------------------------------------------
REM  HELP - Display help window
REM ---------------------------------------------------------------------------
:help
scrshow intro.scn /n9 /p
GOTO start

REM ---------------------------------------------------------------------------
REM  INFO - Display information window
REM ---------------------------------------------------------------------------
:info
scrshow intro.scn /n8 /p
GOTO start

REM ---------------------------------------------------------------------------
REM  RESIDENT - Install instantADDRESS into memory
REM ---------------------------------------------------------------------------
:resident
instaddr > NUL:
IF ERRORLEVEL 1 GOTO noload
IF ERRORLEVEL 0 GOTO success
GOTO start
REM UNABLE TO LOAD instantADDRESS ---------------------------------------------
:noload
scrshow intro.scn /n7 /p
GOTO start
REM instantADDRESS LOADED SUCCESSFULLY ----------------------------------------
:success
scrshow intro.scn /n6 /p
GOTO start

REM ---------------------------------------------------------------------------
REM  MANUAL - Print the User's Manual
REM ---------------------------------------------------------------------------
:manual
SET doc$=INSTADDR.DOC
GOTO print

REM ---------------------------------------------------------------------------
REM  SITE - Print the site license
REM ---------------------------------------------------------------------------
:site
SET doc$=SITELICN.DOC
GOTO print

REM ---------------------------------------------------------------------------
REM  REGISTER - Print the registration form
REM ---------------------------------------------------------------------------
:register
SET doc$=REGISTER.FRM
GOTO print

REM ---------------------------------------------------------------------------
REM  README - Print the README file
REM ---------------------------------------------------------------------------
:readme
SET doc$=README
GOTO print

REM ---------------------------------------------------------------------------
REM  PRINT - Print a file, first ask for printer type and port
REM ---------------------------------------------------------------------------
:print
scrshow intro.scn /n4 /k
IF ERRORLEVEL 35 GOTO no_readme
IF ERRORLEVEL 21 GOTO yes_readme
IF ERRORLEVEL 1 GOTO start
GOTO readme

REM No graphics characters allowed
:no_readme
SET gfx$=FALSE
GOTO port

REM Graphics characters allowed
:yes_readme
SET gfx$=TRUE

REM Select printer port
:port
scrshow intro.scn /n5 /k
IF ERRORLEVEL 48 GOTO serial2
IF ERRORLEVEL 30 GOTO serial1
IF ERRORLEVEL 4 GOTO port3
IF ERRORLEVEL 3 GOTO port2
IF ERRORLEVEL 2 GOTO port1
IF ERRORLEVEL 1 GOTO print
GOTO port

REM Serial port 2 selected
:serial2
SET prt$=2
GOTO serprtfile

REM Serial port 1 selected
:serial1
SET prt$=1
GOTO serprtfile

REM Port 3 selected
:port3
SET prt$=3
GOTO prtfile

REM Port 2 selected
:port2
SET prt$=2
GOTO prtfile

REM Port 1 selected
:port1
SET prt$=1
GOTO prtfile

:serprtfile
IF %gfx$% == TRUE printext %doc$% /p COM%prt$% > NUL:
IF %gfx$% == FALSE printext %doc$% /p COM%prt$% /c > NUL:
SET gfx$=
SET prt$=
SET doc$=
GOTO start

:prtfile
IF %gfx$% == TRUE printext %doc$% /p LPT%prt$% > NUL:
IF %gfx$% == FALSE printext %doc$% /p LPT%prt$% /c > NUL:
SET gfx$=
SET prt$=
SET doc$=
GOTO start

REM ---------------------------------------------------------------------------
REM  INSTALL - Install the instantADDRESS files onto a disk
REM ---------------------------------------------------------------------------
:install
scrshow intro.scn /n2 /k
IF ERRORLEVEL 48 GOTO inst_b
IF ERRORLEVEL 46 GOTO inst_c
IF ERRORLEVEL 36 GOTO inst_j
IF ERRORLEVEL 35 GOTO inst_h
IF ERRORLEVEL 34 GOTO inst_g
IF ERRORLEVEL 33 GOTO inst_f
IF ERRORLEVEL 32 GOTO inst_d
IF ERRORLEVEL 30 GOTO inst_a
IF ERRORLEVEL 23 GOTO inst_i
IF ERRORLEVEL 18 GOTO inst_e
IF ERRORLEVEL 1 GOTO start
GOTO install
:inst_b
SET drv$=B:
GOTO create
:inst_c
SET drv$=C:
GOTO create
:inst_j
SET drv$=J:
GOTO create
:inst_h
SET drv$=H:
GOTO create
:inst_g
SET drv$=G:
GOTO create
:inst_f
SET drv$=F:
GOTO create
:inst_d
SET drv$=D:
GOTO create
:inst_a
SET drv$=A:
GOTO create
:inst_i
SET drv$=I:
GOTO create
:inst_e
SET drv$=E:

REM - CREATE A DIRECTORY? -----------------------------------------------------
:create
scrshow intro.scn /n3 /k
IF ERRORLEVEL 35 GOTO crdone
IF ERRORLEVEL 21 GOTO yes_create
IF ERRORLEVEL 1 GOTO install
GOTO create

:yes_create
MD %drv$%\ADDRESS
CD %drv$%\ADDRESS
GOTO crdone

:crdone
CLS
ECHO Copying instantADDRESS files to drive %drv$%
ECHO ----------------------------------------
COPY *.* %drv$%
SET drv$=
GOTO start

REM ---------------------------------------------------------------------------
REM  EXIT - Exit to Operating System
REM ---------------------------------------------------------------------------
:exit
CLS
