*
*  All of these macros assume that QEdit 2 is in Insert and Indent modes.
*  They all involve putting the cursor at the end of a piece of text and
*  then pressing the assigned key. Here, the "piece of text" is represented
*  by "foo". The cursor would be after the second "o" when the macro key
*  would be pressed.
*
*  @p creates a commented procedure block
*            procedure foo;
*            begin {foo}
*            end; {foo}
*
@p            macrobegin markblockend wordleft markblockbegin endline return copyblock endline return copyblock unmarkblock "end; {" endline "}" cursorup endline "}" wordleft "begin {" cursorup endline ";" wordleft "procedure " endline cursorleft
*
*  @f creates a commented function block
*            function foo : ;
*            begin {foo}
*            end; {foo}
*
@f            macrobegin markblockend wordleft markblockbegin endline return copyblock endline return copyblock unmarkblock "end; {" endline "}" cursorup endline "}" wordleft "begin {" cursorup endline ";" wordleft "function " endline cursorleft " : "
*
*  @w creates a commented while block
*            while foo do begin
*
*            end; {while foo}
*
@w            macrobegin begline wordright "while " wordleft markblockbegin endline markblockend return copyblock unmarkblock "end; {" endline "}" cursorup endline " do begin" return " "
*
*  @r creates a commented repeat block
*            repeat {foo}
*
*            until foo;
*
@r            macrobegin begline wordright "repeat {" markblockbegin endline markblockend "}" return "until " copyblock endline ";" unmarkblock cursorup endline return "  "
*
*  @b creates a commented begin-end block
*            begin {foo}
*
*            end; {foo}
*
@b            macrobegin wordleft "begin {" cursorleft markblockbegin endline "}" markblockend return "end; " copyblock unmarkblock cursorup endline return "  "
*
