/*  QMAKE       A program to expedite program maintenance using QEdit.
 *              Jerry Houston - COLLEGE CORNER BBS - (206)643-0804
 *
 *              QMAKE strips the extension from the name of the file
 *              that's currently being edited in QEdit, then runs MAKE
 *              using that stripped file name.
 *                  This allows easy program maintenance provided that
 *              you insure that:
 *
 *                        your macro for QEdit contains the
 *                         path where your version of MAKE.EXE
 *                         is stored (see USAGE below)
 *                        your makefile has the same name as
 *                         the program being edited, but with
 *                         no extension.
 *
 *  USAGE       From a command line, QMAKE could be run with the path to
 *              MAKE.EXE and the name of the program being edited as
 *              arguments, but it would be simpler to in that case just to
 *              run MAKE with the appropriate filename.
 *                  QMAKE should be invoked instead with a macro from within
 *              QEdit.  An example of an appropriate macro is shown below.
 *              Although the macro is here split into multiple lines for
 *              readability, it should be one line in your QKEY.DEF file.
 *              Be sure to run QCONFIG to reconfigure your copy of QEdit to
 *              include the new macro, and put QMAKE into your DOS path.
 *
 *              <key to assign macro to> macro_begin save_file
 *              dos 'QMAKE C:\BOUND\MAKE.EXE ' current_filename return
 *                         |               |
 *                        /                 \
 *                       path to your MAKE.EXE
 *
 *              I assigned my macro to <Alt-K>, which is somewhat nmemonic
 *              for maKe, and is not used in the default keybindings.  To
 *              do the same, replace <key to assign macro to> in the above
 *              description to  @k  .
 *
 *  ERRORS      None are returned from Qmake.
 *
 *  NOTES       Other such such programs exist, though the ones I've seen
 *              don't work with MAKE.  They execute compiler commands
 *              directly, based on the extension of the file being edited.
 *                  Since I create a makefile for nearly every program I
 *              compile, I find it easier just to run MAKE.EXE with the name
 *              of the current file as an argument, stripped of its ext.
 *                  Also, I usually don't care to have a file of errors
 *              read into the editor as a separate file in another window.
 *              usually it's sufficient just to note any errors before
 *              returning to QEdit.  On the rare occasion that I want to
 *              create a list of errors, I can do it from within the
 *              makefile, and read it into QEdit with ordinary edit commands.
 *                  This program QMAKE.EXE and the accompanying source are
 *              placed into the public domain as of July 2, 1988, by the
 *              author, Jerry Houston.  Enjoy!
 */
#include <STDIO.H>
#include <PROCESS.H>
#include <STRING.H>
void main(int,char**, char**);


void main(int argc, char **argv, char **envp)
{
    char *pcMarker;                 /* pointer to end of makefile name  */

/*  Point to the beginning of the filename argument.  If it contains a dot,
 *  traverse to the dot, and replace it with a null.  Don't do this
 *  truncation if the filename has no dot in it - it might be a makefile.
 */
    pcMarker = argv[2];
    if( strchr( argv[2], '.' ))
    {
        while( *(++pcMarker) != '.' )      /* traverse filename to dot  */
            ;
        *pcMarker = '\0';           /* truncate filename extension      */
    }

/*  Execute MAKE with a list of arguments:  argv[0] and argv[1].  Also
 *  pass along the environment from here, so MAKE has access to PATH for
 *  running the various compiler executables and the linker.
 */
    execle( argv[1], argv[1], argv[2], NULL, envp );
}


