/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                Filename : LISTICON.C                                    *
 *                 Version : 1.1                                           *
 *                 Project : Windows 3.0 Icons                             *
 *                  Author : Philippe Rabergeau                            *
 *                Modifier : Karen S. Lance                                *
 *               Copyright : (C) 1990 by Philippe Rabergeau                *
 *                Compiler : Borland Turbo C Version 2.0                   *
 *           Creation date : 07/18/90                                      *
 *       Modification date : 08/24/90                                      *
 *                           11/11/90                                      *
 *             Description : List Windows 3.0 icons                        *
 *                Comments : Not for Commercial Use                        *
 *                                                                         *
 * Please inform the author of any development in association              *
 * with this source code. You are authorized to use this source code       *
 * ONLY if you send me your collection of original WINDOWS 3.0 icons!      *
 *                                                                         *
 *=========================================================================*
 * WARNING: Memory model must be LARGE                                     *
 *=========================================================================*
 * This source code is not very clean, if I received a lot of support      *
 * I promise to clean up the code and add more stuff.                       *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <conio.h>
#include <dir.h>
#include <mem.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

#define  ICON_MAX              2048
#define  begin  {
#define  end    }
#define  False  0
#define  True   1

typedef struct
   begin
   char name[13];
   end
icon_struct;

icon_struct icon[ICON_MAX];
int         icon_total;

int  opt_video;
char opt_str[64];
char current_path[64];
char new_path[64];

int  icon_nb_screen[3]  = {55,39,89};
int  icon_nb_width[3]   = {8,8,10};
char icon_videomode[3]  = {0x12,0x10,0x54};
char icon_videowidth[3] = {80,80,100};

unsigned char vga_row = 1;
unsigned char vga_col = 0;

char far *vga_font;

unsigned char palette_icon[17]= {0x00,0x04,0x02,0x06,0x01,0x05,0x03,0x38,
                                 0x07,0x24,0x12,0x36,0x09,0x2D,0x1B,0x3F,0x00};
unsigned char bufico[512];

int rowico  = 0;
int colico  = 0;
int icon_nb = 0;

unsigned char vgaplane[4] = {0x01,0x02,0x04,0x08};

/*---------------------------------------------------------------------*/
void vga_clrscr(int type)
begin
   unsigned int c,nb;
   int byte;

   if (type==2)
       begin
       nb = 60000u;
       for (c=0; c<4; c++)
           begin
           disable();
           outportb(*(unsigned far *)MK_FP(0xC000, 0x10), 0xB2);
           byte = (inportb(*(unsigned far *)MK_FP(0xC000, 0x10) + 1) & 0xE1)
                  | (c << 1);
           outport(*(unsigned far *)MK_FP(0xC000, 0x10), (byte << 8) | 0xB2);
           enable();
           outportb(0x3C4,2);
           outportb(0x3C5,vgaplane[c]);
           setmem(MK_FP(0xA000,0),nb, 0xFF);
           end
       end
   else
       begin
       if (type == 0)
           nb = 38400u;
       else
           nb = 28000;
       outportb ( 0x3C4, 2 );
       outportb ( 0x3C5, 0x0F);
       setmem (MK_FP(0xA000,0),nb, 0xFF);
       end
   end

/*---------------------------------------------------------------------*/
void vga_putico(void)
begin
   unsigned char ScreenByte;
   int i, j,m, k,c,r;
   unsigned int Offset, Bit,val;
   int byte;

   rowico = ((icon_nb/icon_nb_width[opt_video])*64)+16;
   colico = (((icon_nb%icon_nb_width[opt_video]))*10)+5;
   for (c=0; c<4; c++)
       begin
       if (opt_video == 2)
           begin
           disable();
           outportb(*(unsigned far *)MK_FP(0xC000, 0x10), 0xB2);
           byte = (inportb(*(unsigned far *)MK_FP(0xC000, 0x10) + 1) & 0xE1)
                  | (c << 1);
           outport(*(unsigned far *)MK_FP(0xC000, 0x10), (byte << 8) | 0xB2);
           enable();
           end
       outportb(0x3C4,2);
       outportb(0x3C5,vgaplane[c]);
       r = rowico;
       k = 511;
       for (m=0; m<32; m++)
           begin
           Offset = (r*icon_videowidth[opt_video])+colico;
           for (i=0; i<4; i++)
               begin
               ScreenByte=0;
               Bit = 0x01;
               for (j=0; j<4; j++)
                   begin
                   val = (unsigned int)(bufico[k] & 0x0F);
                   if ((val&vgaplane[c]) != 0)
                      ScreenByte |= Bit;
                   Bit <<= 1;
                   val = (unsigned int)(bufico[k] >> 4) & 0x0F;
                   if ((val&vgaplane[c]) != 0)
                      ScreenByte |= Bit;
                   Bit <<= 1;
                   k--;
                   end
              pokeb(0xA000,Offset--,ScreenByte);
           end
           r++;
       end
   end
end

/*---------------------------------------------------------------------*/
void palette_set(unsigned char *s)
   begin
   struct SREGS sregs;
   union REGS regs;

   regs.x.ax = 0x1002;
   regs.x.dx = FP_OFF(s);
   sregs.es  = FP_SEG(s);
   int86x(0x10,&regs,&regs,&sregs);
   end

/*---------------------------------------------------------------------*/
void vga_font_load(void)
   begin
   struct REGPACK preg;

   preg.r_ax = 0x1130;
   preg.r_bx = 0x0300;
   intr(0x10,&preg);
   vga_font = MK_FP(preg.r_es,preg.r_bp);
   end

/*---------------------------------------------------------------------*/
void vga_putchar(unsigned char buff)
   begin
   int i;
   char far *base;
   char far *set;
   int byte,c=0x01;

   if (opt_video==2)
       begin
       disable();
       outportb(*(unsigned far *)MK_FP(0xC000, 0x10), 0xB2);
       byte = (inportb(*(unsigned far *)MK_FP(0xC000, 0x10) + 1) & 0xE1)
              | (c << 1);
       outport(*(unsigned far *)MK_FP(0xC000, 0x10), (byte << 8) | 0xB2);
       enable();
       end
   outportb(0x03C4,0x02);
   outportb(0x03C5,0x0F);
   base = MK_FP(0xA000,(vga_row*8*icon_videowidth[opt_video])+vga_col);
   set  = (char far *)(vga_font+(buff*8));
   for ( i = 0; i <8; i++ )
       begin
       *base = ~*set;
       base += icon_videowidth[opt_video];
       set++;
       end
   ++vga_col;
   end

/*---------------------------------------------------------------------*/
void vga_putstr(char *st)
begin
   int i;

   vga_col = 1+((icon_nb%icon_nb_width[opt_video])*10);
   vga_row = 7+((icon_nb/icon_nb_width[opt_video])*8);
   for (i=0; st[i]!=0; i++)
       vga_putchar(st[i]);
end

/*---------------------------------------------------------------------*/
void strcenter(char *s,int nb)
begin
   char st[100];
   int i,n;

   n = strlen(s);
   n = (nb - n) / 2;
   for (i=0; i<n; i++)
       st[i] = ' ';
   st[i] = 0;
   strcat(st, s);
   strcpy(s, st);
end

/*---------------------------------------------------------------------*/
int listico(char *fname)
begin
   int fp;
   char filespec[64];
   char filename[9];

   strcpy(filespec, fname);
   fp = open(filespec, O_RDONLY|O_BINARY);
   lseek(fp, 126L, SEEK_SET);
   read(fp, bufico, 512);
   close(fp);
   vga_putico();
   strncpy (filename, fname, strlen(fname)-4);
   filename[strlen(fname)-4] = 0;
   strcenter(filename, 8);
   vga_putstr(filename);
   return(1);
end

/*---------------------------------------------------------------------*/
int get_screenmode(void)
begin
   union REGS regs;

   regs.h.al = 0;
   regs.h.ah = 15;
   int86(0x10,&regs,&regs);
   return(regs.h.al & 0x7f);
end

/*---------------------------------------------------------------------*/
void set_screenmode(int mode)
begin
   union REGS regs;

   regs.h.al = mode;
   regs.h.ah = 0;
   int86(0x10,&regs,&regs);
end

/*---------------------------------------------------------------------*/
int dir_ico(void)
begin
   int done;
   struct ffblk ffblk;

   icon_total = 0;
   done = findfirst(opt_str, &ffblk, FA_ARCH);
   if (done < 0)
       return(0);
   while (!done)
       begin
       strcpy(icon[icon_total++].name, ffblk.ff_name);
       done = findnext(&ffblk);
       end
   qsort((char *)icon, icon_total, sizeof(icon_struct), strcmp);
   return(1);
end

/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/

void main(int argc,char *argv[])
begin
int ch,i,lastmode = 0;

   opt_video  = False;
   opt_str[0] = 0;
 
   for (i=1; i<argc; i++)
       begin
       if ((argv[i][0]=='/') || (argv[i][0]=='-') || (argv[i][0]=='?'))
           begin
           if (toupper(argv[i][1]) == 'E')
               opt_video = 1;
           else 
           if (toupper(argv[i][1]) == 'S')
               opt_video = 2;
           else
               begin
               printf(" Usage:  LISTICO [option] filename\n\n");
               printf(" Option:  /E .... EGA  640x350x16\n");
               printf("          /S .... SVGA 800x600x16 (ATI Wonder only)\n");
               printf(" When the icons are displayed:\n");
               printf("    press <ESC> to quit before the program's done\n");
               printf("    press any other key to see the next screen\n");
               exit(0);
               end
           end
       else
      begin
      strcpy(opt_str, argv[i]);
           if  (opt_str[0] == 0)
               opt_str[0] = '*';
      else
      if  (opt_str[strlen(opt_str)-1] == '\\')
          strcat(opt_str, "*");
           if  (strchr(argv[i], '.') == NULL)
               begin
               if  (strchr(opt_str, '*') == NULL)
                   if  (strlen(opt_str) > 2)
                        strcat(opt_str, "\\*");
                   else
                        strcat(opt_str, "*");
               strcat(opt_str,".ICO");
               end
           end
       end

   getcwd (current_path, 64);
   if  (strchr(opt_str, '\\') != NULL)
       begin
       for (i=63; opt_str[i]!='\\'; i--);
           strncpy(new_path, opt_str, i);
       chdir(new_path);
       end
   if  (opt_str[1] == ':')
       setdisk(toupper(opt_str[0])-'A');

   if (dir_ico() == 0)
       printf("No matching Windows 3.0 ICON files\n");
   else
       begin
       lastmode = get_screenmode();
       set_screenmode (icon_videomode[opt_video]);
       palette_set (palette_icon);
       vga_clrscr (opt_video);
       vga_font_load();
       icon_nb = 0;
       for (i=0; (i < icon_total); i++)
           begin
           listico(icon[i].name);
           icon_nb++;
           if (icon_nb > icon_nb_screen[opt_video])
              begin
              ch = getch();
              if (ch == 0x1B)
                 break;
              vga_clrscr(opt_video);
              icon_nb = 0;
              end
           end
       if  (ch != 0x1B)
           ch = getch();
       set_screenmode(lastmode);
       printf("\nK. S. Lance thanks Philippe Rabergeau for LISTICO 1.0");
       printf("\n        and thanks you for using LISTICON 1.1! \n");
       end
   setdisk(toupper(current_path[0])-'A');
   chdir (current_path);
   exit(0);
end
