/*   RayLathe (c) Koehler
   - Thick <0 = draw solid, =0 = move, >0 = draw hollow
   Revision History:
   03-24-93 1.0 KJK  New. Inspired by uLathe.
*/

#include <math.h>
#include <stdio.h>

#define min(a,b) (a<b ? a : b)
#define max(a,b) (a>b ? a : b)

#define VERSION 1.00

double intercept(double, double, double, double);
void  lathe_cut(double, double, double, double, double);

void main()
   {
   double oldx = 0.01, oldy = 0.01;
   double x, y, thick;
   double boundminx=10000000, boundmaxx=-10000000, boundmaxy=0;
   double length, center, eye_distance;

   fprintf(stderr,"RayLathe v%2.2f (c) 1993 Koehler\n",VERSION);
   printf("// POVRAY 1.0 object created by RayLathe v%2.2f (c) 1993 Koehler\n",VERSION);
   printf("// See suggested camera vectors at end of this file\n\n");
   printf("#declare LatheWork =\n");
   printf("   composite\n");
   printf("      {\n");
   scanf("%lf %lf %lf", &x, &y, &thick);
   do
       {
       if ((thick)  && (x != oldx))
	   lathe_cut(oldx, oldy, x, y, thick);
       boundmaxx = max(boundmaxx, x);
       boundminx = min(boundminx, x);
       boundmaxy = max(boundmaxy, y);
       oldx = x;
       oldy = y;
       scanf("%lf %lf %lf", &x, &y, &thick);
       }
   while (y >= 0);
   printf("      bounded_by\n");
   printf("         {\n");
   printf("         box {<%f %f %f>  <%f %f %f> }\n",boundminx,-boundmaxy,-boundmaxy, boundmaxx, boundmaxy, boundmaxy);
   printf("         }\n");
   printf("      }\n");
   length = boundmaxx - boundminx;
   center = length / 2 + boundminx;
   printf("\n#declare Look_At = <%f 0 0>   // Center of object\n", center);
   eye_distance = -max(fabs(length), boundmaxy*2.4);
   printf("#declare Location = <%f 0 %f>    // Good camera position\n", center, eye_distance);
   }

void lathe_cut(x1, y1, x2, y2, thick)
   double x1, y1, x2, y2, thick;
   {
   double minx, miny, minz, maxx, maxy, maxz, origin;

   minx = min(x1,x2)*1.001;
   maxx = max(x1,x2)*1.001;
   maxy = max(y1,y2)*1.001;
   miny = -maxy;
   maxz = maxy;
   minz = miny;
   printf("      object       // (%lf, %lf, %lf)\n", x2, y2, thick);
   printf("         {\n");
   printf("         intersection\n");
   printf("            {\n");
   if (y1 == y2)
       {
       if (y1 > 0)
	   {
	   printf("            quadric {Cylinder_X  ");
	   printf("scale <1 %f %f> }\n", y1, y1);
	   }
       }
   else
       {
       if ((x1 == 0) || (x2 == 0))
	   origin = 0;
       else
	   origin=intercept(x1, y1, x2, y2);
       printf("            quadric {QCone_X  ");
       if (x1 == 0)
	   printf("scale <%f %f %f>  ", fabs(origin-x2), y2, y2);
       else
	   printf("scale <%f %f %f>  ", fabs(origin-x1), y1, y1);
       printf("translate <%f 0 0> }\n", origin);
       }
   if ((thick >= 0) && (((y1-thick)>0) || ((y2-thick)>0)))
       {
       if (y1 == y2)
	   {
	   if ((y1-thick) > 0)
	       {
	       printf("            quadric {Cylinder_X  ");
	       printf("scale <1 %f %f> inverse }\n", y1-thick, y1-thick);
	       }
	   }
       else
	   {
	   if ((x1 == 0) || (x2 == 0))
	       origin = 0;
	   else
	       origin = (((y1-thick)/y1)*(origin-x1))+x1;
	   printf("            quadric {QCone_X  ");
	   if ((origin-x1) == 0)
	       printf("scale <%f %f %f>  ", fabs(origin-x2), y2-thick, y2-thick);
	   else
	       printf("scale <%f %f %f>  ", fabs(origin-x1), y1-thick, y1-thick);
	   printf("translate <%f 0 0> inverse }\n", origin);
	   }
       }
   printf("            box {<%f %f %f>  <%f %f %f> }\n",minx,miny,minz,maxx,maxy,maxz);
   printf("            }\n");
   printf("         bounded_by\n");
   printf("            { box {<%f %f %f>  <%f %f %f> } }\n",minx,miny,minz,maxx,maxy,maxz);
   printf("         texture { LatheWorkTex }\n");
   printf("         }\n");
   }

double intercept(x1, y1, x2, y2)
   double x1, y1, x2, y2;
   {
   double result;
   return(x2 - ((x2-x1) / (y2-y1) * y2));
   }
