PROGRAM ed3d;

{-----------------------------------------------------------------------}
{ Koerpereditor, Frank Menzel, Nov. 1994 }
{ Vers. 2.0 }
{-----------------------------------------------------------------------}

USES oop3d,shapes,graph,oopdraw,graphwc,crt,dos,objects;

TYPE  showmeth=(wire,hide,sol,fla,gour,pho);	  {Darstellungsarten}

CONST lengthgad:integer=500;highgad:integer=16;	  {Laenge/Hoehe Gadgets}
      ydist=18;                                   {highgad+2}
      graygadget=16*lightgray+8;                  {Gadgetfarbe}
      graywindows=16*lightgray;                   {Farbe der Windows}
      lightcol=lightgray;darkcol=darkgray;        {Randfarben der Gadgets}
      ph3d:REAL=-45;th3d:REAL=45;dist3d:REAL=3000;{Betrachter in 3DView}
      lph3d:REAL=-10;lth3d:REAL=35;ldist:REAL=10000;{Licht in 3DView}
      longitude:REAL=-45;latitude:REAL=45;        {Betrachterpos.}
      covis:BOOLEAN=FALSE;livis:BOOLEAN=FALSE;    {Flags Coordsyst./Licht}
      shm:showmeth=hide;                          {Modus Hide fuer Darst.}
      copn=19;ended=100;                          {PN Coordsyst./Endgadget}
      gx1=0;gy1=98;gx2=668;gy2=599;               {Grenzen Grafikfenster}
      bx1=gx2+1;by1=20;bx2=799;by2=gy2;           {Grenzen Buttonfenster}
      start=275;                                  {Abstaende 3D-Butons}
      rox:REAL=0;roy:REAL=0;roz:REAL=10;          {Offsetwinkel fuer Obj.-rot.}
      clong:REAL=0;clat:REAL=0;                   {Offsetwinkel fuer Camera}
      llx:REAL=0;lly:REAL=0;llz:REAL=0;           {Offsetwinkel Lichtquellen}
      dist:REAL=3000;                             {Abstand Betrachter}
      delayanim:INTEGER=0;                        {Wartezeit bei Animate}
      lc:INTEGER=black;                           {Linienfarbe}

(*$I _Button.INC *)                               {_Button.inc einbinden}

VAR screen1,screen2,screen3,scrback:device;	  {versch. Screens}
    wo:world;
    xl,yl,zl,l,mxw,myw:REAL;
    inpint1:ininteger;inp1,inp2,inp3,inp4:inreal;
    tw1:textwindow;
    pbo:pbox;pcu:pwuerfel;ptet:ptetraeder;poct:poktaeder;pdod:pdodekaeder;
    pico:pikosaeder;pxpln:pplanex;pypln:pplaney;pzpln:pplanez;
    ppyrst:ppyrstumpf;pcyl:pzylinder;ppyr:ppyramide;pcone:pkegel;
    pd:pdisc;psph:psphere;ptor:ptorus;co:coordsystem;
    btn,xd,yd,pn,oldcol: INTEGER;
    pbodshape:plshape;
    shapeobjects:pcollection;	{Koerper hier gespeichert}
    item:INTEGER;               {verweist auf akt.Obj.in ShapeObjects}
    pls:plshape;                {Zeiger auf aktuelles LShape-Objekt}
    vga_pal:vgapaltype;
{------------------------------------------------------------------------}
   PROCEDURE showworld;
   VAR hp:pointer;
   BEGIN
     IF shapeobjects^.count>0 THEN BEGIN
       hp:=graphlist;graphlist:=shapeobjects;
       wo.insertall;graphlist:=hp;
     END;
     IF wo.pol^.count>0 THEN BEGIN
       if not wo.cut then wo.shadow;
       wo.zentrproj(longitude,latitude,dist);
       wo.hlhsr;wo.show;
     END;
   END;{showworld}

   PROCEDURE clearscr1(col:integer);
   BEGIN
     screen1.clearviewport;
     setcolor(col);
     rectanglewc(-getmaxx/2,-getmaxy/2,getmaxx/2,getmaxy/2);
     setcolor(white);
   END;

function dat_request(tail:string;var dat:string;clear:boolean):boolean;
var gl:gadlist;                         {Liste Buttons}
    dx_s,prgad,j,i:integer;
    ly,count,file_pos,f_count:integer;
    gefunden:word;                      {Anzahl gefundener Files}
    f_name:string;                      {ausgewhltes File}
    scale_o,scale_u:real;               {Skalierungsfaktoren Balken}
    katalog:searchrec;                  {Verzeichnis der Eintrge}
    file_ok:boolean;                    {Kennzeichen, ob File OK}
    wincount,lastpage:integer;          {ausgewhltes/letztes Fenster}

const length=75;high=140;               {Breite, Hhe Filefenster}
      xa=0;ya=0;                        {Mittelpunkt  Filefenster}
      length_b=23;                      {Breite Balkenfenster}
      l=17;h=17;                        {Laenge/Hoehe OK/CANCEL-Button}
      xc1=xa-length;yc1=ya-high;        {Ecke unten links}
      xc2=xa+length;yc2=ya+high;        {Ecke oben rechts}
      iy=yc2-18;dl=15;step=15;lb=84.5;
      offs=4;hc=15;
      last=18;                          {Anzahl max.Files in Filefenster}
      h_bar=237;l_bar=length_b-2;       {max.Hoehe/Breite des Balkens}
      xs_bar=xc2+1;ys_bar=yc2-22;       {Pos.Balken oben links}

procedure rect_pos(xs,ys,l,h:real;col:integer);
begin
  setfillstyle(solidfill,col);setcolor(col);
  rectanglewc(xs,ys,xs+l,ys-h);
  floodfill(xs+2,ys-2,col);
end;

procedure rect_show;
begin
  setfillstyle(solidfill,black);
  rectanglewc(xc1,yc1,xc2+length_b,yc2); {floodfill(xc1+5,yc1+5,white);}
  linewc(xc2,yc1,xc2,yc2);
  rect_pos(xs_bar,ys_bar,l_bar,h_bar,black);
end;

procedure choice_show(i:integer);
begin
  setcolor(lightgray);
  rectanglewc(xc1+1,yc2-offs-((i-1)*hc),xc2-1,yc2-offs-i*hc);
end;

procedure choice_hide(i:integer);
begin
  setcolor(black);
  rectanglewc(xc1+1,yc2-offs-((i-1)*hc),xc2-1,yc2-offs-i*hc);
end;

function choice_file(mouse_x,mouse_y:real):integer;
var ret,ys,i:integer;
begin
  ret:=-1;ys:=yc2-offs;i:=1;
  if ((mouse_x>=xc1+1)and(mouse_x<=xc2-1))and
     ((mouse_y<=ys)and (mouse_y>=yc1+6))then begin
  ret:=1;
  while (mouse_y>=yc1) and (mouse_y<(yc2-offs-((i-1)*hc))) do begin
    ret:=i;inc(i);
  end;
  end;
  choice_file:=ret;
end;

procedure files(file_pos:integer);
begin
  rect_show;
  gefunden:=0;count:=0;ly:=iy;i:=1;
  f_name:='';
  findfirst(f_name+'*'+tail,archive,katalog);
  while doserror=0 do begin
    inc(gefunden);inc(i);
    if (gefunden>=file_pos) and (gefunden<last+file_pos) then begin
      setcolor(white);outtextxywc(xc1+dl,ly,katalog.name);
    end;
    findnext(katalog);
    if i>file_pos then dec(ly,step);
  end;
  if gefunden=0 then message('Keine Datei gefunden',red);
end;

procedure get_file(pos:integer;var f:string);
var gefunden:integer;
begin
  gefunden:=0;
  f:='';
  findfirst(f+'*'+tail,archive,katalog);
  while (doserror=0)and(gefunden<>-1) do begin
    inc(gefunden);
    if gefunden=pos then begin f:=katalog.name;gefunden:=-1;end
    else findnext(katalog);
  end;
end;

begin
  if clear then clearscr1(white);
  setcolor(white);
  file_pos:=1;j:=1;file_ok:=false;wincount:=0;
  rect_show;
  gl.init(graygadget);
  dx_s:=dx;dx:=1;
  gl.newgadget(xc2+dx+3,yc2-h-dy-2,l,h,'',1);
  gl.newgadget(xc2+dx+3,yc1+dy+1,l,h,'',2);
  gl.newgadget(xc1+dx,yc1-h-3,lb,h,'   OK',3);
  gl.newgadget(xc1+dx+2*dx+lb+1,yc1-h-3,lb,h,' CANCEL',ended);
  dx:=dx_s;
  setcolor(white);
  initlocator(xc1+lb/2,yc1-h/2,gl.lcol,echooff);
  files(file_pos);
  lastpage:=gefunden div last ;
  if gefunden<=last then scale_u:=1 else scale_u:=1/(gefunden/last);
  scale_o:=h_bar*scale_u;              {Balkenhoehe berechnen}
  gl.x:=xc1+lb/2;gl.y:=yc1-h/2;
with gl do
 repeat
  gl.show;choice_show(j);
  if wincount<lastpage then begin       {Balken darstellen}
    rect_pos(xs_bar,ys_bar-wincount*scale_o,l_bar,scale_o,darkgray)
  end else
    rect_pos(xs_bar,ys_bar-h_bar+scale_o,l_bar,scale_o,darkgray);
  screen1.activateviewport;
  initlocator(x,y,lcol,echooff);
  locator(x,y);
  i:=choice_file(x,y);
  if (i<>-1)then
    begin
      if wincount<lastpage then begin choice_hide(j);j:=i;choice_show(i)end
      else if i<=gefunden mod last then begin
        choice_hide(j);j:=i;choice_show(i);end
    end else begin
  prgad:=pressedanygadget;
  case prgad of
    1:begin if wincount>0 then begin {naechsten Files}
              dec(wincount);j:=1;
             end;
        if clear then clearscr1(white) else clearscr1(black);
        if file_pos>1 then dec(file_pos,last);files(file_pos);
      end;
    2:begin if wincount<lastpage then  {vorige Files}
             begin inc(wincount);j:=1;
             end;
       if clear then clearscr1(white) else clearscr1(black);
       if gefunden-file_pos>last then inc(file_pos,18);files(file_pos);
      end;
    3:begin {OK}
       if clear then clearscr1(white);prgad:=ended;
       f_count:=wincount*last+j;
       get_file(f_count,dat);
       file_ok:=true;
      end;
    ended:begin  {CANCEL}
        file_ok:=false;
      end;
  end;
 end;
 until prgad=ended;
  gl.done;if clear then clearscr1(white);
  graphlist^.deleteall;
  dat_request:=file_ok;
end;


   PROCEDURE changeproj(prph,prth:REAL);
   BEGIN
     longitude:=prph;latitude:=prth;dist:=dist3d;
     wo.setlsource(lph3d,lth3d,ldist);
   END;

   PROCEDURE sel;
   BEGIN
     IF shapeobjects^.count>0 THEN BEGIN
       inc(item);
       pls^.lattr(oldcol,0,1);pls^.show;
       IF item>shapeobjects^.count THEN item:=1;
       pls:=shapeobjects^.at(item-1);oldcol:=pls^.lcolor;
     END;
   END;

   PROCEDURE new_all;
   VAR i,count:INTEGER;
   BEGIN
     shapeobjects^.freeall;
     wo.deleteall;clearscr1(white);
     count:=wo.plight_source^.count;
     IF count>1 THEN
       FOR i:=1 TO count-1 do wo.plight_source^.atfree(1);
   END;

   PROCEDURE winxform;
   VAR prgad:INTEGER;

   PROCEDURE scale;
   VAR sx,sy,sz:REAL;
    BEGIN
     IF pls<>NIL THEN BEGIN
      tw1.initcentered(22,8,green);
      tw1.show;
      tw1.gotoxy(7,1);
      tw1.wrstr('Skalierung');
      sx:=1;sy:=1;sz:=1;
      tw1.gotoxy(2,4);              tw1.wrstr('XScal: xs = ');
      tw1.gotoxy(2,5);              tw1.wrstr('YScal: ys = ');
      tw1.gotoxy(2,6);              tw1.wrstr('ZScal: zs = ');
      inp1.init(45,25,5,green,sx);  inp2.init(45,26,5,green,sy);
      inp3.init(45,27,5,green,sz);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;tw1.done;
      pls^.zentrproj(longitude,latitude,dist);
      pls^.scal(sx,sy,sz);clearscr1(white);
      showworld;
     END;
    END;{scale}

    PROCEDURE rot;
    VAR wx,wy,wz:REAL;
    BEGIN
     IF pls<>NIL THEN BEGIN
      tw1.initcentered(22,8,green);
      tw1.show;
      tw1.gotoxy(7,1);
      tw1.wrstr('Rotation');
      wx:=0;wy:=0;wz:=0;
      tw1.gotoxy(2,4);              tw1.wrstr('XRot: wx = ');
      tw1.gotoxy(2,5);              tw1.wrstr('YRot: wy = ');
      tw1.gotoxy(2,6);              tw1.wrstr('ZRot: wz = ');
      inp1.init(45,25,5,green,wx);  inp2.init(45,26,5,green,wy);
      inp3.init(45,27,5,green,wz);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;tw1.done;
      pls^.zentrproj(longitude,latitude,dist);clearscr1(white);
      pls^.rot(wx,wy,wz);
      showworld;
     END;
    END;{rot}

    PROCEDURE trans;
    VAR tx,ty,tz:REAL;
    BEGIN
     IF pls<>NIL THEN BEGIN
      tw1.initcentered(22,8,green);
      tw1.show;
      tw1.gotoxy(7,1);
      tw1.wrstr('Translation');
      tx:=0;ty:=0;tz:=0;
      tw1.gotoxy(2,4);              tw1.wrstr('XTrans: tx = ');
      tw1.gotoxy(2,5);              tw1.wrstr('YTrans: ty = ');
      tw1.gotoxy(2,6);              tw1.wrstr('ZTrans: tz = ');
      inp1.init(45,25,5,green,tx);  inp2.init(45,26,5,green,ty);
      inp3.init(45,27,5,green,tz);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;tw1.done;
      pls^.zentrproj(longitude,latitude,dist);clearscr1(white);
      pls^.trans(tx,ty,tz);
      showworld;
     END;
    END;{trans}

   BEGIN
     clearscr1(white);
     showworld;IF covis THEN co.show;
     screen2.clearviewport;
     glxf.show;glview.show;
     item:=shapeobjects^.count;
     IF item>0 THEN pls:=shapeobjects^.at(item-1) ELSE pls:=NIL;
     WITH glxf DO
     REPEAT
       IF pls<>NIL THEN BEGIN
         pls^.zentrproj(longitude,latitude,dist);
         screen1.activateviewport;
         oldcol:=pls^.lcolor;
         pls^.lattr(lightred,0,1);pls^.hlhsr;pls^.show;
         pls^.lattr(oldcol,0,1);
       END;
       screen2.activateviewport;
       initlocator(glxf.x,glxf.y,lcol,echooff);
       locator(x,y);
       prgad:=pressedanygadget;
       IF prgad=-1 THEN BEGIN
         glview.x:=glxf.x;glview.y:=glxf.y;
         prgad:=glview.pressedanygadget;
      END;
       screen1.activateviewport;
       CASE prgad OF
{Scal}      1: scale;
{Rot}       2: rot;
{Trans}     3: trans;
{Select}    4: sel;
{csyst}     5: BEGIN covis:=NOT(covis);
                IF NOT covis THEN BEGIN clearscr1(white);showworld;END;
               END;
           20: BEGIN clearscr1(white);changeproj(ph3d,th3d);END;
{YXView}   21: BEGIN clearscr1(white);changeproj(-90,0);END;
{ZXView}   22: BEGIN clearscr1(white);changeproj(-90,90);END;
{ZYView}   23: BEGIN clearscr1(white);changeproj(0,90);END;
      END;
       IF (prgad>=20)AND(prgad<=23) THEN showworld;
       IF (covis) AND (prgad<>ended)THEN BEGIN
         co.zentrproj(longitude,latitude,dist);
         co.show;
       END;
     UNTIL prgad=ended;
     screen2.clearviewport;
    END;{winxform}

   PROCEDURE winedit;
   VAR prgad:INTEGER;k:INTEGER;
       cols_active:BOOLEAN;
   CONST startx=-400;starty=0;
         lx=50;ly=10;

   PROCEDURE del;
   BEGIN
     IF pls<>NIL THEN BEGIN
       pls^.zentrproj(longitude,latitude,dist);
       pls^.hide;
       k:=shapeobjects^.indexof(pls);
       shapeobjects^.atfree(k);wo.deleteall;
       showworld;
       IF shapeobjects^.count>0 THEN BEGIN
         pls:=shapeobjects^.at(shapeobjects^.count-1);
         item:=shapeobjects^.indexof(pls)+1;
         if item>shapeobjects^.count-1 then item:=0;
       END ELSE pls:=NIL;
     END;
   END;

   PROCEDURE tri;
   BEGIN
     IF pls<>NIL THEN BEGIN
       pls^.zentrproj(longitude,latitude,dist);
       pls^.hide;
       pls^.triang;showworld;
     END;
   END;

   PROCEDURE inpropertys;
   VAR polnr,fcol,fsty:INTEGER;
       inp1,inp2,inp3,inp4:ininteger;pf:plfacet;
     PROCEDURE prop_all(pf:plfacet);far;
     BEGIN
       pf^.polnumber:=polnr;
     END;

    BEGIN
      IF pls<>NIL THEN BEGIN
        pf:=pls^.pol^.at(0);polnr:=pf^.polnumber;
        fcol:=pf^.groundcolor;fsty:=pf^.fstyle;
        lc:=pls^.lcolor;
        tw1.initcentered(26,10,green);
        tw1.show;
        tw1.gotoxy(7,1);
        tw1.wrstr('Eigenschaften');
        tw1.gotoxy(5,4);              tw1.wrstr('pn     = ');
        tw1.gotoxy(5,5);              tw1.wrstr('FColor = ');
        tw1.gotoxy(5,6);              tw1.wrstr('FStyle = ');
        tw1.gotoxy(5,7);              tw1.wrstr('LColor = ');
        inp1.init(44,24,5,green,polnr);  inp2.init(44,25,5,green,fcol);
        inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);
        inp3.init(44,26,5,green,fsty);inp3.setframe(1,FALSE);
        inp4.init(44,27,5,green,lc);inp4.setframe(1,FALSE);
        inp1.show;inp2.show;inp3.show;inp4.show;
        inp1.run;inp2.run;inp3.run;inp4.run;
        pls^.fattr(fcol,fsty);pls^.lattr(lc,0,1);
        pls^.pol^.foreach(@prop_all);
        graphlist^.deleteall;
        inp1.done;inp2.done;inp3.done;tw1.done;
      END;
    END;{inpropertys}

    PROCEDURE cols;
    VAR ix,iy,ilx,ily,lc,c:INTEGER;
        posx,posy:INTEGER;
    BEGIN
     cols_active:=NOT(cols_active);
     IF cols_active THEN BEGIN
      screen2.activateviewport;
      posx:=startx;posy:=starty;
      FOR iy:=0 TO 15 DO BEGIN
       lc:=iy*16;
       FOR ily:=1 TO ly DO BEGIN
        posx:=startx;c:=lc;
        FOR ix:=0 TO 15 DO BEGIN
         setcolor(c);
         linewc(posx+1,posy,posx+lx-1,posy);
         posx:=posx+lx;inc(c);
        END;
        dec(posy);
       END;
      END;
      screen1.activateviewport;
     END ELSE BEGIN
      screen2.clearviewport;gled.show;
     END;
    END;

   PROCEDURE check_cols(x,y:REAL);
   VAR endx,endy,posx,posy:REAL;i,k,c:INTEGER;pf:plfacet;
     FUNCTION in_area(startx,starty,endx,endy:REAL):BOOLEAN;
     BEGIN
       in_area:=((x>=startx)AND(x<=endx))AND
                      ((y<=starty)AND(y>=endy));
     END;
   BEGIN
     IF in_area(startx,starty,startx+16*lx,starty-16*ly)
     THEN BEGIN
       c:=-1;i:=0;k:=0;posx:=startx;posy:=starty;
       REPEAT
         IF in_area(posx,posy,posx+lx,posy-ly) THEN c:=i;
         inc(i);
         inc(k);k:=k MOD 16;
         posx:=posx+lx;
         IF k=0 THEN BEGIN posy:=posy-ly;posx:=startx;END;
       UNTIL (i=256)OR(c<>-1);
       IF c<>-1 THEN
        IF pls<>NIL THEN BEGIN
         pf:=pls^.pol^.at(0);
         IF (shm<>wire)AND(shm<>hide) THEN pls^.fattr(c,pf^.fstyle)
           ELSE begin lc:=c;pls^.lattr(lc,0,1);end;
         message('Objektfarbe gesetzt !',lightblue);delay(400);
         message('',black);
        END;
     END;
   END;{check_cols}

   BEGIN
     clearscr1(white);showworld;cols_active:=FALSE;
     screen2.clearviewport;
     gled.show;
     item:=shapeobjects^.count;
     IF item>0 THEN pls:=shapeobjects^.at(item-1) ELSE pls:=NIL;
     WITH gled DO
     REPEAT
       IF pls<>NIL THEN BEGIN
         pls^.zentrproj(longitude,latitude,dist);
         screen1.activateviewport;
         oldcol:=pls^.lcolor;
         pls^.lattr(lightred,0,1);pls^.hlhsr;pls^.show;
         pls^.lattr(oldcol,0,1);
       END;
       screen2.activateviewport;
       initlocator(gled.x,gled.y,lcol,echooff);
       locator(x,y);
       prgad:=pressedanygadget;
       IF (prgad=-1)AND(cols_active) THEN check_cols(x,y);
       screen1.activateviewport;
       CASE prgad OF
{Select}    1: sel;
{Delete}    2: del;
{Triang}    3: tri;
{Form}     4: BEGIN winxform;gled.show;END;
{Prop.}     5: inpropertys;
{Colors}    6: cols;
{Invert}    7: IF pls<>NIL THEN BEGIN
                message('Invert ausgefuehrt !',lightblue);
                pls^.invert;delay(400);
                message('',black);
               END;
      END;
     UNTIL prgad=ended;
     screen2.clearviewport;
     screen2.activateviewport;
    END;{winedit}

    PROCEDURE winopt;
    VAR prgad:INTEGER;

    PROCEDURE inoffslight;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr(' Offsetwinkel Licht');
      tw1.gotoxy(2,4);              tw1.wrstr('x-Winkel xoff= ');
      tw1.gotoxy(2,5);              tw1.wrstr('y-Winkel yOff= ');
      tw1.gotoxy(2,6);              tw1.wrstr('z-Winkel zOff= ');
      inp1.init(48,24,5,green,llx);  inp2.init(48,25,5,green,lly);
      inp3.init(48,26,5,green,llz);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;
      tw1.done;
    END;{inoffslight}

    PROCEDURE inoffsobs;
    BEGIN
      tw1.initcentered(26,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('Offsetwinkel Betrachter');
      tw1.gotoxy(2,4);              tw1.wrstr('Longitude = ');
      tw1.gotoxy(2,6);              tw1.wrstr('Latitude  = ');
      inp1.init(44,24,5,green,clong);  inp2.init(44,26,5,green,clat);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);
      inp1.show;inp2.show;
      inp1.run;inp2.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;tw1.done;
    END;{inoffsobs}

    PROCEDURE inoffsobj;
    BEGIN
      tw1.initcentered(30,10,green);
      tw1.show;
      tw1.gotoxy(1,1);
      tw1.wrstr(' Offsetwinkel Objektrotation');
      tw1.gotoxy(6,4);              tw1.wrstr('x-Winkel xoff= ');
      tw1.gotoxy(6,5);              tw1.wrstr('y-Winkel yOff= ');
      tw1.gotoxy(6,6);              tw1.wrstr('z-Winkel zOff= ');
      inp1.init(48,24,5,green,rox);  inp2.init(48,25,5,green,roy);
      inp3.init(48,26,5,green,roz);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;tw1.done;
    END;{inoffsobj}

    PROCEDURE innewlight;
    CONST ph:REAL=0;th:REAL=20;d:REAL=2000;
          col:INTEGER=white;int:INTEGER=1;
    VAR   in4,in5:ininteger;
    BEGIN
      tw1.initcentered(30,15,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('Neue Lichtquelle definieren');
      tw1.gotoxy(6,4);              tw1.wrstr('Longitude = ');
      tw1.gotoxy(6,5);              tw1.wrstr('Latitude  = ');
      tw1.gotoxy(6,6);              tw1.wrstr('Distance  = ');
      tw1.gotoxy(6,7);              tw1.wrstr('Intensity = ');
      tw1.gotoxy(6,9);              tw1.wrstr('Color     = ');
      inp1.init(45,21,5,green,ph);  inp2.init(45,22,5,green,th);
      inp3.init(45,23,5,green,d);
      in4.init(45,24,5,green,int);  in5.init(45,26,5,green,col);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      in4.setframe(1,FALSE);in5.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show; in4.show;in5.show;
      inp1.run;inp2.run;inp3.run;in4.run;in5.run;
      wo.addlsource(ph,th,d,int,col);
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;in4.done;in5.done;tw1.done;
    END;{innewlight}


    PROCEDURE indist;
    BEGIN
      tw1.initcentered(26,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('Abstaende vom Nullpunkt');
      tw1.gotoxy(4,4);tw1.wrstr('Betrachter  = ');
      tw1.gotoxy(4,6);tw1.wrstr('Lichtquelle = ');
      inp1.init(47,24,5,green,dist);  inp2.init(47,26,5,green,ldist);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);
      inp1.show;inp2.show;
      inp1.run;inp2.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;tw1.done;
    END;{indist}

    PROCEDURE inmisc;
    VAR inint1,inint2:ininteger;
    BEGIN
      tw1.initcentered(34,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('Genauigkeitswert fuer PriorList');
      tw1.gotoxy(6,2);
      tw1.wrstr('Wartezeit fuer Animate');
      tw1.gotoxy(6,5);tw1.wrstr('RekDepth  = ');
      tw1.gotoxy(6,7);tw1.wrstr('DelayTime = ');
      inint1.init(44,25,5,green,maxrekdepth);
      inint2.init(44,27,5,green,delayanim);
      inint1.setframe(1,FALSE);inint2.setframe(1,FALSE);
      inint1.show;inint2.show;
      inint1.run;inint2.run;
      graphlist^.deleteall;
      inint1.done;inint2.done;tw1.done;
    END;{inmisc}

    PROCEDURE inshading;
    VAR in1:inreal;in2:ininteger;
    BEGIN
      tw1.initcentered(26,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('Umgebungslicht/Reflexion');
      tw1.gotoxy(2,4);              tw1.wrstr('Umg.-Licht (0-1) = ');
      tw1.gotoxy(2,5);              tw1.wrstr('Reflexion  (0-1) = ');
      tw1.gotoxy(2,6);              tw1.wrstr('Spiegelung (0-1) = ');
      tw1.gotoxy(2,7);              tw1.wrstr('Glanz      (0-15)= ');
      inp1.init(49,24,5,green,wo.pmatprop^.amb);
      inp2.init(49,25,5,green,wo.pmatprop^.ref);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);
      inp1.show;inp2.show;
      in1.init(49,26,5,green,wo.pmatprop^.mirr);
      in2.init(49,27,5,green,wo.pmatprop^.shine);
      in1.setframe(1,FALSE);in2.setframe(1,FALSE);
      in1.show;in2.show;inp1.run;inp2.run;in1.run;in2.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;tw1.done;
    END;{inshading}

    PROCEDURE in3dobspos;
    BEGIN
      tw1.initcentered(30,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('   Betrachterpos. 3DView');
      tw1.gotoxy(6,4);              tw1.wrstr('Longitude = ');
      tw1.gotoxy(6,5);              tw1.wrstr('Latitude  = ');
      tw1.gotoxy(6,6);              tw1.wrstr('Distance  = ');
      inp1.init(48,24,5,green,longitude);  inp2.init(48,25,5,green,latitude);
      inp3.init(48,26,5,green,dist);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      ph3d:=longitude;th3d:=latitude;dist3d:=dist;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;tw1.done;
    END;{in3dobspos}

    PROCEDURE in3dlightpos;
    BEGIN
      tw1.initcentered(30,10,green);
      tw1.show;
      tw1.gotoxy(2,1);
      tw1.wrstr('  Lichtposition bei 3DView');
      tw1.gotoxy(6,4);              tw1.wrstr('Longitude = ');
      tw1.gotoxy(6,5);              tw1.wrstr('Latitude  = ');
      tw1.gotoxy(6,6);              tw1.wrstr('Distance  = ');
      inp1.init(48,24,5,green,lph3d);  inp2.init(48,25,5,green,lth3d);
      inp3.init(48,26,5,green,ldist);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inp3.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;
      inp1.run;inp2.run;inp3.run;
      graphlist^.deleteall;
      inp1.done;inp2.done;inp3.done;tw1.done;
    END;{in3dlightpos}

    PROCEDURE switch_sh_mod;
    BEGIN
      IF wo.shmod=intmod THEN BEGIN
        wo.setshmod(rgbmod);
        message('Schattierungsart: RGB-Mode; Phong-Shading',lightblue);
      END ELSE BEGIN
        wo.setshmod(intmod);
        message('Schattierungsart: INT-Mode',lightblue);
      END;
    END;


    BEGIN
     screen2.clearviewport;
     glopt.show;
     WITH glopt DO
     REPEAT
       screen2.activateviewport;
       initlocator(x,y,lcol,echooff);
       locator(x,y);
       prgad:=pressedanygadget;
       screen1.activateviewport;
       CASE prgad OF
{ROffsLight} 1: inoffslight;
{ROffsObs}   2: inoffsobs;
{ROffsObj}   3: inoffsobj;
{Distance}   4: indist;
{3DObsPos}   5: in3dobspos;
{3DLightPos} 6: in3dlightpos;
{AddLight}   7: innewlight;
{VisLight}   8: BEGIN livis:=NOT(livis);
                 IF livis THEN message('Lichtquelle(n) sichtbar',lightblue) ELSE
                   message('Lichtquelle(n) nicht sichtbar',lightblue);
                END;
{Shading}    9: inshading;
{Misc}      10: inmisc;
{CalcCut}   11: BEGIN wo.cut:=NOT(wo.cut);
                 IF wo.cut THEN
                   message('Schnitte werden berechnet-keine Schatten',lightblue) ELSE
                 message('Schnitte werden nicht berechnet-Schatten',lightblue);
               END;
{INT-RGB}   12: switch_sh_mod;
      END;
     UNTIL prgad=ended;
     screen2.clearviewport;
     mgl.show;glview.show;
     clearscr1(white);
    END;{winopt}

    PROCEDURE inputbox;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(10,1);
      tw1.wrstr('Box');
      xl:=100;yl:=100;zl:=100;pn:=boxpn;
      tw1.gotoxy(1,4);              tw1.wrstr('XLength: xl= ');
      tw1.gotoxy(1,5);              tw1.wrstr('YLength: yl= ');
      tw1.gotoxy(1,6);              tw1.wrstr('ZLength: zl= ');
      tw1.gotoxy(1,7);              tw1.wrstr('PN:      pn= ');
      inp1.init(45,24,5,green,xl);  inp2.init(45,25,5,green,yl);
      inp3.init(45,26,5,green,zl);  inpint1.init(45,27,5,green,pn);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);       inpint1.setframe(1,FALSE);
      inp1.show;                    inp2.show;
      inp3.show;                    inpint1.show;
      inp1.run;                     inp2.run;
      inp3.run;                     inpint1.run;
      graphlist^.deleteall;
      pbo:=NEW(pbox,setto(xl,yl,zl,pn));
      inp1.done;inp2.done;inp3.done;inpint1.done;tw1.done;
    END;{inputbox}

    PROCEDURE inputcube;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(8,1);            tw1.wrstr('Wuerfel');
      l:=100;pn:=cubepn;
      tw1.gotoxy(1,4);            tw1.wrstr('Length:  l  = ');
      tw1.gotoxy(1,5);            tw1.wrstr('PN:      pn = ');
      inp1.init(45,24,5,green,l); inpint1.init(45,25,5,green,pn);
      inp1.setframe(1,FALSE);     inpint1.setframe(1,FALSE);
      inp1.show;                  inpint1.show;
      inp1.run;                   inpint1.run;
      inp1.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      pcu:=NEW(pwuerfel,setto(l,pn));
    END;{inputcube}

    PROCEDURE inputtetr;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(7,1);            tw1.wrstr('Tetraeder');
      l:=100;pn:=tetpn;
      tw1.gotoxy(1,4);            tw1.wrstr('Length:  l = ');
      tw1.gotoxy(1,5);            tw1.wrstr('PN:      pn= ');
      inp1.init(45,24,5,green,l); inpint1.init(45,25,5,green,pn);
      inp1.setframe(1,FALSE);     inpint1.setframe(1,FALSE);
      inp1.show;                  inpint1.show;
      inp1.run;                   inpint1.run;
      inp1.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      ptet:=NEW(ptetraeder,setto(l,0,0,0,pn));
    END;{inputtetr}

    PROCEDURE inputoct;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(7,1);            tw1.wrstr('Oktaeder');
      l:=100;pn:=octpn;
      tw1.gotoxy(1,4);            tw1.wrstr('Length:  l = ');
      tw1.gotoxy(1,5);            tw1.wrstr('PN:      pn= ');
      inp1.init(45,24,5,green,l); inpint1.init(45,25,5,green,pn);
      inp1.setframe(1,FALSE);     inpint1.setframe(1,FALSE);
      inp1.show;                  inpint1.show;
      inp1.run;                   inpint1.run;
      inp1.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      poct:=NEW(poktaeder,setto(l,0,0,0,pn));
    END;{inputoct}

    PROCEDURE inputdod;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(7,1);            tw1.wrstr('Dodekaeder');
      l:=100;pn:=dodpn;
      tw1.gotoxy(1,4);            tw1.wrstr('Length:  l = ');
      tw1.gotoxy(1,5);            tw1.wrstr('PN:      pn= ');
      inp1.init(45,24,5,green,l); inpint1.init(45,25,5,green,pn);
      inp1.setframe(1,FALSE);     inpint1.setframe(1,FALSE);
      inp1.show;                  inpint1.show;
      inp1.run;                   inpint1.run;
      inp1.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      pdod:=NEW(pdodekaeder,setto(l,0,0,0,pn));
    END;{inputdod}

    PROCEDURE inputico;
    BEGIN
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(7,1);            tw1.wrstr('Ikosaeder');
      l:=100;pn:=icopn;
      tw1.gotoxy(1,4);            tw1.wrstr('Length:  l = ');
      tw1.gotoxy(1,5);            tw1.wrstr('PN:      pn= ');
      inp1.init(45,24,5,green,l); inpint1.init(45,25,5,green,pn);
      inp1.setframe(1,FALSE);     inpint1.setframe(1,FALSE);
      inp1.show;                  inpint1.show;
      inp1.run;                   inpint1.run;
      inp1.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      pico:=NEW(pikosaeder,setto(l,0,0,0,pn));
    END;{inputico}

    PROCEDURE inputplnx;
    VAR l1,l2:REAL;
    BEGIN
      tw1.initcentered(24,10,green);
      tw1.show;
      tw1.gotoxy(9,1);            tw1.wrstr('XPlane');
      l1:=150;l2:=100;pn:=plnxpn;
      tw1.gotoxy(1,4);            tw1.wrstr(' YLength: yl= ');
      tw1.gotoxy(1,5);            tw1.wrstr(' ZLength: zl= ');
      tw1.gotoxy(1,6);            tw1.wrstr(' PN:      pn= ');
      inp1.init(45,24,5,green,l1);inp2.init(45,25,5,green,l2);
      inpint1.init(45,26,5,green,pn);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inpint1.setframe(1,FALSE);
      inp1.show;    inp2.show;    inpint1.show;
      inp1.run;     inp2.run;     inpint1.run;
      inp1.done;inp2.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      pxpln:=NEW(pplanex,setto(l1,l2,pn));
    END;{inputplnx}

    PROCEDURE inputplny;
    VAR l1,l2:REAL;
    BEGIN
      tw1.initcentered(24,10,green);
      tw1.show;
      tw1.gotoxy(9,1);            tw1.wrstr('YPlane');
      l1:=150;l2:=100;pn:=plnypn;
      tw1.gotoxy(1,4);            tw1.wrstr(' XLength: xl= ');
      tw1.gotoxy(1,5);            tw1.wrstr(' ZLength: zl= ');
      tw1.gotoxy(1,6);            tw1.wrstr(' PN:      pn= ');
      inp1.init(45,24,5,green,l1);inp2.init(45,25,5,green,l2);
      inpint1.init(45,26,5,green,pn);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inpint1.setframe(1,FALSE);
      inp1.show;    inp2.show;    inpint1.show;
      inp1.run;     inp2.run;     inpint1.run;
      inp1.done;inp2.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      pypln:=NEW(pplaney,setto(l1,l2,pn));
    END;{inputplny}

    PROCEDURE inputplnz;
    VAR l1,l2:REAL;
    BEGIN
      tw1.initcentered(24,10,green);
      tw1.show;
      tw1.gotoxy(9,1);            tw1.wrstr('ZPlane');
      l1:=150;l2:=100;pn:=plnzpn;
      tw1.gotoxy(1,4);            tw1.wrstr(' XLength: xl= ');
      tw1.gotoxy(1,5);            tw1.wrstr(' YLength: yl= ');
      tw1.gotoxy(1,6);            tw1.wrstr(' PN:      pn= ');
      inp1.init(45,24,5,green,l1);inp2.init(45,25,5,green,l2);
      inpint1.init(45,26,5,green,pn);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inpint1.setframe(1,FALSE);
      inp1.show;    inp2.show;    inpint1.show;
      inp1.run;     inp2.run;     inpint1.run;
      inp1.done;inp2.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      pzpln:=NEW(pplanez,setto(l1,l2,pn));
    END;{inputplnz}

    PROCEDURE inputpyrst;
    VAR r1,r2,h,alpha:REAL;
    BEGIN
      r1:=50;r2:=25;h:=100;alpha:=90;pn:=pyrstpn;
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(4,1);
      tw1.wrstr('Pyramidenstumpf');
      tw1.gotoxy(5,4);              tw1.wrstr('r1    = ');
      tw1.gotoxy(5,5);              tw1.wrstr('r2    = ');
      tw1.gotoxy(5,6);              tw1.wrstr('h     = ');
      tw1.gotoxy(5,7);              tw1.wrstr('alpha = ');
      tw1.gotoxy(5,8);              tw1.wrstr('pn    = ');
      inp1.init(45,24,5,green,r1);  inp2.init(45,25,5,green,r2);
      inp3.init(45,26,5,green,h);   inp4.init(45,27,5,green,alpha);
      inpint1.init(45,28,5,green,pn);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);       inp4.setframe(1,FALSE);
      inpint1.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;inp4.show;inpint1.show;
      inp1.run;inp2.run;inp3.run;inp4.run;inpint1.run;
      graphlist^.deleteall;
      ppyrst:=NEW(ppyrstumpf,setto(r1,r2,h,alpha,pn));
      inp1.done;inp2.done;inp3.done;inp4.done;inpint1.done;tw1.done;
    END;{inputpyrst}

    PROCEDURE inputcyl;
    VAR rz,hz,alpha:REAL;
    BEGIN
      rz:=50;hz:=100;alpha:=10;pn:=cylpn;
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(7,1);
      tw1.wrstr('Zylinder');
      tw1.gotoxy(5,4);              tw1.wrstr('rz    = ');
      tw1.gotoxy(5,5);              tw1.wrstr('hz    = ');
      tw1.gotoxy(5,6);              tw1.wrstr('alpha = ');
      tw1.gotoxy(5,7);              tw1.wrstr('pn    = ');
      inp1.init(45,24,5,green,rz);  inp2.init(45,25,5,green,hz);
      inp3.init(45,26,5,green,alpha);
      inpint1.init(45,27,5,green,pn);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);
      inpint1.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;inpint1.show;
      inp1.run;inp2.run;inp3.run;inpint1.run;
      graphlist^.deleteall;
      pcyl:=NEW(pzylinder,setto(rz,hz,alpha,pn));
      inp1.done;inp2.done;inp3.done;inpint1.done;tw1.done;
    END;{inputcyl}

    PROCEDURE inputpyr;
    VAR rp,hp:REAL;
    BEGIN
      tw1.initcentered(24,10,green);
      tw1.show;
      tw1.gotoxy(8,1);            tw1.wrstr('Pyramide');
      rp:=50;hp:=100;pn:=pyrpn;
      tw1.gotoxy(8,4);            tw1.wrstr('rp = ');
      tw1.gotoxy(8,5);            tw1.wrstr('hp = ');
      tw1.gotoxy(8,6);            tw1.wrstr('pn = ');
      inp1.init(45,24,5,green,rp);inp2.init(45,25,5,green,hp);
      inpint1.init(45,26,5,green,pn);
      inp1.setframe(1,FALSE);inp2.setframe(1,FALSE);inpint1.setframe(1,FALSE);
      inp1.show;    inp2.show;    inpint1.show;
      inp1.run;     inp2.run;     inpint1.run;
      inp1.done;inp2.done;inpint1.done;tw1.done;
      graphlist^.deleteall;
      ppyr:=NEW(ppyramide,setto(rp,hp,pn));
    END;{inputpyr}

    PROCEDURE inputcone;
    VAR rc,hc,alpha:REAL;
    BEGIN
      rc:=50;hc:=100;alpha:=10;pn:=conepn;
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(9,1);
      tw1.wrstr('Kegel');
      tw1.gotoxy(5,4);              tw1.wrstr('rc    = ');
      tw1.gotoxy(5,5);              tw1.wrstr('hc    = ');
      tw1.gotoxy(5,6);              tw1.wrstr('alpha = ');
      tw1.gotoxy(5,7);              tw1.wrstr('pn    = ');
      inp1.init(45,24,5,green,rc);  inp2.init(45,25,5,green,hc);
      inp3.init(45,26,5,green,alpha);
      inpint1.init(45,27,5,green,pn);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);
      inpint1.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;inpint1.show;
      inp1.run;inp2.run;inp3.run;inpint1.run;
      graphlist^.deleteall;
      pcone:=NEW(pkegel,setto(rc,hc,alpha,pn));
      inp1.done;inp2.done;inp3.done;inpint1.done;tw1.done;
    END;{inputcone}

    PROCEDURE inputdisc;
    VAR ri,ro,alpha:REAL;h:INTEGER;in1:ININTEGER;
    BEGIN
      ri:=10;ro:=50;alpha:=10;pn:=discpn;h:=1;
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(9,1);
      tw1.wrstr('Disc');
      tw1.gotoxy(5,4);              tw1.wrstr('ri    = ');
      tw1.gotoxy(5,5);              tw1.wrstr('ro    = ');
      tw1.gotoxy(5,6);              tw1.wrstr('h     = ');
      tw1.gotoxy(5,7);              tw1.wrstr('alpha = ');
      tw1.gotoxy(5,8);              tw1.wrstr('pn    = ');
      inp1.init(45,24,5,green,ri);  inp2.init(45,25,5,green,ro);
      inp3.init(45,27,5,green,alpha);inpint1.init(45,28,5,green,pn);
      in1.init(45,26,5,green,h);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);       in1.setframe(1,FALSE);
      inpint1.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;inpint1.show;in1.show;
      inp1.run;inp2.run;in1.run;inp3.run;inpint1.run;
      graphlist^.deleteall;
      pd:=NEW(pdisc,setto(ri,ro,h,alpha,pn));
      inp1.done;inp2.done;inp3.done;inpint1.done;tw1.done;
    END;{inputdisc}

    PROCEDURE inputsph;
    VAR r,alpha:REAL;ec:INTEGER;inp1:ininteger;
    BEGIN
      ec:=12;alpha:=18;r:=100;pn:=sphpn;
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(9,1);
      tw1.wrstr('Kugel');
      tw1.gotoxy(3,4);              tw1.wrstr('Ecken  = ');
      tw1.gotoxy(3,5);              tw1.wrstr('alpha  = ');
      tw1.gotoxy(3,6);              tw1.wrstr('Radius = ');
      tw1.gotoxy(3,7);              tw1.wrstr('pn     = ');
      inp1.init(45,24,5,green,ec);  inp2.init(45,25,5,green,alpha);
      inp3.init(45,26,5,green,r);
      inpint1.init(45,27,5,green,pn);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);
      inpint1.setframe(1,FALSE);
      inp1.show;inp2.show;inp3.show;inpint1.show;
      inp1.run;inp2.run;inp3.run;inpint1.run;
      graphlist^.deleteall;
      psph:=NEW(psphere,setto(ec,alpha,r,pn));
      inp1.done;inp2.done;inp3.done;inpint1.done;tw1.done;
    END;{inputsph}

    PROCEDURE inputtor;
    VAR r,alpha,mx:REAL;ec:INTEGER;inpint:ininteger;
    BEGIN
      ec:=12;alpha:=18;r:=30;pn:=torpn;mx:=100;
      tw1.initcentered(22,10,green);
      tw1.show;
      tw1.gotoxy(9,1);
      tw1.wrstr('Torus');
      tw1.gotoxy(1,4);              tw1.wrstr('Ecken     = ');
      tw1.gotoxy(1,5);              tw1.wrstr('alpha     = ');
      tw1.gotoxy(1,6);              tw1.wrstr('Radius r1 = ');
      tw1.gotoxy(1,7);              tw1.wrstr('Radius r2 = ');
      tw1.gotoxy(1,8);              tw1.wrstr('pn        = ');
      inpint.init(45,24,5,green,ec);
      inp1.init(45,25,5,green,alpha);  inp2.init(45,26,5,green,r);
      inp3.init(45,27,5,green,mx);
      inpint1.init(45,28,5,green,pn);
      inp1.setframe(1,FALSE);       inp2.setframe(1,FALSE);
      inp3.setframe(1,FALSE);       inpint.setframe(1,FALSE);
      inpint1.setframe(1,FALSE);
      inpint.show;inp1.show;inp2.show;inp3.show;inpint1.show;
      inpint.run;inp1.run;inp2.run;inp3.run;inpint1.run;
      graphlist^.deleteall;
      ptor:=NEW(ptorus,setto(ec,alpha,r,mx,pn));
      inpint.done;inp1.done;inp2.done;inp3.done;inpint1.done;tw1.done;
    END;{inputtor}

    PROCEDURE infunctdat;
    VAR instr:instring;lsname:STRING;
        pls:plshape;
    BEGIN
      {pls:=NEW(plshape,init);
      {IF covis THEN co.hide;
      lsname:=('funkt2.dat');
      tw1.initcentered(20,6,graywindows);
      tw1.show;
      tw1.gotoxy(5,1);            tw1.wrstr('Load Function');
      tw1.gotoxy(1,4);            tw1.wrstr('Name:');
      instr.init(40,26,12,graywindows,lsname);}
      if dat_request('.DAT',lsname,true) then begin
        pls:=NEW(plshape,init);
        pls^.loaddat(lsname);pls^.setcentr(0,0);
        shapeobjects^.insert(pls);
      end;
      {tw1.done; }
      IF covis THEN co.show;
      showworld;
    END;{infunctdat}


   PROCEDURE winobj;
   VAR prgad:INTEGER;
   BEGIN
     gl1.init(white);     {GadgetList fuer Objekte init.}
      inobjectbuttons;             {Buttons fuer Objekte init.}
     screen2.clearviewport;
     gl1.show;glview.show;
     clearscr1(white);
     showworld;
     graphlist^.deleteall;
     IF covis THEN co.show;
     WITH gl1 DO
     REPEAT
       screen2.activateviewport;
       initlocator(gl1.x,gl1.y,lcol,echooff);
       locator(x,y);
       prgad:=pressedanygadget;
       IF prgad=-1 THEN BEGIN
         glview.x:=x;glview.y:=y;
         prgad:=glview.pressedanygadget;
       END;
       screen1.activateviewport;
       CASE prgad OF
         boxpn  : inputbox;
         cubepn : inputcube;
         tetpn  : inputtetr;
         octpn  : inputoct;
         dodpn  : inputdod;
         icopn  : inputico;
         plnxpn : inputplnx;
         plnypn : inputplny;
         plnzpn : inputplnz;
         pyrstpn: inputpyrst;
         pyrpn  : inputpyr;
         cylpn  : inputcyl;
         conepn : inputcone;
         sphpn  : inputsph;
         torpn  : inputtor;
         discpn : inputdisc;
         {curpn  : incurvedat;    {def.sind: aspirale, radlinie, schraube}
         matpn  : infunctdat;
         copn   :   BEGIN covis:=NOT(covis);
                      IF covis THEN BEGIN
                        co.zentrproj(longitude,latitude,dist);co.show;
                      END ELSE BEGIN clearscr1(white);showworld;END;
                    END;
         20: changeproj(ph3d,th3d);
         21: changeproj(-90,0);
         22: changeproj(-90,90);
         23: changeproj(0,90);
{EDIT}   24: BEGIN winedit;gl1.show;glview.show; END;
{FORM}  25: BEGIN winxform;gl1.show;glview.show; END;
{NEW}   26: new_all;
       END;
       IF graphlist^.count>0 THEN BEGIN
         pbodshape:=graphlist^.at(graphlist^.count-1);
         graphlist^.deleteall;
         shapeobjects^.insert(pbodshape);
         wo.insert(pbodshape);
         pbodshape^.setcentr(0,0);
       END;
      IF (((((prgad<>-1) AND (prgad<>ended))AND(prgad<>copn))AND
          ((prgad<>24)AND (prgad<>25)))AND
          (wo.pol^.count>0))AND((prgad<>curpn)AND(prgad<>matpn))
      THEN BEGIN
         if not wo.cut then wo.shadow;
         wo.zentrproj(longitude,latitude,dist);
         wo.hlhsr;
         clearscr1(white);
         wo.show;
         IF covis THEN BEGIN
           co.zentrproj(longitude,latitude,dist);co.show;
         END;
       END;
     UNTIL prgad=ended;
     screen2.clearviewport;
     mgl.show;glview.show;clearscr1(white);gl1.done;
    END;{winobj}

   FUNCTION fileobj:BOOLEAN;
   VAR prgad:INTEGER;

    PROCEDURE save;
    VAR instr:instring;lsname:STRING;p:pointer;
    BEGIN
      lsname:='*       .dat';
      tw1.initcentered(20,10,graywindows);
      tw1.show;
      tw1.gotoxy(7,1);            tw1.wrstr('SaveAs');
      tw1.gotoxy(1,4);            tw1.wrstr('Name:');
      instr.init(40,24,12,graywindows,lsname);
      IF shapeobjects^.count>0 THEN BEGIN
        p:=graphlist;graphlist:=shapeobjects;
        wo.insertall;graphlist:=p;
        instr.setframe(1,FALSE);instr.show;instr.run;
        wo.savedat(lsname)
      END ELSE message('Keine Objekte zum speichern vorhanden !',red);
      instr.done;tw1.done;graphlist^.deleteall;
    END;{save}

    PROCEDURE load;
    VAR instr:instring;lsname:STRING;
        pls:plshape;
    BEGIN
      {pls:=NEW(plshape,init);  }
      IF covis THEN co.hide;
      if dat_request('.DAT',lsname,true) then begin
        pls:=NEW(plshape,init);
        pls^.loaddat(lsname);pls^.setcentr(0,0);
        shapeobjects^.insert(pls);
      end;
      IF covis THEN co.show;
      showworld;
    END;{load}

    PROCEDURE picload;
    VAR instr:instring;lsname:STRING;i,l:integer;
    BEGIN
      IF covis THEN co.hide;
      if dat_request('.O3D',lsname,false) then begin
        push_pal;
        cleardevice;
        l:=length(lsname)-3;
        for i:=l to l+3 do lsname[i]:=' ';
        loadpic(lsname);
        wait;
        vga_pal:=vgapalette;pop_pal;
      end else begin cleardevice;
        message('CANCEL - Kein Bild geladen !',red);
      end;
    END;{picload}

    PROCEDURE picsave;
    VAR instr:instring;lsname:STRING;
    BEGIN
      IF covis THEN co.hide;
      lsname:='        ';
      tw1.initcentered(20,10,graywindows);
      tw1.show;
      tw1.gotoxy(7,1);            tw1.wrstr('SavePic');
      tw1.gotoxy(1,4);            tw1.wrstr('Name:');
      instr.init(40,24,8,graywindows,lsname);
      instr.setframe(1,FALSE);instr.show;instr.run;
      instr.done;tw1.done;graphlist^.deleteall;
      savepic(lsname);
    END;{picsave}

   PROCEDURE aboutwindow;
    BEGIN
      tw1.initcentered(38,11,graywindows);
      tw1.show;
      tw1.gotoxy(15,2);
      tw1.wrstr('Ed3D V2.0');
      tw1.gotoxy(9,4);
      tw1.wrstr('Written by Frank Menzel');
      {tw1.gotoxy(5,6);
     { tw1.wrstr('TU-Dresden, Fakultt Informatik'); }
      tw1.gotoxy(13,6);
      tw1.wrstr('November  1994');
      tw1.gotoxy(5,10);
      tw1.wrstr('Ed3D is a small 3D-CAD program.');
      wait;
      tw1.done;graphlist^.deleteall;
    END;{aboutwindow}

   VAR update:BOOLEAN;
   BEGIN
     screen2.clearviewport;
     update:=FALSE;
     glfi.show;
     WITH glfi DO
     REPEAT
       screen2.activateviewport;
       initlocator(glfi.x,glfi.y,lcol,echooff);
       locator(x,y);
       prgad:=pressedanygadget;
       screen1.activateviewport;
       CASE prgad OF
{New}     1: new_all;
{Load}    2: BEGIN load;update:=TRUE;{clearscr1(white);} END;
{Save}    3: BEGIN save; END;
{LoadPic} 4: BEGIN nextactivepage;cleardevice;nextvisualpage;
                   {push_pal;}picload;{wait;vga_pal:=vgapalette;pop_pal;}
                   nextactivepage;nextvisualpage;
             END;
{SavePic} 5: BEGIN nextactivepage;nextvisualpage;cleardevice;
                   scrback.activateviewport;
                   wo.fillshow;picsave;
                   nextactivepage;nextvisualpage;screen2.activateviewport;
             END;
{ShowPic} 6: BEGIN nextactivepage;push_pal;vgapalette:=vga_pal;
                   write_coltab(true);nextvisualpage;wait;
                  nextactivepage;pop_pal;nextvisualpage;
             END;
{About}   7: aboutwindow;
       END;
     UNTIL prgad=ended;
     screen2.clearviewport;
     mgl.show;glview.show;
     fileobj:=update;
    END;{fileobj}

  PROCEDURE mainloop;
  VAR prgad:INTEGER;ch:CHAR; p:pointer;

    FUNCTION reallyquit:BOOLEAN;
    VAR instr:instring;choice:STRING;
    BEGIN
      tw1.initcentered(24,7,red);
      tw1.show;
      tw1.gotoxy(4,2);            tw1.wrstr('Exit program now ?');
      choice:='Yes';
      instr.init(40,26,3,red,choice);
      instr.setframe(1,FALSE);
      instr.show;
      instr.run;
      instr.done;
      tw1.done;
      IF (choice[1]='Y')OR(choice[1]='y')
        THEN reallyquit:=TRUE ELSE reallyquit:=FALSE;
    END;{reallyquit}


   PROCEDURE anim;
   VAR long,lat:REAL;

   PROCEDURE insertfromshapeobj;
   VAR hp:pointer;
   BEGIN
     hp:=graphlist;graphlist:=shapeobjects;
     wo.insertall;graphlist:=hp;
   END;

   PROCEDURE showwo;
   BEGIN
     if not wo.cut then wo.shadow;
     wo.zentrproj(longitude,latitude,dist);
     CASE shm OF
       wire:wo.show;
       hide:BEGIN wo.hlhsr;wo.show;END;
       sol:BEGIN wo.priorlist;wo.fillshow;END;
       fla:BEGIN wo.lattr(0,0,1);wo.priorlist;wo.cshade;wo.fillshow;END;
     END;
     IF livis THEN wo.showsource;
     IF covis THEN
       BEGIN co.zentrproj(longitude,latitude,dist);co.show;END;
   END;

   BEGIN
   IF shapeobjects^.count>0 THEN BEGIN
    IF (shm<>gour)AND (shm<>pho) THEN BEGIN
     nextactivepage;
     screen2.clearviewport;clearscr1(white);screen3.clearviewport;
     screen2.activateviewport;mgl.show;glview.show;
     screen1.activateviewport;
     nextactivepage;
     REPEAT
       nextactivepage;
       insertfromshapeobj;
       longitude:=longitude+clong;latitude:=latitude+clat;
       wo.rot(rox,roy,roz);
       wo.lrot(0,0,0,llx,lly,llz);
       clearscr1(white);
       showwo;
       message('Abbruch mit rechter Maustaste oder beliebiger Taste !',lightblue);
       nextvisualpage;delay(delayanim);
     UNTIL keypressed OR rightbutton;
     if page=0 then begin nextactivepage;nextvisualpage;end;
    END ELSE BEGIN
     message('Animation nicht bei Gouraud- oder Phongshading moeglich !',red);
     prgad:=1;wait;
    END;
   END;
   END;{anim}

  PROCEDURE lightanim;
  VAR ph,th,rx,ry,rz:REAL;
  BEGIN
    ph:=clong;th:=clat;rx:=rox;ry:=roy;rz:=roz;
    clong:=0;clat:=0;rox:=0;roy:=0;roz:=0;
    anim;
    clong:=ph;clat:=th;rox:=rx;roy:=ry;roz:=rz;
  END;{lightanim}

  PROCEDURE cameraanim;
  VAR lx,ly,lz,rx,ry,rz:REAL;
  BEGIN
    rx:=rox;ry:=roy;rz:=roz;lx:=llx;ly:=lly;lz:=llz;
    rox:=0;roy:=0;roz:=0;llx:=0;lly:=0;llz:=0;
    anim;
    rox:=rx;roy:=ry;roz:=rz;llx:=lx;lly:=ly;llz:=lz;
  END;{cameraanim}

  BEGIN
    mgl.show;glview.show;
    WITH mgl DO
    REPEAT
      screen2.activateviewport;
      initlocator(mgl.x,mgl.y,lcol,echooff);
      locator(x,y);
      prgad:=pressedanygadget;
      IF prgad=-1 THEN BEGIN
         glview.x:=mgl.x;glview.y:=mgl.y;
         prgad:=glview.pressedanygadget;
      END;
     screen1.activateviewport;
      CASE prgad OF
{File}     1 : IF fileobj THEN BEGIN prgad:=0;clearscr1(white);END;
{Object}   2 : winobj;
{Edit}     3 : BEGIN winedit;mgl.show;glview.show;clearscr1(white); END;
{Form}     4 : BEGIN winxform;mgl.show;glview.show;clearscr1(white);END;
{Options}  6 : BEGIN winopt;changeproj(longitude,latitude);END;
{Wire}     10: BEGIN clearscr1(white);shm:=wire;wo.setshading(flat);END;
{Hidden}   11: BEGIN clearscr1(white);shm:=hide;wo.setshading(flat);END;
{Solid}    12: BEGIN clearscr1(white);shm:=sol;wo.setshading(flat);END;
{Flat}     13: BEGIN clearscr1(white);shm:=fla;wo.setshading(flat);END;
{Gouraud}  14: BEGIN clearscr1(white);shm:=gour;wo.setshading(gouraud);END;
{Phong}    15: BEGIN clearscr1(white);shm:=pho;wo.setshading(phong);END;
{Anim}     16: BEGIN anim;prgad:=1;END;
{CSystem}copn: BEGIN covis:=NOT(covis);
                IF NOT covis THEN co.hide;
               END;
{3DView}   20: BEGIN clearscr1(white);changeproj(ph3d,th3d);END;
{YXView}   21: BEGIN clearscr1(white);changeproj(-90,0);END;
{ZXView}   22: BEGIN clearscr1(white);changeproj(-90,90);END;
{ZYView}   23: BEGIN clearscr1(white);changeproj(0,90);END;
{EXIT}  ended: IF reallyquit THEN exit ELSE prgad:=-1;
      END;
      graphlist^.deleteall;
      message('',black);
      IF (prgad<>-1)AND(prgad<>1)  THEN BEGIN
       IF shapeobjects^.count>0 THEN BEGIN
          p:=graphlist;graphlist:=shapeobjects;
          wo.insertall;graphlist:=p;
       END;
       IF ((wo.pol^.count>0)AND(prgad<>copn))AND (prgad<>1) THEN BEGIN
          IF (shm<>wire) AND (shm<>hide) THEN BEGIN
            if not wo.cut then wo.shadow;
            wo.zentrproj(longitude,latitude,dist);
            message('Moment bitte. Ich berechne Schnittpunkte.',lightblue);
            clearscr1(white);
            IF shm<>sol THEN BEGIN wo.lattr(0,0,1);END;
            message('',black);
            wo.priorlist;wo.cshade;
            wo.fillshow;
          END ELSE BEGIN
            if not wo.cut then wo.shadow;
            wo.zentrproj(longitude,latitude,dist);
            IF lc=black THEN wo.lattr(white,0,1);
            IF shm=hide THEN wo.hlhsr ELSE wo.setpolvis;
            wo.show;
          END;
          IF livis THEN wo.showsource;
        END;
        IF prgad<>-1 THEN BEGIN
          IF covis THEN BEGIN
            co.zentrproj(longitude,latitude,dist);co.show;
          END;
        END;
      END;
    UNTIL prgad=ended;
  END;{mainloop}

    PROCEDURE initall;
    BEGIN
      opengraphic256('c:\tp\bgi'); {Grafikmodus SVGA800x600x256}
      nextactivepage;cleardevice;nextvisualpage;
      scrback.init;                {Fenster auf 2.Seite init.}
      scrback.setwindow(-getmaxx/2,-getmaxy/2,getmaxx/2,getmaxy/2);
      scrback.setviewport(gx1,gy1,gx2,gy2,clipon,black);
      screen3.init;                {Fenster unter Screen1 (Darstell.-fenster)}
      screen3.setviewport(0,by1,gx2,gy1-1,clipon,graywindows);
      screen3.activateviewport;
      screen1.init;                {Fenster, wo Objekte gezeichnet werden}
      screen1.setwindow(-getmaxx/2,-getmaxy/2,getmaxx/2,getmaxy/2);
      screen1.setviewport(gx1,gy1,gx2,gy2,clipon,black);
      rectanglewc(-getmaxx/2,-getmaxy/2,getmaxx/2,getmaxy/2);
      screen2.init;                {Fenster fuer Buttons}
      screen2.setviewport(bx1,by1,bx2,by2,clipon,graywindows);
      screen2.activateviewport;
      mgl.init(white);     {GadgetList fuer Hauptfenster init.}
      inmainbuttons;               {Buttons im Hauptfenster initialisieren}
      glview.init(white);  {GadgetList fuer Viewbuttons}
      inviewbuttons;
      glfi.init(white);    {GadgetList fuer Filebuttons}
      infilebuttons;
      gled.init(white);    {GadgetList fuer Editbuttons}
      ineditbuttons;
      glxf.init(white);    {GadgetList fuer Formbuttons}
      inxformbuttons;
      glopt.init(white);   {Gadgetlist fuer Optionbuttons}
      inoptbuttons;
      shapeobjects:=NEW(pcollection,init(5,5));{Liste fuer alle Objekte}
      wo.init;                     {Objekt World init. fuer 3D-Graf.-Obj.}
      wo.setcentr(0,0);            {Verschiebung auf Screen=0}
      wo.setlsource(lph3d,lth3d,ldist);{Lichtquelle auf Observer setzen}
      co.init;co.setcentr(0,0);    {Koordsystem initialisieren}
     END;


BEGIN
   initall;                 {Grafiktreiber/Fenster/World initialisieren}
   graphlist^.deleteall;    {Kollektion bereinigen}
   mainloop;                {Abfragen Hauptfenster}
   graph.closegraph;        {Grafikmodus beenden}
END.{ed3d}
