Program Optics;
{       By Bob Westwater             }
{       6/2/85  Version 1.0          }
{                                    }
{   This program computes various    }
{   parameters of a reflecting tele- }
{   scope. It is adapted from a basic}
{   program that was published by    }
{   Byte magazine in March 1983 on   }
{   page 450.                        }
{        This version is for Turbo   }
{   Pascal.      Enjoy---   - Bob -  }

Var
  K,A,FD,SP,
  FR,FA,AS,
  SS,Step      : Real;
  X            : Integer;
  FL,FO,EF,
  PO,PA,RD,
  ER,MA,DL,
  SC,CO,KN   : Real;
  Astring    : Char;
  Flag       : Boolean;
  Response   : Char;

Const
  PI = 3.14159;
  Q = 180;
  JJ = 250;

Procedure Setup;
  Begin
     KN := 0.3;
     K:=(Q/PI)*3600;
     ClrScr;
     Writeln( 'This Telescope program computes');
     Writeln( 'various parameters for a reflecting');
     Writeln( 'telescope.');
  end; {setup}

Procedure EyePiece( Astring :Char; KN :Real);
    Begin
         Case UpCase(Astring) of
           'P' : KN := 0.75;
           'O' : KN := 0.80;
           'S' : KN := 0.80;
           'E' : KN := 0.35;
         end  {case}
    end; {EyePiece}

Procedure Calc;
   Begin
      PO := FL/EF;
      PA := PO;
      RD := A/PO;
      ER :=(FL*EF*KN)/(FL-EF);
      MA := 9+(5*(LN(A)/LN(10)));
      DL := 4.56/A;
      SC := 8120.66/FL;
   end;

Procedure GetData;
  Begin
    Write('Enter Aperture ');
    Readln(A);
    Write('Enter mirror F.L. ');
    Readln(FL);
    FO :=FL/A;
    Write('Enter eyepiece F.L. ');
    Readln(EF);
    Write('Enter eyepiece type (P,O,S,E) ');
    Readln(AString);
    EyePiece(AString,KN);
  end;

Procedure WaitForReturn;
   Begin
        Writeln('Press <RETURN> key to continue');
        Readln;
   end;

Procedure PrintSpecs;
   Begin
     ClrScr;
     Writeln('Aperture =',A:6:2);
     Writeln('Mirror F.L. =',FL:3:1);
     Writeln('Effective F-stop = f/',FO:2:1);
     Writeln('Eyepiece F.L. =',EF:1:3);
     Writeln('Telescope Power =',PA:4:0);
     Writeln('Eye Relief =',ER:1:5);
     Writeln('Ramsden Disk =',RD:1:4);
     Writeln('Mag. Limit =',MA:2:1);
     Writeln('Dawes Limit =',DL:2:4,'"');
     Writeln('P.F. Scale =',SC:1:3);
     Writeln;
   end;

Procedure Coma;
  Begin
     Write('Enter the field Diameter. ');
     Readln(FD);
     FR := FD/2;
     Write('Enter step size ');
     Readln(Step);
     SS := 0;
     ClrScr;
     Writeln('   Angle     Coma       Astig');
       While SS < FR do
         Begin
           FA := SS*(PI/Q);
           CO := (FA/(16*(FO*FO)))*K;
           AS :=((FA*FA)/(2*FO))*K;
           Writeln('  ',SS:5:2,'      ',CO:5:5,'    ',AS:5:5);
           SS := SS + Step;
         end
  end;

Procedure Radius;
   Begin
      ClrScr;
      Writeln('  Radius    Coma    Astig');
        While SS < 18 do
          Begin
            FA := (SS*SC)/K;
            CO := (FA/(16*(FO*FO)))*K;
            CO := CO/SC;
            AS := ((FA*FA)/(2*FO))*K;
            AS := AS/SC;
            Writeln('  ',SS:5:2,'   ',CO:5:5,'   ',AS:5:5);
            SS := SS + 2;
          end
   end;

begin
  Flag := True;
  While Flag = True do
    Begin
        setup;
        getdata;
        calc;
        printspecs;
        WaitForReturn;
        Coma;
        SP :=(0.0078/(FO*FO*FO))*K;
        Writeln('AX.  SP.  AB. =',SP:5:5);
        WaitForReturn;
        Radius;
        SP := SP/SC;
        Writeln('AX. SP. AB. =',SP:5:5);
        WaitForReturn;
        Writeln('Want to do it again?');
        readln(Response);
          if UpCase(Response) = 'Y' then
          Flag := True
          else
          Flag := False;
     end {while}
end. {main}if UpCase(Response) = 'Y' then
                                                                                                                                   