#include <graphics.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define G 6.67e-3
#define MAXNUM 45

struct object {
	double rx,ry,vx,vy,mass;
	} masses[MAXNUM];

struct accel {
	double ax,ay;
	};

int xmax,ymax,maxcolor,NUM;
double xscale,yscale;

/********************************************************************/
void graphicson(void)
	{
	int err,graphdriver = DETECT, graphmode;

	initgraph(&graphdriver,&graphmode,"");
	if ((err=graphresult()) != 0)
		{
		printf("%s\n",grapherrormsg(err));
		abort();
		}

	maxcolor = getmaxcolor();
	xmax = getmaxx();
	ymax = getmaxy();
	xscale = 16384.0 / xmax;
	yscale = 16384.0 / ymax;
	}
/********************************************************************/

void init(void)
	{
	int i;
	double r,v;

    randomize();
	masses[0].rx = 0;	masses[0].ry = 0;
	masses[0].vx = 0;	masses[0].vy = 0;
	masses[0].mass = 700000000;
	for (i=1; i<NUM; i++)
		{
        masses[i].rx = (rand()-16384)/10.0;
		masses[i].ry = (rand()-16384)/10.0;
		r = sqrt((*(masses+i)).rx * (*(masses+i)).rx +
				 (*(masses+i)).ry * (*(masses+i)).ry);
		masses[i].mass = rand() * 100.0;
		v = sqrt(G * (*masses).mass / r);
		masses[i].vx = masses[i].ry / r * v;
		masses[i].vy = -masses[i].rx / r * v;
		}
	}

/*********************************************************************/

void getaccel(int masso,struct accel *acc)
	{
	int i;
	double ax,ay,ar,r2,dx,dy;

	ax = 0;		ay = 0;
	for (i=0; i<NUM; i++)
		{
		if (i != masso)
			{
			dx = (*(masses+i)).rx - (*(masses+masso)).rx;
			dy = (*(masses+i)).ry - (*(masses+masso)).ry;
			r2 = dx*dx + dy*dy;
			ar = (*(masses+i)).mass / (r2 * sqrt(r2));
            ax += ar * dx;
			ay += ar * dy;
			}
		}
	(*acc).ax = ax * G;
	(*acc).ay = ay * G;
	}

/*********************************************************************/

void plotmass(int i)
	{
	double xpos,ypos;

	xpos = ((*(masses+i)).rx + 8192) / xscale;
	ypos = ((*(masses+i)).ry + 8192) / yscale;
	if ((xpos>0)&&(xpos<xmax)&&(ypos>0)&&(ypos<ymax))
		putpixel(xpos,ypos,maxcolor);
	}

/*********************************************************************/

void starplot(int i)
	{
	double xpos,ypos;
	int color;

	xpos = ((*(masses+i)).rx + 8192) / xscale;
	ypos = ((*(masses+i)).ry + 8192) / yscale;
	if ((xpos>1)&&(xpos<xmax)&&(ypos>1)&&(ypos<ymax))
		{
		putpixel(xpos,ypos,maxcolor);
		putpixel(xpos-1,ypos,maxcolor);
		putpixel(xpos+1,ypos,maxcolor);
		putpixel(xpos,ypos-1,maxcolor);
		putpixel(xpos,ypos+1,maxcolor);
		}
	}

/*********************************************************************/

void printmass(int i)
	{
    double dx,dy,d;
    char t[20];
	int j;

	if (!i)	{
			dx = (*masses).rx;
			dy = (*masses).ry;
			}
	else	{
			dx = (*(masses+i)).rx-(*masses).rx;
			dy = (*(masses+i)).ry-(*masses).ry;
			}
	d = sqrt(dx*dx+dy*dy);
	if (d<10000)
		{
		for (j=0; j<4; j++) t[j]=0;
		itoa(i,t,10);
		for (j=0; j<4; j++) if (!t[j]) t[j]=' ';
		itoa(d,t+4,10);
		t[3] = ':';
		if (!i) { t[0]='S'; t[1]='U'; t[2]='N';
				  outtextxy(0,0,t); }
		else outtextxy((i-1)/10*100,((i-1)%10)*10+10,t);
		}
	}

/*********************************************************************/

void opscreen(void)
	{
	char s[30];

    clrscr();
	printf("\t\t\t    SOLAR SYSTEM SIMULATOR\n\n\n");
	printf("\tThis program will create and simulate a solar system\n");
	printf("\tfor you.  You tell it how many planets you would like, up\n");
	printf("\tto a maximum of 40, and it will give each planet a position,\n");
	printf("\tmass, and velocity randomly.  It will then calculate and\n");
	printf("\tdisplay the motions of each planet, along with their\n");
	printf("\tdistances from the sun.  Also displayed is the distance the\n");
	printf("\tsun has moved from it's point of origin.  The calculations\n");
	printf("\tare all based on newton's laws, which means that each planet\n");
	printf("\t(and the sun) is affected by the gravitational pull of every\n");
	printf("\tother planet in the solar system.  This produces a rather\n");
	printf("\tcomplex and unpredictable display.\n\n");
	printf("\t\tYou can press [ENTER] to turn tracking on and off,\n");
	printf("\t\tpress the space bar to end the display.\n\n\n");
	printf("How many planets would you like to see?\n");
	do {
		gets(s);
		NUM = atoi(s);
		}
	while ((NUM<1)||(NUM>40));
	NUM++;
	}

/*********************************************************************/

main()
	{
	int i,s=0,track=0,ch;
	struct accel acc;

	opscreen();
	init();
	graphicson();
	setfillstyle(SOLID_FILL,BLACK);
	do
		{
		if (kbhit()) ch=getch();
			else ch='';
		if (ch==13) {	track=1-track;	setactivepage(s);	cleardevice();	}
		if (!track)
			{
			setactivepage(s);
			setvisualpage(1-s);
			cleardevice();
			s = 1-s;
			}

	/* Plot positions */

		if (track) bar(0,0,NUM/10*100+100,110);
        starplot(0);
		printmass(0);
		for (i=1; i<NUM; i++)
			{
			plotmass(i);
			printmass(i);
			}

	/* Calculate new velocities */

		for (i=0; i<NUM; i++)
			{
			getaccel(i,&acc);
			(*(masses+i)).vx += acc.ax;
			(*(masses+i)).vy += acc.ay;
			}

	/* Calculate new positions */

		for (i=0; i<NUM; i++)
			{
			(*(masses+i)).rx += (*(masses+i)).vx;
			(*(masses+i)).ry += (*(masses+i)).vy;
			}
		}
	while (ch != ' ');
	closegraph();
	}