' Program "ATMOS"

' Copyright (C) 1982 by David Eagle

' IBM-PC  << Microsoft QuickBASIC compiler, version 4.5 >>

' Determines properties of the standard atmosphere

'  temperature; degrees Fahrenheit and Celsius
'  pressure; newtons per square meter
'  density, kilograms per cubic meter

'**********************************************************

DEFDBL A-Z

DECLARE SUB KEYCHECK ()
DECLARE SUB PHEADER ()

CONST C0 = 288.15#
CONST F0 = 518.67#
CONST ALTITUDE0 = 10999.9272#
CONST PRESSURE0 = 101325.016#
CONST DENSITY0 = 1.22557#

DO
   CLS
   LOCATE 5, 1
   PRINT TAB(34); "Program ATMOS"
   LOCATE 7, 1
   PRINT TAB(20); "< Properties of the Standard Atmosphere >"
   LOCATE 10, 1
   PRINT TAB(24); "Copyright (C) 1982 by David Eagle"
   LOCATE 13, 1
   PRINT TAB(26); "Microsoft QuickBASIC Compiler"
   PRINT TAB(20); "Copyright (C) Microsoft Corp. 1982...1988"
   CALL KEYCHECK

   CLS
   LOCATE 5, 1
   PRINT TAB(34); "Program ATMOS"
  
   DO
      PRINT
      PRINT
      PRINT "Please input the initial altitude ( meters )"
      INPUT IALT
   LOOP UNTIL IALT >= 0#

   DO
      PRINT
      PRINT
      PRINT "Please input the final altitude ( meters )"
      INPUT FALT
   LOOP UNTIL FALT > IALT

   DO
      PRINT
      PRINT
      PRINT "Please input the altitude increment ( meters )"
      INPUT DALT
   LOOP UNTIL DALT > 0#

   J% = INT(IALT / DALT + .5#)
   K% = INT(FALT / DALT + .5#)

   IPASS% = 1
   PNUM% = 0

   FOR I% = J% TO K%
       PNUM% = PNUM% + 1
       ALTITUDE = I% * DALT

       IF ALTITUDE < ALTITUDE0 THEN
          RHO2 = 1# - .000022556913# * ALTITUDE
          RHO1 = RHO2 ^ 5.256116#
       ELSE
          RHO1 = .2233618# * EXP(1.7345477# - .0001576872# * ALTITUDE)
          RHO2 = .7519#
       END IF

       DRATIO = RHO1 / RHO2
       PRESSURE = RHO1 * PRESSURE0
       DENSITY = DRATIO * DENSITY0

       TEMPF = RHO2 * F0 - 459.67#
       TEMPC = RHO2 * C0 - 273.15#

       ' print data

       IF IPASS% = 1 THEN
          CALL PHEADER
          IPASS% = 0
       END IF

       PRINT
       PRINT USING "######.##"; TAB(2); ALTITUDE; TAB(25); PRESSURE;
       PRINT USING "###.#######"; TAB(42); DENSITY;
       PRINT USING "###.##"; TAB(64); TEMPF; TAB(73); TEMPC

       IF PNUM% = 8 THEN
          CALL KEYCHECK
          CLS
          PRINT
          PNUM% = 0
          IPASS% = 1
       END IF

   NEXT I%

   IF PNUM% > 0 AND PNUM% < 8 THEN CALL KEYCHECK

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection ( y = yes, n = no )"
      INPUT SELECTION$
   LOOP UNTIL INSTR("nNyY", SELECTION$)

LOOP UNTIL INSTR("nN", SELECTION$)

END

SUB KEYCHECK STATIC

    ' Check user response subroutine

    LOCATE 25, 1
    PRINT TAB(25); "< press any key to continue >";

    A$ = ""
    WHILE A$ = ""
      A$ = INKEY$
    WEND

END SUB

SUB PHEADER STATIC

    ' Print page header subroutine

    CLS
    LOCATE 3, 1
    PRINT TAB(5); "ALTITUDE"; TAB(25); "PRESSURE";
    PRINT TAB(45); "DENSITY"; TAB(65); "TEMPERATURE";
    PRINT TAB(4); "( meters )"; TAB(24); "( nt/sq m )";
    PRINT TAB(44); "( kg/m^3 )"; TAB(64); "( degrees F, C )";
    PRINT
    PRINT

END SUB

