' Program "BALLOON"

' Copyright (C) 1982 by David Eagle

' IBM-PC  << QuickBASIC compiler, version 4.5 >>

' Determines performance capability of hot air balloons

'  gross weight capability, kilograms
'  gas temperature required, degrees Fahrenheit
'  balloon volume required, cubic meters
'  maximum altitude capability, meters

'*********************************************************

DEFDBL A-Z

DECLARE SUB KEYCHECK ()
DECLARE SUB GWEIGHT ()
DECLARE SUB TREQUIRED ()
DECLARE SUB VREQUIRED ()
DECLARE SUB MAXALT ()
DECLARE SUB ATMOS ()
DECLARE SUB WFUNCTION (WF)
DECLARE SUB GET.WEIGHT ()
DECLARE SUB GET.VOLUME ()
DECLARE SUB GET.GASTEMP ()
DECLARE SUB GET.ALTITUDE ()

COMMON SHARED WEIGHT, VOLUME, GASTEMP, ALTITUDE, ALTITUDE0
COMMON SHARED RHO, RHOAMB, GTEMPABS, TAMBABS, TSITEABS

DEF FNA (X) = 5# * (X + 459.67#) / 9#

DEF FNB (X) = (1# - .000022556913# * X)

DEF FNC (X) = 9# * X / 5# - 459.67#

ALTITUDE0 = 10999.9272#
RHOSL = 1.22557#

CLS
LOCATE 5, 1
PRINT TAB(32); "Program BALLOON"
LOCATE 7, 1
PRINT TAB(24); "Copyright (C) 1982 by David Eagle"
LOCATE 11, 1
PRINT TAB(26); "Microsoft QuickBASIC Compiler"
PRINT TAB(20); "Copyright (C) Microsoft Corp. 1982...1988"
CALL KEYCHECK

DO
   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program BALLOON"
   PRINT
   PRINT
   PRINT "Launch site altitude ( meters )"
   INPUT ALTSITE
   PRINT
   PRINT "Launch site temperature ( degrees F )"
   INPUT TEMPSITE

   ' determine launch site ambient density and absolute temperature

   RHO = RHOSL * FNB(ALTSITE) ^ 4.256116# / (1# + (TEMPSITE - 59#) / 518.67#)
   TSITEABS = FNA(TEMPSITE)

   ' print menu and propmt user for selection

   CLS
   LOCATE 5, 1
   PRINT TAB(20); "Performance Menu"
   PRINT
   PRINT
   PRINT TAB(10); " < 1 > Gross weight capability"
   PRINT
   PRINT TAB(10); " < 2 > Gas temperature required"
   PRINT
   PRINT TAB(10); " < 3 > Balloon volume required"
   PRINT
   PRINT TAB(10); " < 4 > Maximum altitude capability"
   PRINT
   PRINT
   PRINT "Selection"
   INPUT SELECTION%

   CLS
   LOCATE 5, 1

   SELECT CASE SELECTION%
   CASE 1
        CALL GWEIGHT
   CASE 2
        CALL TREQUIRED
   CASE 3
        CALL VREQUIRED
   CASE 4
        CALL MAXALT
   END SELECT

   ' print results

   FORMAT$ = "#######.##"

   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program BALLOON"
   PRINT
   PRINT
   PRINT
   PRINT TAB(5); "Gross weight         ( kilograms )";
   PRINT USING FORMAT$; TAB(55); WEIGHT
   PRINT
   PRINT TAB(5); "Balloon volume       ( cubic meters )";
   PRINT USING FORMAT$; TAB(55); VOLUME
   PRINT
   PRINT TAB(5); "Gas temperature      ( degrees F )";
   PRINT USING FORMAT$; TAB(55); GASTEMP
   PRINT
   PRINT TAB(5); "Altitude             ( meters )";
   PRINT USING FORMAT$; TAB(55); ALTITUDE
   PRINT
   PRINT
   PRINT TAB(5); "Ambient temperature  ( degrees F )";
   PRINT USING FORMAT$; TAB(55); FNC(TAMBABS)
   PRINT
   CALL KEYCHECK

   ' request another selection

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection ( y = yes, n = no )"
      INPUT A$
   LOOP UNTIL INSTR("nNyY", A$)

LOOP UNTIL INSTR("nN", A$)

END

SUB ATMOS STATIC

    ' Ambient density and absolute temperature subroutine

    IF ALTITUDE < ALTITUDE0 THEN
       A = FNB(ALTITUDE)
       RHOAMB = RHO * A ^ 4.256116#
       TAMBABS = A * TSITEABS
    ELSE
       RHOAMB = .297122# * RHO * EXP(1.73454773# - .0001576872# * ALTITUDE)
       TAMBABS = 216.65#
    END IF

END SUB

SUB GET.ALTITUDE STATIC
   
    ' Request altitude subroutine

    DO
       PRINT
       PRINT "Altitude ( meters )"
       INPUT ALTITUDE
    LOOP UNTIL ALTITUDE > 0#

END SUB

SUB GET.GASTEMP STATIC
   
    ' Request gas temperature subroutine

    DO
       PRINT
       PRINT "Please input the gas temperature ( degrees F )"
       INPUT GASTEMP
    LOOP UNTIL GASTEMP > 0#

    GTEMPABS = FNA(GASTEMP)

END SUB

SUB GET.VOLUME STATIC

    ' Request balloon volume subroutine

    DO
       PRINT
       PRINT "Please input the balloon volume ( cubic meters )"
       INPUT VOLUME
    LOOP UNTIL VOLUME > 0#

END SUB

SUB GET.WEIGHT STATIC

    ' Request gross weight subroutine

    DO
       PRINT
       PRINT "Please input the gross weight ( kilograms )"
       INPUT WEIGHT
    LOOP UNTIL WEIGHT > 0#

END SUB

SUB GWEIGHT STATIC

    ' Gross weight capability subroutine

    PRINT
   
    CALL GET.VOLUME
    CALL GET.GASTEMP
    CALL GET.ALTITUDE
   
    CALL ATMOS
   
    WEIGHT = VOLUME * RHOAMB * (1# - TAMBABS / GTEMPABS)

END SUB

SUB KEYCHECK STATIC

    ' Check user response subroutine

    LOCATE 25, 1
    PRINT TAB(25); "< press any key to continue >";

    A$ = ""
    WHILE A$ = ""
      A$ = INKEY$
    WEND

END SUB

SUB MAXALT STATIC

    ' Maximum altitude subroutine

    PRINT
   
    CALL GET.WEIGHT
    CALL GET.VOLUME
    CALL GET.GASTEMP

    X0 = 0#
    X2 = 3# * ALTITUDE0
   
    ALTITUDE = 0#
   
    CALL WFUNCTION(WF0)

    IF WF0 <= 0# THEN
       CLS
       LOCATE 5, 1
       PRINT TAB(27); "CANNOT LIFT THIS WEIGHT !!"
       CALL KEYCHECK
       EXIT SUB
    END IF

    DO
       X1 = .5# * (X0 + X2)
       ALTITUDE = X0
      
       CALL WFUNCTION(F0)
       ALTITUDE = X1
      
       CALL WFUNCTION(F1)
       ALTITUDE = X2
      
       CALL WFUNCTION(F2)
      
       A = X1 - X0
       B = F1 / F0
       C = B * B - F2 / F0
      
       X3 = X1 + A * B / SQR(C)
      
       ALTITUDE = X3
      
       IF ABS(X3 - X2) < .1# THEN EXIT DO
      
       CALL WFUNCTION(F3)
      
       IF F3 * F1 < 0# THEN X0 = X1
       IF F3 * F2 < 0# THEN X0 = X2
      
       X2 = X3
    LOOP

END SUB

SUB TREQUIRED STATIC

    ' Gas temperature required subroutine

    PRINT
    CALL GET.WEIGHT
    CALL GET.VOLUME
    CALL GET.ALTITUDE

    CALL ATMOS
   
    A = VOLUME * RHOAMB
   
    GTEMPABS = A * TAMBABS / (A - WEIGHT)
   
    GASTEMP = FNC(GTEMPABS)

END SUB

SUB VREQUIRED STATIC

    ' Balloon volume required subroutine

    PRINT
   
    CALL GET.WEIGHT
    CALL GET.GASTEMP
    CALL GET.ALTITUDE
   
    CALL ATMOS
   
    VOLUME = WEIGHT / (RHOAMB * (1# - TAMBABS / GTEMPABS))

END SUB

SUB WFUNCTION (WF) STATIC

    ' Weight function subroutine

    CALL ATMOS

    WF = VOLUME * RHOAMB * (1# - TAMBABS / GTEMPABS) - WEIGHT

END SUB

