' Program "GLIDER"

' Copyright (C) 1982 by David Eagle

' IBM-PC  << QuickBASIC compiler, version 4.5 >>

' Determines maximum range and maximum endurance
' flight performance of gliders, sailplanes, etc.

'  glide speed, meters per second
'  glide angle, degrees
'  horizontal range, meters
'  rate-of-descent, meters per minute
'  lift-to-drag ratio, non-dimensional

'*********************************************************

DEFDBL A-Z

DECLARE SUB KEYCHECK ()
DECLARE SUB INTRO ()
DECLARE SUB PDATA (GANGLE, GSPEED, ROD, RANGE, LIFT, DRAG)

DEF FNRHO (X) = (1# - .000022556913# * X) ^ 4.256116#

CONST PI = 3.14159265#
CONST RHOSL = 1.22557#
CONST GRAVITY = 9.806649999999999#
CONST RTD = 180# / PI

'***********************************************************

CLS
LOCATE 5, 1
PRINT TAB(33); "Program GLIDER"
LOCATE 7, 1
PRINT TAB(24); "Copyright (C) 1982 by David Eagle"
LOCATE 11, 1
PRINT TAB(26); "Microsoft QuickBASIC Compiler"
PRINT TAB(18); "Copyright (C) Microsoft Corp. 1982...1988"

CALL KEYCHECK

DO
   CLS
   LOCATE 5, 1
   PRINT "Program introduction ( y = yes, n = no )"
   INPUT INTRODUCTION$
LOOP UNTIL INSTR("nNyY", INTRODUCTION$)

IF INSTR("yY", INTRODUCTION$) THEN CALL INTRO

DO
   CLS
   LOCATE 5, 1
   PRINT TAB(33); "Program GLIDER"
  
   DO
      PRINT
      PRINT
      PRINT "Please input the launch site altitude ( meters )"
      INPUT ALTSITE
   LOOP UNTIL ALTSITE >= 0#

   PRINT
   PRINT "Please input the launch site temperature ( degrees F )"
   INPUT TEMPSITE

   ' determine launch site ambient density

   RHOSITE = RHOSL * FNRHO(ALTSITE) / (1# + (TEMPSITE - 59#) / 518.67#)

   ' request user inputs

   DO
      CLS
      LOCATE 5, 1
      PRINT "Please input the initial flight altitude ( meters )"
      INPUT ALTITUDE
   LOOP UNTIL ALTITUDE > 0#

   DO
      PRINT
      PRINT "Please input the wingspan ( centimeters )"
      INPUT WINGSPAN
   LOOP UNTIL WINGSPAN > 0#

   WINGSPAN = .01# * WINGSPAN
  
   DO
      PRINT
      PRINT "Please input the wing area ( square centimeters )"
      INPUT WINGAREA
   LOOP UNTIL WINGAREA > 0#

   WINGAREA = .0001# * WINGAREA
  
   DO
      PRINT
      PRINT "Please input the mass ( grams )"
      INPUT MASS
   LOOP UNTIL MASS > 0#

   MASS = .001# * MASS
  
   DO
      PRINT
      PRINT "Please input the zero-lift drag coefficient ( non-dimensional )"
      INPUT CD0
   LOOP UNTIL CD0 >= 0#

   DO
      PRINT
      PRINT "Please input the efficiency factor ( non-dimensional )"
      INPUT EFACTOR
   LOOP UNTIL EFACTOR > 0#

   ' compute aspect ration, efficiency parameter, density and weight

   ASPECT = WINGSPAN * WINGSPAN / WINGAREA
   K1 = PI * ASPECT * EFACTOR
   RHO = RHOSITE * FNRHO(ALTITUDE)
   WEIGHT = GRAVITY * MASS

   ' determine maximum range flight conditions

   LIFT1 = SQR(CD0 * K1)
   DRAG1 = 2# * CD0
   GANGLE1 = ATN(DRAG1 / LIFT1)
   GSPEED1 = SQR(2# * WEIGHT * COS(GANGLE1) / (RHO * WINGAREA * LIFT1))
   ROD1 = GSPEED1 * SIN(GANGLE1)
   RANGE1 = ALTITUDE / TAN(GANGLE1)

   ' determine maximum endurance flight conditions

   LIFT2 = SQR(3# * K1 * CD0)
   DRAG2 = 4# * CD0
   GANGLE2 = ATN(DRAG2 / LIFT2)
   GSPEED2 = SQR(2# * WEIGHT * COS(GANGLE2) / (RHO * WINGAREA * LIFT2))
   ROD2 = GSPEED2 * SIN(GANGLE2)
   RANGE2 = ALTITUDE / TAN(GANGLE2)

   ' print results

   CLS
   PRINT
   PRINT
   PRINT TAB(25); "MAXIMUM RANGE GLIDE CONDITIONS"
   PRINT
   PRINT
   CALL PDATA(GANGLE1, GSPEED1, ROD1, RANGE1, LIFT1, DRAG1)

   CLS
   PRINT
   PRINT
   PRINT TAB(23); "MAXIMUM ENDURANCE GLIDE CONDITIONS"
   PRINT
   PRINT
   CALL PDATA(GANGLE2, GSPEED2, ROD2, RANGE2, LIFT2, DRAG2)

   ' request another selection

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection ( y = yes, n = no )"
      INPUT SELECTION$
   LOOP UNTIL INSTR("nNyY", SELECTION$)

LOOP UNTIL INSTR("nN", SELECTION$)

END

SUB INTRO STATIC

    ' Introduction subroutine

    CLS
    LOCATE 2, 1
    PRINT "     PROGRAM 'GLIDER' IS AN INTERACTIVE BASIC COMPUTER PROGRAM WHICH CAN BE USED";
    PRINT "TO DETERMINE BOTH THE MAXIMUM RANGE AND MAXIMUM ENDURANCE FLIGHT CONDITIONS FOR";
    PRINT "MODEL ROCKET BOOST GLIDERS. THESE ARE THE FLIGHT CONDITIONS WHEN THE GLIDER";
    PRINT "WILL FLY THE FARTHEST OR STAY IN THE AIR THE LONGEST TIME. THE 'GLIDER' SOFTWARE";
    PRINT "COMPENSATES FOR THE VARIATION IN DENSITY AT THE INITIAL GLIDE ALTITUDE AND 'NON-";
    PRINT "STANDARD' FLYING CONDITIONS SUCH AS HOT OR COLD DAYS OR FLYING SITES WHICH ARE";
    PRINT "NOT AT SEA LEVEL. THESE UNIQUE FEATURES WILL PROVIDE THE USER WITH AN ACCURATE";
    PRINT "PREDICTION OF THE MOTION OF GLIDERS."
    PRINT
    PRINT "     PROGRAM 'GLIDER' WILL PROMPT THE USER FOR SEVERAL INPUTS NECESSARY FOR THE";
    PRINT "SOFTWARE TO WORK PROPERLY. THIS IS A DESCRIPTION OF THESE REQUESTS AND A SHORT";
    PRINT "DISCUSSION OF HOW THE USER SHOULD RESPOND.";
    CALL KEYCHECK
   
    CLS
    PRINT
    PRINT "     LAUNCH SITE ALTITUDE ( METERS )"
    PRINT
    PRINT "THE USER RESPONSE SHOULD BE THE ALTITUDE AT THE FLYING SITE IN METERS. FLYING";
    PRINT "SITES ABOVE SEA LEVEL ARE POSITIVE AND THOSE BELOW SEA LEVEL ARE NEGATIVE."
    PRINT
    PRINT "     LAUNCH SITE TEMPERATURE ( DEGREES F )"
    PRINT
    PRINT "THE RESPONSE TO THIS REQUEST SHOULD BE THE TEMPERATURE AT THE FLYING SITE IN";
    PRINT "DEGREES FAHRENHEIT."
    PRINT
    PRINT "     FLIGHT ALTITUDE ( METERS )"
    PRINT
    PRINT "AT THIS POINT THE USER SHOULD INPUT THE INITIAL FLIGHT ALTITUDE OF THE GLIDER IN";
    PRINT "METERS. THIS IS THE ALTITUDE ABOVE THE FLYING SITE WHEN THE GLIDE BEGINS."
    PRINT
    PRINT "     WINGSPAN ( CENTIMETERS )"
    PRINT
    PRINT "THE USER SHOULD RESPOND WITH THE WINGSPAN OF THE GLIDER IN CENTIMETERS. THIS";
    PRINT "IS THE DISTANCE FROM WINGTIP TO WINGTIP."
    CALL KEYCHECK
   
    CLS
    PRINT
    PRINT "     WING AREA ( SQUARE CENTIMETERS )"
    PRINT
    PRINT "THE USER SHOULD INPUT THE WING AREA OF THE GLIDER IN SQUARE CENTIMETERS."
    PRINT
    PRINT "     MASS ( GRAMS )"
    PRINT
    PRINT "THE RESPONSE TO THIS REQUEST SHOULD BE THE MASS OF THE GLIDER IN GRAMS."
    PRINT
    PRINT "     ZERO-LIFT DRAG COEFFICIENT ( NON-DIMENSIONAL )"
    PRINT
    PRINT "THE USER SHOULD INPUT THE 'NO-LIFT' DRAG COEFFICIENT. THIS IS THE PLANFORM DRAG";
    PRINT "COEFFICIENT WHICH IS USUALLY DETERMINED FROM WIND TUNNEL TESTS. TYPICAL VALUES";
    PRINT "RANGE FROM .01 TO .05."
    PRINT
    PRINT "     EFFICIENCY FACTOR ( NON-DIMENSIONAL )"
    PRINT
    PRINT "THIS IS A NON-DIMENSIONAL NUMBER WHICH MUST BE DETERMINED FROM WIND TUNNEL TEST";
    PRINT "OR ESTIMATED NUMERICALLY. TYPICAL VALUES RANGE FROM .6 TO .9."
    CALL KEYCHECK
   
    CLS
    PRINT
    PRINT
    PRINT "     AFTER THE PROGRAM HAS RUN, IT WILL ASK THE USER FOR ANOTHER SELECTION. THE";
    PRINT "USER SHOULD RESPOND WITH 'Y' IF HE OR SHE DESIRES THE SELECTION OR 'N' IF NOT."
    PRINT
    PRINT "     ANOTHER SELECTION ( Y = YES, N = NO ) ?"
    PRINT
    PRINT "THE USER SHOULD RESPOND WITH 'N' TO EXIT THE PROGRAM."
    CALL KEYCHECK
   
    CLS
    PRINT
    PRINT "     PROGRAM 'GLIDER' OUTPUTS DATA ABOUT BOTH THE MAXIMUM RANGE AND MAXIMUM";
    PRINT "ENDURANCE FLIGHT CONDITIONS OF THE BOOST GLIDER. THIS INFORMATION INCLUDES THE";
    PRINT "GLIDE SPEED AND ANGLE, THE HORIZONTAL RANGE AND RATE-OF-DESCENT AND THE GLIDER";
    PRINT "LIFT-TO-DRAG RATIO. THE GLIDE SPEED IS PRINTED IN METERS PER SECOND AND THE";
    PRINT "RATE-OF-DESCENT IS IN METERS PER MINUTE. THE HORIZONTAL RANGE IS GIVEN IN METERS";
    PRINT "AND THE GLIDE ANGLE IS IN DEGREES. THE LIFT-TO-DRAG RATIO IS NON-DIMENSIONAL."
    PRINT
    PRINT "     FOR USERS WHO MAY WANT TO SEE OTHER VARIABLES COMPUTED BY THE SOFTWARE,";
    PRINT "'RHOSITE' IS THE AMBIENT DENSITY AT THE FLYING SITE AND 'RHO' IS THE DENSITY";
    PRINT "AT THE INITIAL FLIGHT ALTITUDE. THE ASPECT RATIO OF THE GLIDER IS COMPUTED IN";
    PRINT "THE VARIABLE 'ASPECT'.";
    CALL KEYCHECK

END SUB

SUB KEYCHECK STATIC

    ' Check user response subroutine

    LOCATE 25, 1
    PRINT TAB(25); "< press any key to continue >";

    A$ = ""
    WHILE A$ = ""
      A$ = INKEY$
    WEND

END SUB

SUB PDATA (GANGLE, GSPEED, ROD, RANGE, LIFT, DRAG) STATIC

    ' Print subroutine

    FORMAT$ = "##########.####"

    PRINT
    PRINT TAB(5); "Glide speed          ( meters per second )";
    PRINT USING FORMAT$; TAB(55); GSPEED
    PRINT
    PRINT TAB(5); "Glide angle          ( degrees )";
    PRINT USING FORMAT$; TAB(55); GANGLE * RTD
    PRINT
    PRINT
    PRINT TAB(5); "Horizontal range     ( meters )";
    PRINT USING FORMAT$; TAB(55); RANGE
    PRINT
    PRINT TAB(5); "Rate-of-descent      ( meters per minutes )";
    PRINT USING FORMAT$; TAB(55); 60# * ROD
    PRINT
    PRINT
    PRINT TAB(5); "Lift-to-Drag ratio   ( non-dimensional )";
    PRINT USING FORMAT$; TAB(55); LIFT / DRAG
    
    CALL KEYCHECK

END SUB

