' Program "ROCKET1"

' Copyright (C) 1982, 1994 by David Eagle

' IBM-PC  << QuickBASIC compiler, version 4.5 >>

' Determines flight performance of model rockets

'  altitude at burnout, meters
'  velocity at burnout, meters per second
'  coast time and total flight time, seconds
'  maximum altitude, meters

'********************************************************

DEFDBL A-Z

DECLARE FUNCTION DENSITY (X)

CONST PI = 3.14159265#
CONST GRAVITY = 9.806649999999999#
CONST RHOSL = 1.22557#

DO
   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program ROCKET1"
   LOCATE 7, 1
   PRINT TAB(20); "Copyright (C) 1982, 1994 by David Eagle"
   LOCATE 11, 1
   PRINT TAB(27); "Microsoft QuickBASIC Compiler"
   PRINT TAB(19); "Copyright (C) Microsoft Corp. 1982...1988"
   LOCATE 25, 1
   PRINT TAB(25); "< press any key to continue >";
  
   A$ = ""
   WHILE A$ = ""
      A$ = INKEY$
   WEND

   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program ROCKET1"

   DO
      PRINT
      PRINT
      PRINT "Please input the launch site altitude (meters)"
      PRINT "(sites above sea level are positive, sites below sea level are negative)"
      INPUT ALTSITE
   LOOP UNTIL (ABS(ALTSITE) >= 0#)

   PRINT
   PRINT "Please input the launch site temperature (degrees Fahrenheit)"
   INPUT TEMPSITE

   DO
      CLS
      LOCATE 5, 1
      PRINT "Please input the thrust duration (seconds)"
      INPUT TDURATION
   LOOP UNTIL TDURATION > 0#

   DO
      PRINT
      PRINT "Please input the total impulse (newton-seconds)"
      INPUT IMPULSE
   LOOP UNTIL IMPULSE > 0#

   DO
      PRINT
      PRINT "Please input the initial mass (grams)"
      INPUT MASSI
   LOOP UNTIL MASSI > 0#

   DO
      PRINT
      PRINT "Please input the propellant mass (grams)"
      INPUT MPROP
   LOOP UNTIL MPROP > 0#

   DO
      PRINT
      PRINT "Please input the frontal diameter (millimeters)"
      INPUT FD
   LOOP UNTIL FD > 0#

   DO
      PRINT
      PRINT "Please input the drag coefficient"
      INPUT CD
   LOOP UNTIL CD > 0#

   ' convert mass to kilograms and diameter to square meters

   MASSI = .001# * MASSI
   MPROP = .001# * MPROP
   FD = PI * FD * FD / 4000000#

   ' compensate for launch site altitude and temperature

   RHO = RHOSL * DENSITY(ALTSITE) / (1# + (TEMPSITE - 59#) / 518.67#)

   ' determine altitude performance

   THRUST = IMPULSE / TDURATION
   MASS = (MASSI - .5# * MPROP)
   K2 = .5# * RHO * FD * CD
   WEIGHT = MASS * GRAVITY

   B = TDURATION * SQR(K2 * (THRUST - WEIGHT)) / MASS
   C = EXP(B)
   D = EXP(-B)
   E = .5# * (C + D)
   F = (C - D) / (C + D)

   ' calculate burnout conditions

   ALTBO = (MASS / K2) * LOG(E)
   VELBO = F * SQR((THRUST - WEIGHT) / K2)
   MASSBO = MASSI - MPROP
   WEIGHTBO = MASSBO * GRAVITY

   ' compute coast conditions

   TCOAST = SQR(MASSBO / (K2 * GRAVITY)) * ATN(VELBO * SQR(K2 / WEIGHTBO))
   ALTCOAST = (MASSBO / (2# * K2)) * LOG(K2 * VELBO * VELBO / WEIGHTBO + 1#)

   ' calculate total flight time and maximum altitude

   TFLIGHT = TDURATION + TCOAST
   ALTMAX = ALTBO + ALTCOAST

   ' print results

   F1$ = "######.####"
  
   CLS
   LOCATE 3, 1
   PRINT TAB(32); "Program ROCKET1"

   LOCATE 6, 1
   PRINT TAB(10); "Burnout altitude   (meters)";
   PRINT USING F1$; TAB(58); ALTBO

   LOCATE 8, 1
   PRINT TAB(10); "Burnout velocity   (meters per second)";
   PRINT USING F1$; TAB(58); VELBO

   LOCATE 10, 1
   PRINT TAB(10); "Burnout mass       (grams)";
   PRINT USING F1$; TAB(58); 1000# * MASSBO

   LOCATE 13, 1
   PRINT TAB(10); "Coast time         (seconds)";
   PRINT USING F1$; TAB(58); TCOAST

   LOCATE 15, 1
   PRINT TAB(10); "Total flight time  (seconds)";
   PRINT USING F1$; TAB(58); TFLIGHT

   LOCATE 19, 1
   PRINT TAB(10); "Maximum altitude   (meters)";
   PRINT USING F1$; TAB(58); ALTMAX

   LOCATE 21, 1
   PRINT TAB(10); "Average thrust     (newtons)";
   PRINT USING F1$; TAB(58); THRUST

   LOCATE 25, 1
   PRINT TAB(25); "< press any key to continue >";
  
   A$ = ""
  
   WHILE A$ = ""
      A$ = INKEY$
   WEND

   ' request another selection

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection (y = yes, n = no)"
      INPUT SLCT$
      SLCT$ = UCASE$(SLCT$)
   LOOP UNTIL (SLCT$ = "Y" OR SLCT$ = "N")

LOOP UNTIL (SLCT$ = "N")

END

FUNCTION DENSITY (X) STATIC

    ' Atmospheric density function

    DENSITY = (1# - .000022556913# * X) ^ 4.256116#

END FUNCTION

