' Program "ROCKET2"

' Copyright (C) 1982 by David Eagle

' IBM-PC  << QuickBASIC compiler, version 4.5 >>

' Determines flight performance of model rockets

'  altitude at burnout               ( meters )
'  velocity at burnout               ( meters per second )
'  coast time and total flight time  ( seconds )
'  maximum altitude                  ( meters )

'********************************************************************

DEFDBL A-Z

DECLARE SUB KEYCHECK ()
DECLARE SUB INTEGRATE ()
DECLARE SUB PLMASS ()
DECLARE SUB PLTHRUST ()
DECLARE SUB PDATA ()
DECLARE SUB DIFFEQ ()

CONST PI = 3.141592653589793#
CONST GRAVITY = 9.806649999999999#
CONST RHOSL = 1.22557#
CONST DTR = PI / 180#
CONST RTD = 180# / PI

' Integrator coefficients

CONST A0 = .045#
CONST B0 = .3#
CONST C0 = 13# / 126#
CONST D0 = 5# / 18#
CONST E0 = 5# / 42#
CONST F0 = 7# / 600#
CONST G0 = 7# / 30#
CONST H0 = 7# / 15#
CONST I0 = 7# / 6#
CONST J0 = 25# / 63#
CONST K0 = .7#
CONST L0 = 19# / 78#
CONST M0 = 35# / 312#
CONST N0 = 15# / 104#
CONST O0 = 64# / 39#
CONST P0 = 70# / 39#
CONST Q0 = 15# / 13#

DIM SHARED D1(2), D2(2), D3(2), D4(2)
DIM SHARED ACC(2), XP(2), XS(2), VP(2), VS(2)

COMMON SHARED LANGLE, FLTFLG%, F5, MAXTHR, SUSTHR, VEX, VEX2
COMMON SHARED MASSI, MPROP, TT, TP, DT, TSUS, TMAX, TDUR, T6, T7
COMMON SHARED THRUST, MASS, DRAG, FFACTOR, TDELAY, FORMAT$

DEF FNA (X) = (1# - .000022556913# * X) ^ 4.256116#

FORMAT$ = "######.####"

'********************************************************************

CLS
LOCATE 5, 1
PRINT TAB(32); "Program ROCKET2"
LOCATE 7, 1
PRINT TAB(24); "Copyright (C) 1982 by David Eagle"
LOCATE 11, 1
PRINT TAB(26); "Microsoft QuickBASIC Compiler"
PRINT TAB(20); "Copyright (C) Microsoft Corp. 1982...1988"
TDELAY = 10
CALL KEYCHECK

DO
   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program ROCKET2"

   DO
      PRINT
      PRINT
      PRINT "Please input the launch site altitude ( meters )"
      INPUT ALTSITE
   LOOP UNTIL ALTSITE >= 0#

   DO
      PRINT
      PRINT "Please input the launch site temperature ( degrees F )"
      INPUT TEMPSITE
   LOOP UNTIL TEMPSITE >= 0#

   DO
      PRINT
      PRINT "Please input the maximum thrust ( newtons )"
      INPUT MAXTHR
   LOOP UNTIL MAXTHR > 0#

   DO
      PRINT
      PRINT "Please input the sustainer thrust ( newtons )"
      INPUT SUSTHR
   LOOP UNTIL SUSTHR > 0#

   DO
      PRINT
      PRINT "Please input the time of maximum thrust ( seconds )"
      INPUT TMAX
   LOOP UNTIL TMAX > 0#

   DO
      PRINT
      PRINT "Please input the time of sustainer thrust ( seconds )"
      INPUT TSUS
   LOOP UNTIL TSUS > 0#

   DO
      PRINT
      PRINT "Please input the thrust duration ( seconds )"
      INPUT TDUR
   LOOP UNTIL TDUR > 0#

   DO
      PRINT
      PRINT "Please input the initial mass ( grams )"
      INPUT MASSI
   LOOP UNTIL MASSI > 0#

   MASSI = .001# * MASSI

   DO
      PRINT
      PRINT "Please input the propellant mass ( grams )"
      INPUT MPROP
   LOOP UNTIL MPROP > 0#

   MPROP = .001# * MPROP

   DO
      PRINT
      PRINT "Please input the frontal diameter ( millimeters )"
      INPUT FDIA
   LOOP UNTIL FDIA > 0#

   FDIA = PI * FDIA * FDIA / 4000000#

   DO
      PRINT
      PRINT "Please input the drag coefficient"
     INPUT CD
   LOOP UNTIL CD > 0#

   DO
      PRINT
      PRINT "Please input the launch angle"
      PRINT "( degrees [ 0 to 90 ] - measured from the ground )"
      PRINT "( For example, a vertical launch is an angle of 90 degrees )"
      INPUT LANGLE
   LOOP UNTIL LANGLE >= 0# AND LANGLE <= 90#

   LANGLE = LANGLE * DTR

   DO
      PRINT
      PRINT "Please input the boost step size ( seconds )"
      PRINT "( a value of .01 seconds is recommended )"
      INPUT DTBOOST
   LOOP UNTIL DTBOOST > 0#

   DO
      PRINT
      PRINT "Please input the coast step size ( seconds )"
      PRINT "( a value of .1 seconds is recommended )"
     INPUT DTCOAST
   LOOP UNTIL DTCOAST > 0#

   DO
      CLS
      LOCATE 5, 1
      PRINT "Display results at each step ( y = yes, n = no )"
      INPUT PS$
   LOOP UNTIL INSTR("nNyY", PS$)

   CLS
   LOCATE 5, 1
   PRINT "Integrating equations of motion ...      Time ="

   ' compensate for launch site altitude and temperature

   RHOSITE = RHOSL * FNA(ALTSITE) / (1# + (TEMPSITE - 59#) / 518.67#)

   F5 = MAXTHR - SUSTHR
   FFACTOR = .5# * RHOSITE * FDIA * CD
   T6 = TSUS - TMAX

   ' calculate exhaust velocity

   VEX = (MAXTHR * .5# * TSUS + SUSTHR * (TDUR - .5# * TMAX - .5# * TSUS)) / MPROP
   VEX2 = 2# * VEX

   TP = 0#
   XP(1) = 0#
   XP(2) = 0#
   VP(1) = 0#
   VP(2) = 0#
   FLTFLG% = 0

   ' powered flight

   NP% = TDUR / DTBOOST
   DT = DTBOOST

   FOR I% = 1 TO NP%
       CALL INTEGRATE
       IF INSTR("nN", PS$) THEN
          LOCATE 5, 50
          PRINT USING FORMAT$; TP
       ELSE
          TT = TP
          CALL PLMASS
          CALL PLTHRUST
          TDELAY = 5
          CALL PDATA
       END IF
   NEXT I%

   ' burnout conditions

   XBO = XP(2)
   VBO = SQR(VP(1) ^ 2 + VP(2) ^ 2)

   ' coasting flight

   DT = DTCOAST
   FLTFLG% = 1

   WHILE VP(2) > 0#
      LOCATE 5, 50
      PRINT USING FORMAT$; TP
      CALL INTEGRATE
      IF INSTR("yY", PS$) THEN
         TT = TP
         CALL PLMASS
         CALL PLTHRUST
         TDELAY = 5
         CALL PDATA
      END IF
   WEND

   TCOAST = TP - TDUR

   ' print final conditions

   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program ROCKET2"
   PRINT
   PRINT
   PRINT TAB(10); "Burnout altitude   ( meters )";
   PRINT USING FORMAT$; TAB(55); XBO
   PRINT
   PRINT TAB(10); "Burnout velocity   ( meters per second )";
   PRINT USING FORMAT$; TAB(55); VBO
   PRINT
   PRINT
   PRINT TAB(10); "Coast time         ( seconds )";
   PRINT USING FORMAT$; TAB(55); TCOAST
   PRINT
   PRINT TAB(10); "Total flight time  ( seconds )";
   PRINT USING FORMAT$; TAB(55); TP
   PRINT
   PRINT
   PRINT TAB(10); "Maximum altitude   ( meters )";
   PRINT USING FORMAT$; TAB(55); XP(2)
   TDELAY = 10000
   CALL KEYCHECK

   ' request another selection

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection ( y = yes, n = no )"
      INPUT A$
   LOOP UNTIL INSTR("nNyY", A$)

LOOP UNTIL INSTR("nN", A$)

END

SUB DIFFEQ STATIC

    ' Equations of motion subroutine

    VMAG = SQR(VS(1) ^ 2 + VS(2) ^ 2)

    IF XP(2) < 1# THEN
       UVX = COS(LANGLE)
       UVY = SIN(LANGLE)
    ELSE
       UVX = VS(1) / VMAG
       UVY = VS(2) / VMAG
    END IF

    DRAG = VMAG ^ 2 * FFACTOR * FNA(XS(2))
    MASS = MASSI - MPROP
    THRUST = 0#

    IF FLTFLG% = 0 THEN
       T7 = TT - TMAX
       CALL PLMASS
       CALL PLTHRUST
    END IF

    TACC = (THRUST - DRAG) / MASS
    ACC(1) = TACC * UVX
    ACC(2) = TACC * UVY - GRAVITY

END SUB

SUB INTEGRATE STATIC

    ' Integration subroutine

    TT = TP

    FOR I% = 1 TO 2
        XS(I%) = XP(I%)
        VS(I%) = VP(I%)
    NEXT I%

    CALL DIFFEQ

    TT = TP + B0 * DT

    FOR I% = 1 TO 2
        D1(I%) = DT * ACC(I%)
        XS(I%) = XP(I%) + DT * (B0 * VP(I%) + A0 * D1(I%))
        VS(I%) = VP(I%) + B0 * D1(I%)
    NEXT I%

    CALL DIFFEQ

    TT = TP + K0 * DT

    FOR I% = 1 TO 2
        D2(I%) = DT * ACC(I%)
        XS(I%) = XP(I%) + DT * (K0 * VP(I%) + F0 * D1(I%) + G0 * D2(I%))
        VS(I%) = VP(I%) - H0 * D1(I%) + I0 * D2(I%)
    NEXT I%

    CALL DIFFEQ

    TT = TP + DT

    FOR I% = 1 TO 2
        D3(I%) = DT * ACC(I%)
        XS(I%) = XP(I%) + DT * (VP(I%) + L0 * D1(I%) + M0 * D2(I%) + N0 * D3(I%))
        VS(I%) = VP(I%) + O0 * D1(I%) - P0 * D2(I%) + Q0 * D3(I%)
    NEXT I%

    CALL DIFFEQ

    TP = TP + DT

    FOR I% = 1 TO 2
        D4(I%) = DT * ACC(I%)
        XP(I%) = XP(I%) + DT * (VP(I%) + C0 * D1(I%) + D0 * D2(I%) + E0 * D3(I%))
        VP(I%) = VP(I%) + C0 * (D1(I%) + D4(I%)) + J0 * (D2(I%) + D3(I%))
    NEXT I%

END SUB

SUB KEYCHECK STATIC

    ' Check user response subroutine

    LOCATE 25, 1
    PRINT TAB(25); "< press any key to continue >";

    A = TIMER
    B = TIMER + TDELAY
    A$ = ""

    WHILE (A$ = "" AND A < B)
       A = TIMER
       A$ = INKEY$
    WEND

END SUB

SUB PDATA STATIC

    ' Print subroutine

    VMAG = SQR(VP(1) ^ 2 + VP(2) ^ 2)
    RMAG = SQR(XP(1) ^ 2 + XP(2) ^ 2)

    FPA = RTD * ATN(VP(2) / VP(1))
    ACC = SGN(ACC(2)) * SQR(ACC(1) ^ 2 + ACC(2) ^ 2)

    CLS
    LOCATE 3, 1
    PRINT TAB(10); "Flight time        ( seconds )";
    PRINT USING FORMAT$; TAB(55); TP
    PRINT
    PRINT
    PRINT TAB(10); "Altitude           ( meters )";
    PRINT USING FORMAT$; TAB(55); XP(2)
    PRINT
    PRINT TAB(10); "Horizontal range   ( meters )";
    PRINT USING FORMAT$; TAB(55); XP(1)
    PRINT
    PRINT TAB(10); "Velocity           ( meters per second )";
    PRINT USING FORMAT$; TAB(55); VMAG
    PRINT
    PRINT TAB(10); "Flight path angle  ( degrees )";
    PRINT USING FORMAT$; TAB(55); FPA
    PRINT
    PRINT TAB(10); "Acceleration       ( meters/second/second )";
    PRINT USING FORMAT$; TAB(55); ACC
    PRINT
    PRINT
    PRINT TAB(10); "Mass               ( grams )";
    PRINT USING FORMAT$; TAB(55); 1000# * MASS
    PRINT
    PRINT TAB(10); "Thrust             ( newtons )";
    PRINT USING FORMAT$; TAB(55); THRUST
    PRINT
    PRINT TAB(10); "Drag               ( newtons )";
    PRINT USING FORMAT$; TAB(55); DRAG
    CALL KEYCHECK

    CLS

END SUB

SUB PLMASS STATIC

    ' Piecewise-linear mass subroutine

    IF TP <= TMAX THEN
       MASS = MASSI - MAXTHR * TT ^ 2 / (VEX2 * TMAX)
       EXIT SUB
    ELSEIF TP > TMAX AND TP <= TSUS THEN
       MASS = MASSI - (MAXTHR / VEX) * (TT - .5# * TMAX) + F5 * T7 ^ 2 / (VEX2 * T6)
       EXIT SUB
    ELSEIF TP > TSUS AND TP < TDUR THEN
       MASS = MASSI - (MAXTHR * TSUS + SUSTHR * T6) / VEX2 - (SUSTHR / VEX) * (TT - TSUS)
       EXIT SUB
    ELSEIF TP >= TDUR THEN
       MASS = MASSI - MPROP
       EXIT SUB
    END IF

END SUB

SUB PLTHRUST STATIC

    ' Piecewise-linear thrust subroutine

    IF TP <= TMAX THEN
       THRUST = MAXTHR * TT / TMAX
       EXIT SUB
    ELSEIF (TP > TMAX AND TP <= TSUS) THEN
       THRUST = MAXTHR - F5 * (TT - TMAX) / T6
       EXIT SUB
    ELSEIF (TP > TSUS AND TP < TDUR) THEN
       THRUST = SUSTHR
       EXIT SUB
    ELSEIF TP >= TDUR THEN
       THRUST = 0#
       EXIT SUB
    END IF

END SUB

