' Program "ROCKET3"

' Copyright (C) 1987 By David Eagle

' IBM-PC  << QuickBASIC compiler, version 4.5 >>

' For a given model rocket engine and aerodynamic characteristics,
' this program determines the optimal launch mass of a model rocket
' which maximizes total altitude ( Bengen's maxima )

'**************************************************************

DEFDBL A-Z

DECLARE SUB KEYCHECK ()
DECLARE SUB MNBRAK (AX, BX, CX)
DECLARE SUB BRENT (AX, BX, CX, TOL, XMIN, FMIN)
DECLARE SUB EVALUATE (MASSI, ALTMAX)

CONST PI = 3.141592654#
CONST GRAVITY = 9.806649999999999#
CONST RHOSL = 1.22557#

COMMON SHARED RHO, TDURATION, IMPULSE, MPROP, FD, CD
COMMON SHARED ALTBO, VELBO, MASSBO, WEIGHTBO
COMMON SHARED TCOAST, ALTCOAST, TFLIGHT

DEF FNA (X) = (1# - .000022556913# * X) ^ 4.256116#

'**************************************************************

DO
   CLS
   LOCATE 5, 1
   PRINT TAB(32); "Program ROCKET3"
   LOCATE 7, 1
   PRINT TAB(23); "Copyright (C) 1987 by David Eagle"
   LOCATE 11, 1
   PRINT TAB(25); "Microsoft QuickBASIC Compiler"
   PRINT TAB(20); "Copyright (C) Microsoft Corp. 1982...1988"
   CALL KEYCHECK

   CLS
   PRINT
   PRINT TAB(32); "Program ROCKET3"
 
   DO
      PRINT
      PRINT
      PRINT "Launch site altitude ( meters )"
      INPUT ALTSITE
   LOOP UNTIL ALTSITE >= 0#
  
   PRINT
   PRINT "Launch site temperature ( degrees Fahrenheit )"
   INPUT TEMPSITE
  
   DO
      PRINT
      PRINT "Thrust duration ( seconds )"
      INPUT TDURATION
   LOOP UNTIL TDURATION > 0#
  
   DO
      PRINT
      PRINT "Total impulse ( newton-seconds )"
      INPUT IMPULSE
   LOOP UNTIL IMPULSE > 0#
  
   DO
      PRINT
      PRINT "Propellant mass ( grams )"
      INPUT MPROP
   LOOP UNTIL MPROP > 0#
  
   DO
      PRINT
      PRINT "Frontal diameter ( millimeters )"
      INPUT FD
   LOOP UNTIL FD > 0#
  
   DO
      PRINT
      PRINT "Drag coefficient ( non-dimensional )"
      INPUT CD
   LOOP UNTIL CD > 0#

   ' convert mass to kilograms and diameter to square meters

   MPROP = .001# * MPROP
   FD = PI * FD ^ 2 / 4000000#

   ' compensate for launch site altitude and temperature

   RHO = RHOSL * FNA(ALTSITE) / (1# + (TEMPSITE - 59#) / 518.67#)

   ' determine best launch mass

   M1 = 1.001# * MPROP
   M2 = 2# * MPROP

   CALL MNBRAK(M1, M2, M3)

   CALL BRENT(M1, M2, M3, .00000001#, MASSI, ALTMAX)

   ' print results

   FORMAT$ = "######.####"

   CLS
   PRINT
   PRINT TAB(32); "Program ROCKET3"
   PRINT
   PRINT
   PRINT TAB(10); "Initial mass       ( grams )";
   PRINT USING FORMAT$; TAB(55); 1000# * MASSI
   PRINT
   PRINT
   PRINT TAB(10); "Burnout altitude   ( meters )";
   PRINT USING FORMAT$; TAB(55); ALTBO
   PRINT
   PRINT TAB(10); "Burnout velocity   ( meters per second )";
   PRINT USING FORMAT$; TAB(55); VELBO
   PRINT
   PRINT TAB(10); "Burnout mass       ( grams )";
   PRINT USING FORMAT$; TAB(55); 1000# * MASSBO
   PRINT
   PRINT
   PRINT TAB(10); "Coast time         ( seconds )";
   PRINT USING FORMAT$; TAB(55); TCOAST
   PRINT
   PRINT TAB(10); "Total flight time  ( seconds )";
   PRINT USING FORMAT$; TAB(55); TFLIGHT
   PRINT
   PRINT
   PRINT TAB(10); "Maximum altitude   ( meters )";
   PRINT USING FORMAT$; TAB(55); -ALTMAX
   CALL KEYCHECK

   ' request another selection

   DO
      CLS
      LOCATE 5, 1
      PRINT "Another selection ( y = yes, n = no )"
      INPUT SELECTION$
   LOOP UNTIL INSTR("nNyY", SELECTION$)

LOOP UNTIL INSTR("nN", SELECTION$)

END

SUB BRENT (AX, BX, CX, TOL, XMIN, FMIN) STATIC

    ' Brent's method minimizing subroutine

    CGOLD = .381966#
    ZEPS = .0000000001#

    A = AX
    IF CX < AX THEN A = CX

    B = AX
    IF CX > AX THEN B = CX

    V = BX
    W = V
    X = V
    E = 0#

    CALL EVALUATE(X, FX)

    FV = FX
    FW = FX

    FOR ITER% = 1 TO 100

        XM = .5# * (A + B)
        TOL1 = TOL * ABS(X) + ZEPS
        TOL2 = 2# * TOL1

        IF ABS(X - XM) <= (TOL2 - .5# * (B - A)) THEN
           XMIN = X
           FMIN = FX
           EXIT FOR
        END IF

        IF ABS(E) > TOL1 THEN
           R = (X - W) * (FX - FV)
           Q = (X - V) * (FX - FW)
           P = (X - V) * Q - (X - W) * R
           Q = 2# * (Q - R)
           IF Q > 0# THEN P = -P
           Q = ABS(Q)
           ETEMP = E
           E = D
        END IF

        IF (ABS(P) >= ABS(.5# * Q * ETEMP) OR P <= Q * (A - X) OR P >= Q * (B - X)) THEN

           IF X >= XM THEN
              E = A - X
           ELSE
              E = B - X
           END IF

           D = CGOLD * E
        ELSE
           D = P / Q
           U = X + D
           IF (U - A < TOL2 OR B - U < TOL2) THEN D = SGN(XM - X) * TOL1
        END IF

        IF ABS(D) >= TOL1 THEN
           U = X + D
        ELSE
           U = X + SGN(D) * TOL1
        END IF

        CALL EVALUATE(U, FU)

        IF FU <= FX THEN
           IF U >= X THEN
              A = X
           ELSE
              B = X
           END IF
           V = W
           FV = FW
           W = X
           FW = FX
           X = U
           FX = FU
        ELSE
           IF U < X THEN
              A = U
           ELSE
              B = U
           END IF

           IF (FU <= FW OR W = X) THEN
              V = W
              FV = FW
              W = U
              FW = FU
           ELSEIF (FU <= FV OR V = X OR V = W) THEN
              V = U
              FV = FU
           END IF

        END IF

    NEXT ITER%

END SUB

SUB EVALUATE (MASSI, ALTMAX) STATIC

    ' Calculate maximum altitude subroutine

    THRUST = IMPULSE / TDURATION
    MASS = MASSI - .5# * MPROP
    K2 = .5# * RHO * FD * CD
    WEIGHT = MASS * GRAVITY

    B = TDURATION * SQR(K2 * (THRUST - WEIGHT)) / MASS
    C = EXP(B)
    D = EXP(-B)
    E = .5# * (C + D)
    F = (C - D) / (C + D)

    ' burnout conditions

    ALTBO = (MASS / K2) * LOG(E)
    VELBO = F * SQR((THRUST - WEIGHT) / K2)
    MASSBO = MASSI - MPROP
    WEIGHTBO = MASSBO * GRAVITY

    ' coast conditions

    TCOAST = SQR(MASSBO / (K2 * GRAVITY)) * ATN(VELBO * SQR(K2 / WEIGHTBO))

    ALTCOAST = (MASSBO / (2# * K2)) * LOG(K2 * VELBO * VELBO / WEIGHTBO + 1#)

    ' flight time and maximum altitude

    TFLIGHT = TDURATION + TCOAST
    ALTMAX = -(ALTBO + ALTCOAST)

END SUB

SUB KEYCHECK STATIC

   ' CHECK USER RESPONSE SUBROUTINE

   LOCATE 25, 1
   PRINT TAB(25); "< press any key to continue >";

   A$ = ""
   WHILE A$ = ""
     A$ = INKEY$
   WEND

END SUB

SUB MNBRAK (AX, BX, CX) STATIC

    ' Bracket the minima of a function subroutine

    GOLD = 1.618034#
    GLIMIT = 10#

    CALL EVALUATE(AX, FA)

    CALL EVALUATE(BX, FB)

    DO WHILE FB > FA
       AX = BX
       BX = BX + .01#
       CALL EVALUATE(AX, FA)
       CALL EVALUATE(BX, FB)
    LOOP

    CX = BX + GOLD * (BX - AX)

    CALL EVALUATE(CX, FC)

    DO WHILE (FB >= FC)
       R = (BX - AX) * (FB - FC)
       Q = (BX - CX) * (FB - FA)
       MAX = 9.999999999999999D-21
       IF ABS(Q - R) > MAX THEN MAX = ABS(Q - R)
       U = BX - ((BX - CX) * Q - (BX - AX) * R) / (2# * SGN(Q - R) * MAX)
       ULIM = BX + GLIMIT * (CX - BX)

       IF ((BX - U) * (U - CX)) > 0# THEN

          CALL EVALUATE(U, FU)

          IF FU < FC THEN
             AX = BX
             FA = FB
             BX = U
             FB = FU
             EXIT DO
          ELSEIF FU > FB THEN
             CX = U
             FC = FU
             EXIT DO
          END IF

          U = CX + GOLD * (CX - BX)
          CALL EVALUATE(U, FU)

       ELSEIF ((CX - U) * (U - ULIM)) > 0# THEN

          CALL EVALUATE(U, FU)

          IF FU < FC THEN
             BX = CX
             CX = U
             U = CX + GOLD * (CX - BX)
             FB = FC
             FC = FU
             CALL EVALUATE(U, FU)
          END IF

       ELSEIF ((U - ULIM) * (ULIM - CX)) >= 0# THEN

          U = ULIM
          CALL EVALUATE(U, FU)

       ELSE

          U = CX + GOLD * (CX - BX)
          CALL EVALUATE(U, FU)

       END IF

       AX = BX
       BX = CX
       CX = U
       FA = FB
       FB = FC
       FC = FU
    LOOP

END SUB

