program Brainscape;
{written by W. Jeffrey Wilson & lynne ostergren,
            Department of Psychological Sciences,
            Indiana University - Purdue University at Fort Wayne,
            2101 Coliseum Boulevard East,
            Fort Wayne, IN  46805.
copyright, 1985 by Purdue Research Foundation, West Lafayette, Indiana 47907.
                    All Rights Reserved.  Unmodified copies of this program
                    may be freely distributed.  Each copy must contain this
                    notice.}

{Version 1.2: created 1/23/86}

const
   MoveList = ' GO RUN WAL CLI DOR D VEN V LAT L MED M ROS R CAU C ';
   GetList  = ' GET PIC GRA TAK STE ';
   ManipList= ' OPE CLO UNL LOC LIF STA SPR REA LOO EXA EAT SWA THR ';
   EatList  = '{ EAT} DRI TAS CON ';
   LookList = '  ';
   PutList  = ' PUT DRO LEA ';
   InvList  = ' INV I ';
   ScoreList= ' SCO ';
   SaveList = ' SAV ';
   RestoreList = ' RES ';
   HelpList = ' HEL ';
   QuitList = ' QUI ';
   ItemsToGet=
' ZIP DA  DOP NE  NOR NA  ACH ACE SER 5HT GAB VES PUR PYR PIL GOL STA VIA OLI BOT GRO HOR KEY PAP SCR ANT CEL GLA ALL ';
   Adj = 'Adjoining Room to the ';

type
   CommandTypes = (None, Move, Get, Put, Eat, Look, Manip, Inventory,
                   ReportScore, Save, Restore, Help, Quit, HomuncPestered);
   Directions = (D, V, L, M, R, C);
   RoomTypes =
    (LateralVentricle, ThirdVentricle, CerebralAqueduct, FourthVentricle,
    Foramen, SubArachnoid, CaudateHead, CaudateTail, Putamen, Pallidum,
    Nigra, InternalCapsule, CerebralPeduncle, NigroStriatalBundle,
    Thalamus, Pons, Medulla, Raphe, LateralLemniscus, VentralNoradBundle,
    InferiorColliculus, MedialGeniculate, TrapezoidBody, PeriAqueductalGray,
    AuditoryCx, SuprachiasmNuc, Pituitary, Pyramids, CingulateGyrus,
    OpticTract, OpticChiasm, LateralGeniculate, SuperiorColliculus,
    OpticRadiation, VisualCx, Amygdala, Septum, MammillaryBody, Hippocampus,
    Fornix, VMN, LHA, SensoryStrip, MotorStrip, FrontalLobe, Brocas,
    Wernickes, AssocCx, Accumbens, Cerebellum, Assoc1, Assoc2, Assoc3,
    Assoc4, Assoc5, NoWhere, NotYet, Question);
   Ventricle = LateralVentricle..Foramen;
   Objects = (Nothing, DA, NE, ACh, SER, GABA, VesDA, VesNE, VesACh, Ves5HT,
              VesGABA, PurkinjeCell, PyramidalCell, Pill, GolgiStain, Oligodendrocyte,
              GrowthHormone, Key, Scrap, Glass);
   Dungeon = record
              Name : string[40];
              AdjRoom : array [Directions] of RoomTypes;
              Item : array [DA..Glass] of Boolean;
              Visited : Boolean;
             end;
   RoomArray = array[LateralVentricle..Assoc5] of Dungeon;
   ObjDesc = array[Objects] of string[80];
   GameSave = record
               Map: RoomArray;
               LocCurrent : RoomTypes;
               Carrying: array[Objects] of Boolean;
               CurrentScore : integer;
               GhostStained : Boolean;
               BoxLocked : Boolean;
               StuffStolen : Boolean;
               GolgiHere : Boolean;
               ThiefTime : integer;
               HomuncTime : integer;
               HomuncStays : integer;
               PillWork : integer;
               GrowingBig : integer;
               ObjectsCurrent : ObjDesc;
               EscapeCurrent : string[4];
              end;

const
   TimeCommand : array[Ventricle] of string[3] =
                 ('med','cau','cau','cau','cau');
   ObjectDescription : ObjDesc =
        ('nothing','dopamine','norepinephrine','acetylcholine','serotonin',
         'GABA','a vesicle that once           contained dopamine','a noradrenergic vesicle',
         'a vesicle with traces of      acetylcholine on it','a serotonergic vesicle',
         'a vesicle for GABA','a Purkinje cell','a pyramidal cell',
         'an anti-immune system pill','a delicate crystal vial with   a faded label',
         'a large oligodendrocyte','a bottle labeled "Growth      Hormone: Promotes growth      and strength"',
         'a rusty key','a scrap of paper','broken glass');
   ThiefLair : RoomTypes = Accumbens;
   ChestLoc : RoomTypes = Accumbens;
   EscapeKey : string[3] = 'RL';
   Escape : string[3] = '   ';
   LoadLimit : integer = 5;
   Load : 0..5 = 0;
   LastObject : Objects = Glass;

var
   Command : string[40];
   Answer : string[40];
   RightAnswers : string[40];
   CommandDupe : string[25];
   NounDupe : string[25];
   Verb : string[5];
   Noun : string[5];
   Cmd : CommandTypes;
   index : 0..24;
   Loc, Loc1: RoomTypes;
   DungeonFile : file of RoomArray;
   GameFile : GameSave;
   SaveFile : file of GameSave;
   Dir : Directions;
   Object : Objects;
   ItemsGotten : array[Objects] of Boolean;
   HaveSomething : Boolean;
   TimeForThief : 0..maxint;
   HomunculusTime : 0..maxint;
   HomunculusStays : 0..maxint;
   ItemsStolen : Boolean;
   ThiefHere : Boolean;
   TotalScore, RoomScore, ExtraScore : integer;
   GolgiStained : Boolean;
   ChestLocked : Boolean;
   PillWorking : 0..10;
   Growing : 0..9;
   ContentsShown : Boolean;
   WrongAnswer : Boolean;
   CursorX : 1..80;
   CursorY : 1..25;
   inkey : char;

procedure ShowInventory; forward;

procedure CalculateScore; forward;

procedure PrintScore; forward;

procedure SaveCursor; forward;

procedure RestoreCursor; forward;

{$I MapFile.pas}
{$I Frame}

procedure MemoryExam;
var
   value : integer;

begin
   clrscr;
   value := Mem[$F000 : $FFFE];
   if value = 253 then
      TextMode(C80);
   value := Mem[$0000 : $0449];
   if value <> 7 then
      TextMode(BW80);
end;

procedure Randomize;{Seeds random # generator}
var
   i,j : integer;
begin
   i := 0;
   j := 0;
   writeln;
   TextColor(Yellow + 16);
   writeln('                       --- Press "I" for Introduction ---');
   write  ('                           --- Press "G" for Game ---');
   while not keypressed do
      begin
         i := i + 13;
         j := j + 17;
         if i > 32000 then i := 0;
         if j > 32000 then j := 0;
      end;
   MemW[DSeg:$0129]:= i;
   MemW[DSeg:$012B]:= j;
   Read(kbd,inkey);
   inkey := UpCase(inkey);
   clrscr;
end;

procedure PressKey;
begin
   writeln;
   write('                     --- Press space bar to continue. ---');
   repeat
      read(kbd,inkey);
   until inkey <> '';
   clrscr;
end;

procedure ClearFrame;
begin
   window(1,1,80,25);
   GotoXY(1,13);
   write(chr(179));
   GotoXY(80,13);
   write(chr(179));
   GotoXY(50,24);
   write(chr(196));
   window(2,2,79,23);
   clrscr;
end;

procedure TitleEnd;
begin
   delay(5000);
   writeln;
   Randomize;
   TextBackground(Black);
   TextColor(Yellow);
   clrscr;
end;

overlay procedure TitlePage;
var
   Title1,Title2,Title3,Title4,Title5,Title6,Title7 : string[80];
begin
   TextBackground(Black);
   TextColor(Yellow);
   clrscr;
   GotoXY(1,2);
Title1:='   ####### ####### ###### ##### #    # ###### ###### ###### ####### ######  ##';
Title2:='    #    #  #    # #    #   #   ##   # #      #      #    #  #    # #       ##';
Title3:='    #    #  #    # #    #   #   ###  # #      #      #    #  #    # #       ##';
Title4:='    ######  ###### ######   #   # ## # ###### #      ######  ###### ####    ##';
Title5:='    #    #  # #    #    #   #   #  ###      # #      #    #  #      #       ##';
Title6:='    #    #  #  #   #    #   #   #   ##      # #      #    #  #      #       ';
Title7:='   ####### ###  ## #    # ##### #    # ###### ###### #    # ###     ######  ##';
      for CursorX := 1 to Length(Title1) do
         if Title1[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
      for CursorX := 1 to Length(Title2) do
         if Title2[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
      for CursorX := 1 to Length(Title3) do
         if Title3[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
      for CursorX := 1 to Length(Title4) do
         if Title4[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
      for CursorX := 1 to Length(Title5) do
         if Title5[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
      for CursorX := 1 to Length(Title6) do
         if Title6[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
      for CursorX := 1 to Length(Title7) do
         if Title7[CursorX] = '#' then
            write(chr(219))
         else
            write(' ');
      writeln;
   writeln;

writeln('                       --- An Adventure in Neuroanatomy ---');
writeln;
writeln('                                        by');
writeln('                                W. Jeffrey Wilson');
writeln('                                        &');
writeln('                                 lynne ostergren');
   writeln;
writeln('                     Indiana University - Purdue University');
writeln('                                  at Fort Wayne');
   writeln;
writeln('   Copyright 1985, Purdue Research Foundation. All Rights Reserved.  Unmodified');
writeln('   copies of this program may be freely made and distributed.  This notice must');
write  ('   appear on each copy.')
end;

overlay procedure Introduction;
begin
   window(2,2,79,23);
   clrscr;
   writeln('   Having stayed up late last night studying for your upcoming Neuroanatomy');
   writeln('exam, you slept fitfully, and awake none too refreshed.  At the foot of');
   writeln('your bed you find a shrouded figure, wizened and gray, speaking to you with');
   writeln('a distinct Old French accent.  "Bonjour.  Je m'+chr(39)+'appelle Rene Descartes.  O!');
   writeln('Pardonez-moi!  Hello, Forgive me.  I am Rene Descartes," the figure says.');
   writeln('"For years I have pondered the mysteries of the Mind-Brain problem, and I');
   writeln('am now convinced that the only way to solve this philosophical impasse is to');
   writeln('enter the brain itself and have a look around.  A mechanism by which this is');
   writeln('possible has occurred to me, but I myself am too old and frail for such a');
   writeln('trying journey.  You, however, a promising student of Neuroanatomy, and far');
   writeln('younger than I, are ideal for the adventure."');
   PressKey;
   writeln('   Convinced that Descartes is nothing more than an aftereffect of the');
   writeln('pepperoni pizza that saw you through your long hours of study last night,');
   writeln('you head for the shower.  Descartes awaits you there, beckoning from the');
   writeln('steamy stall, and you join him.');
   writeln('   "LISTEN CLOSELY AND REMEMBER MY WORDS!" he booms through the hot spray');
   writeln('of water.  "I am giving you two pills.  Take one now, and you will be safe');
   writeln('from the phagocytes and white blood cells of the immune system during your');
   writeln('journey through the blood supply to the brain.  Be sure to swallow the other');
   writeln('one before leaving the brain to journey back to the heart, where I can');
   writeln('rescue you.  REMEMBER... If you enter your bloodstream without having first');
   writeln('taken the pill, you will surely not survive!"');
   PressKey;
   writeln('   Concerned now that a figment of your imagination is soaping your back,');
   writeln('you turn to confront Descartes.  His gaze pierces you, and he continues.');
   writeln('   "Once you reach the brain you will be safe from most physical harm, as');
   writeln('long as you remain there.  You will undoubtedly be confronted with problems');
   writeln('of many kinds.  In every case, your knowledge of Neuroanatomy and your');
   writeln('uncommon good sense will provide a solution.  Persevere!  No problem is');
   writeln('insurmountable."');
   PressKey;
   writeln('   You realize now that he is serious, and figment or not, you may well');
   writeln('soon find yourself on your way to your own brain!  You begin to pay closer');
   writeln('attention to what Descartes has to say.');
   writeln('   "You can move in any of the six anatomical directions:');
   writeln('                  Rostral: toward the head,');
   writeln('                   Caudal: toward the tail,');
   writeln('                   Medial: toward the midline,');
   writeln('                  Lateral: toward the side,');
   writeln('                   Dorsal: toward the top, or back,');
   writeln('              and Ventral: toward the bottom, or stomach."');
   PressKey;
   writeln('   "Indicate your intentions with two-word phrases, such as '+chr(39)+'Go Rostral'+chr(39)+',');
   writeln(chr(39)+'Get dendrite'+chr(39)+', or '+chr(39)+'Drop myelin'+chr(39)+'.  (Movement commands can be abbreviated');
   writeln('by typing only the first letter of the direction in which you wish to move.)');
   writeln('Several other commands might prove useful:');
   writeln('         Inventory:  Show what you are carrying,');
   writeln('             Score:  Indicate your current score,');
   writeln('              Save:  Save the current game on disk,');
   writeln('           Restore:  Restore the last saved game from disk,');
   writeln('          and Quit:  Leave the current game."');
   PressKey;
   writeln('   Through a process that you could never hope to understand, Descartes has');
   writeln('reduced you to a very small size, and is about to place you in your own');
   writeln('carotid artery for the journey to the brain.');
   writeln('   "To gain the most knowledge from this adventure, enter every area of the');
   writeln('brain that you can.  Find the treasures of the brain, and bring them back');
   writeln('to me.  Solve the problems that confront you.  And be absolutely certain');
   writeln('that you bring back some growth hormone, for without it I am powerless to');
   writeln('return you to your normal size, and you will remain miniscule forever."');
   PressKey;
   writeln('   "The anti-immune system pill has taken effect," Descartes assures you,');
   writeln('as he injects you into your carotid artery, "so you wll be safe from the');
   writeln('phagocytes.  Enjoy this journey, and learn much from it!"');
   PressKey;
end;

overlay procedure BloodToBrain;
begin
   window(2,2,79,23);
   writeln('   Still reeling with excitement, you ponder your situation.  You are now in ');
   writeln('your own carotid artery, coursing toward your brain!  You feel the surge of');
   writeln('each heart beat as you are driven closer to your encounter with the very');
   writeln('essence of yourself.');
   PressKey;
   writeln;
   writeln('   Neuroanatomical terms occupy your thoughts during this, the most exciting');
   writeln('journey of your life....');
   writeln;
   writeln('   Rostral, Caudal, Ventral, Dorsal, Lateral, Medial!');
   writeln;
   writeln('If only you had paid more attention during that Neuro lecture!');
   PressKey;
   writeln;
   writeln('   The blood flows rapidly.  You pass through the circle of Willis and find');
   writeln('yourself... Yes! in the choroid plexus of the lateral ventricle!');
   PressKey;
   writeln('   With some of the blood plasma, you leave the choroid plexus and enter');
   writeln('the lateral ventricle itself.');
   PressKey;
   clrscr;
end;

overlay procedure ReturnToHeart;
begin
   ClearFrame;
   writeln('   From the Subarachnoid space you are swept through an arachnoid granulation');
   writeln('and into the venous system through which blood leaves the brain.');
if PillWorking > 0 then begin
   ExtraScore := ExtraScore + 50;
   writeln('White blood cells gather hungrily around you, but you are protected from');
   writeln('them by the powerful medication provided by Descartes.');
   PressKey;
   writeln('   You find yourself in the jugular vein, leaving the head');
   writeln('and coursing back toward the heart.  Fear grips you as you wonder whether or');
   writeln('not you will be rescued by Descartes before the contractions of the heart ');
   writeln('crush you.');
   PressKey;
   writeln('Descartes appears, just in time to save you.');
   writeln('"What treasures of the brain have you brought me?," he asks.  You dutifully');
   write('reveal that ');
   ShowInventory;
   if not ItemsGotten[GrowthHormone] and (Growing = 0) then begin
      writeln('"Without growth hormone, you will remain tiny for the rest of your');
      writeln('life," Descartes moans.  "There is nothing I can do!"');
      end else begin
      writeln('"Marvelous! You found the growth hormone! Now you can return to your');
      writeln('normal size!" Descartes cries with relief.');
      end;
   CalculateScore;
   Case TotalScore of
   0..200: begin
   writeln('"Your score is only ',TotalScore,'.  I expected so much from you, and I am');
   writeln('sorely disappointed", he sighs.  "To have been so close to a full');
   writeln('understanding of the brain, and to have failed!  I shall return to my');
   writeln('studies, and hope that, in the future, someone else will succeed in');
   writeln('uncovering the knowledge that lies in the brain.  This is my ultimate dream."');
   end;
   201..400: begin
   writeln('"Your score is ',TotalScore,'.  You are only beginning to discover what ');
   writeln('awaits you within your head.  You should try to learn more of the mysteries');
   writeln('of the brain."');
   end;
   401..600: begin
   writeln('"Good! A score of ',TotalScore,'!  You have made considerable progress toward');
   writeln('furthering your knowledge of the brain.  However, you have much more to');
   writeln('learn."');
   end;
   601..800: begin
   writeln('"Very good!  You have scored ',TotalScore,'!  This score indicates that your');
   writeln('knowledge of the brain has grown considerably, but there is still more');
   writeln('to be learned.  Try again!  Explore further!"');
   end;
   801..1000: begin
   writeln('"',TotalScore,' points! A remarkable achievement!  You are nearing a complete');
   writeln('understanding of the brain!  Persevere!  There are still some aspects of');
   writeln('the brain to be discovered.  I am quite certain that you are capable of');
   writeln('a most complete exploration."');
   end;
   1001..1140: begin
   writeln('"You are approaching perfection!  ',TotalScore,' points! You are so very close');
   writeln('to a perfect score of 1150 points.  Try again. I know that this score is');
   writeln('within your reach."');
   end;
   else begin
   writeln('"A perfect score of ',TotalScore,'!  Never have I seen such an achievement!');
   writeln('You have learned more about the brain than I knew in my day, and more than');
   writeln('many people know today.  Congratulations on this most wonderous');
   writeln('accomplishment!"');
   end
   end;
   PressKey;
   clrscr;
   writeln('He is gone.');
   delay(3000);
   Verb := ' QUI ';
end
else begin
   writeln('Unprotected by the anti-immune system pill, you are quickly engulfed by');
   writeln('white blood cells.  Your final thought is of the knowledge you gained in');
   writeln('this adventure, and of how foolish you were not to use it.');
   CalculateScore;
   writeln('Your score is ',TotalScore,'.');
   PressKey;
   Verb := ' QUI ';
end;
end;

overlay procedure WakeUp;
begin
   writeln;
   writeln('     You awaken to the sound of the alarm clock, your head spinning with ');
   writeln('neuroanatomical terminology.  Rather than feeling refreshed, you feel oddly');
   writeln('as if the night had been spent in deep concentration.  No time to dwell on');
   writeln('that now.  You',chr(39),'ve got to get ready for that neuroanatomy exam....');
   writeln;
   delay(5000);
   PressKey;
   window(1,1,80,25);
end;

procedure ShowContents;
begin
   if not ContentsShown then
      begin
         SaveCursor;
         window(51,14,79,23);
         clrscr;
         writeln('Items that you see:');
         for Object := DA to LastObject do
               if Room[Loc].Item[Object] then
                  writeln(ObjectDescription[Object]);
         ContentsShown := True;
         RestoreCursor;
      end;
end;

procedure CalculateLoad;
var
   Object : DA..Glass;
begin
   Load := 0;
   for Object := DA to LastObject do
      if ItemsGotten[Object] then
         Load := Load + 1;
end;

{$I Rmdesc.pas}

procedure CorrectAnswer;
var
   index : integer;
begin
   index := 0;
   WrongAnswer := False;
   HomunculusStays := 0;
   clrscr;
   writeln('That is absolutely correct!  Because you');
   writeln('knew the answer, you will be transported to...');
   delay(3000);
   repeat
      index := index + 1;
      Loc := RoomTypes(random(50));
   until ((Loc > CaudateTail) and (Loc <> Accumbens) and (Loc <> Amygdala) and
         (Loc <> Pyramids) and (Loc <> Pituitary) and (Loc <> VisualCx) and
         (Loc <> TrapezoidBody) and (not Room[Loc].Visited)) or (index = 1200);
   if index = 1200 then
      repeat
         Loc := RoomTypes(random(50));
      until (Loc > CaudateTail) and (Loc <> Accumbens) and (Loc <> Amygdala) and
            (Loc <> Pyramids) and (Loc <> Pituitary) and (Loc <> VisualCx) and
            (Loc <> TrapezoidBody);
   clrscr;
end;

procedure IncorrectAnswer;
begin
   clrscr;
   writeln('That is wrong!');
   if WrongAnswer then begin
      writeln('Descartes appears, quite disappointed.');
      writeln('"Two wrong answers in a row.  You have clearly');
      writeln('not yet mastered the material.  You are hereby');
      writeln('banished to the pineal body - yes, the very');
      writeln('seat of the soul - where you must forever');
      writeln('contemplate the brain in all of its wonder.');
      CalculateScore;
      writeln('You have scored a total of ',TotalScore,' points."');
      Verb := ' QUI ';
      WrongAnswer := False;
      write('    Press Space Bar to Continue.');
      read(kbd,inkey);
      Loc := Loc1
   end else begin
      WrongAnswer := True;
      writeln('You will have one more chance to answer a');
      writeln('question correctly, or face being banished to');
      writeln('the pineal body by Descartes!');
      end;
end;

{$I Question.pas}

procedure RoomWindow;
begin
   window(2,2,79,12);
   clrscr;
end;

procedure CommentWindow;
begin
   window(2,14,49,23);
   clrscr;
end;

procedure SaveCursor;
begin
   window(2,14,49,23);
   CursorX := WhereX;
   CursorY := WhereY;
end;

procedure RestoreCursor;
begin
   window(2,14,49,23);
   GotoXY(CursorX,CursorY);
end;

procedure RestoreCursorTwo;
begin
   window(2,14,49,23);
   CursorX := 1;
   CursorY := 3;
   GotoXY(CursorX,CursorY);
end;

procedure LongDescription;
begin
   RoomDescriptionsOne;
   if Loc = ChestLoc then begin
writeln('There is an old wooden chest attached to the wall here.  It has ornately');
writeln('carved wooden doors, and a big, rusty padlock.');
   end;
   ContentsShown := False;
   ShowContents;
end;

procedure ThiefFound;
begin
   if ItemsStolen and (Loc = ThiefLair) then
      ThiefHere := True
   else
      ThiefHere := False;
end;

procedure DescribeRoom;
begin
   SaveCursor;
   RoomWindow;
   Write('You are in ');
   if (Loc = Wernickes) or (Loc = Brocas) then
      writeln(Room[Loc].Name,'.')
   else
      writeln('the ',Room[Loc].Name,'.');
   LongDescription;
   ThiefFound;
   if ThiefHere then
      begin
         window(2,2,79,12);
         GotoXY(1,7);
         writeln;
         writeln('You have found the lair of Golgi'+chr(39)+'s ghost!');
         writeln('He is cowering in a corner, muttering about this invasion of his sanctuary!');
      end;
   if not Room[Loc].Visited then
      begin
         Room[Loc].Visited := True;
         if Loc = SensoryStrip then begin
            window(2,2,79,12);
            GotoXY(1,7);
            writeln;
            writeln('There is a small, oddly shaped man here.  He has a huge mouth, gigantic');
            writeln('hands, and a tiny torso.  He is eyeing you with interest.');
            writeln('It is a Homunculus!');
            HomunculusStays := 2 + Random(8);
            HomunculusTime := 30 + Random(30);
         end;
      end;
   ShowContents;
   RestoreCursor;
end;

procedure TimerCommand;

var
   inkey : char;
   timer : real;
   timeout : real;

begin
   timer := 0;
   timeout := 30000;
   command := '';
   inkey := ' ';
   write('What do you want to do? ');
   repeat
      timer := timer + 1.0;
      if keypressed then begin
            read(kbd,inkey);
               case inkey of
                  #8,#27:begin
                     delete(command, length(command),1);
                     GotoXY(WhereX-1,WhereY);
                     write(' ');
                     GotoXY(WhereX-1,WhereY);
                     end;
                  #13: inkey := #13;
                  else begin
                     write(inkey);
                     command := command + inkey;
                       end
               end;
         end;
   until (timer >= timeout) or ((inkey = #13) and (length(command)>0) and (command[ord(command[0])]<>' '));
   writeln;
   if timer = timeout then
      Command := TimeCommand[Loc]
end;

procedure GetCommand;
begin
   window(2,14,49,23);
   GotoXY(1,1);
   clreol;
   if Loc < SubArachnoid then
      TimerCommand
   else
      repeat
         write('What do you want to do? ');
         readln(Command);
      until (ord(Command[0]) <> 0) and (Command[ord(Command[0])] <> ' ');
   while Command[1] = ' ' do
      delete (Command, 1, 1);
   for index := 1 to ord(Command[0]) do
      Command[index] := UpCase(Command[index]);
   CommandDupe := Command + ' ';
   if pos(' ',CommandDupe) > 3 then
         delete(CommandDupe, 4, 24)
      else
         delete(CommandDupe, pos(' ',CommandDupe), 24);
   Verb := ' ' + CommandDupe + ' ';
   CommandDupe := Command + ' ';
   Noun := '';
   while CommandDupe[1] <> ' ' do
      delete (CommandDupe, 1, 1);
   if length(CommandDupe) > 1 then
      while CommandDupe[1] = ' ' do
         delete (CommandDupe, 1, 1);
   NounDupe := CommandDupe;
   if pos(' ',CommandDupe) > 3 then
         delete(CommandDupe, 4, 24)
      else
         delete(CommandDupe, pos(' ',CommandDupe), 24);
   Noun := ' ' + CommandDupe + ' ';
end;

procedure Interpret;
begin
   CommentWindow;
   writeln;
   writeln;
   Cmd := None;
   if pos(Verb, MoveList) > 0 then
     begin
      Cmd := Move;
      if pos(Verb, MoveList) > 15 then
         Noun := Verb;
     end;
   if pos(Verb, GetList) > 0 then
      Cmd := Get;
   if pos(Verb, PutList) > 0 then
      Cmd := Put;
   if pos(Verb, ManipList) > 0 then
      Cmd := Manip;
   if pos(Verb,EatList) > 0 then
      Cmd := Eat;
   if pos(Verb, LookList) > 0 then
      Cmd := Look;
   if pos(Verb, InvList) > 0 then
      Cmd := Inventory;
   if pos(Verb, ScoreList) > 0 then
      Cmd := ReportScore;
   if pos(Verb, SaveList) > 0 then
      Cmd := Save;
   if pos(Verb, RestoreList) > 0 then
      Cmd := Restore;
   if pos(Verb, HelpList) > 0 then
      Cmd := Help;
   if pos(Verb, QuitList) > 0 then
      Cmd := Quit;
   if Noun = ' HOM ' then
      Cmd := HomuncPestered;
   if not(Cmd in[Inventory, ReportScore, Save, Restore, Help, Quit]) then begin
      if Cmd = None then
         case random(5) of
            0: writeln('I do not understand the verb "',Verb,'".');
            1: writeln('That makes no sense at all!');
            2: writeln('I do not know how to ',Command,'.');
            3: writeln('What are you, Nuts?');
            4: writeln('"',Command,'" is not in my vocabulary.')
         end
      else
         if Noun = '  ' then begin
            writeln('Indicate what you want to ',Command,'.');
            Cmd := None;
         end;
   end;
end;

procedure MovePlayer;
begin
   Loc1 := Loc;
   if (Noun = ' D ') or (Noun = ' DOR ') then
      Loc := Room[Loc].AdjRoom[D]
   else
   if (Noun = ' V ') or (Noun = ' VEN ') then
      Loc := Room[Loc].AdjRoom[V]
   else
   if (Noun = ' L ') or (Noun = ' LAT ') then
      Loc := Room[Loc].AdjRoom[L]
   else
   if (Noun = ' M ') or (Noun = ' MED ') then
      Loc := Room[Loc].AdjRoom[M]
   else
   if (Noun = ' R ') or (Noun = ' ROS ') then
      Loc := Room[Loc].AdjRoom[R]
   else
   if (Noun = ' C ') or (Noun = ' CAU ') then
      Loc := Room[Loc].AdjRoom[C];
   if Loc in [Assoc1..Assoc5] then
      begin
         Escape := Escape + Copy(Noun,2,1);
         Delete(Escape,1,1);
         if Escape = EscapeKey then
            begin
               Loc := FrontalLobe;
               Escape := '   ';
            end;
      end;
   if (Loc = Amygdala) and (Loc1 = CaudateTail) then begin
      RoomWindow;
      writeln('You have lost your footing, and are slipping down the long, twisting tail');
      writeln('of the caudate nucleus....');
      delay(5000);
   end;
   if Loc = NoWhere then
      begin
         writeln;
         case random(5) of
            0: writeln('You can not move that way!');
            1: writeln('Moving',Noun,'from here is impossible.');
            2: writeln('Should I make my own door?');
            3: writeln('You try to move',Noun,',but you bruise your nose.');
            4: writeln('You cannot move through solid matter.')
         end;
         Loc := Loc1;
      end;
   if Loc = NotYet then
      case Loc1 of
         NigrostriatalBundle: if ItemsGotten[DA] then
                                Loc := CaudateHead
                              else begin
                                writeln;
                                writeln('You need dopamine to go that way.');
                                Loc := Loc1;
                              end;
         VentralNoradBundle : if ItemsGotten[NE] then
                                Loc := Thalamus
                              else begin
                                writeln;
                                writeln('You need norepinephrine to go that way.');
                                Loc := Loc1;
                              end;
         Septum, Hippocampus: begin
                                 writeln;
                                 writeln('You cannot pass that way... Yet!');
                                 Loc := Loc1;
                              end;
      end;
   if Loc = Question then
      PoseQuestion;
   if (Loc = Foramen) and (HomunculusStays > 0) then
      HomunculusStays := 1;
   if Loc = SubArachnoid then
      begin
         DescribeRoom;
         Delay(5000);
         ReturnToHeart;
         Loc := Loc1;
      end;
   if (Loc <> Loc1) and (TimeForThief < 2) and GolgiStained then
      TimeForThief := 10 + random(30);
   if Loc <> Loc1 then
      begin
         ContentsShown := False;
         RoomWindow;
         DescribeRoom;
      end;
end;

procedure IdentifyVesicle;
var
   VesiclePresent : boolean;
   MoreThanOne : Boolean;
   Response : char;

begin
   VesiclePresent := False;
   MoreThanOne := False;
   Response := ' ';
if Cmd = Get then begin
   for Object := VesDA to VesGABA do
      begin
         if Room[Loc].Item[Object] then
           begin
            if VesiclePresent then
               MoreThanOne := True
            else
               VesiclePresent := True;
           end;
      end;
   if not VesiclePresent then
      Object := VesDA
   else
      if MoreThanOne then
        begin
         Object := GABA;
         repeat
            Object := succ(Object);
            if Object = PurkinjeCell then
               Object := VesDA;
            if Room[Loc].Item[Object] then
               begin
                  writeln('Do you mean ',ObjectDescription[Object],'? (y/n)');
                  readln(Response);
               end;
         until (Response = 'y') or (Response = 'Y');
        end
      else
        begin
         Object := GABA;
         repeat
            Object := succ(Object);
         until Room[Loc].Item[Object];
        end;
 end
else
if Cmd = Put then begin
 for Object := VesDA to VesGABA do
      begin
         if ItemsGotten[Object] then
           begin
            if VesiclePresent then
               MoreThanOne := True
            else
               VesiclePresent := True;
           end;
      end;
   if not VesiclePresent then
      Object := VesDA
   else
      if MoreThanOne then
        begin
         Object := GABA;
         repeat
            Object := succ(Object);
            if Object = PurkinjeCell then
               Object := VesDA;
            if ItemsGotten[Object] then
               begin
                  writeln('Do you mean ',ObjectDescription[Object],'? (y/n)');
                  readln(Response);
               end;
         until (Response = 'y') or (Response = 'Y');
        end
      else
        begin
         Object := GABA;
         repeat
            Object := succ(Object);
         until ItemsGotten[Object];
        end;
 end;
end;

procedure IdentifyCell;
begin
   if Cmd = Get then begin
      if Room[Loc].Item[PyramidalCell] then
         Object := PyramidalCell
      else
      if Room[Loc].Item[PurkinjeCell] then
         Object := PurkinjeCell
      else
      if Room[Loc].Item[Oligodendrocyte] then
         Object := Oligodendrocyte;
   end;
   if Cmd = Put then begin
      if ItemsGotten[PyramidalCell] then
         Object := PyramidalCell
      else
      if ItemsGotten[PurkinjeCell] then
         Object := PurkinjeCell
      else
      if ItemsGotten[Oligodendrocyte] then
         Object := Oligodendrocyte;
   end;
end;

procedure IdentifyObject;
begin
   Object := Nothing;
   Index := pos(Noun,ItemsToGet);
   case Index of
      5,9:      Object := DA;
      13,17,21: Object := NE;
      25,29:    Object := ACh;
      33,37:    Object := SER;
      41:       Object := GABA;
      45:       IdentifyVesicle;
      49:       Object := PurkinjeCell;
      53:       Object := PyramidalCell;
      57, 101:  Object := Pill;
      61,65,69: Object := GolgiStain;
      73:       Object := Oligodendrocyte;
      77,81,85: Object := GrowthHormone;
      89:       Object := Key;
      93,97:    Object := Scrap;
      105:      IdentifyCell;
      109:      Object := Glass
   end;
end;

procedure GetDA;
begin
   if ItemsGotten[VesDA] or (ObjectDescription[VesDA] = '') then
      begin
         ItemsGotten[DA] := True;
         Room[Loc].Item[DA] := False;
         writeln('Dopamine taken.');
         ObjectDescription[DA] := 'dopamine in a vesicle';
         ObjectDescription[VesDA] := '';
         ItemsGotten[VesDA] := False;
      end
   else
      writeln('You have nothing to put it in.');
end;

procedure GetNE;
begin
   if ItemsGotten[VesNE] or (ObjectDescription[VesNE] = '') then
      begin
         ItemsGotten[NE] := True;
         Room[Loc].Item[NE] := False;
         writeln('Norepinephrine taken.');
         ObjectDescription[NE] := 'norepinephrine in a vesicle';
         ObjectDescription[VesNE] := '';
         ItemsGotten[VesNE] := False;
      end
   else
      writeln('You have nothing to put it in.');
end;

procedure GetACh;
begin
   if ItemsGotten[VesACh] or (ObjectDescription[VesACh] = '') then
      begin
         ItemsGotten[ACh] := True;
         Room[Loc].Item[ACh] := False;
         writeln('Acetylcholine taken.');
         ObjectDescription[ACh] := 'acetylcholine in a vesicle';
         ObjectDescription[VesACh] := '';
         ItemsGotten[VesACh] := False;
      end
   else
      writeln('You have nothing to put it in.');
end;

procedure GetSer;
begin
   if ItemsGotten[Ves5HT] or (ObjectDescription[Ves5HT] = '') then
      begin
         ItemsGotten[SER] := True;
         Room[Loc].Item[SER] := False;
         writeln('Serotonin taken.');
         ObjectDescription[SER] := 'serotonin in a vesicle';
         ObjectDescription[Ves5HT] := '';
         ItemsGotten[Ves5HT] := False;
      end
   else
      writeln('You have nothing to put it in.');
end;

procedure GetGABA;
begin
   if ItemsGotten[VesGABA] or (ObjectDescription[VesGABA] = '') then
      begin
         ItemsGotten[GABA] := True;
         Room[Loc].Item[GABA] := False;
         writeln('GABA taken.');
         ObjectDescription[GABA] := 'GABA in a vesicle';
         ObjectDescription[VesGABA] := '';
         ItemsGotten[VesGABA] := False;
      end
   else
      writeln('You have nothing to put it in.');
end;

procedure RenameVesicle;
begin
   case Object of
      VesDA : ObjectDescription[Object] := 'a dopaminergic vesicle';
      VesNE : ObjectDescription[Object] := 'a noradrenergic vesicle';
      Ves5HT: ObjectDescription[Object] := 'a serotonergic vesicle';
      VesAch: ObjectDescription[Object] := 'a cholinergic vesicle';
      VesGABA:ObjectDescription[Object] := 'a GABAergic vesicle';
      GrowthHormone:ObjectDescription[Object] := 'growth hormone';
      GolgiStain: if pos('o',ObjectDescription[Object])=0 then
                     ObjectDescription[Object] :=
                     'a fragile vial with an old label'
   end;
end;

procedure GetItem;
begin
   writeln;
   if pos(Noun,ItemsToGet) > 0 then
      begin
         if Noun = ' ALL ' then
            begin
               ContentsShown := False;
               RestoreCursorTwo;
               for Object :=DA to LastObject do
                  if Room[Loc].Item[Object] then
                     begin
                        if Load < LoadLimit then
                           begin
                              case Object of
                                 DA: GetDA;
                                 NE: GetNE;
                                ACh: GetACh;
                                SER: GetSer;
                               GABA: GetGABA
                              else
                                 begin
                                    ItemsGotten[Object] := True;
                                    Room[Loc].Item[Object] := False;
                                    RenameVesicle;
                                    writeln (ObjectDescription[Object],' taken.');
                                    CalculateLoad;
                                 end;
                              end;
                           end
                        else
                           begin
                              writeln('You cannot carry any more!');
                              Object := LastObject;
                           end;
                     end;
            end
         else
            begin
               IdentifyObject;
               if (Object in [DA, NE, ACh, SER, GABA])
                and (length(NounDupe)>13)
                and Room[Loc].Item[Objects(Ord(Object)+5)] then
                  Object := Objects(Ord(Object)+5);
               if not Room[Loc].Item[Object] then
                  writeln('I do not see a ', NounDupe,'here.')
               else
                  begin
                     if Load < LoadLimit then
                        begin
                           ContentsShown := False;
                           RestoreCursorTwo;
                           case Object of
                              DA: GetDA;
                              NE: GetNE;
                              ACh: GetACh;
                              SER: GetSer;
                              GABA: GetGABA
                              else
                                 begin
                                    ItemsGotten[Object] := True;
                                    Room[Loc].Item[Object] := False;
                                    RenameVesicle;
                                    writeln (NounDupe,' taken.');
                                    CalculateLoad;
                                 end;
                              end;
                        end
                     else
                        writeln('You cannot carry anything else!');
                  end;
            end;
      ShowContents;
      end
   else
      case random(5) of
         0: writeln('I do not know how to get a ',NounDupe,'.');
         1: writeln('What a novel idea!');
         2: writeln('You must be joking!');
         3: writeln(NounDupe,'! How can I get a ',NounDupe,'?');
         4: writeln('Get it yourself!')
      end;
end;

procedure PutItem;
begin
   writeln;
   if pos(Noun,ItemsToGet) > 0 then
    begin
     if Noun = ' ALL ' then
        begin
         ContentsShown := False;
         RestoreCursorTwo;
         for Object := DA to LastObject do
            if ItemsGotten[Object] then
               begin
                  writeln(ObjectDescription[Object],' dropped.');
                  Room[Loc].Item[Object] := True;
                  if (Object = GolgiStain) and (Loc > Foramen) then
                     begin
                        writeln('The crystal shatters as it hits the floor!');
                        Room[Loc].Item[Glass] := True;
                        Room[Loc].Item[GolgiStain] := False;
                  end;
                  ItemsGotten[Object] := False;
                  if Loc < Foramen then
                     begin
                        Room[Loc].Item[Object] := False;
                        Room[Foramen].Item[Object] := True;
                        writeln('...And carried away by the flow of the');
                        writeln('cerebrospinal fluid!');
                     end;
               end;
         end
     else
      begin
         IdentifyObject;
         if (Object in [DA, NE, ACh, SER, GABA])
                and (length(NounDupe)>13)
                and ItemsGotten[Objects(Ord(Object)+5)] then
                  Object := Objects(Ord(Object)+5);
         if not ItemsGotten[Object] then begin
            writeln('I cannot put down the ',NounDupe);
            writeln('if I do not have it!');
            end
         else
         begin
            ContentsShown := False;
            RestoreCursorTwo;
            ItemsGotten[Object] := False;
            Room[Loc].Item[Object] := True;
            writeln(NounDupe,' dropped.');
            if (Object = GolgiStain) and (Loc > Foramen) then begin
               writeln('The crystal shatters as it hits the floor!');
               Room[Loc].Item[GolgiStain] := False;
               Room[Loc].Item[Glass] := True;
            end;
            if Loc < Foramen then
               begin
                  Room[Loc].Item[Object] := False;
                  Room[Foramen].Item[Object] := True;
                  writeln('The flow of cerebrospinal fluid carries off the');
                  writeln(NounDupe);
               end;
         end;
      end;
     ShowContents;
     end
   else
      writeln('I cannot put down the ',NounDupe,'.');
end;

procedure HomuncLeavesSensStrip;
begin
   if Loc = SensoryStrip then
      begin
         window(2,7,79,12);
         clrscr;
         window(2,14,49,23);
         GotoXY(1,3);
      end;
end;

procedure ManipulateItem;
begin
   writeln;
   if (Verb = ' UNL ') and (Loc = ChestLoc) and (Noun = ' CHE ') then
    begin
      if ItemsGotten[Key] then begin
         writeln('The padlock opens readily!');
         ChestLocked := False;
         end
      else
         writeln('You do not have a key!');
    end
   else
   if (Verb = ' OPE ') and (Loc = ChestLoc) and (Noun = ' CHE ') then
    begin
      if ChestLocked then
         writeln('The chest is locked!')
      else begin
         writeln('Opening the chest reveals a vial.');
         writeln('The label is old and yellowed.');
         Room[Loc].Item[GolgiStain] := True;
         ContentsShown := False;
         ShowContents;
         RestoreCursorTwo;
      end;
    end
   else
   if (Verb = ' REA ') and ((Noun = ' LAB ') or (Noun = ' VIA '))
           and (ItemsGotten[Golgistain] or Room[Loc].Item[GolgiStain]) then
      begin
         writeln('You can barely make out the faded characters.');
         writeln('               "ACME Golgi Stain');
         writeln('        for silver impregnation of cells"');
         writeln('           (and cantankerous ghosts!)"');
         if pos('via',ObjectDescription[GolgiStain])>0 then
            ObjectDescription[GolgiStain] := 'a vial of Golgi Stain';
         ContentsShown := False;
         ShowContents;
      end
   else
   if ((Verb = ' REA ') or (Verb = ' LOO ') or (Verb = ' EXA '))
      and ((Noun = ' PAP ') or (Noun = ' SCR ')) and ItemsGotten[Scrap] then
      begin
         writeln('     "We hope you are enjoying BRAINSCAPE!');
         writeln('Please send comments, suggestions, or pleas');
         writeln('for help to:');
         writeln;
         writeln('   W. Jeffrey Wilson, Ph.D.');
         writeln('   Dept. of Psychological Sciences');
         writeln('   Indiana University-Purdue University');
         writeln('   Fort Wayne, IN  46805"');
      end
   else
   if (Verb = ' LOO ') or (Verb = ' EXA ') then
      writeln('I see nothing special about the ',NounDupe)
   else
   if ((Verb = ' STA ') or (Verb = ' SPR ') or (Verb = ' THR '))
         and ((Noun = ' GHO ') or (Noun = ' GOL ')or (Noun = ' STA ')
         or (Noun = ' VIA '))
         and ItemsGotten[GolgiStain]
         and (Loc = ThiefLair) and (ItemsStolen) then
      begin
       if (Verb = ' THR ') and (Noun = ' VIA ') then begin
          ItemsGotten[GolgiStain] := False;
          Room[Loc].Item[Glass] := True;
          ContentsShown := False;
          writeln('The crystal shatters against the ghost!');
          ShowContents;
       end;
       if not GolgiStained then begin
         writeln('Golgi'+chr(39)+'s Ghost shrieks in terror as he is doused');
         writeln('by the stain.  He begins to glow, and the eerie');
         writeln('silver light fills the air.');
         GolgiStained := True;
         ExtraScore := ExtraScore + 100;
       end else begin
         writeln('The wretched fellow has already been stained!');
       end;
      end
   else
   if ((Verb = ' EAT ') or (Verb = ' SWA ')) then
      if (Noun = ' PIL ') then
         if ItemsGotten[Pill] then
           begin
             ItemsGotten[Pill] := False;
             PillWorking := 10;
             writeln('Mmmm... Suddenly you feel very protected.');
           end
         else
            writeln('You do not have a pill.')
      else if (Noun = ' GRO ') or (Noun = ' HOR ') then
         if ItemsGotten[GrowthHormone] then
            begin
               ItemsGotten[GrowthHormone] := False;
               ExtraScore := ExtraScore + 100;
               Growing := 1;
               if HomunculusStays > 0 then
                  writeln('The Homunculus scurries off, startled!');
               HomuncLeavesSensStrip;
               HomunculusStays := 0;
               writeln('Mmmm... you suddenly feel quite a bit stronger.');
            end
         else
            writeln('You do not have any ',NounDupe,'.')
      else
         writeln('What a revolting idea!!')
   else
      writeln('You cannot do that... yet.');
end;

procedure Thief;
begin
   if (TimeForThief = 0) and (Loc <> ThiefLair) then
      begin
         GotoXY(1,5);
         writeln('===============================================');
         writeln('Golgi'+chr(39)+'s Ghost appears, seemingly from nowhere!');
         writeln('"If you want to live, give me your treasures!"');
         HaveSomething := False;
         for Object := DA to LastObject do
            begin
               Room[ThiefLair].Item[Object] :=
                          ItemsGotten[Object] or Room[ThiefLair].Item[Object];
               if ItemsGotten[Object] = True then
                  begin
                     HaveSomething := True;
                     ItemsStolen := True;
                  end;
               ItemsGotten[Object] := False;
            end;
         if not HaveSomething then
            write('"Nothing for me this time?  ');
         if HaveSomething then
            write('  "');
         writeln('I shall return!"');
         writeln('He is gone, as mysteriously as he appeared!');
         write('===============================================');
         TimeForThief := 40 + random(30);
      end
   else
   if (TimeForThief < 3) and GolgiStained and (Loc <> ThiefLair) then
      begin
         GotoXY(1,7);
         writeln('-----------------------------------------------');
         writeln('An eerie silver aura begins to fill the room.');
         writeln('Its source is unclear.');
         write('-----------------------------------------------');
         TimeForThief := TimeForThief -1;
      end
   else
   if Loc <> ThiefLair then
      TimeForThief := TimeForThief - 1;
end;

procedure PillWearsOff;
begin
   if PillWorking >0 then
      begin
         PillWorking := PillWorking - 1;
         if PillWorking = 0 then
            begin
               GotoXY(1,7);
               writeln(
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
               writeln('You feel somehow less protected than you did a');
               writeln('moment ago.');
               write(
'!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
            end;
      end;
end;

procedure Homunculus;
begin
   if (Room[SensoryStrip].Visited) and (TimeForThief <> 0)
   and (Growing = 0) and (Loc > SubArachnoid) then
      HomunculusTime := HomunculusTime - 1;
   if HomunculusStays > 0 then begin
      GotoXY(1,2);
      HomunculusStays := HomunculusStays - 1;
      if HomunculusStays > 0 then
         writeln('There is a Homunculus with you!')
      else begin
         GotoXY(1,8);
         writeln('Losing interest in you, the Homunculus wanders');
         writeln('away, scratching his small head with a very');
         write('large finger.');
         HomuncLeavesSensStrip;
         end;
   end else
   if (HomunculusTime = 0) then begin
      GotoXY(1,8);
      writeln('The Homunculus has returned.  He is grinning');
      writeln('widely, and seems very interested in what');
      write('you are doing.');
      HomunculusStays := 2 + Random(8);
      HomunculusTime := 30 + Random(30);
   end;
end;

procedure HomuncLeaves;
begin
   if HomunculusStays > 0 then begin
      HomunculusStays := 0;
      case Random(6) of
         0:begin
              writeln('Insulted by this action, the Homunculus sneers');
              writeln('at you and walks away!');
           end;
         1:begin
              writeln('The Homunculus shrieks with terror as you');
              writeln('attempt this, and runs away!');
           end;
         2:begin
              writeln('Before you can try it, the Homunculus scurries');
              writeln('out of reach, and disappears!');
           end;
         3:begin
              writeln('Only a fool tries that with a Homunculus!');
              writeln('Fortunately for you, the Homunculus chooses');
              writeln('this moment to wander off.');
           end;
         4:begin
              writeln('This amuses the Homunculus to no end!  His');
              writeln('laughter echoes loudly as he leaves you.');
           end;
         5:begin
              writeln('For some unknown reason, the Homunculus finds');
              writeln('this threatening, and heads for safety.');
           end
      end;
      HomuncLeavesSensStrip;
   end else
      writeln('The Homunculus is not here!');
end;

procedure GrowingBig;
begin
   if (Growing > 0) and (Verb <> ' QUI ') then
      begin
         GotoXY(1,7);
         Growing := Growing + 1;
         LoadLimit := LoadLimit + Growing;
         writeln('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
         case Growing of
            1..4:begin
                  writeln('Things are happening inside of you.  You are ');
                  writeln('feeling much stronger, and could carry more.');
                  write('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
                 end;
            5..8:begin
                  writeln('You are getting larger. Soon you will be too');
                  writeln('big to move, but your strength is incredible!');
                  write('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!');
                 end;
            9:begin
                 ClearFrame;
writeln('You can no longer move, as the growth hormone has taken effect.  You are');
writeln('crushing the surrounding tissue!');
delay(5000);
writeln;
writeln('You have now grown to fill the space within the skull, and find it quite');
writeln('difficult to breathe!');
delay(5000);
writeln;
writeln('Unable to breathe, you suffocate inside of your own skull!  Descartes arrives,');
writeln('too late to help, and simply shakes his head in despair.');
delay(5000);
CalculateScore;
writeln('As you die, Descartes informs you that your score is ',TotalScore,', and laments');
writeln('the fact that you would have learned more and scored higher if only you had');
writeln('lived.');
Verb := ' QUI ';
              end
         end;
      end;
end;

procedure ShowInventory;
begin
   Writeln;
   Writeln('You are carrying:');
   HaveSomething := False;
   for Object := DA to LastObject do
         if ItemsGotten[Object] then
            begin
               Writeln('        ',ObjectDescription[Object]);
               HaveSomething := True;
            end;
   if not HaveSomething then
      writeln('         NOTHING!');
end;

procedure SaveGame;
begin
   writeln;
   writeln('This will erase previously saved game!');
   write('Are you sure you want to do this? ');
   readln(Command);
   if pos(Command,'YES Yes yes')>0 then begin
      GameFile.Map := Room;
      GameFile.LocCurrent := Loc;
      GameFile.Carrying := ItemsGotten;
      GameFile.CurrentScore := ExtraScore;
      GameFile.GhostStained := GolgiStained;
      GameFile.BoxLocked := ChestLocked;
      GameFile.StuffStolen := ItemsStolen;
      GameFile.GolgiHere := ThiefHere;
      GameFile.ThiefTime := TimeForThief;
      GameFile.HomuncTime := HomunculusTime;
      GameFile.HomuncStays := HomunculusStays;
      GameFile.PillWork := PillWorking;
      GameFile.GrowingBig := Growing;
      GameFile.ObjectsCurrent := ObjectDescription;
      GameFile.EscapeCurrent := Escape;
      Assign(SaveFile,'SAVEGAME.DAT');
      Rewrite(SaveFile);
      Write(SaveFile,GameFile);
      Close(SaveFile);
      writeln('*** Game saved ***');
   end else
      writeln('*** Not saved ***');
end;

procedure RestoreGame;
begin
   writeln;
   writeln('This will destroy current game!');
   write('Are you sure you want to do this? ');
   readln(Command);
   if pos(Command,'YES Yes yes') > 0 then begin
{$I-} Assign(SaveFile,'SAVEGAME.DAT');
      Reset(SaveFile);
      if IOresult = 0 then begin
{$I+}    Read(SaveFile,GameFile);
         Close(SaveFile);
         Room := GameFile.Map;
         Loc := GameFile.LocCurrent;
         ItemsGotten := GameFile.Carrying;
         ExtraScore := GameFile.CurrentScore;
         GolgiStained := GameFile.GhostStained;
         ChestLocked := GameFile.BoxLocked;
         ItemsStolen := GameFile.StuffStolen;
         ThiefHere := GameFile.GolgiHere;
         TimeForThief := GameFile.ThiefTime;
         HomunculusTime := GameFile.HomuncTime;
         HomunculusStays := GameFile.HomuncStays;
         PillWorking := GameFile.PillWork;
         Growing := GameFile.GrowingBig;
         ObjectDescription := GameFile.ObjectsCurrent;
         Escape := GameFile.EscapeCurrent;
         writeln('*** GameRestored ***');
         ContentsShown := False;
         DescribeRoom;
      end else
         writeln('*** No Saved Game Available! ***');
   end else
      writeln('*** Not Restored ***');
end;

procedure PrintScore;
begin
   writeln;
   writeln('Score = ',TotalScore);
end;

procedure CalculateScore;
begin
   TotalScore := 0;
   RoomScore := 0;
   for Loc1 := LateralVentricle to Cerebellum do
      if Room[Loc1].Visited then RoomScore := RoomScore + 10;
   TotalScore := ExtraScore + RoomScore;
   for Object := DA to GABA do
      if ItemsGotten[Object] then
         TotalScore := TotalScore + 50;
   for Object := PurkinjeCell to PyramidalCell do
      if ItemsGotten[Object] then
         TotalScore := TotalScore + 50;
   for Object := Oligodendrocyte to GrowthHormone do
      if ItemsGotten[Object] then
         TotalScore := TotalScore + 50;
end;

procedure QuitProgram;
begin
   CalculateScore;
   GotoXY(1,3);
   writeln('Descartes appears, quite perturbed.');
   writeln('"Your score is ',TotalScore,'.');
   writeln('Are you sure you want to quit?"');
   GetCommand;
   if (Verb = ' YES ') or (Verb = ' Y ') then
      Verb := ' QUI '
   else clrscr;
end;

procedure OfferHelp;
begin
   GotoXY(1,3);
   case random(5) of
      0:writeln('You are beyond help!');
      1:writeln('You must be an optimist!');
      2:writeln('Solve this problem yourself!');
      3:writeln('I'+chr(39)+'m just a dumb computer.');
      4:writeln('Nice try! I wish I could help.')
   end;
end;

procedure Initialize;
begin
   for Object := Nothing to LastObject do
      ItemsGotten[Object] := False;
   ItemsGotten[Pill] := True;
   GolgiStained := False;
   ChestLocked := True;
   TimeForThief := 10 + random(30);
   HomunculusTime := 100;
   HomunculusStays := 0;
   RoomScore := 0;
   ExtraScore := 0;
   TotalScore := 0;
   PillWorking := 10;
   Growing := 0;
   ItemsStolen := False;
   ThiefHere := False;
   ContentsShown := False;
   WrongAnswer := False;
   Verb := ' ';
end;

begin
   TextColor(Yellow);
   NormVideo;
   MemoryExam;
   TitlePage;
   TitleEnd;
   clrscr;
   Initialize;
   Frame;
   if inkey = 'I' then
      begin
         Introduction;
         BloodToBrain;
      end;
   InFrame;
   Loc := LateralVentricle;
   DescribeRoom;
   while Verb <> ' QUI ' do begin
      Homunculus;
      Thief;
      PillWearsOff;
      CalculateLoad;
      GetCommand;
      Interpret;
      SaveCursor;
      case Cmd of
         Move: MovePlayer;
         Get : GetItem;
         Put : PutItem;
         Manip: ManipulateItem;
         Inventory : ShowInventory;
         Look: DescribeRoom;
         ReportScore : begin
                         CalculateScore;
                         PrintScore;
                       end;
         Save: SaveGame;
         Restore: RestoreGame;
         HomuncPestered: HomuncLeaves;
         Help: OfferHelp;
         Quit: QuitProgram
      end;
      if Verb <> ' QUI ' then
         begin
            RestoreCursorTwo;
            GrowingBig;
         end;
   end;
   ClearFrame;
   WakeUp;
   TitlePage;
   writeln;
   writeln;
   TextColor(Yellow + 16);
write('               Press Alt, Ctrl, & Del simultaneously to play again.');
   TextColor(Yellow);
end.

