/* OPEN.CMD -- opens a WPS object */

/* load rexx utility functions */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

view = 'DEFAULT'
quiet = ''
name = ''

/* parse command line */
call CLI arg(1)

/* analyze arguments, set switches and vars */
do i = 1 to argv.0
  if left(argv.i,1) = '/' then
  do
    if substr(argv.i,2,1) = 'v' then
    do
      view = right(argv.i,length(argv.i) - 2)
    end
    else if substr(argv.i,2,1) = 'V' then
    do
      view = right(argv.i,length(argv.i) - 2)
    end
    else if substr(argv.i,2,1) = 's' then
    do
      quiet = 'quiet'
    end
    else if substr(argv.i,2,1) = 'S' then
    do
      quiet = 'quiet'
    end
    else if substr(argv.i,2,1) = '?' then
    do
      signal giveHelp
    end
  end
  else name = argv.i
end

/* do the dirty deed */
if name \= '' then
do
  if quiet = '' then
  do
    say ' Opening "'name'"'
    say '  View = "'view'"'
  end

  setup = 'OPEN='view
  rc = SysSetObjectData(name,setup)

  if quiet = '' then
  do
    if rc = 0 then say 'Open failed.'
    if rc \= 0 then say 'Open succeeded.'
  end
end
else signal giveHelp
exit

/*
 * Usage help
 */
giveHelp:

say 'Usage:  OPEN <object name or id> [/v<view>] [/silent]'
say ''
say ' <object name or id> is the full qualified pathname of a file'
say '                     system object or an id like <WP_DESKTOP>'
say ' <view> can be ICON, TREE, DETAILS, SETTINGS, etc. (defaults to DEFAULT)'
say '  Examples:  OPEN "<WP_CLOCK>"  (Note quotes around object id!)'
say '             OPEN C:\DESKTOP\MYFOLDER /vICON /s'
say ''
say 'Hector wuz here.'
exit

/*
 * Command Line Interpreter
 */
CLI: procedure expose argv.

args = arg(1)
argv.0 = 0
do i = 1 while args >< ''
  argv.0 = i
 parse value strip(args,'B') with argv.i args
  if left(argv.i, 1) = '"' then
    parse value argv.i args with '"' argv.i '"' args
end
return

